/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$BK\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\bH\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u001dH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0006\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "analysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "specificFeatures", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersion;Lorg/jetbrains/kotlin/config/ApiVersion;Ljava/util/Map;Ljava/util/Map;)V", "getLanguageVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "getFlag", "T", "flag", "(Lorg/jetbrains/kotlin/config/AnalysisFlag;)Ljava/lang/Object;", "getFeatureSupport", "feature", "getManuallyEnabledLanguageFeatures", "", "getManuallyDisabledLanguageFeatures", "isEnabledOnlyByFlag", "", "state", "isDisabledOnlyByFlag", "isEnabledByDefault", "toString", "", "isPreRelease", "Companion", "util"})
@SourceDebugExtension(value={"SMAP\nLanguageVersionSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageVersionSettings.kt\norg/jetbrains/kotlin/config/LanguageVersionSettingsImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,761:1\n1#2:762\n536#3:763\n521#3,6:764\n536#3:770\n521#3,6:771\n1056#4:777\n1869#4,2:778\n1056#4:780\n1869#4,2:781\n188#5,3:783\n*S KotlinDebug\n*F\n+ 1 LanguageVersionSettings.kt\norg/jetbrains/kotlin/config/LanguageVersionSettingsImpl\n*L\n712#1:763\n712#1:764,6\n715#1:770\n715#1:771,6\n728#1:777\n728#1:778,2\n735#1:780\n735#1:781,2\n741#1:783,3\n*E\n"})
public final class LanguageVersionSettingsImpl
implements LanguageVersionSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageVersion languageVersion;
    @NotNull
    private final ApiVersion apiVersion;
    @NotNull
    private final Map<AnalysisFlag<?>, ?> analysisFlags;
    @NotNull
    private final Map<LanguageFeature, LanguageFeature.State> specificFeatures;
    @JvmField
    @NotNull
    public static final LanguageVersionSettingsImpl DEFAULT = new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST_STABLE, null, null, 12, null);

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion, @NotNull Map<AnalysisFlag<?>, ? extends Object> analysisFlags, @NotNull Map<LanguageFeature, ? extends LanguageFeature.State> specificFeatures) {
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkNotNullParameter(analysisFlags, (String)"analysisFlags");
        Intrinsics.checkNotNullParameter(specificFeatures, (String)"specificFeatures");
        this.languageVersion = languageVersion;
        this.apiVersion = apiVersion;
        Map<AnalysisFlag<?>, ? extends Object> map = Collections.unmodifiableMap(analysisFlags);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
        this.analysisFlags = map;
        Map<LanguageFeature, ? extends LanguageFeature.State> map2 = Collections.unmodifiableMap(specificFeatures);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(...)");
        this.specificFeatures = map2;
    }

    public /* synthetic */ LanguageVersionSettingsImpl(LanguageVersion languageVersion, ApiVersion apiVersion, Map map, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(languageVersion, apiVersion, map, map2);
    }

    @Override
    @NotNull
    public LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    @NotNull
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public <T> T getFlag(@NotNull AnalysisFlag<? extends T> flag) {
        Intrinsics.checkNotNullParameter(flag, (String)"flag");
        Object object = this.analysisFlags.get(flag);
        if (object == null) {
            object = flag.getDefaultValue();
        }
        return (T)object;
    }

    @Override
    @NotNull
    public LanguageFeature.State getFeatureSupport(@NotNull LanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        LanguageFeature.State state = this.specificFeatures.get((Object)feature);
        if (state != null) {
            LanguageFeature.State it = state;
            boolean bl = false;
            return it;
        }
        return this.isEnabledByDefault(feature) ? LanguageFeature.State.ENABLED : LanguageFeature.State.DISABLED;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LanguageFeature> getManuallyEnabledLanguageFeatures() {
        void $this$filterTo$iv$iv;
        Map<LanguageFeature, LanguageFeature.State> $this$filter$iv = this.specificFeatures;
        boolean $i$f$filter = false;
        Map<LanguageFeature, LanguageFeature.State> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!this.isEnabledOnlyByFlag((LanguageFeature)((Object)it.getKey()), (LanguageFeature.State)it.getValue())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.keySet());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LanguageFeature> getManuallyDisabledLanguageFeatures() {
        void $this$filterTo$iv$iv;
        Map<LanguageFeature, LanguageFeature.State> $this$filter$iv = this.specificFeatures;
        boolean $i$f$filter = false;
        Map<LanguageFeature, LanguageFeature.State> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!this.isDisabledOnlyByFlag((LanguageFeature)((Object)it.getKey()), (LanguageFeature.State)it.getValue())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.keySet());
    }

    private final boolean isEnabledOnlyByFlag(LanguageFeature feature, LanguageFeature.State state) {
        return !this.isEnabledByDefault(feature) && state == LanguageFeature.State.ENABLED;
    }

    private final boolean isDisabledOnlyByFlag(LanguageFeature feature, LanguageFeature.State state) {
        return this.isEnabledByDefault(feature) && state == LanguageFeature.State.DISABLED;
    }

    private final boolean isEnabledByDefault(LanguageFeature feature) {
        return feature.getSinceVersion() != null && this.getLanguageVersion().compareTo((Enum)feature.getSinceVersion()) >= 0 && this.getApiVersion().compareTo(feature.getSinceApiVersion()) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        Map.Entry entry;
        void $this$forEach$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u247 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u247.append("Language = " + this.getLanguageVersion() + ", API = " + this.getApiVersion());
        Iterable $this$sortedBy$iv = this.specificFeatures.entrySet();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry entry = (Map.Entry)a;
                boolean bl = false;
                LanguageFeature feature = (LanguageFeature)((Object)entry.getKey());
                entry = (Map.Entry)b;
                Comparable comparable = Integer.valueOf(feature.ordinal());
                bl = false;
                feature = (LanguageFeature)((Object)entry.getKey());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(feature.ordinal()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            char c;
            entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            LanguageFeature feature = (LanguageFeature)((Object)entry.getKey());
            LanguageFeature.State state = (LanguageFeature.State)entry.getValue();
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    c = '+';
                    break;
                }
                case 2: {
                    c = '-';
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            char c2 = c;
            $this$toString_u24lambda_u247.append("" + ' ' + c2 + (Object)((Object)feature));
        }
        $this$sortedBy$iv = this.analysisFlags.entrySet();
        $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry entry = (Map.Entry)a;
                boolean bl = false;
                AnalysisFlag flag = (AnalysisFlag)entry.getKey();
                entry = (Map.Entry)b;
                Comparable comparable = (Comparable)((Object)flag.toString());
                bl = false;
                flag = (AnalysisFlag)entry.getKey();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)flag.toString())));
            }
        });
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            entry = (Map.Entry)element$iv;
            boolean bl3 = false;
            AnalysisFlag flag = (AnalysisFlag)entry.getKey();
            Object value2 = entry.getValue();
            $this$toString_u24lambda_u247.append("" + ' ' + flag + ':' + value2);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPreRelease() {
        boolean bl;
        if (LanguageVersionSettingsKt.isPreRelease(this.getLanguageVersion())) return true;
        Map<LanguageFeature, LanguageFeature.State> $this$any$iv = this.specificFeatures;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Iterator<Map.Entry<LanguageFeature, LanguageFeature.State>> iterator2 = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry<LanguageFeature, LanguageFeature.State> element$iv;
            if (!iterator2.hasNext()) return false;
            Map.Entry<LanguageFeature, LanguageFeature.State> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            LanguageFeature feature = entry.getKey();
            LanguageFeature.State state = entry.getValue();
            if (state == LanguageFeature.State.ENABLED && LanguageVersionSettingsKt.forcesPreReleaseBinariesIfEnabled(feature)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion, @NotNull Map<AnalysisFlag<?>, ? extends Object> analysisFlags) {
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkNotNullParameter(analysisFlags, (String)"analysisFlags");
        this(languageVersion, apiVersion, analysisFlags, null, 8, null);
    }

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion) {
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        this(languageVersion, apiVersion, null, null, 12, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl$Companion;", "", "<init>", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;", "util"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LanguageFeature.State.values().length];
            try {
                nArray[LanguageFeature.State.ENABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageFeature.State.DISABLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

