/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.signature;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureBuilder;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureComputer;
import org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrFileSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J+\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\f\u0010\u001a\u001a\u00020\u0010*\u00020\rH\u0002J\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureComputer;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "<init>", "(Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;)V", "getMangler", "()Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "publicSignatureBuilder", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer$PublicIdSigBuilder;", "computeSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "computePublicIdSignature", "compatibleMode", "", "currentFileSignatureX", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "inFile", "R", "file", "Lorg/jetbrains/kotlin/ir/symbols/IrFileSymbol;", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/symbols/IrFileSymbol;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "checkIfPlatformSpecificExport", "localCounter", "", "scopeCounter", "", "reset", "", "PublicIdSigBuilder", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIdSignatureComputers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdSignatureComputers.kt\norg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n1#2:267\n*E\n"})
public final class PublicIdSignatureComputer
implements IdSignatureComputer {
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    @NotNull
    private final PublicIdSigBuilder publicSignatureBuilder;
    @Nullable
    private IdSignature.FileSignature currentFileSignatureX;
    private long localCounter;
    private int scopeCounter;

    public PublicIdSignatureComputer(@NotNull KotlinMangler.IrMangler mangler) {
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        this.mangler = mangler;
        this.publicSignatureBuilder = new PublicIdSigBuilder();
    }

    @NotNull
    public final KotlinMangler.IrMangler getMangler() {
        return this.mangler;
    }

    @Override
    @NotNull
    public IdSignature computeSignature(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.publicSignatureBuilder.buildSignature(declaration);
    }

    @NotNull
    public final IdSignature computePublicIdSignature(@NotNull IrDeclaration declaration, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KotlinMangler.IrMangler $this$computePublicIdSignature_u24lambda_u240 = this.mangler;
        boolean bl = false;
        boolean bl2 = $this$computePublicIdSignature_u24lambda_u240.isExported(declaration, compatibleMode);
        if (_Assertions.ENABLED && !bl2) {
            boolean bl3 = false;
            String string = RenderIrElementKt.render$default(declaration, null, 1, null) + " expected to be exported";
            throw new AssertionError((Object)string);
        }
        return this.publicSignatureBuilder.buildSignature(declaration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public <R> R inFile(@Nullable IrFileSymbol file, @NotNull Function0<? extends R> block) {
        IdSignature.FileSignature fileSignature;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        PublicIdSignatureComputer publicIdSignatureComputer = this;
        IrFileSymbol irFileSymbol = file;
        if (irFileSymbol != null) {
            void it;
            IrFileSymbol irFileSymbol2 = irFileSymbol;
            PublicIdSignatureComputer publicIdSignatureComputer2 = publicIdSignatureComputer;
            boolean bl = false;
            fileSignature = new IdSignature.FileSignature((IrFileSymbol)it);
            publicIdSignatureComputer = publicIdSignatureComputer2;
        } else {
            fileSignature = null;
        }
        publicIdSignatureComputer.currentFileSignatureX = fileSignature;
        try {
            Object object = block.invoke();
            return (R)object;
        }
        finally {
            this.currentFileSignatureX = null;
        }
    }

    private final boolean checkIfPlatformSpecificExport(IrDeclaration $this$checkIfPlatformSpecificExport) {
        KotlinMangler.IrMangler $this$checkIfPlatformSpecificExport_u24lambda_u243 = this.mangler;
        boolean bl = false;
        return $this$checkIfPlatformSpecificExport_u24lambda_u243.isPlatformSpecificExport($this$checkIfPlatformSpecificExport);
    }

    public final void reset() {
        this.localCounter = 0L;
        this.scopeCounter = 0;
    }

    public static final /* synthetic */ boolean access$checkIfPlatformSpecificExport(PublicIdSignatureComputer $this, IrDeclaration $receiver) {
        return $this.checkIfPlatformSpecificExport($receiver);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u000e\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0002H\u0014R\u0014\u0010\u0006\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer$PublicIdSigBuilder;", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureBuilder;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;)V", "mangler", "getMangler", "()Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "currentFileSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "getCurrentFileSignature", "()Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "visitor", "org/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer$PublicIdSigBuilder$visitor$1", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer$PublicIdSigBuilder$visitor$1;", "accept", "", "d", "collectParents", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "renderDeclarationForDescription", "", "ir.serialization.common"})
    private final class PublicIdSigBuilder
    extends IdSignatureBuilder<IrDeclaration, KotlinMangler.IrMangler> {
        @NotNull
        private final visitor.1 visitor;

        public PublicIdSigBuilder() {
            this.visitor = new IrVisitorVoid(this, PublicIdSignatureComputer.this){
                final /* synthetic */ PublicIdSigBuilder this$0;
                final /* synthetic */ PublicIdSignatureComputer this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public Void visitElement(IrElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    throw new IllegalStateException(("Unexpected element " + RenderIrElementKt.render$default(element, null, 1, null)).toString());
                }

                public void visitPackageFragment(IrPackageFragment declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    this.this$0.setPackageFqn(declaration.getPackageFqName());
                }

                private final boolean isTopLevelPrivate(IrDeclarationWithVisibility $this$isTopLevelPrivate) {
                    return Intrinsics.areEqual((Object)$this$isTopLevelPrivate.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) && !PublicIdSignatureComputer.access$checkIfPlatformSpecificExport(this.this$1, $this$isTopLevelPrivate) && ($this$isTopLevelPrivate.getParent() instanceof IrPackageFragment || IrUtilsKt.isFacadeClass($this$isTopLevelPrivate.getParent()));
                }

                public void visitClass(IrClass declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    PublicIdSigBuilder.access$collectParents(this.this$0, declaration);
                    this.this$0.setTopLevelPrivate(this.this$0.isTopLevelPrivate() || this.isTopLevelPrivate(declaration));
                    if (declaration.getKind() == ClassKind.ENUM_ENTRY) {
                        this.this$0.getClassFqnSegments().add("<EEC>");
                    }
                    this.this$0.setDescriptionIfLocalDeclaration(declaration);
                    this.this$0.setExpected(declaration.isExpect());
                }

                public void visitSimpleFunction(IrSimpleFunction declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    IrPropertySymbol property2 = declaration.getCorrespondingPropertySymbol();
                    if (property2 != null) {
                        IrVisitorsKt.acceptVoid((IrElement)property2.getOwner(), this);
                        if (this.this$0.getContainer() != null) {
                            this.this$0.createContainer();
                        }
                        this.this$0.setHashIdAndDescriptionFor(declaration, this.this$0.getContainer() == null);
                        List<String> list = this.this$0.getClassFqnSegments();
                        String string = declaration.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                        list.add(string);
                    } else {
                        PublicIdSigBuilder.access$collectParents(this.this$0, declaration);
                        this.this$0.setTopLevelPrivate(this.this$0.isTopLevelPrivate() || this.isTopLevelPrivate(declaration));
                        this.this$0.setHashIdAndDescriptionFor(declaration, false);
                        this.this$0.setDescriptionIfLocalDeclaration(declaration);
                    }
                    this.this$0.setExpected(declaration.isExpect());
                }

                public void visitConstructor(IrConstructor declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    PublicIdSigBuilder.access$collectParents(this.this$0, declaration);
                    this.this$0.setHashIdAndDescriptionFor(declaration, false);
                    this.this$0.setExpected(declaration.isExpect());
                }

                public void visitScript(IrScript declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    PublicIdSigBuilder.access$collectParents(this.this$0, declaration);
                }

                public void visitProperty(IrProperty declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    PublicIdSigBuilder.access$collectParents(this.this$0, declaration);
                    this.this$0.setTopLevelPrivate(this.this$0.isTopLevelPrivate() || this.isTopLevelPrivate(declaration));
                    this.this$0.setHashIdAndDescriptionFor(declaration, false);
                    this.this$0.setExpected(declaration.isExpect());
                }

                public void visitTypeAlias(IrTypeAlias declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    PublicIdSigBuilder.access$collectParents(this.this$0, declaration);
                    this.this$0.setTopLevelPrivate(this.this$0.isTopLevelPrivate() || this.isTopLevelPrivate(declaration));
                }

                public void visitEnumEntry(IrEnumEntry declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    PublicIdSigBuilder.access$collectParents(this.this$0, declaration);
                }

                public void visitTypeParameter(IrTypeParameter declaration) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    IrDeclarationParent rawParent = declaration.getParent();
                    IrElement parent2 = rawParent instanceof IrSimpleFunction ? ((object = ((IrSimpleFunction)rawParent).getCorrespondingPropertySymbol()) != null && (object = (IrProperty)object.getOwner()) != null ? (IrElement)object : (IrElement)rawParent) : (IrElement)rawParent;
                    parent2.accept(this, null);
                    this.this$0.createContainer();
                    boolean bl = parent2 instanceof IrProperty && Intrinsics.areEqual((Object)((IrProperty)parent2).getSetter(), (Object)rawParent) ? this.this$0.getClassFqnSegments().add("<STP>") : this.this$0.getClassFqnSegments().add("<TP>");
                    this.this$0.setHashIdAndDescription(declaration.getIndex(), this.this$0.renderDeclarationForDescription(declaration), false);
                }

                public void visitField(IrField declaration) {
                    IrProperty prop;
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    IrPropertySymbol irPropertySymbol = declaration.getCorrespondingPropertySymbol();
                    IrProperty irProperty = prop = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
                    if (prop != null) {
                        IrVisitorsKt.acceptVoid((IrElement)prop, this);
                        this.this$0.createContainer();
                        this.this$0.getClassFqnSegments().add("<BF>");
                        this.this$0.setDescriptionIfLocalDeclaration(declaration);
                    } else {
                        PublicIdSigBuilder.access$collectParents(this.this$0, declaration);
                        this.this$0.setHashIdAndDescriptionFor(declaration, false);
                    }
                }
            };
        }

        @Override
        @NotNull
        protected KotlinMangler.IrMangler getMangler() {
            return PublicIdSignatureComputer.this.getMangler();
        }

        @Override
        @Nullable
        protected IdSignature.FileSignature getCurrentFileSignature() {
            return PublicIdSignatureComputer.this.currentFileSignatureX;
        }

        @Override
        protected void accept(@NotNull IrDeclaration d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            IrVisitorsKt.acceptVoid((IrElement)d, this.visitor);
        }

        private final void collectParents(IrDeclarationWithName declaration) {
            IrVisitorsKt.acceptVoid((IrElement)declaration.getParent(), this.visitor);
            if (!(declaration instanceof IrClass) || !IrUtilsKt.isFacadeClass((IrDeclarationParent)((Object)declaration))) {
                List<String> list = this.getClassFqnSegments();
                String string = declaration.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                list.add(string);
            }
        }

        @Override
        @NotNull
        protected String renderDeclarationForDescription(@NotNull IrDeclaration declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            return RenderIrElementKt.render$default(declaration, null, 1, null);
        }

        public static final /* synthetic */ void access$collectParents(PublicIdSigBuilder $this, IrDeclarationWithName declaration) {
            $this.collectParents(declaration);
        }
    }
}

