/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.concurrent;

import io.vavr.concurrent.Future;
import io.vavr.concurrent.FutureImpl;
import io.vavr.concurrent.PromiseImpl;
import io.vavr.control.Try;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public interface Promise<T> {
    public static <T> Promise<T> failed(Throwable exception) {
        Objects.requireNonNull(exception, "exception is null");
        return Promise.failed(Future.DEFAULT_EXECUTOR, exception);
    }

    public static <T> Promise<T> failed(Executor executor2, Throwable exception) {
        Objects.requireNonNull(executor2, "executor is null");
        Objects.requireNonNull(exception, "exception is null");
        return Promise.make(executor2).failure(exception);
    }

    public static <T> Promise<T> fromTry(Try<? extends T> result2) {
        return Promise.fromTry(Future.DEFAULT_EXECUTOR, result2);
    }

    public static <T> Promise<T> fromTry(Executor executor2, Try<? extends T> result2) {
        Objects.requireNonNull(executor2, "executor is null");
        Objects.requireNonNull(result2, "result is null");
        return Promise.make(executor2).complete(result2);
    }

    public static <T> Promise<T> make() {
        return Promise.make(Future.DEFAULT_EXECUTOR);
    }

    public static <T> Promise<T> make(Executor executor2) {
        Objects.requireNonNull(executor2, "executor is null");
        return new PromiseImpl(FutureImpl.of(executor2));
    }

    public static <T> Promise<T> narrow(Promise<? extends T> promise) {
        return promise;
    }

    public static <T> Promise<T> successful(T result2) {
        return Promise.successful(Future.DEFAULT_EXECUTOR, result2);
    }

    public static <T> Promise<T> successful(Executor executor2, T result2) {
        Objects.requireNonNull(executor2, "executor is null");
        return Promise.make(executor2).success(result2);
    }

    default public Executor executor() {
        return this.executorService();
    }

    @Deprecated
    public ExecutorService executorService();

    public Future<T> future();

    default public boolean isCompleted() {
        return this.future().isCompleted();
    }

    default public Promise<T> complete(Try<? extends T> value2) {
        if (this.tryComplete(value2)) {
            return this;
        }
        throw new IllegalStateException("Promise already completed.");
    }

    public boolean tryComplete(Try<? extends T> var1);

    default public Promise<T> completeWith(Future<? extends T> other) {
        return this.tryCompleteWith(other);
    }

    default public Promise<T> tryCompleteWith(Future<? extends T> other) {
        other.onComplete(this::tryComplete);
        return this;
    }

    default public Promise<T> success(T value2) {
        return this.complete(Try.success(value2));
    }

    default public boolean trySuccess(T value2) {
        return this.tryComplete(Try.success(value2));
    }

    default public Promise<T> failure(Throwable exception) {
        return this.complete(Try.failure(exception));
    }

    default public boolean tryFailure(Throwable exception) {
        return this.tryComplete(Try.failure(exception));
    }
}

