/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelArtifact;
import com.android.tools.lint.model.LintModelArtifactType;
import com.android.tools.lint.model.LintModelBuildFeatures;
import com.android.tools.lint.model.LintModelDependenciesWriter;
import com.android.tools.lint.model.LintModelJavaArtifact;
import com.android.tools.lint.model.LintModelLibrariesWriter;
import com.android.tools.lint.model.LintModelResourceField;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelVariant;
import com.android.tools.lint.model.LintModelWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u0016\u001a\u00020\u000b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u0019\u001a\u00020\u000b2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b0\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J2\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010 \u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/lint/model/LintModelVariantWriter;", "Lcom/android/tools/lint/model/LintModelWriter;", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "variantName", "", "writer", "Ljava/io/Writer;", "<init>", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Ljava/lang/String;Ljava/io/Writer;)V", "writeVariant", "", "variant", "Lcom/android/tools/lint/model/LintModelVariant;", "writeDependencies", "", "createdBy", "writeBuildFeatures", "buildFeatures", "Lcom/android/tools/lint/model/LintModelBuildFeatures;", "indent", "", "writeManifestPlaceholders", "manifestPlaceholders", "", "writeResValues", "resValues", "Lcom/android/tools/lint/model/LintModelResourceField;", "writeArtifact", "artifact", "Lcom/android/tools/lint/model/LintModelArtifact;", "tag", "writeType", "lint-model"})
@SourceDebugExtension(value={"SMAP\nLintModelSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintModelSerialization.kt\ncom/android/tools/lint/model/LintModelVariantWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,2012:1\n1#2:2013\n608#3:2014\n1321#3,2:2015\n608#3:2017\n1321#3,2:2018\n*S KotlinDebug\n*F\n+ 1 LintModelSerialization.kt\ncom/android/tools/lint/model/LintModelVariantWriter\n*L\n801#1:2014\n802#1:2015,2\n823#1:2017\n824#1:2018,2\n*E\n"})
final class LintModelVariantWriter
extends LintModelWriter {
    @NotNull
    private final String variantName;

    public LintModelVariantWriter(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @NotNull String variantName, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        super(adapter, new PrintWriter(writer));
        this.variantName = variantName;
    }

    public /* synthetic */ LintModelVariantWriter(LintModelSerialization.LintModelSerializationAdapter lintModelSerializationAdapter, String string, Writer writer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            writer = LintModelSerialization.LintModelSerializationAdapter.getWriter$default(lintModelSerializationAdapter, LintModelSerialization.TargetFile.VARIANT, string, null, 4, null);
        }
        this(lintModelSerializationAdapter, string, writer);
    }

    public final void writeVariant(@NotNull LintModelVariant variant, boolean writeDependencies, @Nullable String createdBy) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.setRoot(variant.getModule().getDir());
        int indent = 0;
        this.indent(indent);
        this.getPrinter().print("<variant");
        this.printName(this.getPrinter(), variant.getName(), indent);
        String string = createdBy;
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.printAttribute(this.getPrinter(), "createdBy", it, indent);
        }
        if (variant.getUseSupportLibraryVectorDrawables()) {
            this.printAttribute(this.getPrinter(), "useSupportLibraryVectorDrawables", "true", indent);
        }
        String string2 = variant.getPackage();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            this.printAttribute(this.getPrinter(), "package", it, indent);
        }
        AndroidVersion androidVersion = variant.getMinSdkVersion();
        if (androidVersion != null) {
            AndroidVersion it = androidVersion;
            boolean bl = false;
            PrintWriter printWriter = this.getPrinter();
            String string3 = it.getApiString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getApiString(...)");
            this.printAttribute(printWriter, "minSdkVersion", string3, indent);
        }
        AndroidVersion androidVersion2 = variant.getTargetSdkVersion();
        if (androidVersion2 != null) {
            AndroidVersion it = androidVersion2;
            boolean bl = false;
            PrintWriter printWriter = this.getPrinter();
            String string4 = it.getApiString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getApiString(...)");
            this.printAttribute(printWriter, "targetSdkVersion", string4, indent);
        }
        if (variant.getDebuggable()) {
            this.printAttribute(this.getPrinter(), "debuggable", "true", indent);
        }
        if (variant.getShrinkable()) {
            this.printAttribute(this.getPrinter(), "shrinking", "true", indent);
        }
        File file = variant.getMergedManifest();
        if (file != null) {
            File it = file;
            boolean bl = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "mergedManifest", it, indent, null, 8, null);
        }
        File file2 = variant.getManifestMergeReport();
        if (file2 != null) {
            File it = file2;
            boolean bl = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "manifestMergeReport", it, indent, null, 8, null);
        }
        LintModelWriter.printFiles$default(this, this.getPrinter(), "proguardFiles", variant.getProguardFiles(), indent, null, 8, null);
        LintModelWriter.printFiles$default(this, this.getPrinter(), "consumerProguardFiles", variant.getConsumerProguardFiles(), indent, null, 8, null);
        LintModelWriter.printStrings$default(this, this.getPrinter(), "resourceConfigurations", variant.getResourceConfigurations(), indent, null, 8, null);
        File file3 = variant.getPartialResultsDir();
        if (file3 != null) {
            File it = file3;
            boolean bl = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "partialResultsDir", it, indent, null, 8, null);
        }
        LintModelWriter.printFiles$default(this, this.getPrinter(), "desugaredMethodsFiles", variant.getDesugaredMethodsFiles(), indent, null, 8, null);
        this.getPrinter().println(">");
        this.writeBuildFeatures(variant.getBuildFeatures(), indent + 1);
        this.writeSourceProviders(variant.getSourceProviders(), "sourceProviders", indent + 1);
        this.writeSourceProviders(variant.getTestSourceProviders(), "testSourceProviders", indent + 1);
        this.writeSourceProviders(variant.getTestFixturesSourceProviders(), "testFixturesSourceProviders", indent + 1);
        this.writeResValues(variant.getResValues(), indent + 1);
        this.writeManifestPlaceholders(variant.getManifestPlaceholders(), indent + 1);
        this.writeArtifact(variant.getArtifact(), "artifact", indent + 1, writeDependencies, true);
        if (variant.getArtifact().getType() == LintModelArtifactType.MAIN) {
            LintModelAndroidArtifact lintModelAndroidArtifact = variant.getAndroidTestArtifact();
            if (lintModelAndroidArtifact != null) {
                LintModelAndroidArtifact artifact2 = lintModelAndroidArtifact;
                boolean bl = false;
                LintModelVariantWriter.writeArtifact$default(this, artifact2, "androidTestArtifact", indent + 1, writeDependencies, false, 16, null);
            }
            LintModelAndroidArtifact lintModelAndroidArtifact2 = variant.getTestFixturesArtifact();
            if (lintModelAndroidArtifact2 != null) {
                LintModelAndroidArtifact artifact3 = lintModelAndroidArtifact2;
                boolean bl = false;
                LintModelVariantWriter.writeArtifact$default(this, artifact3, "testFixturesArtifact", indent + 1, writeDependencies, false, 16, null);
            }
            LintModelJavaArtifact lintModelJavaArtifact = variant.getTestArtifact();
            if (lintModelJavaArtifact != null) {
                LintModelJavaArtifact artifact4 = lintModelJavaArtifact;
                boolean bl = false;
                LintModelVariantWriter.writeArtifact$default(this, artifact4, "testArtifact", indent + 1, writeDependencies, false, 16, null);
            }
        }
        this.indent(indent);
        this.getPrinter().println("</variant>");
        this.getPrinter().close();
    }

    public static /* synthetic */ void writeVariant$default(LintModelVariantWriter lintModelVariantWriter, LintModelVariant lintModelVariant, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        lintModelVariantWriter.writeVariant(lintModelVariant, bl, string);
    }

    private final void writeBuildFeatures(LintModelBuildFeatures buildFeatures, int indent) {
        this.indent(indent);
        this.getPrinter().print("<buildFeatures");
        if (buildFeatures.getCoreLibraryDesugaringEnabled()) {
            this.printAttribute(this.getPrinter(), "coreLibraryDesugaring", "true", indent);
        }
        if (buildFeatures.getViewBinding()) {
            this.printAttribute(this.getPrinter(), "viewBinding", "true", indent);
        }
        this.getPrinter().println("/>");
    }

    private final void writeManifestPlaceholders(Map<String, String> manifestPlaceholders, int indent) {
        if (manifestPlaceholders.isEmpty()) {
            return;
        }
        this.indent(indent);
        this.getPrinter().println("<manifestPlaceholders>");
        Sequence $this$sortedBy$iv = MapsKt.asSequence(manifestPlaceholders);
        boolean $i$f$sortedBy = false;
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            String key = (String)it.getKey();
            String value = (String)it.getValue();
            this.indent(indent + 1);
            this.getPrinter().print("<placeholder");
            this.printName(this.getPrinter(), key, indent + 1);
            this.printAttribute(this.getPrinter(), "value", value, indent + 1);
            this.getPrinter().println(" />");
        }
        this.indent(indent);
        this.getPrinter().println("</manifestPlaceholders>");
    }

    private final void writeResValues(Map<String, ? extends LintModelResourceField> resValues, int indent) {
        if (resValues.isEmpty()) {
            return;
        }
        this.indent(indent);
        this.getPrinter().println("<resValues>");
        Sequence $this$sortedBy$iv = MapsKt.asSequence(resValues);
        boolean $i$f$sortedBy = false;
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            this.indent(indent + 1);
            this.getPrinter().print("<resValue");
            LintModelResourceField resourceField = (LintModelResourceField)it.getValue();
            this.printAttribute(this.getPrinter(), "type", resourceField.getType(), indent + 1);
            this.printName(this.getPrinter(), resourceField.getName(), indent + 1);
            this.printAttribute(this.getPrinter(), "value", resourceField.getValue(), indent + 1);
            this.getPrinter().println(" />");
        }
        this.indent(indent);
        this.getPrinter().println("</resValues>");
    }

    private final void writeArtifact(LintModelArtifact artifact2, String tag, int indent, boolean writeDependencies, boolean writeType) {
        this.indent(indent);
        this.getPrinter().print("<");
        this.getPrinter().print(tag);
        LintModelWriter.printFiles$default(this, this.getPrinter(), "classOutputs", artifact2.getClassOutputs(), indent, null, 8, null);
        if (writeType) {
            this.printAttribute(this.getPrinter(), "type", artifact2.getType().name(), indent);
        }
        if (artifact2 instanceof LintModelAndroidArtifact) {
            if (((LintModelAndroidArtifact)artifact2).getApplicationId() != null) {
                PrintWriter printWriter = this.getPrinter();
                String string = ((LintModelAndroidArtifact)artifact2).getApplicationId();
                Intrinsics.checkNotNull((Object)string);
                this.printAttribute(printWriter, "applicationId", string, indent);
            }
            LintModelWriter.printFiles$default(this, this.getPrinter(), "generatedSourceFolders", ((LintModelAndroidArtifact)artifact2).getGeneratedSourceFolders(), indent, null, 8, null);
            LintModelWriter.printFiles$default(this, this.getPrinter(), "generatedResourceFolders", ((LintModelAndroidArtifact)artifact2).getGeneratedResourceFolders(), indent, null, 8, null);
            LintModelWriter.printFiles$default(this, this.getPrinter(), "desugaredMethodsFiles", ((LintModelAndroidArtifact)artifact2).getDesugaredMethodsFiles(), indent, null, 8, null);
        }
        this.getPrinter().println(">");
        this.indent(indent);
        this.getPrinter().print("</");
        this.getPrinter().print(tag);
        this.getPrinter().println(">");
        if (writeDependencies) {
            LintModelDependenciesWriter dependencyWriter = new LintModelDependenciesWriter(this.getAdapter(), this.variantName, tag, null, 8, null);
            dependencyWriter.writeDependencies(artifact2.getDependencies());
            LintModelLibrariesWriter libraryWriter = new LintModelLibrariesWriter(this.getAdapter(), this.variantName, tag, null, 8, null);
            libraryWriter.writeLibraries(artifact2.getDependencies().getLibraryResolver(), artifact2.getDependencies());
        }
    }

    static /* synthetic */ void writeArtifact$default(LintModelVariantWriter lintModelVariantWriter, LintModelArtifact lintModelArtifact, String string, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        lintModelVariantWriter.writeArtifact(lintModelArtifact, string, n, bl, bl2);
    }
}

