/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils.concurrency;

import com.android.utils.concurrency.AsyncSupplier;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BD\b\u0007\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012#\b\u0002\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0018\u001a\u0004\u0018\u00018\u00002\b\u0010\u0017\u001a\u0004\u0018\u00018\u00008B@BX\u0082\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR(\u0010\u001e\u001a\u0004\u0018\u00018\u00002\b\u0010\u0017\u001a\u0004\u0018\u00018\u00008V@RX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u001a\"\u0004\b \u0010\u001c\u00a8\u0006\""}, d2={"Lcom/android/utils/concurrency/CachedAsyncSupplier;", "V", "Lcom/android/utils/concurrency/AsyncSupplier;", "compute", "Lkotlin/Function0;", "isUpToDate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "", "executor", "Ljava/util/concurrent/ExecutorService;", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/ExecutorService;)V", "Lcom/google/common/util/concurrent/ListeningExecutorService;", "kotlin.jvm.PlatformType", "runningComputationLock", "Ljava/util/concurrent/locks/ReentrantLock;", "runningComputation", "Lcom/google/common/util/concurrent/ListenableFuture;", "lastComputedValueLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "newValue", "lastComputedValue", "getLastComputedValue", "()Ljava/lang/Object;", "setLastComputedValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "now", "getNow", "setNow", "get", "common"})
public final class CachedAsyncSupplier<V>
implements AsyncSupplier<V> {
    @NotNull
    private final Function0<V> compute;
    @NotNull
    private final Function1<V, Boolean> isUpToDate;
    private final ListeningExecutorService executor;
    @NotNull
    private final ReentrantLock runningComputationLock;
    @NotNull
    private ListenableFuture<V> runningComputation;
    @NotNull
    private final ReentrantReadWriteLock lastComputedValueLock;
    @Nullable
    private V lastComputedValue;

    @JvmOverloads
    public CachedAsyncSupplier(@NotNull Function0<? extends V> compute, @NotNull Function1<? super V, Boolean> isUpToDate, @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter(compute, (String)"compute");
        Intrinsics.checkNotNullParameter(isUpToDate, (String)"isUpToDate");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.compute = compute;
        this.isUpToDate = isUpToDate;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.runningComputationLock = new ReentrantLock();
        ListenableFuture listenableFuture = Futures.immediateFuture(null);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
        this.runningComputation = listenableFuture;
        this.lastComputedValueLock = new ReentrantReadWriteLock();
    }

    public /* synthetic */ CachedAsyncSupplier(Function0 function0, Function1 function1, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(function0, function1, executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V getLastComputedValue() {
        V v;
        ReentrantReadWriteLock.ReadLock readLock = this.lastComputedValueLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            v = this.lastComputedValue;
        }
        finally {
            readLock.unlock();
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setLastComputedValue(V newValue) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lastComputedValueLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.lastComputedValue = newValue;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Override
    @Nullable
    public V getNow() {
        ListenableFuture<V> currentComputation = this.get();
        return (V)(currentComputation.isDone() ? Futures.getDone((Future)((Future)currentComputation)) : this.getLastComputedValue());
    }

    private void setNow(V newValue) {
        this.setLastComputedValue(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ListenableFuture<V> get() {
        V cachedValue = this.getLastComputedValue();
        if (cachedValue != null && ((Boolean)this.isUpToDate.invoke(cachedValue)).booleanValue()) {
            ListenableFuture listenableFuture = Futures.immediateFuture(cachedValue);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
            return listenableFuture;
        }
        Lock lock = this.runningComputationLock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.runningComputation.isDone()) {
                ListenableFuture listenableFuture = Futures.nonCancellationPropagating((ListenableFuture)this.executor.submit(new Callable(this){
                    final /* synthetic */ CachedAsyncSupplier<V> this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final V call() {
                        Object computedValue = CachedAsyncSupplier.access$getCompute$p(this.this$0).invoke();
                        CachedAsyncSupplier.access$setLastComputedValue(this.this$0, computedValue);
                        return (V)computedValue;
                    }
                }));
                Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"nonCancellationPropagating(...)");
                this.runningComputation = listenableFuture;
            }
            ListenableFuture<V> listenableFuture = this.runningComputation;
            return listenableFuture;
        }
        finally {
            lock.unlock();
        }
    }

    @JvmOverloads
    public CachedAsyncSupplier(@NotNull Function0<? extends V> compute, @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter(compute, (String)"compute");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this(compute, null, executor, 2, null);
    }

    public static final /* synthetic */ Function0 access$getCompute$p(CachedAsyncSupplier $this) {
        return $this.compute;
    }

    public static final /* synthetic */ void access$setLastComputedValue(CachedAsyncSupplier $this, Object newValue) {
        $this.setLastComputedValue(newValue);
    }
}

