/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.sdklib.AndroidApiLevel;
import com.android.sdklib.AndroidMajorVersion;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AndroidVersion
implements Comparable<AndroidVersion>,
Serializable {
    public static final String PLATFORM_HASH_PREFIX = "android-";
    public static final Pattern PREVIEW_PATTERN = Pattern.compile("^[A-Z][0-9A-Za-z_]*$");
    public static final Pattern API_LEVEL_PATTERN = Pattern.compile("(\\d+)(\\.(\\d+))?(-ext(\\d+))?");
    private static final long serialVersionUID = 1L;
    private final AndroidApiLevel mAndroidApiLevel;
    private final String mCodename;
    private final Integer mExtensionLevel;
    private final boolean mIsBaseExtension;
    public static final AndroidVersion DEFAULT = new AndroidVersion(1, null);
    public static final AndroidVersion ART_RUNTIME = new AndroidVersion(21, null);
    public static final AndroidVersion SUPPORTS_64_BIT = new AndroidVersion(21, null);
    public static final AndroidVersion BINDER_CMD_AVAILABLE = new AndroidVersion(24, null);
    public static final AndroidVersion ALLOW_SPLIT_APK_INSTALLATION = new AndroidVersion(21, null);
    public static final AndroidVersion SUPPORTS_MULTI_USER = new AndroidVersion(17, null);
    public static final int MIN_RECOMMENDED_API = 22;
    public static final int MIN_RECOMMENDED_WEAR_API = 25;
    public static final int MIN_FOLDABLE_DEVICE_API = 29;
    public static final int MIN_EMULATOR_FOLDABLE_DEVICE_API = 34;
    public static final int MIN_FREEFORM_DEVICE_API = 30;
    public static final int MIN_HINGE_FOLDABLE_DEVICE_API = 30;
    public static final int MIN_PIXEL_4A_DEVICE_API = 30;
    public static final int MIN_4K_TV_API = 31;
    public static final int MIN_RESIZABLE_DEVICE_API = 34;
    public static final int MAX_32_BIT_API = 30;
    public static final int MIN_RECTANGULAR_WEAR_API = 28;
    public static final Comparator<AndroidVersion> API_LEVEL_ORDERING = Comparator.comparing(AndroidVersion::getAndroidApiLevel).thenComparing(AndroidVersion::getCodename, Comparator.nullsFirst(Comparator.naturalOrder()));
    private static final Comparator<AndroidVersion> ORDERING = API_LEVEL_ORDERING.thenComparing(AndroidVersion::getNonBaseExtensionLevel, Comparator.nullsFirst(Comparator.naturalOrder()));

    @Deprecated
    public AndroidVersion(int apiLevel) {
        this(apiLevel, null);
    }

    public AndroidVersion(int apiLevel, int apiMinorLevel) {
        this(apiLevel, apiMinorLevel, null, null, true);
    }

    public AndroidVersion(AndroidApiLevel apiLevel) {
        this(apiLevel, null, null, true);
    }

    public AndroidVersion(int apiLevel, String codename) {
        this(apiLevel, codename, null, true);
    }

    public AndroidVersion(int apiLevel, String codename, Integer extensionLevel, boolean isBaseExtension) {
        this(apiLevel, 0, codename, extensionLevel, isBaseExtension);
    }

    public AndroidVersion(int apiLevel, int apiMinorLevel, String codename, Integer extensionLevel, boolean isBaseExtension) {
        this(new AndroidApiLevel(apiLevel, apiMinorLevel), codename, extensionLevel, isBaseExtension);
    }

    public AndroidVersion(AndroidApiLevel androidApiLevel, String codename, Integer extensionLevel, boolean isBaseExtension) {
        if (!isBaseExtension) {
            Preconditions.checkNotNull((Object)extensionLevel, (Object)"extensionLevel required when isBaseExtension is false");
        }
        this.mAndroidApiLevel = androidApiLevel;
        this.mCodename = AndroidVersion.sanitizeCodename(codename);
        this.mExtensionLevel = extensionLevel;
        this.mIsBaseExtension = isBaseExtension;
    }

    public AndroidVersion withBaseExtensionLevel() {
        int baseExtensionLevel = AndroidVersion.getBaseExtensionLevel(this.mAndroidApiLevel);
        return new AndroidVersion(this.mAndroidApiLevel, this.mCodename, baseExtensionLevel <= 0 ? null : Integer.valueOf(baseExtensionLevel), true);
    }

    public AndroidVersion withExtensionLevel(int extensionLevel) {
        return new AndroidVersion(this.mAndroidApiLevel, this.mCodename, (Integer)extensionLevel, extensionLevel == AndroidVersion.getBaseExtensionLevel(this.mAndroidApiLevel));
    }

    public static AndroidVersion fromString(String apiString) {
        try {
            Matcher matcher = API_LEVEL_PATTERN.matcher(apiString);
            if (matcher.matches()) {
                int majorVersion = Integer.parseInt(matcher.group(1));
                int minorVersion = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : 0;
                AndroidApiLevel androidApiLevel = new AndroidApiLevel(majorVersion, minorVersion);
                Integer extensionLevel = matcher.group(5) != null ? Integer.valueOf(Integer.parseInt(matcher.group(5))) : null;
                boolean isBaseExtension = extensionLevel == null || extensionLevel <= AndroidVersion.getBaseExtensionLevel(androidApiLevel);
                return new AndroidVersion(androidApiLevel, null, extensionLevel, isBaseExtension);
            }
        }
        catch (NumberFormatException matcher) {
            // empty catch block
        }
        String codename = AndroidVersion.sanitizeCodename(apiString);
        if (codename == null || !PREVIEW_PATTERN.matcher(codename).matches()) {
            throw new IllegalArgumentException("Invalid Android API or codename " + apiString);
        }
        return new AndroidVersion(0, codename);
    }

    public AndroidApiLevel getAndroidApiLevel() {
        return this.mAndroidApiLevel;
    }

    @Deprecated
    public int getApiLevel() {
        return this.mAndroidApiLevel.getMajorVersion();
    }

    @Deprecated
    public int getApiMinorLevel() {
        return this.mAndroidApiLevel.getMinorVersion();
    }

    public int getFeatureLevel() {
        int apiLevel = this.mAndroidApiLevel.getMajorVersion();
        return this.mCodename != null ? apiLevel + 1 : apiLevel;
    }

    public String getCodename() {
        return this.mCodename;
    }

    public AndroidMajorVersion getMajorVersion() {
        return new AndroidMajorVersion(this.mAndroidApiLevel, this.mCodename);
    }

    @Deprecated
    public String getApiString() {
        return this.getApiStringWithoutExtension();
    }

    private String getApiString(boolean withExtension) {
        if (this.mCodename != null) {
            return this.mCodename;
        }
        if (withExtension && !this.mIsBaseExtension) {
            return String.valueOf(this.mAndroidApiLevel) + "-ext" + this.mExtensionLevel;
        }
        return this.mAndroidApiLevel.toString();
    }

    public String getApiStringWithoutExtension() {
        return this.getApiString(false);
    }

    public String getApiStringWithExtension() {
        return this.getApiString(true);
    }

    public String getPlatformHashString() {
        if (this.mAndroidApiLevel.getMajorVersion() == 36 && this.mAndroidApiLevel.getMinorVersion() == 0 && this.mCodename == null) {
            return this.mIsBaseExtension ? "android-36" : "android-36-ext" + this.mExtensionLevel;
        }
        return PLATFORM_HASH_PREFIX + this.getApiStringWithExtension();
    }

    public Integer getExtensionLevel() {
        return this.mExtensionLevel;
    }

    public boolean isBaseExtension() {
        return this.mIsBaseExtension;
    }

    public boolean isPreview() {
        return this.mCodename != null;
    }

    public boolean isLegacyMultidex() {
        return this.getFeatureLevel() < 21;
    }

    public boolean canRun(AndroidVersion appVersion) {
        if (appVersion.mCodename != null) {
            return appVersion.mCodename.equals(this.mCodename);
        }
        return API_LEVEL_ORDERING.compare(this, appVersion) >= 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AndroidVersion)) {
            return false;
        }
        AndroidVersion other = (AndroidVersion)obj;
        return Objects.equals(this.mAndroidApiLevel, other.mAndroidApiLevel) && Objects.equals(this.mCodename, other.mCodename) && (this.mIsBaseExtension && other.mIsBaseExtension || Objects.equals(this.mExtensionLevel, other.mExtensionLevel));
    }

    public int hashCode() {
        return Objects.hash(this.mAndroidApiLevel, this.mCodename, this.mIsBaseExtension ? 0 : this.mExtensionLevel);
    }

    public String toString() {
        String s = "API " + this.mAndroidApiLevel.toString();
        if (this.isPreview()) {
            s = s + String.format(Locale.ROOT, ", %1$s preview", this.mCodename);
        }
        if (this.mExtensionLevel != null) {
            s = s + String.format(Locale.ROOT, ", extension level %1$s", this.mExtensionLevel);
        }
        return s;
    }

    @Override
    public int compareTo(AndroidVersion o) {
        return ORDERING.compare(this, o);
    }

    private Integer getNonBaseExtensionLevel() {
        return this.isBaseExtension() ? null : this.getExtensionLevel();
    }

    public boolean isAtLeast(int apiLevel) {
        return this.isAtLeast(apiLevel, null);
    }

    public boolean isAtLeast(int apiLevel, String codename) {
        return this.compareTo(new AndroidVersion(apiLevel, codename)) >= 0;
    }

    @Deprecated
    public boolean isGreaterOrEqualThan(int api) {
        return this.isAtLeast(api);
    }

    @Deprecated
    public static int getBaseExtensionLevel(int api) {
        return AndroidVersion.getBaseExtensionLevel(new AndroidApiLevel(api));
    }

    public static int getBaseExtensionLevel(AndroidApiLevel api) {
        ApiBaseExtension[] values2;
        for (ApiBaseExtension value : values2 = ApiBaseExtension.values()) {
            if (!value.getApi().equals(api)) continue;
            return value.getExtension();
        }
        return 0;
    }

    private static String sanitizeCodename(String codename) {
        if (codename != null && ((codename = codename.trim()).isEmpty() || "REL".equals(codename))) {
            codename = null;
        }
        return codename;
    }

    public static enum ApiBaseExtension {
        S(new AndroidApiLevel(31), 1),
        S_V2(new AndroidApiLevel(32), 1),
        TIRAMISU(new AndroidApiLevel(33), 3),
        UPSIDE_DOWN_CAKE(new AndroidApiLevel(34), 7),
        VANILLA_ICE_CREAM(new AndroidApiLevel(35), 13),
        BAKLAVA(new AndroidApiLevel(36), 17),
        BAKLAVA_2025Q4(new AndroidApiLevel(36, 1), 20);

        private final AndroidApiLevel myApi;
        private final int myExtension;

        private ApiBaseExtension(AndroidApiLevel api, int extension) {
            this.myApi = api;
            this.myExtension = extension;
        }

        public AndroidApiLevel getApi() {
            return this.myApi;
        }

        public int getExtension() {
            return this.myExtension;
        }
    }

    public static class VersionCodes {
        public static final int UNDEFINED = 0;
        public static final int BASE = 1;
        public static final int BASE_1_1 = 2;
        public static final int CUPCAKE = 3;
        public static final int DONUT = 4;
        public static final int ECLAIR = 5;
        public static final int ECLAIR_0_1 = 6;
        public static final int ECLAIR_MR1 = 7;
        public static final int FROYO = 8;
        public static final int GINGERBREAD = 9;
        public static final int GINGERBREAD_MR1 = 10;
        public static final int HONEYCOMB = 11;
        public static final int HONEYCOMB_MR1 = 12;
        public static final int HONEYCOMB_MR2 = 13;
        public static final int ICE_CREAM_SANDWICH = 14;
        public static final int ICE_CREAM_SANDWICH_MR1 = 15;
        public static final int JELLY_BEAN = 16;
        public static final int JELLY_BEAN_MR1 = 17;
        public static final int JELLY_BEAN_MR2 = 18;
        public static final int KITKAT = 19;
        public static final int KITKAT_WATCH = 20;
        public static final int LOLLIPOP = 21;
        public static final int LOLLIPOP_MR1 = 22;
        public static final int M = 23;
        public static final int N = 24;
        public static final int N_MR1 = 25;
        public static final int O = 26;
        public static final int O_MR1 = 27;
        public static final int P = 28;
        public static final int Q = 29;
        public static final int R = 30;
        public static final int S = 31;
        public static final int S_V2 = 32;
        public static final int TIRAMISU = 33;
        public static final int UPSIDE_DOWN_CAKE = 34;
        public static final int VANILLA_ICE_CREAM = 35;
        public static final int BAKLAVA = 36;
    }

    public static final class AndroidVersionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AndroidVersionException(String message2, Throwable cause) {
            super(message2, cause);
        }
    }
}

