/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.MapIndexStorageCache;
import com.intellij.util.io.IOCancellationCallbackHolder;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u001b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000b0\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/indexing/impl/LockedCacheWrapper;", "Key", "", "Value", "Lcom/intellij/util/indexing/impl/MapIndexStorageCache;", "underlyingCache", "<init>", "(Lcom/intellij/util/indexing/impl/MapIndexStorageCache;)V", "cacheAccessLock", "Ljava/util/concurrent/locks/ReentrantLock;", "read", "Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "key", "(Ljava/lang/Object;)Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "readIfCached", "getCachedValues", "", "invalidateAll", "", "toString", "", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nMapIndexStorageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/LockedCacheWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,367:1\n1#2:368\n*E\n"})
public final class LockedCacheWrapper<Key, Value>
implements MapIndexStorageCache<Key, Value> {
    @NotNull
    private final MapIndexStorageCache<Key, Value> underlyingCache;
    @NotNull
    private final ReentrantLock cacheAccessLock;

    public LockedCacheWrapper(@NotNull MapIndexStorageCache<Key, Value> underlyingCache) {
        Intrinsics.checkNotNullParameter(underlyingCache, (String)"underlyingCache");
        this.underlyingCache = underlyingCache;
        this.cacheAccessLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ChangeTrackingValueContainer<Value> read(@NotNull Key key) {
        ChangeTrackingValueContainer<Value> changeTrackingValueContainer;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Lock lock = this.cacheAccessLock;
        lock.lock();
        try {
            boolean bl = false;
            changeTrackingValueContainer = this.underlyingCache.read(key);
        }
        finally {
            lock.unlock();
        }
        return changeTrackingValueContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ChangeTrackingValueContainer<Value> readIfCached(@NotNull Key key) {
        ChangeTrackingValueContainer<Value> changeTrackingValueContainer;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Lock lock = this.cacheAccessLock;
        lock.lock();
        try {
            boolean bl = false;
            changeTrackingValueContainer = this.underlyingCache.readIfCached(key);
        }
        finally {
            lock.unlock();
        }
        return changeTrackingValueContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<ChangeTrackingValueContainer<Value>> getCachedValues() {
        Collection<ChangeTrackingValueContainer<Value>> collection;
        Lock lock = this.cacheAccessLock;
        lock.lock();
        try {
            boolean bl = false;
            collection = this.underlyingCache.getCachedValues();
        }
        finally {
            lock.unlock();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll() {
        while (!this.cacheAccessLock.tryLock(10L, TimeUnit.MILLISECONDS)) {
            IOCancellationCallbackHolder.checkCancelled();
        }
        try {
            this.underlyingCache.invalidateAll();
        }
        finally {
            this.cacheAccessLock.unlock();
        }
    }

    @NotNull
    public String toString() {
        return "LockedCacheWrapper(underlying: " + this.underlyingCache + ')';
    }
}

