/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiConstructorUtil {
    @NotNull
    private static final TokenSet CONSTRUCTOR_CALL_TOKENS = TokenSet.create(JavaTokenType.SUPER_KEYWORD, JavaTokenType.THIS_KEYWORD);

    @Nullable
    public static PsiMethodCallExpression findThisOrSuperCallInConstructor(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(0);
        }
        if (!constructor.isConstructor()) {
            return null;
        }
        return (PsiMethodCallExpression)CachedValuesManager.getCachedValue(constructor, () -> {
            PsiCodeBlock body = constructor.getBody();
            if (body == null) {
                return new CachedValueProvider.Result<Object>(null, PsiModificationTracker.MODIFICATION_COUNT);
            }
            Ref result = new Ref();
            PsiTreeUtil.processElements(body, PsiMethodCallExpression.class, call -> {
                if (JavaPsiConstructorUtil.isConstructorCall(call) && PsiTreeUtil.getParentOfType(call, PsiMethod.class) == constructor) {
                    result.set(call);
                    return false;
                }
                return true;
            });
            return new CachedValueProvider.Result<PsiMethodCallExpression>((PsiMethodCallExpression)result.get(), PsiModificationTracker.MODIFICATION_COUNT);
        });
    }

    @Contract(value="null -> false")
    public static boolean isChainedConstructorCall(@Nullable PsiElement call) {
        if (!(call instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiElement child = ((PsiMethodCallExpression)call).getMethodExpression().getReferenceNameElement();
        return PsiUtil.isJavaToken(child, JavaTokenType.THIS_KEYWORD);
    }

    @Contract(value="null -> false")
    public static boolean isSuperConstructorCall(@Nullable PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiElement child = ((PsiMethodCallExpression)element).getMethodExpression().getReferenceNameElement();
        return PsiUtil.isJavaToken(child, JavaTokenType.SUPER_KEYWORD);
    }

    @Contract(value="null -> false")
    public static boolean isConstructorCall(@Nullable PsiElement call) {
        if (!(call instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiElement child = ((PsiMethodCallExpression)call).getMethodExpression().getReferenceNameElement();
        return PsiUtil.isJavaToken(child, CONSTRUCTOR_CALL_TOKENS);
    }

    public static PsiMethod findConstructorInSuper(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(1);
        }
        return JavaPsiConstructorUtil.findConstructorInSuper(constructor, new HashSet());
    }

    private static PsiMethod findConstructorInSuper(@NotNull PsiMethod constructor, @NotNull Set<? super PsiMethod> visited) {
        PsiClass superClass;
        PsiClass containingClass;
        if (constructor == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(2);
        }
        if (visited == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(3);
        }
        if (!visited.add(constructor)) {
            return null;
        }
        PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor(constructor);
        if (JavaPsiConstructorUtil.isSuperConstructorCall(call)) {
            PsiMethod superConstructor = call.resolveMethod();
            if (superConstructor != null) {
                return superConstructor;
            }
        } else if (JavaPsiConstructorUtil.isChainedConstructorCall(call)) {
            PsiMethod chainedConstructor = call.resolveMethod();
            if (chainedConstructor != null) {
                return JavaPsiConstructorUtil.findConstructorInSuper(chainedConstructor, visited);
            }
            return null;
        }
        if ((containingClass = constructor.getContainingClass()) != null && (superClass = containingClass.getSuperClass()) != null && superClass.getName() != null) {
            MethodSignature defConstructor = MethodSignatureUtil.createMethodSignature(superClass.getName(), PsiType.EMPTY_ARRAY, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY, true);
            return MethodSignatureUtil.findMethodBySignature(superClass, defConstructor, false);
        }
        return null;
    }

    @NotNull
    public static List<PsiMethod> getChainedConstructors(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(4);
        }
        ConstructorVisitorInfo info = new ConstructorVisitorInfo();
        JavaPsiConstructorUtil.visitConstructorChain(constructor, info);
        if (info.visitedConstructors != null) {
            info.visitedConstructors.remove(constructor);
        }
        List<PsiMethod> list = ObjectUtils.notNull(info.visitedConstructors, Collections.emptyList());
        if (list == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static void visitConstructorChain(@NotNull PsiMethod entry, @NotNull ConstructorVisitorInfo info) {
        if (entry == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(6);
        }
        if (info == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(7);
        }
        PsiMethod constructor = entry;
        PsiMethodCallExpression methodCall;
        while (JavaPsiConstructorUtil.isChainedConstructorCall(methodCall = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor(constructor))) {
            PsiMethod method = methodCall.resolveMethod();
            if (method == null) {
                return;
            }
            if (info.visitedConstructors != null && info.visitedConstructors.contains(method)) {
                info.recursivelyCalledConstructor = method;
                return;
            }
            if (info.visitedConstructors == null) {
                info.visitedConstructors = new ArrayList<PsiMethod>(5);
            }
            info.visitedConstructors.add(method);
            constructor = method;
        }
        return;
    }

    public static boolean isRecursivelyCalledConstructor(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(8);
        }
        ConstructorVisitorInfo info = new ConstructorVisitorInfo();
        JavaPsiConstructorUtil.visitConstructorChain(constructor, info);
        if (info.recursivelyCalledConstructor == null) {
            return false;
        }
        return info.visitedConstructors.indexOf(info.recursivelyCalledConstructor) <= info.visitedConstructors.indexOf(constructor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/JavaPsiConstructorUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/JavaPsiConstructorUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChainedConstructors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findThisOrSuperCallInConstructor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findConstructorInSuper";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChainedConstructors";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitConstructorChain";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isRecursivelyCalledConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConstructorVisitorInfo {
        List<PsiMethod> visitedConstructors;
        PsiMethod recursivelyCalledConstructor;

        private ConstructorVisitorInfo() {
        }
    }
}

