/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import java.util.List;
import java.util.function.Supplier;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;

final class SmartExtensionPoint<T> {
    @NotNull
    private final @NotNull Supplier<? extends ExtensionPoint<@NotNull T>> extensionPointSupplier;
    private volatile PersistentList<T> explicitExtensions;
    private volatile ExtensionPoint<@NotNull T> extensionPoint;
    private volatile PersistentList<T> cache;
    private final ExtensionPointListener<T> extensionPointAndAreaListener;
    private final Object lock;

    SmartExtensionPoint(@NotNull @NotNull Supplier<? extends ExtensionPoint<@NotNull T>> extensionPointSupplier) {
        if (extensionPointSupplier == null) {
            SmartExtensionPoint.$$$reportNull$$$0(0);
        }
        this.explicitExtensions = ExtensionsKt.persistentListOf();
        this.lock = new Object();
        this.extensionPointSupplier = extensionPointSupplier;
        this.extensionPointAndAreaListener = new ExtensionPointAndAreaListener<T>(){

            @Override
            public void areaReplaced(@NotNull ExtensionsArea oldArea) {
                if (oldArea == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.dropCache();
            }

            @Override
            public void extensionAdded(@NotNull T extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.dropCache();
            }

            @Override
            public void extensionRemoved(@NotNull T extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.dropCache();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Issues handling annotations - annotations may be inaccurate
             */
            private void dropCache() {
                if (SmartExtensionPoint.this.cache == null) {
                    return;
                }
                Object object = SmartExtensionPoint.this.lock;
                synchronized (object) {
                    if (SmartExtensionPoint.this.cache != null) {
                        SmartExtensionPoint.this.cache = null;
                        @NotNull ExtensionPoint extensionPoint = SmartExtensionPoint.this.extensionPoint;
                        if (extensionPoint != null) {
                            extensionPoint.removeExtensionPointListener(this);
                            SmartExtensionPoint.this.extensionPoint = null;
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldArea";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/search/searches/SmartExtensionPoint$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "areaReplaced";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitExtension(@NotNull T extension) {
        if (extension == null) {
            SmartExtensionPoint.$$$reportNull$$$0(1);
        }
        Object object = this.lock;
        synchronized (object) {
            this.explicitExtensions = this.explicitExtensions.add(extension);
            this.cache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitExtension(@NotNull T extension) {
        if (extension == null) {
            SmartExtensionPoint.$$$reportNull$$$0(2);
        }
        Object object = this.lock;
        synchronized (object) {
            this.explicitExtensions = this.explicitExtensions.remove(extension);
            this.cache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<T> getExtensions() {
        PersistentList<T> result = this.cache;
        if (result != null) {
            PersistentList<T> persistentList = result;
            if (persistentList != null) return persistentList;
            SmartExtensionPoint.$$$reportNull$$$0(3);
            return persistentList;
        }
        ExtensionPoint<T> extensionPoint = this.extensionPoint;
        if (extensionPoint == null) {
            extensionPoint = this.extensionPointSupplier.get();
            this.extensionPoint = extensionPoint;
        }
        PersistentList<T> extensions = ExtensionsKt.toPersistentList(extensionPoint.getExtensionList());
        Object object = this.lock;
        // MONITORENTER : object
        result = this.cache;
        if (result != null) {
            PersistentList<T> persistentList = result;
            // MONITOREXIT : object
            if (persistentList != null) return persistentList;
            SmartExtensionPoint.$$$reportNull$$$0(4);
            return persistentList;
        }
        extensionPoint.addExtensionPointListener(this.extensionPointAndAreaListener, false, null);
        this.cache = result = this.explicitExtensions.isEmpty() ? extensions : this.explicitExtensions.addAll(extensions);
        PersistentList<T> persistentList = result;
        // MONITOREXIT : object
        if (persistentList != null) return persistentList;
        SmartExtensionPoint.$$$reportNull$$$0(5);
        return persistentList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointSupplier";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/searches/SmartExtensionPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/searches/SmartExtensionPoint";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeExplicitExtension";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

