/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NamedPackageSetReference
extends PackageSetBase {
    private final String myName;

    public NamedPackageSetReference(String name) {
        this.myName = StringUtil.trimStart(name, "$");
    }

    @Override
    public boolean contains(@NotNull VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
        PackageSet packageSet;
        if (file == null) {
            NamedPackageSetReference.$$$reportNull$$$0(0);
        }
        if (project == null) {
            NamedPackageSetReference.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            return false;
        }
        NamedScope scope = holder.getScope(this.myName);
        if (scope == null) {
            if (!(holder instanceof NamedScopeManager)) {
                return false;
            }
            DependencyValidationManager sharedScopesHolder = DependencyValidationManager.getInstance(project);
            scope = sharedScopesHolder.getScope(this.myName);
            if (scope == null) {
                return false;
            }
            holder = sharedScopesHolder;
        }
        if ((packageSet = scope.getValue()) != null) {
            boolean bl;
            if (packageSet instanceof PackageSetBase) {
                PackageSetBase base = (PackageSetBase)packageSet;
                bl = base.contains(file, project, holder);
            } else {
                bl = packageSet.contains(NamedPackageSetReference.getPsiFile(file, project), holder);
            }
            return bl;
        }
        return false;
    }

    @Override
    @NotNull
    public PackageSet createCopy() {
        return new NamedPackageSetReference(this.myName);
    }

    @Override
    @NotNull
    public String getText() {
        String string = "$" + this.myName;
        if (string == null) {
            NamedPackageSetReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public int getNodePriority() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/packageSet/NamedPackageSetReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/packageSet/NamedPackageSetReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

