/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class AllClassesSearchExecutor
implements QueryExecutor<PsiClass, AllClassesSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull AllClassesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiClass> consumer) {
        PsiElement[] scopeRoots;
        SearchScope scope;
        if (queryParameters == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(1);
        }
        if (SearchScope.isEmptyScope(scope = queryParameters.getScope())) {
            return true;
        }
        if (scope instanceof GlobalSearchScope) {
            PsiManager manager = PsiManager.getInstance(queryParameters.getProject());
            return manager.runInBatchFilesMode(() -> AllClassesSearchExecutor.processAllClassesInGlobalScope((GlobalSearchScope)scope, queryParameters, consumer));
        }
        for (PsiElement scopeRoot : scopeRoots = ((LocalSearchScope)scope).getScope()) {
            if (AllClassesSearchExecutor.processScopeRootForAllClasses(scopeRoot, consumer)) continue;
            return false;
        }
        return true;
    }

    private static boolean processAllClassesInGlobalScope(@NotNull GlobalSearchScope scope, @NotNull AllClassesSearch.SearchParameters parameters, @NotNull Processor<? super PsiClass> processor) {
        if (scope == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(4);
        }
        HashSet names = new HashSet(10000);
        Project project = parameters.getProject();
        AllClassesSearchExecutor.processClassNames(project, scope, s -> {
            if (parameters.nameMatches(s)) {
                names.add(s);
            }
            return true;
        });
        ArrayList sorted = new ArrayList(names);
        sorted.sort(String.CASE_INSENSITIVE_ORDER);
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)project);
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(sorted, ProgressIndicatorProvider.getGlobalProgressIndicator(), name -> AllClassesSearchExecutor.processByName(project, scope, processor, cache2, name));
    }

    public static boolean processClassesByNames(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Collection<String> names, @NotNull Processor<? super PsiClass> processor) {
        if (project == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(6);
        }
        if (names == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(8);
        }
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)project);
        for (String name : names) {
            ProgressIndicatorProvider.checkCanceled();
            if (AllClassesSearchExecutor.processByName(project, scope, processor, cache2, name)) continue;
            return false;
        }
        return true;
    }

    private static boolean processByName(Project project, GlobalSearchScope scope, Processor<? super PsiClass> processor, PsiShortNamesCache cache2, String name) {
        for (PsiClass psiClass : DumbService.getInstance(project).runReadActionInSmartMode(() -> cache2.getClassesByName(name, scope))) {
            ProgressIndicatorProvider.checkCanceled();
            if (processor.process(psiClass)) continue;
            return false;
        }
        return true;
    }

    public static boolean processClassNames(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super String> processor) {
        if (project == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(11);
        }
        boolean success = DumbService.getInstance(project).runReadActionInSmartMode(() -> PsiShortNamesCache.getInstance((Project)project).processAllClassNames(s -> {
            ProgressManager.checkCanceled();
            return processor.process((String)s);
        }, scope, null));
        ProgressManager.checkCanceled();
        return success;
    }

    private static boolean processScopeRootForAllClasses(@NotNull PsiElement scopeRoot, final @NotNull Processor<? super PsiClass> processor) {
        if (scopeRoot == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            AllClassesSearchExecutor.$$$reportNull$$$0(13);
        }
        final boolean[] stopped = new boolean[]{false};
        JavaElementVisitor visitor = scopeRoot instanceof PsiCompiledElement ? new JavaRecursiveElementVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(1);
                }
                stopped[0] = !processor.process(aClass);
                super.visitClass(aClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/search/AllClassesSearchExecutor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        } : new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    2.$$$reportNull$$$0(1);
                }
                stopped[0] = !processor.process(aClass);
                super.visitClass(aClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/search/AllClassesSearchExecutor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ApplicationManager.getApplication().runReadAction(() -> scopeRoot.accept(visitor));
        return !stopped[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeRoot";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/AllClassesSearchExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllClassesInGlobalScope";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processClassesByNames";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processClassNames";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "processScopeRootForAllClasses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

