/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.light.LightElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LightReferenceListBuilder
extends LightElement
implements PsiReferenceList {
    private final List<PsiJavaCodeReferenceElement> myRefs = new ArrayList<PsiJavaCodeReferenceElement>();
    private volatile PsiClassType[] myCachedTypes;
    private final PsiReferenceList.Role myRole;
    private final PsiElementFactory myFactory;

    public LightReferenceListBuilder(PsiManager manager, PsiReferenceList.Role role) {
        this(manager, JavaLanguage.INSTANCE, role);
    }

    public LightReferenceListBuilder(PsiManager manager, Language language, PsiReferenceList.Role role) {
        super(manager, language);
        this.myRole = role;
        this.myFactory = JavaPsiFacade.getElementFactory(this.getProject());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            LightReferenceListBuilder.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "light reference list";
    }

    public void addReference(PsiClass aClass) {
        this.addReference(aClass.getQualifiedName());
    }

    public void addReference(String qualifiedName) {
        this.myRefs.add(this.myFactory.createReferenceElementByFQClassName(qualifiedName, this.getResolveScope()));
    }

    public void addReference(PsiClassType type) {
        this.myRefs.add(this.myFactory.createReferenceElementByType(type));
    }

    @Override
    public PsiJavaCodeReferenceElement @NotNull [] getReferenceElements() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = this.myRefs.toArray(PsiJavaCodeReferenceElement.EMPTY_ARRAY);
        if (psiJavaCodeReferenceElementArray == null) {
            LightReferenceListBuilder.$$$reportNull$$$0(1);
        }
        return psiJavaCodeReferenceElementArray;
    }

    @Override
    public PsiClassType @NotNull [] getReferencedTypes() {
        PsiClassType[] types = this.myCachedTypes;
        if (types == null) {
            int size = this.myRefs.size();
            types = size == 0 ? PsiClassType.EMPTY_ARRAY : new PsiClassType[size];
            for (int i = 0; i < size; ++i) {
                types[i] = this.myFactory.createType(this.myRefs.get(i));
            }
            this.myCachedTypes = types;
        }
        if (types == null) {
            LightReferenceListBuilder.$$$reportNull$$$0(2);
        }
        return types;
    }

    @Override
    public PsiReferenceList.Role getRole() {
        return this.myRole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightReferenceListBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightReferenceListBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

