/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.impl.java.stubs.JavaImportStatementElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.reference.SoftReference;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiImportStatementStubImpl
extends StubBase<PsiImportStatementBase>
implements PsiImportStatementStub {
    private final byte myFlags;
    private final String myText;
    private java.lang.ref.SoftReference<PsiJavaCodeReferenceElement> myReference;
    private java.lang.ref.SoftReference<PsiJavaModuleReferenceElement> myModuleReference;
    private static final int ON_DEMAND = 1;
    private static final int STATIC = 2;
    private static final int MODULE = 4;

    public PsiImportStatementStubImpl(StubElement parent, String text, byte flags) {
        super(parent, PsiImportStatementStubImpl.getImportType(flags));
        this.myText = text;
        this.myFlags = flags;
    }

    @NotNull
    private static JavaImportStatementElementType getImportType(byte flags) {
        if (PsiImportStatementStubImpl.isStatic(flags)) {
            JavaImportStatementElementType javaImportStatementElementType = JavaStubElementTypes.IMPORT_STATIC_STATEMENT;
            if (javaImportStatementElementType == null) {
                PsiImportStatementStubImpl.$$$reportNull$$$0(0);
            }
            return javaImportStatementElementType;
        }
        if (PsiImportStatementStubImpl.isModule(flags)) {
            JavaImportStatementElementType javaImportStatementElementType = JavaStubElementTypes.IMPORT_MODULE_STATEMENT;
            if (javaImportStatementElementType == null) {
                PsiImportStatementStubImpl.$$$reportNull$$$0(1);
            }
            return javaImportStatementElementType;
        }
        JavaImportStatementElementType javaImportStatementElementType = JavaStubElementTypes.IMPORT_STATEMENT;
        if (javaImportStatementElementType == null) {
            PsiImportStatementStubImpl.$$$reportNull$$$0(2);
        }
        return javaImportStatementElementType;
    }

    @Override
    public boolean isStatic() {
        return PsiImportStatementStubImpl.isStatic(this.myFlags);
    }

    private static boolean isStatic(byte flags) {
        return BitUtil.isSet((int)flags, 2);
    }

    @Override
    public boolean isModule() {
        return PsiImportStatementStubImpl.isModule(this.myFlags);
    }

    private static boolean isModule(byte flags) {
        return BitUtil.isSet((int)flags, 4);
    }

    @Override
    public boolean isOnDemand() {
        return BitUtil.isSet((int)this.myFlags, 1);
    }

    public byte getFlags() {
        return this.myFlags;
    }

    @Override
    public String getImportReferenceText() {
        return this.myText;
    }

    @Override
    @Nullable
    public PsiJavaCodeReferenceElement getReference() {
        PsiJavaCodeReferenceElement ref = SoftReference.dereference(this.myReference);
        if (ref == null && !this.isModule()) {
            ref = this.isStatic() ? this.getStaticReference() : this.getRegularReference();
            this.myReference = new java.lang.ref.SoftReference<PsiJavaCodeReferenceElement>(ref);
        }
        return ref;
    }

    @Override
    @Nullable
    public PsiJavaModuleReferenceElement getModuleReference() {
        if (!this.isModule()) {
            return null;
        }
        PsiJavaModuleReferenceElement ref = SoftReference.dereference(this.myModuleReference);
        if (ref == null) {
            ref = this.createModuleReference();
            this.myModuleReference = new java.lang.ref.SoftReference<PsiJavaModuleReferenceElement>(ref);
        }
        return ref;
    }

    public static byte packFlags(boolean isOnDemand, boolean isStatic, boolean isModule) {
        byte flags = 0;
        if (isOnDemand) {
            flags = (byte)(flags | 1);
        }
        if (isStatic) {
            flags = (byte)(flags | 2);
        }
        if (isModule) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    @Nullable
    private PsiJavaCodeReferenceElement getStaticReference() {
        PsiJavaCodeReferenceElement refElement = this.createReference();
        if (refElement == null) {
            return null;
        }
        if (this.isOnDemand() && refElement instanceof PsiJavaCodeReferenceElementImpl) {
            ((PsiJavaCodeReferenceElementImpl)refElement).setKindWhenDummy(PsiJavaCodeReferenceElementImpl.Kind.CLASS_FQ_NAME_KIND);
        }
        return refElement;
    }

    @Nullable
    private PsiJavaCodeReferenceElement getRegularReference() {
        PsiJavaCodeReferenceElement refElement = this.createReference();
        if (refElement == null) {
            return null;
        }
        ((PsiJavaCodeReferenceElementImpl)refElement).setKindWhenDummy(this.isOnDemand() ? PsiJavaCodeReferenceElementImpl.Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND : PsiJavaCodeReferenceElementImpl.Kind.CLASS_FQ_NAME_KIND);
        return refElement;
    }

    @Nullable
    private PsiJavaModuleReferenceElement createModuleReference() {
        String refText = this.getImportReferenceText();
        if (refText == null) {
            return null;
        }
        try {
            PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
            return parserFacade.createModuleReferenceFromText(refText, (PsiElement)this.getPsi());
        }
        catch (IncorrectOperationException ignore) {
            return null;
        }
    }

    @Nullable
    private PsiJavaCodeReferenceElement createReference() {
        String refText = this.getImportReferenceText();
        if (refText == null) {
            return null;
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        try {
            return parserFacade.createReferenceFromText(refText, (PsiElement)this.getPsi());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiImportStatementStub[");
        if (this.isStatic()) {
            builder.append("static ");
        }
        if (this.isModule()) {
            builder.append("module ");
        }
        builder.append(this.getImportReferenceText());
        if (this.isOnDemand() && !this.isModule()) {
            builder.append(".*");
        }
        builder.append("]");
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiImportStatementStubImpl", "getImportType"));
    }
}

