/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.metadata.impl;

import com.intellij.platform.workspace.storage.metadata.MetadataStorage;
import com.intellij.platform.workspace.storage.metadata.model.StorageTypeMetadata;
import com.intellij.platform.workspace.storage.metadata.utils.TypesCollectorKt;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B7\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0004J\u001b\u0010\u0010\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b2\u0006\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H$J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0013H$J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0005H\u0004J\u001c\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00042\n\u0010\u001b\u001a\u00060\u0007j\u0002`\bH\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/workspace/storage/metadata/impl/MetadataStorageBase;", "Lcom/intellij/platform/workspace/storage/metadata/MetadataStorage;", "metadataByTypeFqn", "", "", "Lcom/intellij/platform/workspace/storage/metadata/model/StorageTypeMetadata;", "metadataHashByTypeFqn", "", "Lcom/intellij/platform/workspace/storage/metadata/MetadataHash;", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "metadataIsInitialized", "", "hashMetadataIsInitialized", "getMetadataByTypeFqnOrNull", "fqName", "getMetadataHashByTypeFqnOrNull", "(Ljava/lang/String;)Ljava/lang/Integer;", "initializeMetadata", "", "internalInitializeMetadata", "initializeMetadataHash", "internalInitializeMetadataHash", "addMetadata", "typeMetadata", "addMetadataHash", "typeFqn", "metadataHash", "intellij.platform.workspace.storage"})
public abstract class MetadataStorageBase
implements MetadataStorage {
    @NotNull
    private final Map<String, StorageTypeMetadata> metadataByTypeFqn;
    @NotNull
    private final Map<String, Integer> metadataHashByTypeFqn;
    private volatile boolean metadataIsInitialized;
    private volatile boolean hashMetadataIsInitialized;

    public MetadataStorageBase(@NotNull Map<String, StorageTypeMetadata> metadataByTypeFqn, @NotNull Map<String, Integer> metadataHashByTypeFqn) {
        Intrinsics.checkNotNullParameter(metadataByTypeFqn, (String)"metadataByTypeFqn");
        Intrinsics.checkNotNullParameter(metadataHashByTypeFqn, (String)"metadataHashByTypeFqn");
        this.metadataByTypeFqn = metadataByTypeFqn;
        this.metadataHashByTypeFqn = metadataHashByTypeFqn;
    }

    public /* synthetic */ MetadataStorageBase(Map map2, Map map3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = new HashMap();
        }
        if ((n & 2) != 0) {
            map3 = new HashMap();
        }
        this(map2, map3);
    }

    @Override
    @Nullable
    public final StorageTypeMetadata getMetadataByTypeFqnOrNull(@NotNull String fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        if (!this.metadataIsInitialized) {
            this.internalInitializeMetadata();
        }
        return this.metadataByTypeFqn.get(fqName);
    }

    @Override
    @Nullable
    public final Integer getMetadataHashByTypeFqnOrNull(@NotNull String fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        if (!this.hashMetadataIsInitialized) {
            this.internalInitializeMetadataHash();
        }
        return this.metadataHashByTypeFqn.get(fqName);
    }

    protected abstract void initializeMetadata();

    private final synchronized void internalInitializeMetadata() {
        if (this.metadataIsInitialized) {
            return;
        }
        this.initializeMetadata();
        this.metadataIsInitialized = true;
    }

    protected abstract void initializeMetadataHash();

    private final synchronized void internalInitializeMetadataHash() {
        if (this.hashMetadataIsInitialized) {
            return;
        }
        this.initializeMetadataHash();
        this.hashMetadataIsInitialized = true;
    }

    protected final void addMetadata(@NotNull StorageTypeMetadata typeMetadata) {
        Intrinsics.checkNotNullParameter((Object)typeMetadata, (String)"typeMetadata");
        TypesCollectorKt.collectTypesByFqn$default(typeMetadata, this.metadataByTypeFqn, null, 2, null);
    }

    protected final void addMetadataHash(@NotNull String typeFqn, int metadataHash) {
        Intrinsics.checkNotNullParameter((Object)typeFqn, (String)"typeFqn");
        this.metadataHashByTypeFqn.put(typeFqn, metadataHash);
    }

    public MetadataStorageBase() {
        this(null, null, 3, null);
    }
}

