/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.platform.workspace.storage.CodeGeneratorVersions;
import com.intellij.platform.workspace.storage.GeneratedCodeApiVersion;
import com.intellij.platform.workspace.storage.GeneratedCodeImplVersion;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.UtilsKt;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0016\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/workspace/storage/impl/GeneratedCodeCompatibilityChecker;", "", "<init>", "()V", "checkCode", "", "entity", "Ljava/lang/Class;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "toBuilderClass", "toImplClass", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nGeneratedCodeCompatibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneratedCodeCompatibilityChecker.kt\ncom/intellij/platform/workspace/storage/impl/GeneratedCodeCompatibilityChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,71:1\n4135#2,11:72\n4135#2,11:83\n4135#2,11:94\n*S KotlinDebug\n*F\n+ 1 GeneratedCodeCompatibilityChecker.kt\ncom/intellij/platform/workspace/storage/impl/GeneratedCodeCompatibilityChecker\n*L\n16#1:72,11\n33#1:83,11\n48#1:94,11\n*E\n"})
public final class GeneratedCodeCompatibilityChecker {
    @NotNull
    public static final GeneratedCodeCompatibilityChecker INSTANCE = new GeneratedCodeCompatibilityChecker();

    private GeneratedCodeCompatibilityChecker() {
    }

    /*
     * WARNING - void declaration
     */
    public final void checkCode(@NotNull Class<WorkspaceEntity> entity) {
        Annotation[] $this$filterIsInstanceTo$iv$iv;
        boolean $i$f$filterIsInstanceTo;
        Object destination$iv$iv;
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Class<?> builderClass = null;
        if (CodeGeneratorVersions.INSTANCE.getCheckApiInInterface()) {
            boolean bl;
            void $this$filterIsInstanceTo$iv$iv2;
            builderClass = this.toBuilderClass(entity);
            Annotation[] annotations = builderClass.getAnnotations();
            Intrinsics.checkNotNull((Object)annotations);
            Annotation[] $this$filterIsInstance$iv = annotations;
            boolean $i$f$filterIsInstance = false;
            Annotation[] annotationArray = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            int n = ((void)$this$filterIsInstanceTo$iv$iv2).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv = $this$filterIsInstanceTo$iv$iv2[i];
                if (!(element$iv$iv instanceof GeneratedCodeApiVersion)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            GeneratedCodeApiVersion generatedCodeApiVersion = (GeneratedCodeApiVersion)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
            if (generatedCodeApiVersion == null) {
                throw new IllegalStateException(("Generated interface '" + builderClass + "' doesn't have an api version marker. You should regenerate the code of your entities").toString());
            }
            int entityApiVersion = generatedCodeApiVersion.version();
            boolean bl2 = bl = entityApiVersion == CodeGeneratorVersions.INSTANCE.getAPI_VERSION();
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = StringsKt.trimIndent((String)("\n          Current API version of the generator is '" + CodeGeneratorVersions.INSTANCE.getAPI_VERSION() + "',\n          but the generated code is marked as version '" + entityApiVersion + "'.\n          Please, regenerate your entities.\n          \n          Checked entity: " + builderClass + "\n        "));
                throw new AssertionError((Object)string);
            }
        }
        Class<?> implClass = this.toImplClass(entity);
        Annotation[] implAnnotations = implClass.getAnnotations();
        if (CodeGeneratorVersions.INSTANCE.getCheckApiInImpl()) {
            boolean bl;
            Intrinsics.checkNotNull((Object)implAnnotations);
            Annotation[] $this$filterIsInstance$iv = implAnnotations;
            boolean $i$f$filterIsInstance = false;
            destination$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Annotation element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof GeneratedCodeApiVersion)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            GeneratedCodeApiVersion generatedCodeApiVersion = (GeneratedCodeApiVersion)CollectionsKt.singleOrNull((List)((List)destination$iv$iv2));
            if (generatedCodeApiVersion == null) {
                throw new IllegalStateException(("Generated class '" + implClass + "' doesn't have an api version marker. You should regenerate the code of your entities").toString());
            }
            int entityImplApiVersion = generatedCodeApiVersion.version();
            boolean bl4 = bl = entityImplApiVersion == CodeGeneratorVersions.INSTANCE.getAPI_VERSION();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-GeneratedCodeCompatibilityChecker$checkCode$42 = false;
                String $i$a$-assert-GeneratedCodeCompatibilityChecker$checkCode$42 = StringsKt.trimIndent((String)("\n          Current API version of the generator is '" + CodeGeneratorVersions.INSTANCE.getAPI_VERSION() + "',\n          but the generated implementation code is marked as version '" + entityImplApiVersion + "'.\n          Please, regenerate your entities.\n          \n          Checked entity: " + implClass + "\n        "));
                throw new AssertionError((Object)$i$a$-assert-GeneratedCodeCompatibilityChecker$checkCode$42);
            }
        }
        if (CodeGeneratorVersions.INSTANCE.getCheckImplInImpl()) {
            boolean bl;
            Intrinsics.checkNotNull((Object)implAnnotations);
            Annotation[] $this$filterIsInstance$iv = implAnnotations;
            boolean $i$f$filterIsInstance = false;
            $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv3 = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Annotation element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof GeneratedCodeImplVersion)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            GeneratedCodeImplVersion generatedCodeImplVersion = (GeneratedCodeImplVersion)CollectionsKt.singleOrNull((List)((List)destination$iv$iv3));
            if (generatedCodeImplVersion == null) {
                throw new IllegalStateException(("Generated class '" + implClass + "' doesn't have an impl version marker. You should regenerate the code of your entities").toString());
            }
            int entityImplImplVersion = generatedCodeImplVersion.version();
            boolean bl5 = bl = entityImplImplVersion == CodeGeneratorVersions.INSTANCE.getIMPL_VERSION();
            if (_Assertions.ENABLED && !bl) {
                boolean bl6 = false;
                String string = StringsKt.trimIndent((String)("\n          Current IMPL version of the generator is '" + CodeGeneratorVersions.INSTANCE.getIMPL_VERSION() + "',\n          but the generated code is marked as version '" + entityImplImplVersion + "'.\n          Please, regenerate your entities.\n          \n          Checked entity: " + implClass + "\n        "));
                throw new AssertionError((Object)string);
            }
        }
    }

    private final Class<?> toBuilderClass(Class<WorkspaceEntity> $this$toBuilderClass) {
        String string = $this$toBuilderClass.getName() + "$Builder";
        ClassLoader classLoader = $this$toBuilderClass.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        return UtilsKt.loadClassByName(string, classLoader);
    }

    private final Class<?> toImplClass(Class<WorkspaceEntity> $this$toImplClass) {
        String string = $this$toImplClass.getPackageName() + ".impl." + $this$toImplClass.getSimpleName() + "Impl";
        ClassLoader classLoader = $this$toImplClass.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        return UtilsKt.loadClassByName(string, classLoader);
    }
}

