/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import java.util.BitSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vfs/DeduplicatingVirtualFileFilter;", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "delegate", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFileFilter;)V", "visited", "Ljava/util/BitSet;", "accept", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.core.impl"})
public final class DeduplicatingVirtualFileFilter
implements VirtualFileFilter {
    @Nullable
    private final VirtualFileFilter delegate;
    @NotNull
    private final BitSet visited;

    public DeduplicatingVirtualFileFilter(@Nullable VirtualFileFilter delegate) {
        this.delegate = delegate;
        this.visited = new BitSet();
    }

    @Override
    public boolean accept(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.delegate != null) {
            return this.delegate.accept(file);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return true;
        }
        int fileId = ((VirtualFileWithId)((Object)file)).getId();
        if (fileId <= 0) {
            return true;
        }
        boolean wasVisited = this.visited.get(fileId);
        this.visited.set(fileId);
        return !wasVisited;
    }
}

