/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.UtilBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.io.URLUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.NonExtendable
@ApiStatus.Obsolete
public class FileUtil {
    public static final String ASYNC_DELETE_EXTENSION = ".__del__";
    public static final int REGEX_PATTERN_FLAGS = SystemInfoRt.isFileSystemCaseSensitive ? 0 : 2;
    private static final Logger LOG = Logger.getInstance(FileUtil.class);
    private static final FileUtilRt.SymlinkResolver SYMLINK_RESOLVER = new FileUtilRt.SymlinkResolver(){

        @Override
        @NotNull
        public String resolveSymlinksAndCanonicalize(@NotNull String path, char separatorChar, boolean removeLastSlash) {
            String string;
            if (path == null) {
                1.$$$reportNull$$$0(0);
            }
            try {
                string = new File(path).getCanonicalPath().replace(separatorChar, '/');
            }
            catch (IOException ignore) {
                String string2 = FileUtil.toCanonicalPath(path, separatorChar, removeLastSlash, false);
                if (string2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string2;
            }
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isSymlink(@NotNull CharSequence path) {
            if (path == null) {
                1.$$$reportNull$$$0(3);
            }
            return Files.isSymbolicLink(Paths.get(path.toString(), new String[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/io/FileUtil$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/io/FileUtil$1";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveSymlinksAndCanonicalize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveSymlinksAndCanonicalize";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSymlink";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @ApiStatus.Internal
    public static final TObjectHashingStrategy<File> FILE_HASHING_STRATEGY;

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String join(String ... parts) {
        if (parts == null) {
            FileUtil.$$$reportNull$$$0(0);
        }
        String string = String.join((CharSequence)File.separator, parts);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Contract(pure=true)
    @Nullable
    @NlsSafe
    public static String getRelativePath(File base, File file) {
        return FileUtilRt.getRelativePath(base, file);
    }

    @Contract(pure=true)
    @Nullable
    @NlsSafe
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator) {
        if (basePath == null) {
            FileUtil.$$$reportNull$$$0(2);
        }
        if (filePath == null) {
            FileUtil.$$$reportNull$$$0(3);
        }
        return FileUtilRt.getRelativePath(basePath, filePath, separator);
    }

    @Contract(pure=true)
    @Nullable
    @NlsSafe
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator, boolean caseSensitive) {
        if (basePath == null) {
            FileUtil.$$$reportNull$$$0(4);
        }
        if (filePath == null) {
            FileUtil.$$$reportNull$$$0(5);
        }
        return FileUtilRt.getRelativePath(basePath, filePath, separator, caseSensitive);
    }

    public static boolean isAbsolute(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(6);
        }
        return !path.isEmpty() && new File(path).isAbsolute();
    }

    public static boolean exists(@Nullable String path) {
        return path != null && new File(path).exists();
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file, boolean strict) {
        if (ancestor == null) {
            FileUtil.$$$reportNull$$$0(7);
        }
        if (file == null) {
            FileUtil.$$$reportNull$$$0(8);
        }
        return FileUtil.isAncestor(ancestor.getPath(), file.getPath(), strict);
    }

    public static boolean isAncestor(@NotNull String ancestor, @NotNull String file, boolean strict) {
        if (ancestor == null) {
            FileUtil.$$$reportNull$$$0(9);
        }
        if (file == null) {
            FileUtil.$$$reportNull$$$0(10);
        }
        return !ThreeState.NO.equals((Object)FileUtil.isAncestorThreeState(ancestor, file, strict));
    }

    @NotNull
    public static ThreeState isAncestorThreeState(@NotNull String ancestor, @NotNull String file, boolean strict) {
        if (ancestor == null) {
            FileUtil.$$$reportNull$$$0(11);
        }
        if (file == null) {
            FileUtil.$$$reportNull$$$0(12);
        }
        String ancestorPath = FileUtil.toCanonicalPath(ancestor);
        String filePath = FileUtil.toCanonicalPath(file);
        return FileUtil.startsWith(filePath, ancestorPath, strict, SystemInfoRt.isFileSystemCaseSensitive, true);
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull String path, @NotNull String prefix) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(13);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(14);
        }
        return FileUtil.startsWith(path, prefix, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull String path, @NotNull String prefix, boolean isCaseSensitive) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(15);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(16);
        }
        return FileUtil.startsWith(path, prefix, isCaseSensitive, false);
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull String path, @NotNull String prefix, boolean isCaseSensitive, boolean strict) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(17);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(18);
        }
        return !ThreeState.NO.equals((Object)FileUtil.startsWith(path, prefix, strict, isCaseSensitive, false));
    }

    @Contract(pure=true)
    @NotNull
    private static ThreeState startsWith(@NotNull String path, @NotNull String prefix, boolean strict, boolean isCaseSensitive, boolean checkImmediateParent) {
        char next;
        if (path == null) {
            FileUtil.$$$reportNull$$$0(19);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(20);
        }
        int pathLength = path.length();
        int prefixLength = prefix.length();
        if (prefixLength == 0) {
            ThreeState threeState = pathLength == 0 ? ThreeState.YES : ThreeState.UNSURE;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(21);
            }
            return threeState;
        }
        if (prefixLength > pathLength) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(22);
            }
            return threeState;
        }
        if (!path.regionMatches(!isCaseSensitive, 0, prefix, 0, prefixLength)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(23);
            }
            return threeState;
        }
        if (pathLength == prefixLength) {
            ThreeState threeState = strict ? ThreeState.NO : ThreeState.YES;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(24);
            }
            return threeState;
        }
        char lastPrefixChar = prefix.charAt(prefixLength - 1);
        int slashOrSeparatorIdx = prefixLength;
        if (lastPrefixChar == '/' || lastPrefixChar == File.separatorChar) {
            slashOrSeparatorIdx = prefixLength - 1;
        }
        if ((next = path.charAt(slashOrSeparatorIdx)) == '/' || next == File.separatorChar) {
            if (!checkImmediateParent) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    FileUtil.$$$reportNull$$$0(25);
                }
                return threeState;
            }
            if (slashOrSeparatorIdx == pathLength - 1) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    FileUtil.$$$reportNull$$$0(26);
                }
                return threeState;
            }
            int idxNext = path.indexOf(next, slashOrSeparatorIdx + 1);
            idxNext = idxNext == -1 ? path.indexOf(next == '/' ? 92 : 47, slashOrSeparatorIdx + 1) : idxNext;
            ThreeState threeState = idxNext == -1 ? ThreeState.YES : ThreeState.UNSURE;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(27);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState == null) {
            FileUtil.$$$reportNull$$$0(28);
        }
        return threeState;
    }

    @Contract(pure=true)
    @Nullable
    public static File findAncestor(@NotNull File f1, @NotNull File f2) {
        File ancestor;
        if (f1 == null) {
            FileUtil.$$$reportNull$$$0(29);
        }
        if (f2 == null) {
            FileUtil.$$$reportNull$$$0(30);
        }
        for (ancestor = f1; ancestor != null && !FileUtil.isAncestor(ancestor, f2, false); ancestor = ancestor.getParentFile()) {
        }
        return ancestor;
    }

    @Contract(pure=true)
    @Nullable
    public static Path findAncestor(@NotNull Path path1, @NotNull Path path2) {
        Path ancestor;
        if (path1 == null) {
            FileUtil.$$$reportNull$$$0(31);
        }
        if (path2 == null) {
            FileUtil.$$$reportNull$$$0(32);
        }
        for (ancestor = path1; ancestor != null && !path2.startsWith(ancestor); ancestor = ancestor.getParent()) {
        }
        return ancestor;
    }

    @Contract(pure=true)
    @Nullable
    public static File getParentFile(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(33);
        }
        return FileUtilRt.getParentFile(file);
    }

    public static byte @NotNull [] loadFileBytes(@NotNull File file) throws IOException {
        byte[] bytes;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(34);
        }
        try (FileInputStream stream = new FileInputStream(file);){
            long len = file.length();
            if (len < 0L) {
                throw new IOException("File length reported negative, probably doesn't exist");
            }
            if (FileUtilRt.isTooLarge(len)) {
                throw new FileTooBigException("Attempt to load '" + file + "' in memory buffer, file length is " + len + " bytes.");
            }
            bytes = FileUtil.loadBytes(stream, (int)len);
        }
        if (bytes == null) {
            FileUtil.$$$reportNull$$$0(35);
        }
        return bytes;
    }

    @Deprecated
    public static byte @NotNull [] loadFirstAndClose(@NotNull InputStream stream, int maxLength) throws IOException {
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(36);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            FileUtil.copy(stream, maxLength, (OutputStream)buffer);
        }
        finally {
            stream.close();
        }
        byte[] byArray = buffer.toByteArray();
        if (byArray == null) {
            FileUtil.$$$reportNull$$$0(37);
        }
        return byArray;
    }

    @NotNull
    public static String loadTextAndClose(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(38);
        }
        return FileUtil.loadTextAndClose(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    @NotNull
    public static String loadTextAndClose(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            FileUtil.$$$reportNull$$$0(39);
        }
        String string = new String(FileUtil.adaptiveLoadText(reader));
        String string2 = string;
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(40);
        }
        return string2;
        finally {
            reader.close();
        }
    }

    public static char @NotNull [] adaptiveLoadText(@NotNull Reader reader) throws IOException {
        int n;
        if (reader == null) {
            FileUtil.$$$reportNull$$$0(41);
        }
        char[] chars = new char[4096];
        ArrayList<char[]> buffers = null;
        int count2 = 0;
        int total = 0;
        while ((n = reader.read(chars, count2, chars.length - count2)) > 0) {
            count2 += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + reader);
            }
            total += n;
            if (count2 != chars.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<char[]>();
            }
            buffers.add(chars);
            int newLength = Math.min(0x100000, chars.length * 2);
            chars = new char[newLength];
            count2 = 0;
        }
        char[] result = new char[total];
        if (buffers != null) {
            for (char[] buffer : buffers) {
                System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(chars, 0, result, result.length - total, total);
        if (result == null) {
            FileUtil.$$$reportNull$$$0(42);
        }
        return result;
    }

    public static byte @NotNull [] adaptiveLoadBytes(@NotNull InputStream stream) throws IOException {
        int n;
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(43);
        }
        byte[] bytes = new byte[8192];
        ArrayList<byte[]> buffers = null;
        int count2 = 0;
        int total = 0;
        while ((n = stream.read(bytes, count2, bytes.length - count2)) > 0) {
            count2 += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + stream);
            }
            total += n;
            if (count2 != bytes.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<byte[]>();
            }
            buffers.add(bytes);
            int newLength = Math.min(0x100000, bytes.length * 2);
            bytes = new byte[newLength];
            count2 = 0;
        }
        byte[] result = ArrayUtil.newByteArray(total);
        if (buffers != null) {
            for (byte[] buffer : buffers) {
                System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(bytes, 0, result, result.length - total, total);
        if (result == null) {
            FileUtil.$$$reportNull$$$0(44);
        }
        return result;
    }

    @NotNull
    public static Future<Void> asyncDelete(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(45);
        }
        return FileUtil.asyncDelete(Collections.singleton(file));
    }

    @NotNull
    public static Future<Void> asyncDelete(@NotNull Collection<? extends File> files) {
        if (files == null) {
            FileUtil.$$$reportNull$$$0(46);
        }
        ArrayList<File> tempFiles = new ArrayList<File>();
        for (File file : files) {
            File tempFile = FileUtil.renameToTempFileOrDelete(file);
            if (tempFile == null) continue;
            tempFiles.add(tempFile);
        }
        Future<Object> future = tempFiles.isEmpty() ? CompletableFuture.completedFuture(null) : AppExecutorUtil.getAppExecutorService().submit(() -> {
            Thread currentThread = Thread.currentThread();
            int priority = currentThread.getPriority();
            currentThread.setPriority(1);
            try {
                for (File tempFile : tempFiles) {
                    FileUtil.delete(tempFile);
                }
            }
            finally {
                currentThread.setPriority(priority);
            }
            return null;
        });
        if (future == null) {
            FileUtil.$$$reportNull$$$0(47);
        }
        return future;
    }

    @Nullable
    private static File renameToTempFileOrDelete(@NotNull File file) {
        String originalFileName;
        File tempFile;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(48);
        }
        String tempDir = FileUtil.getTempDirectory();
        boolean isSameDrive = true;
        if (SystemInfoRt.isWindows) {
            String tempDirDrive = tempDir.substring(0, 2);
            String fileDrive = file.getAbsolutePath().substring(0, 2);
            isSameDrive = tempDirDrive.equalsIgnoreCase(fileDrive);
        }
        if (isSameDrive && file.renameTo(tempFile = FileUtil.getTempFile(originalFileName = file.getName(), tempDir))) {
            return tempFile;
        }
        FileUtil.delete(file);
        return null;
    }

    @NotNull
    private static File getTempFile(@NotNull String originalFileName, @NotNull String parent) {
        int randomSuffix;
        if (originalFileName == null) {
            FileUtil.$$$reportNull$$$0(49);
        }
        if (parent == null) {
            FileUtil.$$$reportNull$$$0(50);
        }
        int i = randomSuffix = (int)(System.currentTimeMillis() % 1000L);
        while (true) {
            String name;
            File tempFile;
            if (!(tempFile = new File(parent, name = "___" + originalFileName + i + ASYNC_DELETE_EXTENSION)).exists()) {
                File file = tempFile;
                if (file == null) {
                    FileUtil.$$$reportNull$$$0(51);
                }
                return file;
            }
            ++i;
        }
    }

    public static boolean delete(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(52);
        }
        return FileUtilRt.delete(file);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void deleteRecursively(@NotNull Path file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(53);
        }
        FileUtilRt.deleteRecursively(file, null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void delete(@NotNull Path path) throws IOException {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(54);
        }
        FileUtilRt.deleteRecursively(path, null);
    }

    public static boolean createParentDirs(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(55);
        }
        return FileUtilRt.createParentDirs(file);
    }

    public static boolean createDirectory(@NotNull File path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(56);
        }
        return FileUtilRt.createDirectory(path);
    }

    public static boolean createIfDoesntExist(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(57);
        }
        return FileUtilRt.createIfNotExists(file);
    }

    public static boolean ensureCanCreateFile(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(58);
        }
        return FileUtilRt.ensureCanCreateFile(file);
    }

    public static boolean createIfNotExists(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(59);
        }
        return FileUtilRt.createIfNotExists(file);
    }

    public static void copy(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (fromFile == null) {
            FileUtil.$$$reportNull$$$0(60);
        }
        if (toFile == null) {
            FileUtil.$$$reportNull$$$0(61);
        }
        FileUtil.performCopy(fromFile, toFile, true);
    }

    public static void copyContent(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (fromFile == null) {
            FileUtil.$$$reportNull$$$0(62);
        }
        if (toFile == null) {
            FileUtil.$$$reportNull$$$0(63);
        }
        FileUtil.performCopy(fromFile, toFile, false);
    }

    private static void performCopy(@NotNull File _fromFile, @NotNull File _toFile, boolean syncTimestamp) throws IOException {
        if (_fromFile == null) {
            FileUtil.$$$reportNull$$$0(64);
        }
        if (_toFile == null) {
            FileUtil.$$$reportNull$$$0(65);
        }
        if (FileUtil.filesEqual(_fromFile, _toFile)) {
            return;
        }
        Path fromFile = _fromFile.toPath();
        Path toFile = _toFile.toPath();
        try (InputStream in = Files.newInputStream(fromFile, new OpenOption[0]);
             OutputStream out = FileUtil.openOutputStream(toFile);){
            FileUtil.copy(in, out);
        }
        catch (IOException e) {
            throw new IOException(String.format("Couldn't copy [%s] to [%s]", fromFile, toFile), e);
        }
        if (syncTimestamp) {
            try {
                FileTime timeStamp = Files.getLastModifiedTime(fromFile, new LinkOption[0]);
                Files.setLastModifiedTime(toFile, timeStamp);
            }
            catch (IOException e) {
                LOG.warn("Unable to set timestamp of '" + toFile + "'");
            }
        }
        if (SystemInfoRt.isUnix) {
            EnumSet<PosixFilePermission> exec = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE);
            try {
                Set<PosixFilePermission> fromSet = Files.getPosixFilePermissions(fromFile, new LinkOption[0]);
                if (ContainerUtil.exists(exec, fromSet::contains)) {
                    Set<PosixFilePermission> toSet = Files.getPosixFilePermissions(toFile, new LinkOption[0]);
                    for (PosixFilePermission permission : exec) {
                        if (fromSet.contains((Object)permission)) {
                            toSet.add(permission);
                            continue;
                        }
                        toSet.remove((Object)permission);
                    }
                    Files.setPosixFilePermissions(toFile, toSet);
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to set permissions of '" + toFile + "'");
            }
        }
    }

    private static OutputStream openOutputStream(Path file) throws IOException {
        try {
            return Files.newOutputStream(file, new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            Path parentDir = file.getParent();
            if (parentDir == null) {
                throw new IOException("Parent file is null for " + file, e);
            }
            Files.createDirectories(parentDir, new FileAttribute[0]);
            return Files.newOutputStream(file, new OpenOption[0]);
        }
    }

    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            FileUtil.$$$reportNull$$$0(66);
        }
        if (outputStream == null) {
            FileUtil.$$$reportNull$$$0(67);
        }
        FileUtilRt.copy(inputStream, outputStream);
    }

    public static void copy(@NotNull InputStream inputStream, int maxSize, @NotNull OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            FileUtil.$$$reportNull$$$0(68);
        }
        if (outputStream == null) {
            FileUtil.$$$reportNull$$$0(69);
        }
        FileUtil.copy(inputStream, (long)maxSize, outputStream);
    }

    /*
     * WARNING - void declaration
     */
    public static void copy(@NotNull InputStream inputStream, long maxSize, @NotNull OutputStream outputStream) throws IOException {
        int read2;
        if (inputStream == null) {
            FileUtil.$$$reportNull$$$0(70);
        }
        if (outputStream == null) {
            FileUtil.$$$reportNull$$$0(71);
        }
        byte[] buffer = new byte[8192];
        for (long toRead = maxSize; toRead > 0L && (read2 = inputStream.read(buffer, 0, (int)Math.min((long)buffer.length, toRead))) >= 0; toRead -= (long)read2) {
            void outputStream2;
            outputStream2.write(buffer, 0, read2);
        }
    }

    public static void copyFileOrDir(@NotNull File from, @NotNull File to) throws IOException {
        if (from == null) {
            FileUtil.$$$reportNull$$$0(72);
        }
        if (to == null) {
            FileUtil.$$$reportNull$$$0(73);
        }
        FileUtil.copyFileOrDir(from, to, from.isDirectory());
    }

    public static void copyFileOrDir(@NotNull File from, @NotNull File to, boolean isDir) throws IOException {
        if (from == null) {
            FileUtil.$$$reportNull$$$0(74);
        }
        if (to == null) {
            FileUtil.$$$reportNull$$$0(75);
        }
        if (isDir) {
            FileUtil.copyDir(from, to);
        } else {
            FileUtil.copy(from, to);
        }
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir) throws IOException {
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(76);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(77);
        }
        FileUtil.copyDir(fromDir, toDir, true);
    }

    public static void copyDirContent(@NotNull File fromDir, @NotNull File toDir) throws IOException {
        File[] children2;
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(78);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(79);
        }
        for (File child : children2 = ObjectUtils.notNull(fromDir.listFiles(), ArrayUtilRt.EMPTY_FILE_ARRAY)) {
            FileUtil.copyFileOrDir(child, new File(toDir, child.getName()));
        }
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir, boolean copySystemFiles) throws IOException {
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(80);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(81);
        }
        FileUtil.copyDir(fromDir, toDir, copySystemFiles ? null : file -> !StringUtil.startsWithChar(file.getName(), '.'));
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir, @Nullable FileFilter filter2) throws IOException {
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(82);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(83);
        }
        FileUtil.ensureExists(toDir);
        if (FileUtil.isAncestor(fromDir, toDir, true)) {
            LOG.error(fromDir.getAbsolutePath() + " is ancestor of " + toDir + ". Can't copy to itself.");
            return;
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            throw new IOException(UtilBundle.message("exception.directory.is.invalid", fromDir.getPath()));
        }
        if (!fromDir.canRead()) {
            throw new IOException(UtilBundle.message("exception.directory.is.not.readable", fromDir.getPath()));
        }
        for (File file : files) {
            if (filter2 != null && !filter2.accept(file)) continue;
            if (file.isDirectory()) {
                FileUtil.copyDir(file, new File(toDir, file.getName()), filter2);
                continue;
            }
            FileUtil.copy(file, new File(toDir, file.getName()));
        }
    }

    public static void ensureExists(@NotNull File dir) throws IOException {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(84);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException(UtilBundle.message("exception.directory.can.not.create", dir.getPath()));
        }
    }

    @NotNull
    @NlsSafe
    public static String getNameWithoutExtension(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(85);
        }
        String string = FileUtilRt.getNameWithoutExtension(file.getName());
        if (string == null) {
            FileUtil.$$$reportNull$$$0(86);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String getNameWithoutExtension(@NotNull String name) {
        if (name == null) {
            FileUtil.$$$reportNull$$$0(87);
        }
        String string = FileUtilRt.getNameWithoutExtension(name);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(88);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String createSequentFileName(@NotNull File aParentFolder, @NotNull String aFilePrefix, @NotNull String aExtension) {
        if (aParentFolder == null) {
            FileUtil.$$$reportNull$$$0(89);
        }
        if (aFilePrefix == null) {
            FileUtil.$$$reportNull$$$0(90);
        }
        if (aExtension == null) {
            FileUtil.$$$reportNull$$$0(91);
        }
        String string = FileUtil.findSequentNonexistentFile(aParentFolder, aFilePrefix, aExtension).getName();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(92);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String createSequentFileName(@NotNull File aParentFolder, @NotNull String aFilePrefix, @NotNull String aExtension, @NotNull Predicate<? super File> condition) {
        if (aParentFolder == null) {
            FileUtil.$$$reportNull$$$0(93);
        }
        if (aFilePrefix == null) {
            FileUtil.$$$reportNull$$$0(94);
        }
        if (aExtension == null) {
            FileUtil.$$$reportNull$$$0(95);
        }
        if (condition == null) {
            FileUtil.$$$reportNull$$$0(96);
        }
        String string = FileUtil.findSequentFile(aParentFolder, aFilePrefix, aExtension, condition).getName();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(97);
        }
        return string;
    }

    @NotNull
    public static File findSequentNonexistentFile(@NotNull File parentFolder, @NotNull @NonNls String filePrefix, @NotNull String extension) {
        if (parentFolder == null) {
            FileUtil.$$$reportNull$$$0(98);
        }
        if (filePrefix == null) {
            FileUtil.$$$reportNull$$$0(99);
        }
        if (extension == null) {
            FileUtil.$$$reportNull$$$0(100);
        }
        return FileUtil.findSequentFile(parentFolder, filePrefix, extension, file -> !file.exists());
    }

    @NotNull
    public static File findSequentFile(@NotNull File parentFolder, @NotNull String filePrefix, @NotNull String extension, @NotNull Predicate<? super File> condition) {
        if (parentFolder == null) {
            FileUtil.$$$reportNull$$$0(101);
        }
        if (filePrefix == null) {
            FileUtil.$$$reportNull$$$0(102);
        }
        if (extension == null) {
            FileUtil.$$$reportNull$$$0(103);
        }
        if (condition == null) {
            FileUtil.$$$reportNull$$$0(104);
        }
        int postfix = 0;
        String ext = extension.isEmpty() ? "" : '.' + extension;
        File candidate = new File(parentFolder, filePrefix + ext);
        while (!condition.test(candidate)) {
            candidate = new File(parentFolder, filePrefix + ++postfix + ext);
        }
        File file = candidate;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(105);
        }
        return file;
    }

    @NotNull
    @NlsSafe
    public static String toSystemDependentName(@NotNull String filePath) {
        if (filePath == null) {
            FileUtil.$$$reportNull$$$0(106);
        }
        String string = FileUtilRt.toSystemDependentName(filePath);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(107);
        }
        return string;
    }

    @NotNull
    public static String toSystemDependentName(@NotNull String path, char separatorChar) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(108);
        }
        String string = FileUtilRt.toSystemDependentName(path, separatorChar);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(109);
        }
        return string;
    }

    @NotNull
    @NonNls
    public static String toSystemIndependentName(@NotNull String filePath) {
        if (filePath == null) {
            FileUtil.$$$reportNull$$$0(110);
        }
        String string = FileUtilRt.toSystemIndependentName(filePath);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(111);
        }
        return string;
    }

    @Contract(value="null -> null; !null->!null")
    public static String toCanonicalPath(@Nullable String path) {
        return FileUtilRt.toCanonicalPath(path, File.separatorChar, true);
    }

    public static String toCanonicalPath(@Nullable String path, char separatorChar, boolean removeLastSlash) {
        return FileUtilRt.toCanonicalPath(path, separatorChar, removeLastSlash);
    }

    @Contract(value="null, _ -> null; !null,_->!null")
    public static String toCanonicalPath(@Nullable String path, boolean resolveSymlinksIfNecessary) {
        return FileUtil.toCanonicalPath(path, File.separatorChar, true, resolveSymlinksIfNecessary);
    }

    @Contract(value="null, _ -> null; !null,_->!null")
    public static String toCanonicalPath(@Nullable String path, char separatorChar) {
        return FileUtilRt.toCanonicalPath(path, separatorChar, true);
    }

    @Contract(value="null -> null; !null->!null")
    public static String toCanonicalUriPath(@Nullable String path) {
        return FileUtilRt.toCanonicalPath(path, '/', false);
    }

    @Contract(value="null, _, _, _ -> null; !null,_,_,_->!null")
    private static String toCanonicalPath(@Nullable String path, char separatorChar, boolean removeLastSlash, boolean resolveSymlinks) {
        FileUtilRt.SymlinkResolver symlinkResolver = resolveSymlinks ? SYMLINK_RESOLVER : null;
        return FileUtilRt.toCanonicalPath(path, separatorChar, removeLastSlash, symlinkResolver);
    }

    @NotNull
    public static String normalize(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(112);
        }
        int start = 0;
        boolean separator = false;
        if (SystemInfoRt.isWindows) {
            if (path.startsWith("//")) {
                start = 2;
                separator = true;
            } else if (path.startsWith("\\\\")) {
                return FileUtil.normalizeTail(0, path, false);
            }
        }
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (separator) {
                    return FileUtil.normalizeTail(i, path, true);
                }
                separator = true;
                continue;
            }
            if (c == '\\') {
                return FileUtil.normalizeTail(i, path, separator);
            }
            separator = false;
        }
        String string = path;
        if (string == null) {
            FileUtil.$$$reportNull$$$0(113);
        }
        return string;
    }

    @NotNull
    private static String normalizeTail(int prefixEnd, @NotNull String path, boolean separator) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(114);
        }
        StringBuilder result = new StringBuilder(path.length());
        result.append(path, 0, prefixEnd);
        int start = prefixEnd;
        if (start == 0 && SystemInfoRt.isWindows && (path.startsWith("//") || path.startsWith("\\\\"))) {
            start = 2;
            result.append("//");
            separator = true;
        }
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/' || c == '\\') {
                if (!separator) {
                    result.append('/');
                }
                separator = true;
                continue;
            }
            result.append(c);
            separator = false;
        }
        String string = result.toString();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(115);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String unquote(@NotNull String urlString) {
        if (urlString == null) {
            FileUtil.$$$reportNull$$$0(116);
        }
        urlString = urlString.replace('/', File.separatorChar);
        String string = URLUtil.unescapePercentSequences(urlString);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(117);
        }
        return string;
    }

    public static boolean rename(@NotNull File source, @NotNull String newName) throws IOException {
        if (source == null) {
            FileUtil.$$$reportNull$$$0(118);
        }
        if (newName == null) {
            FileUtil.$$$reportNull$$$0(119);
        }
        File target = new File(source.getParent(), newName);
        if (!SystemInfoRt.isFileSystemCaseSensitive && newName.equalsIgnoreCase(source.getName())) {
            File intermediate = FileUtil.createTempFile(source.getParentFile(), source.getName(), ".tmp", false, false);
            return source.renameTo(intermediate) && intermediate.renameTo(target);
        }
        return source.renameTo(target);
    }

    public static void rename(@NotNull File source, @NotNull File target) throws IOException {
        if (source == null) {
            FileUtil.$$$reportNull$$$0(120);
        }
        if (target == null) {
            FileUtil.$$$reportNull$$$0(121);
        }
        if (source.renameTo(target)) {
            return;
        }
        if (!source.exists()) {
            return;
        }
        FileUtil.copy(source, target);
        FileUtil.delete(source);
    }

    public static boolean filesEqual(@Nullable File file1, @Nullable File file2) {
        return FileUtil.pathsEqual(file1 == null ? null : file1.getPath(), file2 == null ? null : file2.getPath());
    }

    public static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        if (Strings.areSameInstance(path1, path2)) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        path1 = FileUtil.toCanonicalPath(path1);
        path2 = FileUtil.toCanonicalPath(path2);
        return SystemInfoRt.isFileSystemCaseSensitive ? path1.equals(path2) : path1.equalsIgnoreCase(path2);
    }

    public static boolean namesEqual(@Nullable String name1, @Nullable String name2) {
        if (Strings.areSameInstance(name1, name2)) {
            return true;
        }
        if (name1 == null || name2 == null) {
            return false;
        }
        return SystemInfoRt.isFileSystemCaseSensitive ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
    }

    public static int compareFiles(@Nullable File file1, @Nullable File file2) {
        return FileUtil.comparePaths(file1 == null ? null : file1.getPath(), file2 == null ? null : file2.getPath());
    }

    public static int comparePaths(@Nullable String path1, @Nullable String path2) {
        return OSAgnosticPathUtil.COMPARATOR.compare(path1, path2);
    }

    public static int fileHashCode(@Nullable File file) {
        return FileUtilRt.pathHashCode(file == null ? null : file.getPath());
    }

    public static int pathHashCode(@Nullable String path) {
        return FileUtilRt.pathHashCode(path);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            FileUtil.$$$reportNull$$$0(122);
        }
        String string = Strings.toLowerCase(FileUtilRt.getExtension(fileName));
        if (string == null) {
            FileUtil.$$$reportNull$$$0(123);
        }
        return string;
    }

    @NotNull
    public static CharSequence getExtension(@NotNull CharSequence fileName) {
        if (fileName == null) {
            FileUtil.$$$reportNull$$$0(124);
        }
        CharSequence charSequence = FileUtilRt.getExtension(fileName);
        if (charSequence == null) {
            FileUtil.$$$reportNull$$$0(125);
        }
        return charSequence;
    }

    public static CharSequence getExtension(@NotNull CharSequence fileName, @Nullable String defaultValue) {
        if (fileName == null) {
            FileUtil.$$$reportNull$$$0(126);
        }
        return FileUtilRt.getExtension(fileName, defaultValue);
    }

    @NotNull
    @NlsSafe
    public static String resolveShortWindowsName(@NotNull String path) throws IOException {
        String string;
        if (path == null) {
            FileUtil.$$$reportNull$$$0(127);
        }
        try {
            string = SystemInfoRt.isWindows && FileUtil.containsWindowsShortName(path) ? Paths.get(path, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toString() : path;
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
        if (string == null) {
            FileUtil.$$$reportNull$$$0(128);
        }
        return string;
    }

    public static boolean containsWindowsShortName(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(129);
        }
        if (path.indexOf(126) < 0) {
            return false;
        }
        path = FileUtil.toSystemIndependentName(path);
        int start = 0;
        while (start < path.length()) {
            int dot;
            int end = path.indexOf(47, start);
            if (end < 0) {
                end = path.length();
            }
            if ((dot = path.lastIndexOf(46, end)) < start) {
                dot = end;
            }
            if (dot - start > 2 && dot - start <= 8 && end - dot - 1 <= 3 && path.charAt(dot - 2) == '~' && Character.isDigit(path.charAt(dot - 1))) {
                return true;
            }
            start = end + 1;
        }
        return false;
    }

    @Nullable
    public static String extractRootPath(@NotNull String normalizedPath) {
        int sc;
        if (normalizedPath == null) {
            FileUtil.$$$reportNull$$$0(130);
        }
        if (SystemInfoRt.isWindows) {
            int p1;
            if (OSAgnosticPathUtil.startsWithWindowsDrive(normalizedPath)) {
                return StringUtil.toUpperCase(normalizedPath.substring(0, 2));
            }
            if (normalizedPath.startsWith("//") && (p1 = normalizedPath.indexOf(47, 2)) > 2 && PathUtilRt.isWindowsUNCRoot(normalizedPath, p1)) {
                int p2 = normalizedPath.indexOf(47, p1 + 1);
                if (p2 > p1 + 1) {
                    return normalizedPath.substring(0, p2);
                }
                if (p2 < 0) {
                    return normalizedPath;
                }
            }
        } else if (StringUtil.startsWithChar(normalizedPath, '/')) {
            return "/";
        }
        if ((sc = normalizedPath.indexOf("://")) != -1) {
            return normalizedPath.substring(0, sc + "://".length());
        }
        return null;
    }

    public static void collectMatchedFiles(@NotNull File root, @NotNull Pattern pattern, @NotNull List<? super File> outFiles) {
        if (root == null) {
            FileUtil.$$$reportNull$$$0(131);
        }
        if (pattern == null) {
            FileUtil.$$$reportNull$$$0(132);
        }
        if (outFiles == null) {
            FileUtil.$$$reportNull$$$0(133);
        }
        FileUtil.collectMatchedFiles(root, root, pattern, outFiles);
    }

    private static void collectMatchedFiles(@NotNull File absoluteRoot, @NotNull File root, @NotNull Pattern pattern, @NotNull List<? super File> files) {
        File[] dirs;
        if (absoluteRoot == null) {
            FileUtil.$$$reportNull$$$0(134);
        }
        if (root == null) {
            FileUtil.$$$reportNull$$$0(135);
        }
        if (pattern == null) {
            FileUtil.$$$reportNull$$$0(136);
        }
        if (files == null) {
            FileUtil.$$$reportNull$$$0(137);
        }
        if ((dirs = root.listFiles()) == null) {
            return;
        }
        for (File dir : dirs) {
            if (dir.isFile()) {
                String path;
                String relativePath = FileUtil.getRelativePath(absoluteRoot, dir);
                if (relativePath == null || !pattern.matcher(path = FileUtil.toSystemIndependentName(relativePath)).matches()) continue;
                files.add(dir);
                continue;
            }
            FileUtil.collectMatchedFiles(absoluteRoot, dir, pattern, files);
        }
    }

    @RegExp
    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern) {
        if (antPattern == null) {
            FileUtil.$$$reportNull$$$0(138);
        }
        return FileUtil.convertAntToRegexp(antPattern, true);
    }

    @RegExp
    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern, boolean ignoreStartingSlash) {
        boolean isTrailingSlash;
        int start;
        if (antPattern == null) {
            FileUtil.$$$reportNull$$$0(139);
        }
        StringBuilder builder = new StringBuilder();
        int asteriskCount = 0;
        boolean recursive = true;
        for (int idx = start = ignoreStartingSlash && (StringUtil.startsWithChar(antPattern, '/') || StringUtil.startsWithChar(antPattern, '\\')) ? 1 : 0; idx < antPattern.length(); ++idx) {
            char ch = antPattern.charAt(idx);
            if (ch == '*') {
                ++asteriskCount;
                continue;
            }
            boolean foundRecursivePattern = recursive && asteriskCount == 2 && (ch == '/' || ch == '\\');
            boolean asterisksFound = asteriskCount > 0;
            asteriskCount = 0;
            boolean bl = recursive = ch == '/' || ch == '\\';
            if (foundRecursivePattern) {
                builder.append("(?:[^/]+/)*?");
                continue;
            }
            if (asterisksFound) {
                builder.append("[^/]*?");
            }
            if (ch == '(' || ch == ')' || ch == '[' || ch == ']' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '+' || ch == '|') {
                builder.append('\\').append(ch);
                continue;
            }
            if (ch == '?') {
                builder.append("[^/]{1}");
                continue;
            }
            if (ch == '\\') {
                builder.append('/');
                continue;
            }
            builder.append(ch);
        }
        boolean bl = isTrailingSlash = builder.length() > 0 && builder.charAt(builder.length() - 1) == '/';
        if (asteriskCount == 0 && isTrailingSlash || recursive && asteriskCount == 2) {
            if (isTrailingSlash) {
                builder.setLength(builder.length() - 1);
            }
            if (builder.length() == 0) {
                builder.append(".*");
            } else {
                builder.append("(?:$|/.+)");
            }
        } else if (asteriskCount > 0) {
            builder.append("[^/]*?");
        }
        String string = builder.toString();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(140);
        }
        return string;
    }

    public static boolean moveDirWithContent(@NotNull File fromDir, @NotNull File toDir) {
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(141);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(142);
        }
        if (!toDir.exists()) {
            return fromDir.renameTo(toDir);
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            return false;
        }
        boolean success = true;
        for (File fromFile : files) {
            File toFile = new File(toDir, fromFile.getName());
            success = success && fromFile.renameTo(toFile);
        }
        fromDir.delete();
        return success;
    }

    @NotNull
    public static String sanitizeFileName(@NotNull String name) {
        if (name == null) {
            FileUtil.$$$reportNull$$$0(143);
        }
        return FileUtil.sanitizeFileName(name, true);
    }

    @NotNull
    public static String sanitizeFileName(@NotNull String name, boolean strict) {
        if (name == null) {
            FileUtil.$$$reportNull$$$0(144);
        }
        return FileUtil.sanitizeFileName(name, strict, "_");
    }

    @NotNull
    public static String sanitizeFileName(@NotNull String name, boolean strict, @NotNull String replacement) {
        if (name == null) {
            FileUtil.$$$reportNull$$$0(145);
        }
        if (replacement == null) {
            FileUtil.$$$reportNull$$$0(146);
        }
        StringBuilder result = null;
        int last2 = 0;
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            boolean appendReplacement = true;
            if (c > '\u0000' && c < '\u00ff') {
                if (strict ? Character.isLetterOrDigit(c) || c == '_' : Character.isJavaIdentifierPart(c) || c == ' ' || c == '@' || c == '-') {
                    continue;
                }
            } else {
                appendReplacement = false;
            }
            if (result == null) {
                result = new StringBuilder();
            }
            if (last2 < i) {
                result.append(name, last2, i);
            }
            if (appendReplacement) {
                result.append(replacement);
            }
            last2 = i + 1;
        }
        if (result == null) {
            String string = name;
            if (string == null) {
                FileUtil.$$$reportNull$$$0(147);
            }
            return string;
        }
        if (last2 < length) {
            result.append(name, last2, length);
        }
        String string = result.toString();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(148);
        }
        return string;
    }

    public static boolean canExecute(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(149);
        }
        return file.canExecute();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean canWrite(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(150);
        }
        return NioFiles.isWritable(Paths.get(path, new String[0]));
    }

    public static void appendToFile(@NotNull File file, @NotNull String text) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(151);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(152);
        }
        FileUtil.writeToFile(file, text.getBytes(StandardCharsets.UTF_8), true);
    }

    public static void writeToFile(@NotNull File file, byte @NotNull [] content) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(153);
        }
        if (content == null) {
            FileUtil.$$$reportNull$$$0(154);
        }
        FileUtil.writeToFile(file, content, false);
    }

    public static void writeToFile(@NotNull File file, @NotNull String text) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(155);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(156);
        }
        FileUtil.writeToFile(file, text, false);
    }

    public static void writeToFile(@NotNull File file, @NotNull String text, @NotNull Charset charset) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(157);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(158);
        }
        if (charset == null) {
            FileUtil.$$$reportNull$$$0(159);
        }
        FileUtil.writeToFile(file, text.getBytes(charset));
    }

    public static void writeToFile(@NotNull File file, @NotNull String text, boolean append) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(160);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(161);
        }
        FileUtil.writeToFile(file, text.getBytes(StandardCharsets.UTF_8), append);
    }

    public static void writeToFile(@NotNull File file, byte @NotNull [] content, int off, int len) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(162);
        }
        if (content == null) {
            FileUtil.$$$reportNull$$$0(163);
        }
        FileUtil.writeToFile(file, content, off, len, false);
    }

    public static void writeToFile(@NotNull File file, byte @NotNull [] content, boolean append) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(164);
        }
        if (content == null) {
            FileUtil.$$$reportNull$$$0(165);
        }
        FileUtil.writeToFile(file, content, 0, content.length, append);
    }

    private static void writeToFile(@NotNull File file, byte @NotNull [] content, int off, int len, boolean append) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(166);
        }
        if (content == null) {
            FileUtil.$$$reportNull$$$0(167);
        }
        FileUtil.createParentDirs(file);
        try (FileOutputStream stream = new FileOutputStream(file, append);){
            ((OutputStream)stream).write(content, off, len);
        }
    }

    @NotNull
    public static JBTreeTraverser<File> fileTraverser(@Nullable File root) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)Lazy.FILE_TRAVERSER.withRoot(root);
        if (jBTreeTraverser == null) {
            FileUtil.$$$reportNull$$$0(168);
        }
        return jBTreeTraverser;
    }

    public static boolean processFilesRecursively(@NotNull File root, @NotNull Processor<? super File> processor) {
        if (root == null) {
            FileUtil.$$$reportNull$$$0(169);
        }
        if (processor == null) {
            FileUtil.$$$reportNull$$$0(170);
        }
        return FileUtil.fileTraverser(root).bfsTraversal().processEach(processor);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean processFilesRecursively(@NotNull File root, @NotNull Processor<? super File> processor, @Nullable Processor<? super File> directoryFilter) {
        if (root == null) {
            FileUtil.$$$reportNull$$$0(171);
        }
        if (processor == null) {
            FileUtil.$$$reportNull$$$0(172);
        }
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(root);
        while (!queue.isEmpty()) {
            File[] children2;
            File file = (File)queue.removeFirst();
            if (!processor.process(file)) {
                return false;
            }
            if (directoryFilter != null && (!file.isDirectory() || !directoryFilter.process(file)) || (children2 = file.listFiles()) == null) continue;
            ContainerUtil.addAll(queue, children2);
        }
        return true;
    }

    @Nullable
    public static File findFirstThatExist(String ... paths) {
        if (paths == null) {
            FileUtil.$$$reportNull$$$0(173);
        }
        for (String path : paths) {
            File file;
            if (Strings.isEmptyOrSpaces(path) || !(file = new File(FileUtil.toSystemDependentName(path))).exists()) continue;
            return file;
        }
        return null;
    }

    @Nullable
    public static Path findFirstPathThatExist(String ... paths) {
        if (paths == null) {
            FileUtil.$$$reportNull$$$0(174);
        }
        for (String path : paths) {
            Path file;
            if (Strings.isEmptyOrSpaces(path) || !Files.exists(file = Paths.get(FileUtil.toSystemDependentName(path), new String[0]), new LinkOption[0])) continue;
            return file;
        }
        return null;
    }

    @NotNull
    public static List<File> findFilesByMask(@NotNull Pattern pattern, @NotNull File dir) {
        if (pattern == null) {
            FileUtil.$$$reportNull$$$0(175);
        }
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(176);
        }
        ArrayList<File> found = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    found.addAll(FileUtil.findFilesByMask(pattern, file));
                    continue;
                }
                if (!pattern.matcher(file.getName()).matches()) continue;
                found.add(file);
            }
        }
        ArrayList<File> arrayList = found;
        if (arrayList == null) {
            FileUtil.$$$reportNull$$$0(177);
        }
        return arrayList;
    }

    @NotNull
    public static List<Path> findPathsByMask(@NotNull Pattern pattern, @NotNull Path dir) {
        if (pattern == null) {
            FileUtil.$$$reportNull$$$0(178);
        }
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(179);
        }
        ArrayList<Path> found = new ArrayList<Path>();
        try (Stream<Path> files = Files.list(dir);){
            files.forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    found.addAll(FileUtil.findPathsByMask(pattern, path));
                } else if (pattern.matcher(path.getFileName().toString()).matches()) {
                    found.add((Path)path);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ArrayList<Path> arrayList = found;
        if (arrayList == null) {
            FileUtil.$$$reportNull$$$0(180);
        }
        return arrayList;
    }

    @NotNull
    public static List<File> findFilesOrDirsByMask(@NotNull Pattern pattern, @NotNull File dir) {
        if (pattern == null) {
            FileUtil.$$$reportNull$$$0(181);
        }
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(182);
        }
        ArrayList<File> found = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (pattern.matcher(file.getName()).matches()) {
                    found.add(file);
                }
                if (!file.isDirectory()) continue;
                found.addAll(FileUtil.findFilesOrDirsByMask(pattern, file));
            }
        }
        ArrayList<File> arrayList = found;
        if (arrayList == null) {
            FileUtil.$$$reportNull$$$0(183);
        }
        return arrayList;
    }

    @Nullable
    @NlsSafe
    public static String findFileInProvidedPath(@NotNull String providedPath, String ... fileNames) {
        File file;
        if (providedPath == null) {
            FileUtil.$$$reportNull$$$0(184);
        }
        if (fileNames == null) {
            FileUtil.$$$reportNull$$$0(185);
        }
        if (Strings.isEmpty(providedPath)) {
            return "";
        }
        File providedFile = new File(providedPath);
        if (providedFile.exists() && ArrayUtil.indexOf(fileNames, providedFile.getName()) >= 0) {
            return FileUtil.toSystemDependentName(providedFile.getPath());
        }
        if (providedFile.isDirectory()) {
            for (String fileName : fileNames) {
                file = new File(providedFile, fileName);
                if (!fileName.equals(file.getName()) || !file.exists()) continue;
                return FileUtil.toSystemDependentName(file.getPath());
            }
        }
        if ((providedFile = providedFile.getParentFile()) != null && providedFile.exists()) {
            for (String fileName : fileNames) {
                file = new File(providedFile, fileName);
                if (!fileName.equals(file.getName()) || !file.exists()) continue;
                return FileUtil.toSystemDependentName(file.getPath());
            }
        }
        return null;
    }

    @Deprecated
    public static boolean isAbsolutePlatformIndependent(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(186);
        }
        return FileUtil.isUnixAbsolutePath(path) || FileUtil.isWindowsAbsolutePath(path);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isUnixAbsolutePath(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(187);
        }
        return path.startsWith("/");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isWindowsAbsolutePath(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(188);
        }
        return path.length() <= 2 && OSAgnosticPathUtil.startsWithWindowsDrive(path) || OSAgnosticPathUtil.isAbsoluteDosPath(path);
    }

    @Contract(value="null -> null; !null -> !null")
    @NlsSafe
    public static String getLocationRelativeToUserHome(@Nullable String path) {
        return FileUtil.getLocationRelativeToUserHome(path, true);
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    @NlsSafe
    public static String getLocationRelativeToUserHome(@Nullable String path, boolean unixOnly) {
        if (path == null) {
            return null;
        }
        if (SystemInfoRt.isUnix || !unixOnly) {
            File projectDir = new File(path);
            File userHomeDir = new File(SystemProperties.getUserHome());
            if (FileUtil.isAncestor(userHomeDir, projectDir, true)) {
                return '~' + File.separator + FileUtil.getRelativePath(userHomeDir, projectDir);
            }
        }
        return path;
    }

    @Contract(pure=true)
    @NotNull
    public static String expandUserHome(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(189);
        }
        if (path.equals("~")) {
            String string = SystemProperties.getUserHome();
            if (string == null) {
                FileUtil.$$$reportNull$$$0(190);
            }
            return string;
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            String string = SystemProperties.getUserHome() + path.substring(1);
            if (string == null) {
                FileUtil.$$$reportNull$$$0(191);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            FileUtil.$$$reportNull$$$0(192);
        }
        return string;
    }

    public static File @NotNull [] notNullize(File @Nullable [] files) {
        return FileUtil.notNullize(files, ArrayUtilRt.EMPTY_FILE_ARRAY);
    }

    public static File @NotNull [] notNullize(File @Nullable [] files, File @NotNull [] defaultFiles) {
        if (defaultFiles == null) {
            FileUtil.$$$reportNull$$$0(193);
        }
        File[] fileArray = files == null ? defaultFiles : files;
        if (fileArray == null) {
            FileUtil.$$$reportNull$$$0(194);
        }
        return fileArray;
    }

    public static boolean isHashBangLine(@Nullable CharSequence firstCharsIfText, @NotNull String marker) {
        if (marker == null) {
            FileUtil.$$$reportNull$$$0(195);
        }
        if (firstCharsIfText == null) {
            return false;
        }
        if (!StringUtil.startsWith(firstCharsIfText, "#!")) {
            return false;
        }
        int lineBreak = Strings.indexOf(firstCharsIfText, '\n', 2);
        return lineBreak >= 0 && Strings.indexOf(firstCharsIfText, marker, 2, lineBreak) != -1;
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(196);
        }
        File file = FileUtilRt.createTempDirectory(prefix, suffix);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(197);
        }
        return file;
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(198);
        }
        File file = FileUtilRt.createTempDirectory(prefix, suffix, deleteOnExit);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(199);
        }
        return file;
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(200);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(201);
        }
        File file = FileUtilRt.createTempDirectory(dir, prefix, suffix);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(202);
        }
        return file;
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(203);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(204);
        }
        File file = FileUtilRt.createTempDirectory(dir, prefix, suffix, deleteOnExit);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(205);
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(206);
        }
        File file = FileUtilRt.createTempFile(prefix, suffix);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(207);
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(208);
        }
        File file = FileUtilRt.createTempFile(prefix, suffix, deleteOnExit);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(209);
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(210);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(211);
        }
        File file = FileUtilRt.createTempFile(dir, prefix, suffix);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(212);
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create2) throws IOException {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(213);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(214);
        }
        File file = FileUtilRt.createTempFile(dir, prefix, suffix, create2);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(215);
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create2, boolean deleteOnExit) throws IOException {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(216);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(217);
        }
        File file = FileUtilRt.createTempFile(dir, prefix, suffix, create2, deleteOnExit);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(218);
        }
        return file;
    }

    @NotNull
    @NlsSafe
    public static String getTempDirectory() {
        String string = FileUtilRt.getTempDirectory();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(219);
        }
        return string;
    }

    @TestOnly
    public static void resetCanonicalTempPathCache(@NotNull String tempPath) {
        if (tempPath == null) {
            FileUtil.$$$reportNull$$$0(220);
        }
        FileUtilRt.resetCanonicalTempPathCache(tempPath);
    }

    @NotNull
    public static File generateRandomTemporaryPath() throws IOException {
        File file = FileUtilRt.generateRandomTemporaryPath();
        if (file == null) {
            FileUtil.$$$reportNull$$$0(221);
        }
        return file;
    }

    @NotNull
    public static File generateRandomTemporaryPath(@NotNull String prefix, @NotNull String suffix) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(222);
        }
        if (suffix == null) {
            FileUtil.$$$reportNull$$$0(223);
        }
        File file = FileUtilRt.generateRandomTemporaryPath(prefix, suffix);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(224);
        }
        return file;
    }

    public static void setExecutable(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(225);
        }
        NioFiles.setExecutable(file.toPath());
    }

    @Nullable
    public static String loadFileOrNull(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(226);
        }
        return FileUtil.loadFileOrNull(new File(path));
    }

    @Nullable
    public static String loadFileOrNull(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(227);
        }
        try {
            return FileUtil.loadFile(file);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    public static String loadFile(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(228);
        }
        String string = FileUtilRt.loadFile(file);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(229);
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, boolean convertLineSeparators) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(230);
        }
        String string = FileUtilRt.loadFile(file, convertLineSeparators);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(231);
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable String encoding) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(232);
        }
        String string = FileUtilRt.loadFile(file, encoding);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(233);
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, @NotNull Charset encoding) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(234);
        }
        if (encoding == null) {
            FileUtil.$$$reportNull$$$0(235);
        }
        String string = String.valueOf(FileUtilRt.loadFileText(file, encoding));
        if (string == null) {
            FileUtil.$$$reportNull$$$0(236);
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable String encoding, boolean convertLineSeparators) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(237);
        }
        String string = FileUtilRt.loadFile(file, encoding, convertLineSeparators);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(238);
        }
        return string;
    }

    public static char @NotNull [] loadFileText(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(239);
        }
        char[] cArray = FileUtilRt.loadFileText(file);
        if (cArray == null) {
            FileUtil.$$$reportNull$$$0(240);
        }
        return cArray;
    }

    public static char @NotNull [] loadFileText(@NotNull File file, @NotNull Charset encoding) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(241);
        }
        if (encoding == null) {
            FileUtil.$$$reportNull$$$0(242);
        }
        char[] cArray = FileUtilRt.loadFileText(file, encoding);
        if (cArray == null) {
            FileUtil.$$$reportNull$$$0(243);
        }
        return cArray;
    }

    public static char[] loadFileText(@NotNull File file, @Nullable String encoding) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(244);
        }
        return FileUtilRt.loadFileText(file, encoding);
    }

    public static char @NotNull [] loadText(@NotNull Reader reader, int length) throws IOException {
        if (reader == null) {
            FileUtil.$$$reportNull$$$0(245);
        }
        char[] cArray = FileUtilRt.loadText(reader, length);
        if (cArray == null) {
            FileUtil.$$$reportNull$$$0(246);
        }
        return cArray;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(247);
        }
        List<String> list = FileUtilRt.loadLines(file);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(248);
        }
        return list;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file, @Nullable String encoding) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(249);
        }
        List<String> list = FileUtilRt.loadLines(file, encoding);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(250);
        }
        return list;
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path) throws IOException {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(251);
        }
        List<String> list = FileUtilRt.loadLines(path);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(252);
        }
        return list;
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path, @Nullable String encoding) throws IOException {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(253);
        }
        List<String> list = FileUtilRt.loadLines(path, encoding);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(254);
        }
        return list;
    }

    @NotNull
    public static List<String> loadLines(@NotNull BufferedReader reader) throws IOException {
        if (reader == null) {
            FileUtil.$$$reportNull$$$0(255);
        }
        List<String> list = FileUtilRt.loadLines(reader);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(256);
        }
        return list;
    }

    public static byte @NotNull [] loadBytes(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(257);
        }
        byte[] byArray = FileUtilRt.loadBytes(stream);
        if (byArray == null) {
            FileUtil.$$$reportNull$$$0(258);
        }
        return byArray;
    }

    public static byte @NotNull [] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(259);
        }
        byte[] byArray = FileUtilRt.loadBytes(stream, length);
        if (byArray == null) {
            FileUtil.$$$reportNull$$$0(260);
        }
        return byArray;
    }

    @NotNull
    public static List<String> splitPath(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(261);
        }
        List<String> list = FileUtilRt.splitPath(path, File.separatorChar);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(262);
        }
        return list;
    }

    @NotNull
    public static List<String> splitPath(@NotNull String path, char separatorChar) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(263);
        }
        List<String> list = FileUtilRt.splitPath(path, separatorChar);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(264);
        }
        return list;
    }

    public static boolean visitFiles(@NotNull File root, @NotNull Processor<? super File> processor) {
        if (root == null) {
            FileUtil.$$$reportNull$$$0(265);
        }
        if (processor == null) {
            FileUtil.$$$reportNull$$$0(266);
        }
        if (!processor.process(root)) {
            return false;
        }
        File[] children2 = root.listFiles();
        if (children2 != null) {
            for (File child : children2) {
                if (FileUtil.visitFiles(child, processor)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean deleteWithRenamingIfExists(@NotNull Path file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(267);
        }
        return Files.exists(file, new LinkOption[0]) && FileUtil.deleteWithRenaming(file);
    }

    public static boolean deleteWithRenaming(@NotNull Path file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(268);
        }
        return FileUtil.deleteWithRenaming(file.toFile());
    }

    public static boolean deleteWithRenaming(@NotNull File file) {
        File tempFileNameForDeletion;
        boolean success;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(269);
        }
        return FileUtil.delete((success = file.renameTo(tempFileNameForDeletion = FileUtil.findSequentNonexistentFile(file.getParentFile(), file.getName(), ""))) ? tempFileNameForDeletion : file);
    }

    @NotNull
    public static String getUrl(@NotNull File file) {
        String string;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(270);
        }
        try {
            string = file.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            String string2 = "file://" + file.getAbsolutePath();
            if (string2 == null) {
                FileUtil.$$$reportNull$$$0(272);
            }
            return string2;
        }
        if (string == null) {
            FileUtil.$$$reportNull$$$0(271);
        }
        return string;
    }

    @NotNull
    public static URI fileToUri(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(273);
        }
        URI uRI = FileUtilRt.fileToUri(file);
        if (uRI == null) {
            FileUtil.$$$reportNull$$$0(274);
        }
        return uRI;
    }

    public static boolean extensionEquals(@NotNull @NonNls String filePath, @NotNull @NonNls String extension) {
        if (filePath == null) {
            FileUtil.$$$reportNull$$$0(275);
        }
        if (extension == null) {
            FileUtil.$$$reportNull$$$0(276);
        }
        return FileUtilRt.extensionEquals(filePath, extension);
    }

    public static boolean isJarOrZip(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(277);
        }
        return FileUtilRt.isJarOrZip(file, true);
    }

    static {
        TObjectHashingStrategy<File> FILE_HASHING_STRATEGY_temp = null;
        try {
            Class<?> clazz = Class.forName("gnu.trove.TObjectHashingStrategy");
            FILE_HASHING_STRATEGY_temp = new TObjectHashingStrategy<File>(){

                public int computeHashCode(File object) {
                    return FileUtil.fileHashCode(object);
                }

                public boolean equals(File o1, File o2) {
                    return FileUtil.filesEqual(o1, o2);
                }
            };
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            FILE_HASHING_STRATEGY = (TObjectHashingStrategy)FILE_HASHING_STRATEGY_temp;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 47: 
            case 51: 
            case 86: 
            case 88: 
            case 92: 
            case 97: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 117: 
            case 123: 
            case 125: 
            case 128: 
            case 140: 
            case 147: 
            case 148: 
            case 168: 
            case 177: 
            case 180: 
            case 183: 
            case 190: 
            case 191: 
            case 192: 
            case 194: 
            case 197: 
            case 199: 
            case 202: 
            case 205: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 218: 
            case 219: 
            case 221: 
            case 224: 
            case 229: 
            case 231: 
            case 233: 
            case 236: 
            case 238: 
            case 240: 
            case 243: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 254: 
            case 256: 
            case 258: 
            case 260: 
            case 262: 
            case 264: 
            case 271: 
            case 272: 
            case 274: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 47: 
            case 51: 
            case 86: 
            case 88: 
            case 92: 
            case 97: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 117: 
            case 123: 
            case 125: 
            case 128: 
            case 140: 
            case 147: 
            case 148: 
            case 168: 
            case 177: 
            case 180: 
            case 183: 
            case 190: 
            case 191: 
            case 192: 
            case 194: 
            case 197: 
            case 199: 
            case 202: 
            case 205: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 218: 
            case 219: 
            case 221: 
            case 224: 
            case 229: 
            case 231: 
            case 233: 
            case 236: 
            case 238: 
            case 240: 
            case 243: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 254: 
            case 256: 
            case 258: 
            case 260: 
            case 262: 
            case 264: 
            case 271: 
            case 272: 
            case 274: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 47: 
            case 51: 
            case 86: 
            case 88: 
            case 92: 
            case 97: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 117: 
            case 123: 
            case 125: 
            case 128: 
            case 140: 
            case 147: 
            case 148: 
            case 168: 
            case 177: 
            case 180: 
            case 183: 
            case 190: 
            case 191: 
            case 192: 
            case 194: 
            case 197: 
            case 199: 
            case 202: 
            case 205: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 218: 
            case 219: 
            case 221: 
            case 224: 
            case 229: 
            case 231: 
            case 233: 
            case 236: 
            case 238: 
            case 240: 
            case 243: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 254: 
            case 256: 
            case 258: 
            case 260: 
            case 262: 
            case 264: 
            case 271: 
            case 272: 
            case 274: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/FileUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 3: 
            case 5: 
            case 106: 
            case 110: 
            case 275: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 54: 
            case 56: 
            case 108: 
            case 112: 
            case 114: 
            case 127: 
            case 129: 
            case 150: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 226: 
            case 251: 
            case 253: 
            case 261: 
            case 263: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 33: 
            case 34: 
            case 45: 
            case 48: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 85: 
            case 149: 
            case 151: 
            case 153: 
            case 155: 
            case 157: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 225: 
            case 227: 
            case 228: 
            case 230: 
            case 232: 
            case 234: 
            case 237: 
            case 239: 
            case 241: 
            case 244: 
            case 247: 
            case 249: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 273: 
            case 277: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 196: 
            case 198: 
            case 201: 
            case 204: 
            case 206: 
            case 208: 
            case 211: 
            case 214: 
            case 217: 
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f1";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f2";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 36: 
            case 38: 
            case 43: 
            case 257: 
            case 259: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 39: 
            case 41: 
            case 245: 
            case 255: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 46: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFileName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_fromFile";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_toFile";
                break;
            }
            case 66: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 67: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromDir";
                break;
            }
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 84: 
            case 176: 
            case 179: 
            case 182: 
            case 200: 
            case 203: 
            case 210: 
            case 213: 
            case 216: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 87: 
            case 143: 
            case 144: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 89: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aParentFolder";
                break;
            }
            case 90: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aFilePrefix";
                break;
            }
            case 91: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aExtension";
                break;
            }
            case 96: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 98: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFolder";
                break;
            }
            case 99: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePrefix";
                break;
            }
            case 100: 
            case 103: 
            case 276: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlString";
                break;
            }
            case 118: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 122: 
            case 124: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedPath";
                break;
            }
            case 131: 
            case 135: 
            case 169: 
            case 171: 
            case 265: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 132: 
            case 136: 
            case 175: 
            case 178: 
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outFiles";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteRoot";
                break;
            }
            case 138: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "antPattern";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 152: 
            case 156: 
            case 158: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 154: 
            case 163: 
            case 165: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 170: 
            case 172: 
            case 266: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 173: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providedPath";
                break;
            }
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFiles";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 220: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempPath";
                break;
            }
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 235: 
            case 242: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/FileUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "startsWith";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileBytes";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFirstAndClose";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTextAndClose";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptiveLoadText";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptiveLoadBytes";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncDelete";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempFile";
                break;
            }
            case 86: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 92: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "createSequentFileName";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "findSequentFile";
                break;
            }
            case 107: 
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemIndependentName";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeTail";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "unquote";
                break;
            }
            case 123: 
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveShortWindowsName";
                break;
            }
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAntToRegexp";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeFileName";
                break;
            }
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "fileTraverser";
                break;
            }
            case 177: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesByMask";
                break;
            }
            case 180: {
                objectArray = objectArray2;
                objectArray2[1] = "findPathsByMask";
                break;
            }
            case 183: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesOrDirsByMask";
                break;
            }
            case 190: 
            case 191: 
            case 192: {
                objectArray = objectArray2;
                objectArray2[1] = "expandUserHome";
                break;
            }
            case 194: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 197: 
            case 199: 
            case 202: 
            case 205: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 218: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 219: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 221: 
            case 224: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRandomTemporaryPath";
                break;
            }
            case 229: 
            case 231: 
            case 233: 
            case 236: 
            case 238: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
            case 240: 
            case 243: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileText";
                break;
            }
            case 246: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 248: 
            case 250: 
            case 252: 
            case 254: 
            case 256: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLines";
                break;
            }
            case 258: 
            case 260: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
            case 262: 
            case 264: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
            case 271: 
            case 272: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 274: {
                objectArray = objectArray2;
                objectArray2[1] = "fileToUri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 47: 
            case 51: 
            case 86: 
            case 88: 
            case 92: 
            case 97: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 117: 
            case 123: 
            case 125: 
            case 128: 
            case 140: 
            case 147: 
            case 148: 
            case 168: 
            case 177: 
            case 180: 
            case 183: 
            case 190: 
            case 191: 
            case 192: 
            case 194: 
            case 197: 
            case 199: 
            case 202: 
            case 205: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 218: 
            case 219: 
            case 221: 
            case 224: 
            case 229: 
            case 231: 
            case 233: 
            case 236: 
            case 238: 
            case 240: 
            case 243: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 254: 
            case 256: 
            case 258: 
            case 260: 
            case 262: 
            case 264: 
            case 271: 
            case 272: 
            case 274: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolute";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAncestorThreeState";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findAncestor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getParentFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "loadFileBytes";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "loadFirstAndClose";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "loadTextAndClose";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "adaptiveLoadText";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "adaptiveLoadBytes";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "asyncDelete";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "renameToTempFileOrDelete";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getTempFile";
                break;
            }
            case 52: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "deleteRecursively";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createParentDirs";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createIfDoesntExist";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "ensureCanCreateFile";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createIfNotExists";
                break;
            }
            case 60: 
            case 61: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "copyContent";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "copyFileOrDir";
                break;
            }
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "copyDir";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "copyDirContent";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "ensureExists";
                break;
            }
            case 85: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "createSequentFileName";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "findSequentNonexistentFile";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "findSequentFile";
                break;
            }
            case 106: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "toSystemIndependentName";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "normalizeTail";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "unquote";
                break;
            }
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 122: 
            case 124: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "resolveShortWindowsName";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "containsWindowsShortName";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "collectMatchedFiles";
                break;
            }
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "convertAntToRegexp";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "moveDirWithContent";
                break;
            }
            case 143: 
            case 144: 
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeFileName";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "canExecute";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "canWrite";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "appendToFile";
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "writeToFile";
                break;
            }
            case 169: 
            case 170: 
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "processFilesRecursively";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "findFirstThatExist";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "findFirstPathThatExist";
                break;
            }
            case 175: 
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "findFilesByMask";
                break;
            }
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "findPathsByMask";
                break;
            }
            case 181: 
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "findFilesOrDirsByMask";
                break;
            }
            case 184: 
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "findFileInProvidedPath";
                break;
            }
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolutePlatformIndependent";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "isUnixAbsolutePath";
                break;
            }
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "isWindowsAbsolutePath";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "expandUserHome";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "isHashBangLine";
                break;
            }
            case 196: 
            case 198: 
            case 200: 
            case 201: 
            case 203: 
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "createTempDirectory";
                break;
            }
            case 206: 
            case 208: 
            case 210: 
            case 211: 
            case 213: 
            case 214: 
            case 216: 
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "resetCanonicalTempPathCache";
                break;
            }
            case 222: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "generateRandomTemporaryPath";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "setExecutable";
                break;
            }
            case 226: 
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "loadFileOrNull";
                break;
            }
            case 228: 
            case 230: 
            case 232: 
            case 234: 
            case 235: 
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
            case 239: 
            case 241: 
            case 242: 
            case 244: {
                objectArray = objectArray;
                objectArray[2] = "loadFileText";
                break;
            }
            case 245: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 247: 
            case 249: 
            case 251: 
            case 253: 
            case 255: {
                objectArray = objectArray;
                objectArray[2] = "loadLines";
                break;
            }
            case 257: 
            case 259: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 261: 
            case 263: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 265: 
            case 266: {
                objectArray = objectArray;
                objectArray[2] = "visitFiles";
                break;
            }
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "deleteWithRenamingIfExists";
                break;
            }
            case 268: 
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "deleteWithRenaming";
                break;
            }
            case 270: {
                objectArray = objectArray;
                objectArray[2] = "getUrl";
                break;
            }
            case 273: {
                objectArray = objectArray;
                objectArray[2] = "fileToUri";
                break;
            }
            case 275: 
            case 276: {
                objectArray = objectArray;
                objectArray[2] = "extensionEquals";
                break;
            }
            case 277: {
                objectArray = objectArray;
                objectArray[2] = "isJarOrZip";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 47: 
            case 51: 
            case 86: 
            case 88: 
            case 92: 
            case 97: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 117: 
            case 123: 
            case 125: 
            case 128: 
            case 140: 
            case 147: 
            case 148: 
            case 168: 
            case 177: 
            case 180: 
            case 183: 
            case 190: 
            case 191: 
            case 192: 
            case 194: 
            case 197: 
            case 199: 
            case 202: 
            case 205: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 218: 
            case 219: 
            case 221: 
            case 224: 
            case 229: 
            case 231: 
            case 233: 
            case 236: 
            case 238: 
            case 240: 
            case 243: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 254: 
            case 256: 
            case 258: 
            case 260: 
            case 262: 
            case 264: 
            case 271: 
            case 272: 
            case 274: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Lazy {
        private static final JBTreeTraverser<File> FILE_TRAVERSER = JBTreeTraverser.from(file -> file == null ? Collections.emptySet() : JBIterable.of(file.listFiles()));

        private Lazy() {
        }
    }
}

