/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ImplementationClassResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/extensions/impl/InterfaceExtensionImplementationClassResolver;", "Lcom/intellij/openapi/extensions/impl/ImplementationClassResolver;", "<init>", "()V", "resolveImplementationClass", "Ljava/lang/Class;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "adapter", "Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;", "intellij.platform.extensions"})
@SourceDebugExtension(value={"SMAP\nInterfaceExtensionImplementationClassResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterfaceExtensionImplementationClassResolver.kt\ncom/intellij/openapi/extensions/impl/InterfaceExtensionImplementationClassResolver\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,49:1\n14#2:50\n*S KotlinDebug\n*F\n+ 1 InterfaceExtensionImplementationClassResolver.kt\ncom/intellij/openapi/extensions/impl/InterfaceExtensionImplementationClassResolver\n*L\n37#1:50\n*E\n"})
public final class InterfaceExtensionImplementationClassResolver
implements ImplementationClassResolver {
    @NotNull
    public static final InterfaceExtensionImplementationClassResolver INSTANCE = new InterfaceExtensionImplementationClassResolver();

    private InterfaceExtensionImplementationClassResolver() {
    }

    @Override
    @NotNull
    public Class<?> resolveImplementationClass(@NotNull ComponentManager componentManager, @NotNull ExtensionComponentAdapter adapter) {
        String idString;
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Object className = adapter.implementationClassOrName;
        if (!(className instanceof String)) {
            Intrinsics.checkNotNull((Object)className, (String)"null cannot be cast to non-null type java.lang.Class<*>");
            return (Class)className;
        }
        PluginDescriptor pluginDescriptor = adapter.pluginDescriptor;
        Class clazz = componentManager.loadClass((String)className, pluginDescriptor);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(...)");
        Class result = clazz;
        ClassLoader pluginClassLoader = pluginDescriptor.getPluginClassLoader();
        if (!(result.getClassLoader() == pluginClassLoader || pluginClassLoader == null || StringsKt.startsWith$default((String)((String)className), (String)"com.intellij.webcore.resourceRoots.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((String)className), (String)"com.intellij.tasks.impl.", (boolean)false, (int)2, null) || pluginClassLoader instanceof PluginAwareClassLoader && ((PluginAwareClassLoader)((Object)pluginClassLoader)).getPackagePrefix() == null || result.isAnnotationPresent(InternalIgnoreDependencyViolation.class) || Intrinsics.areEqual((Object)(idString = pluginDescriptor.getPluginId().getIdString()), (Object)"com.intellij.java") || Intrinsics.areEqual((Object)idString, (Object)"com.intellij.java.ide") || Intrinsics.areEqual((Object)idString, (Object)"com.intellij.java.frontend") || Intrinsics.areEqual((Object)idString, (Object)"com.intellij.kotlin.frontend") || Intrinsics.areEqual((Object)idString, (Object)"org.jetbrains.android") || Intrinsics.areEqual((Object)idString, (Object)"com.intellij.kotlinNative.platformDeps") || Intrinsics.areEqual((Object)idString, (Object)"com.jetbrains.rider.android"))) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ExtensionPointImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(componentManager.createError("Created extension classloader is not equal to plugin's one.\nSee https://youtrack.jetbrains.com/articles/IDEA-A-65/Plugin-Model#internalignoredependencyviolation\n(\n  className=" + (String)className + ",\n  extensionInstanceClassloader=" + result.getClassLoader() + ",\n  pluginClassloader=" + pluginClassLoader + "\n)", pluginDescriptor.getPluginId()));
        }
        adapter.implementationClassOrName = result;
        return result;
    }
}

