/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.modcommand;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.options.OptMultiSelector;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptionContainer;
import com.intellij.codeInspection.options.OptionControllerProvider;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.FutureVirtualFile;
import com.intellij.modcommand.ModChooseAction;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandService;
import com.intellij.modcommand.ModCompositeCommand;
import com.intellij.modcommand.ModCopyToClipboard;
import com.intellij.modcommand.ModDeleteFile;
import com.intellij.modcommand.ModDisplayMessage;
import com.intellij.modcommand.ModEditOptions;
import com.intellij.modcommand.ModHighlight;
import com.intellij.modcommand.ModMoveFile;
import com.intellij.modcommand.ModNavigate;
import com.intellij.modcommand.ModNothing;
import com.intellij.modcommand.ModOpenUrl;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.ModShowConflicts;
import com.intellij.modcommand.ModUpdateFileText;
import com.intellij.modcommand.ModUpdateSystemOptions;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModCommand {
    default public boolean isEmpty() {
        return false;
    }

    @NotNull
    default public @NotNull Set<@NotNull VirtualFile> modifiedFiles() {
        Set<VirtualFile> set = Set.of();
        if (set == null) {
            ModCommand.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    default public ModCommand andThen(@NotNull ModCommand next) {
        if (next == null) {
            ModCommand.$$$reportNull$$$0(1);
        }
        if (this.isEmpty()) {
            ModCommand modCommand = next;
            if (modCommand == null) {
                ModCommand.$$$reportNull$$$0(2);
            }
            return modCommand;
        }
        if (next.isEmpty()) {
            ModCommand modCommand = this;
            if (modCommand == null) {
                ModCommand.$$$reportNull$$$0(3);
            }
            return modCommand;
        }
        ArrayList<ModCommand> commands = new ArrayList<ModCommand>(this.unpack());
        commands.addAll(next.unpack());
        return commands.size() == 1 ? (ModCommand)commands.get(0) : new ModCompositeCommand(commands);
    }

    @NotNull
    default public @NotNull List<@NotNull ModCommand> unpack() {
        List<ModCommand> list = List.of(this);
        if (list == null) {
            ModCommand.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static ModCommand nop() {
        ModNothing modNothing = ModNothing.NOTHING;
        if (modNothing == null) {
            ModCommand.$$$reportNull$$$0(5);
        }
        return modNothing;
    }

    @NotNull
    public static ModCommand copyToClipboard(@NotNull String content) {
        if (content == null) {
            ModCommand.$$$reportNull$$$0(6);
        }
        return new ModCopyToClipboard(content);
    }

    @NotNull
    public static ModCommand openUrl(@NotNull String url) {
        if (url == null) {
            ModCommand.$$$reportNull$$$0(7);
        }
        return new ModOpenUrl(url);
    }

    @NotNull
    public static ModCommand error(@NlsContexts.Tooltip @NotNull String message) {
        if (message == null) {
            ModCommand.$$$reportNull$$$0(8);
        }
        return new ModDisplayMessage(message, ModDisplayMessage.MessageKind.ERROR);
    }

    @NotNull
    public static ModCommand info(@NlsContexts.Tooltip @NotNull String message) {
        if (message == null) {
            ModCommand.$$$reportNull$$$0(9);
        }
        return new ModDisplayMessage(message, ModDisplayMessage.MessageKind.INFORMATION);
    }

    @NotNull
    public static ModCommand select(@NotNull PsiElement target) {
        if (target == null) {
            ModCommand.$$$reportNull$$$0(10);
        }
        PsiFile psiFile = target.getContainingFile();
        TextRange range = target.getTextRange();
        Document document = psiFile.getViewProvider().getDocument();
        if (document instanceof DocumentWindow) {
            DocumentWindow window = (DocumentWindow)document;
            range = window.injectedToHost(range);
            psiFile = InjectedLanguageManager.getInstance(psiFile.getProject()).getTopLevelFile(psiFile);
        }
        VirtualFile file = psiFile.getVirtualFile();
        return new ModNavigate(file, range.getStartOffset(), range.getEndOffset(), range.getStartOffset());
    }

    @NotNull
    public static ModCommand moveTo(@NotNull PsiElement target) {
        if (target == null) {
            ModCommand.$$$reportNull$$$0(11);
        }
        PsiFile psiFile = target.getContainingFile();
        TextRange range = target.getTextRange();
        Document document = psiFile.getViewProvider().getDocument();
        if (document instanceof DocumentWindow) {
            DocumentWindow window = (DocumentWindow)document;
            range = window.injectedToHost(range);
            psiFile = InjectedLanguageManager.getInstance(psiFile.getProject()).getTopLevelFile(psiFile);
        }
        VirtualFile file = psiFile.getVirtualFile();
        return new ModNavigate(file, range.getStartOffset(), range.getStartOffset(), range.getStartOffset());
    }

    @NotNull
    public static ModCommand highlight(@NotNull TextAttributesKey attributes, PsiElement ... elements) {
        if (attributes == null) {
            ModCommand.$$$reportNull$$$0(12);
        }
        if (elements == null) {
            ModCommand.$$$reportNull$$$0(13);
        }
        if (elements.length == 0) {
            return ModCommand.nop();
        }
        VirtualFile file = elements[0].getContainingFile().getVirtualFile();
        List<ModHighlight.HighlightInfo> highlights = ContainerUtil.map(elements, e -> new ModHighlight.HighlightInfo(e.getTextRange(), attributes, true));
        return new ModHighlight(file, highlights);
    }

    @NotNull
    public static ModCommand highlight(PsiElement ... elements) {
        if (elements == null) {
            ModCommand.$$$reportNull$$$0(14);
        }
        return ModCommand.highlight(EditorColors.SEARCH_RESULT_ATTRIBUTES, elements);
    }

    @NotNull
    public static <T extends InspectionProfileEntry> ModCommand updateInspectionOption(@NotNull PsiElement context, @NotNull T inspection, @NotNull @NotNull Consumer<@NotNull T> updater) {
        if (context == null) {
            ModCommand.$$$reportNull$$$0(15);
        }
        if (inspection == null) {
            ModCommand.$$$reportNull$$$0(16);
        }
        if (updater == null) {
            ModCommand.$$$reportNull$$$0(17);
        }
        ModCommand modCommand = ModCommandService.getInstance().updateOption(context, inspection, updater);
        if (modCommand == null) {
            ModCommand.$$$reportNull$$$0(18);
        }
        return modCommand;
    }

    @ApiStatus.Experimental
    @NotNull
    public static ModCommand updateOption(@NotNull PsiElement context, @NotNull @NonNls String bindId, @NotNull Object newValue) {
        if (context == null) {
            ModCommand.$$$reportNull$$$0(19);
        }
        if (bindId == null) {
            ModCommand.$$$reportNull$$$0(20);
        }
        if (newValue == null) {
            ModCommand.$$$reportNull$$$0(21);
        }
        Object oldValue = OptionControllerProvider.getOption(context, bindId);
        return new ModUpdateSystemOptions(List.of(new ModUpdateSystemOptions.ModifiedOption(bindId, oldValue, newValue)));
    }

    @ApiStatus.Experimental
    @NotNull
    public static ModCommand updateOptionList(@NotNull PsiElement context, @NotNull @NonNls String bindId, @NotNull @NotNull Consumer<@NotNull List<@NotNull String>> listUpdater) {
        if (context == null) {
            ModCommand.$$$reportNull$$$0(22);
        }
        if (bindId == null) {
            ModCommand.$$$reportNull$$$0(23);
        }
        if (listUpdater == null) {
            ModCommand.$$$reportNull$$$0(24);
        }
        List oldValue = (List)Objects.requireNonNull(OptionControllerProvider.getOption(context, bindId));
        ArrayList newValue = new ArrayList(oldValue);
        listUpdater.accept(newValue);
        if (oldValue.equals(newValue)) {
            return ModCommand.nop();
        }
        return new ModUpdateSystemOptions(List.of(new ModUpdateSystemOptions.ModifiedOption(bindId, oldValue, newValue)));
    }

    @NotNull
    public static ModCommand psiUpdate(@NotNull ActionContext context, @NotNull @NotNull Consumer<@NotNull ModPsiUpdater> updater) {
        if (context == null) {
            ModCommand.$$$reportNull$$$0(25);
        }
        if (updater == null) {
            ModCommand.$$$reportNull$$$0(26);
        }
        ModCommand modCommand = ModCommandService.getInstance().psiUpdate(context, updater);
        if (modCommand == null) {
            ModCommand.$$$reportNull$$$0(27);
        }
        return modCommand;
    }

    @NotNull
    public static <E extends PsiElement> ModCommand psiUpdate(@NotNull E orig, @NotNull @NotNull Consumer<@NotNull E> updater) {
        if (orig == null) {
            ModCommand.$$$reportNull$$$0(28);
        }
        if (updater == null) {
            ModCommand.$$$reportNull$$$0(29);
        }
        return ModCommand.psiUpdate(orig, (E e, ModPsiUpdater ctx) -> updater.accept(e));
    }

    @NotNull
    public static <E extends PsiElement> ModCommand psiUpdate(@NotNull E orig, @NotNull @NotNull BiConsumer<@NotNull E, @NotNull ModPsiUpdater> updater) {
        if (orig == null) {
            ModCommand.$$$reportNull$$$0(30);
        }
        if (updater == null) {
            ModCommand.$$$reportNull$$$0(31);
        }
        return ModCommand.psiUpdate(ActionContext.from(null, orig.getContainingFile()), (E eu) -> updater.accept((Object)eu.getWritable(orig), (ModPsiUpdater)eu));
    }

    @NotNull
    public static <T extends PsiElement> ModCommandAction psiBasedStep(@NotNull T element, final @NotNull @IntentionName String title, final @NotNull @NotNull Function<@NotNull T, @NotNull ModCommand> function, final @NotNull @NotNull Function<@NotNull T, @NotNull TextRange> range) {
        if (element == null) {
            ModCommand.$$$reportNull$$$0(32);
        }
        if (title == null) {
            ModCommand.$$$reportNull$$$0(33);
        }
        if (function == null) {
            ModCommand.$$$reportNull$$$0(34);
        }
        if (range == null) {
            ModCommand.$$$reportNull$$$0(35);
        }
        return new PsiBasedModCommandAction<T>(element){

            @Override
            @NotNull
            protected ModCommand perform(@NotNull ActionContext context, @NotNull T element) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                ModCommand modCommand = (ModCommand)function.apply(element);
                if (modCommand == null) {
                    1.$$$reportNull$$$0(2);
                }
                return modCommand;
            }

            @Override
            @NotNull
            protected Presentation getPresentation(@NotNull ActionContext context, @NotNull T section) {
                if (context == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (section == null) {
                    1.$$$reportNull$$$0(4);
                }
                Presentation presentation = Presentation.of(this.getFamilyName()).withHighlighting((TextRange)range.apply(section));
                if (presentation == null) {
                    1.$$$reportNull$$$0(5);
                }
                return presentation;
            }

            @Override
            @NotNull
            public String getFamilyName() {
                String string = title;
                if (string == null) {
                    1.$$$reportNull$$$0(6);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 5, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/modcommand/ModCommand$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "section";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/modcommand/ModCommand$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "perform";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentation";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "perform";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentation";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 5, 6 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public static <T extends PsiElement> ModCommandAction psiUpdateStep(final @NotNull T element, final @NotNull @IntentionName String title, final @NotNull @NotNull BiConsumer<@NotNull T, @NotNull ModPsiUpdater> action2, final @NotNull @NotNull Function<@NotNull T, @NotNull TextRange> range) {
        if (element == null) {
            ModCommand.$$$reportNull$$$0(36);
        }
        if (title == null) {
            ModCommand.$$$reportNull$$$0(37);
        }
        if (action2 == null) {
            ModCommand.$$$reportNull$$$0(38);
        }
        if (range == null) {
            ModCommand.$$$reportNull$$$0(39);
        }
        return new PsiUpdateModCommandAction<T>(element){

            @Override
            protected void invoke(@NotNull ActionContext context, @NotNull T element2, @NotNull ModPsiUpdater updater) {
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (updater == null) {
                    2.$$$reportNull$$$0(2);
                }
                action2.accept(element2, updater);
            }

            @Override
            @NotNull
            protected Presentation getPresentation(@NotNull ActionContext context, @NotNull T section) {
                if (context == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (section == null) {
                    2.$$$reportNull$$$0(4);
                }
                Presentation presentation = Presentation.of(this.getFamilyName()).withHighlighting((TextRange)range.apply(section));
                if (presentation == null) {
                    2.$$$reportNull$$$0(5);
                }
                return presentation;
            }

            @Override
            @NotNull
            public String getFamilyName() {
                String string = title;
                if (string == null) {
                    2.$$$reportNull$$$0(6);
                }
                return string;
            }

            public String toString() {
                return "Step: [" + title + "] " + element.getText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 5, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updater";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "section";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/modcommand/ModCommand$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/modcommand/ModCommand$2";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentation";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentation";
                        break;
                    }
                    case 5: 
                    case 6: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 5, 6 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public static <T extends PsiElement> ModCommandAction psiUpdateStep(@NotNull T element, @NotNull @IntentionName String title, @NotNull @NotNull BiConsumer<@NotNull T, @NotNull ModPsiUpdater> action2) {
        if (element == null) {
            ModCommand.$$$reportNull$$$0(40);
        }
        if (title == null) {
            ModCommand.$$$reportNull$$$0(41);
        }
        if (action2 == null) {
            ModCommand.$$$reportNull$$$0(42);
        }
        return ModCommand.psiUpdateStep(element, title, action2, PsiElement::getTextRange);
    }

    @ApiStatus.Experimental
    @NotNull
    public static ModCommand moveCaretAfter(@NotNull ModCommand command2, @NotNull PsiFile file, int offset, boolean leanRight) {
        if (command2 == null) {
            ModCommand.$$$reportNull$$$0(43);
        }
        if (file == null) {
            ModCommand.$$$reportNull$$$0(44);
        }
        VirtualFile virtualFile = file.getVirtualFile();
        ModCommand finalCommand = ModCommand.nop();
        for (ModCommand sub : command2.unpack()) {
            ModMoveFile moveFile;
            ModDeleteFile deleteFile;
            ModUpdateFileText updateFileText;
            if (sub instanceof ModUpdateFileText && (updateFileText = (ModUpdateFileText)sub).file().equals(virtualFile)) {
                offset = updateFileText.translateOffset(offset, leanRight);
            }
            if (sub instanceof ModDeleteFile && (deleteFile = (ModDeleteFile)sub).file().equals(virtualFile)) {
                ModCommand modCommand = command2;
                if (modCommand == null) {
                    ModCommand.$$$reportNull$$$0(45);
                }
                return modCommand;
            }
            if (sub instanceof ModMoveFile && (moveFile = (ModMoveFile)sub).file().equals(virtualFile)) {
                virtualFile = moveFile.targetFile();
            }
            if (sub instanceof ModNavigate) continue;
            finalCommand = finalCommand.andThen(sub);
        }
        ModCommand modCommand = finalCommand.andThen(new ModNavigate(virtualFile, offset, offset, offset));
        if (modCommand == null) {
            ModCommand.$$$reportNull$$$0(46);
        }
        return modCommand;
    }

    @ApiStatus.Experimental
    @NotNull
    public static ModCommand chooseMultipleMembers(@NlsContexts.PopupTitle @NotNull String title, @NotNull @NotNull List<? extends  @NotNull OptMultiSelector.OptElement> elements, @NotNull @NotNull Function<@NotNull List<? extends  @NotNull OptMultiSelector.OptElement>, ? extends @NotNull ModCommand> nextCommand) {
        if (title == null) {
            ModCommand.$$$reportNull$$$0(47);
        }
        if (elements == null) {
            ModCommand.$$$reportNull$$$0(48);
        }
        if (nextCommand == null) {
            ModCommand.$$$reportNull$$$0(49);
        }
        return ModCommand.chooseMultipleMembers(title, elements, elements, nextCommand);
    }

    @ApiStatus.Experimental
    @NotNull
    public static ModCommand chooseMultipleMembers(@NlsContexts.PopupTitle @NotNull String title, final @NotNull @NotNull List<? extends  @NotNull OptMultiSelector.OptElement> elements, final @NotNull @NotNull List<? extends  @NotNull OptMultiSelector.OptElement> defaultSelection, @NotNull @NotNull Function<@NotNull List<? extends  @NotNull OptMultiSelector.OptElement>, ? extends @NotNull ModCommand> nextCommand) {
        class MemberHolder
        implements OptionContainer {
            @NotNull
            @NotNull List<? extends  @NotNull OptMultiSelector.OptElement> myElements;

            MemberHolder() {
                this.myElements = new ArrayList<OptMultiSelector.OptElement>(defaultSelection);
            }

            @Override
            @NotNull
            public OptPane getOptionsPane() {
                OptPane optPane = OptPane.pane(OptPane.multiSelector("myElements", elements, OptMultiSelector.SelectionMode.MULTIPLE));
                if (optPane == null) {
                    MemberHolder.$$$reportNull$$$0(0);
                }
                return optPane;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/modcommand/ModCommand$1MemberHolder", "getOptionsPane"));
            }
        }
        if (title == null) {
            ModCommand.$$$reportNull$$$0(50);
        }
        if (elements == null) {
            ModCommand.$$$reportNull$$$0(51);
        }
        if (defaultSelection == null) {
            ModCommand.$$$reportNull$$$0(52);
        }
        if (nextCommand == null) {
            ModCommand.$$$reportNull$$$0(53);
        }
        return new ModEditOptions<MemberHolder>(title, () -> new MemberHolder(), true, mh -> (ModCommand)nextCommand.apply(mh.myElements));
    }

    @NotNull
    public static ModCommand showConflicts(@NotNull @NotNull Map<@NotNull PsiElement, @NotNull ModShowConflicts.Conflict> conflicts) {
        if (conflicts == null) {
            ModCommand.$$$reportNull$$$0(54);
        }
        return conflicts.isEmpty() ? ModCommand.nop() : new ModShowConflicts(conflicts);
    }

    @NotNull
    public static ModCommand chooseAction(@NlsContexts.PopupTitle @NotNull String title, @NotNull @NotNull List<? extends @NotNull ModCommandAction> actions) {
        if (title == null) {
            ModCommand.$$$reportNull$$$0(55);
        }
        if (actions == null) {
            ModCommand.$$$reportNull$$$0(56);
        }
        return new ModChooseAction(title, actions);
    }

    @NotNull
    public static ModCommand chooseAction(@NlsContexts.PopupTitle @NotNull String title, ModCommandAction ... actions) {
        if (title == null) {
            ModCommand.$$$reportNull$$$0(57);
        }
        if (actions == null) {
            ModCommand.$$$reportNull$$$0(58);
        }
        return new ModChooseAction(title, List.of(actions));
    }

    @NotNull
    public static ModCommand moveFile(@NotNull VirtualFile file, @NotNull VirtualFile target) {
        if (file == null) {
            ModCommand.$$$reportNull$$$0(59);
        }
        if (target == null) {
            ModCommand.$$$reportNull$$$0(60);
        }
        return new ModMoveFile(file, new FutureVirtualFile(target, file.getName(), file.getFileType()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/modcommand/ModCommand";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 10: 
            case 11: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 13: 
            case 14: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 17: 
            case 26: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindId";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listUpdater";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orig";
                break;
            }
            case 32: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 33: 
            case 37: 
            case 41: 
            case 47: 
            case 50: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 44: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextCommand";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultSelection";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "modifiedFiles";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/modcommand/ModCommand";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "andThen";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "unpack";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "nop";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "updateInspectionOption";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "psiUpdate";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "moveCaretAfter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "andThen";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyToClipboard";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openUrl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "info";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "moveTo";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateInspectionOption";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateOption";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "updateOptionList";
                break;
            }
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "psiUpdate";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "psiBasedStep";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "psiUpdateStep";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretAfter";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "chooseMultipleMembers";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "showConflicts";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "chooseAction";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60 -> new IllegalArgumentException(string);
        };
    }
}

