/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.PerFileMappingState;
import com.intellij.lang.PerFileMappingsEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.FilePropertyKey;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.reference.SoftReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public abstract class PerFileMappingsBase<T>
implements PersistentStateComponent<Element>,
PerFileMappingsEx<T>,
Disposable {
    private final Project myProject;
    private List<PerFileMappingState> myDeferredMappings;
    private final Map<VirtualFile, MappingValue<T>> myMappings = new HashMap<VirtualFile, MappingValue<T>>();

    public PerFileMappingsBase() {
        this(null);
    }

    public PerFileMappingsBase(@Nullable Project project) {
        this.myProject = project;
        this.installDeleteUndo();
    }

    @Override
    public void dispose() {
    }

    @Nullable
    protected FilePropertyPusher<T> getFilePropertyPusher() {
        return null;
    }

    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public @Unmodifiable @NotNull Map<VirtualFile, T> getMappings() {
        Map<VirtualFile, MappingValue<T>> map3 = this.myMappings;
        // MONITORENTER : map3
        this.ensureStateLoaded();
        this.cleanup();
        Map<VirtualFile, T> map2 = this.doGetMappings();
        // MONITOREXIT : map3
        if (map2 != null) return map2;
        PerFileMappingsBase.$$$reportNull$$$0(0);
        return map2;
    }

    private @Unmodifiable @NotNull Map<VirtualFile, T> doGetMappings() {
        Map map2 = ContainerUtil.map2Map(this.myMappings.keySet(), it -> Pair.create(it, this.myMappings.get(it).value()));
        if (map2 == null) {
            PerFileMappingsBase.$$$reportNull$$$0(1);
        }
        return map2;
    }

    private void cleanup() {
        Iterator<Map.Entry<VirtualFile, MappingValue<T>>> it = this.myMappings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<VirtualFile, MappingValue<T>> entry = it.next();
            VirtualFile file = entry.getKey();
            MappingValue<T> mapping = entry.getValue();
            if (file == null || mapping != null && file.isValid() && (mapping.unknownValue() != null || !this.isDefaultMapping(file, mapping.value()))) continue;
            it.remove();
        }
    }

    @Override
    @Nullable
    public T getMapping(@Nullable VirtualFile file) {
        T t = this.getConfiguredMapping(file);
        return t == null ? this.getDefaultMapping(file) : t;
    }

    @Nullable
    public T getConfiguredMapping(@Nullable VirtualFile file) {
        FilePropertyPusher<T> pusher = this.getFilePropertyPusher();
        return this.getMappingInner(file, pusher == null ? null : pusher.getFilePropertyKey(), false);
    }

    @Nullable
    public T getDirectlyConfiguredMapping(@Nullable VirtualFile file) {
        return this.getMappingInner(file, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private T getMappingInner(@Nullable VirtualFile file, @Nullable FilePropertyKey<T> pusherKey, boolean forHierarchy) {
        T pushedValue;
        VirtualFile originalFile;
        if (file instanceof VirtualFileWindow) {
            VirtualFileWindow window = (VirtualFileWindow)((Object)file);
            file = window.getDelegate();
        }
        if (Comparing.equal(originalFile = ObjectUtils.doIfNotNull(file, VirtualFileUtil::originalFile), file)) {
            originalFile = null;
        }
        if (file != null) {
            T t = pushedValue = pusherKey == null ? null : (T)pusherKey.getPersistentValue(file);
            if (pushedValue != null) {
                return pushedValue;
            }
        }
        if (originalFile != null) {
            T t = pushedValue = pusherKey == null ? null : (T)pusherKey.getPersistentValue(originalFile);
            if (pushedValue != null) {
                return pushedValue;
            }
        }
        Map<VirtualFile, MappingValue<T>> map2 = this.myMappings;
        synchronized (map2) {
            this.ensureStateLoaded();
            T t = this.getMappingForHierarchy(file);
            if (t != null) {
                return t;
            }
            t = this.getMappingForHierarchy(originalFile);
            if (t != null) {
                return t;
            }
            if (forHierarchy && file != null) {
                return null;
            }
            return this.getNotInHierarchy(originalFile != null ? originalFile : file, this.doGetMappings());
        }
    }

    @Nullable
    protected T getNotInHierarchy(@Nullable VirtualFile file, @NotNull Map<VirtualFile, T> mappings) {
        if (mappings == null) {
            PerFileMappingsBase.$$$reportNull$$$0(2);
        }
        if (this.getProject() == null || file == null || file.getFileSystem() instanceof NonPhysicalFileSystem || !this.getProject().isDefault() && ProjectFileIndex.getInstance(this.getProject()).isInContent(file)) {
            return mappings.get(null);
        }
        return null;
    }

    private T getMappingForHierarchy(@Nullable VirtualFile file) {
        for (VirtualFile cur = file; cur != null; cur = cur.getParent()) {
            T t = this.doGetImmediateMapping(cur);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    @Nullable
    public T getDefaultMapping(@Nullable VirtualFile file) {
        return null;
    }

    protected boolean isDefaultMapping(@NotNull VirtualFile file, @NotNull T mapping) {
        if (file == null) {
            PerFileMappingsBase.$$$reportNull$$$0(3);
        }
        if (mapping == null) {
            PerFileMappingsBase.$$$reportNull$$$0(4);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getImmediateMapping(@Nullable VirtualFile file) {
        Map<VirtualFile, MappingValue<T>> map2 = this.myMappings;
        synchronized (map2) {
            this.ensureStateLoaded();
            return this.doGetImmediateMapping(file);
        }
    }

    @Nullable
    private T doGetImmediateMapping(@Nullable VirtualFile key) {
        MappingValue<T> mappingValue = this.myMappings.get(key);
        return mappingValue != null ? (T)mappingValue.value() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMappings(@NotNull Map<VirtualFile, T> mappings) {
        ArrayList<VirtualFile> oldFiles;
        if (mappings == null) {
            PerFileMappingsBase.$$$reportNull$$$0(5);
        }
        Map<VirtualFile, MappingValue<T>> map2 = this.myMappings;
        synchronized (map2) {
            this.myDeferredMappings = null;
            oldFiles = new ArrayList<VirtualFile>(this.myMappings.keySet());
            HashSet<VirtualFile> oldAndNewKeys = new HashSet<VirtualFile>();
            oldAndNewKeys.addAll(this.myMappings.keySet());
            oldAndNewKeys.addAll(mappings.keySet());
            for (VirtualFile key : oldAndNewKeys) {
                T newValue;
                T oldValue = this.doGetImmediateMapping(key);
                if (Objects.equals(oldValue, newValue = mappings.get(key))) continue;
                if (newValue == null) {
                    this.myMappings.remove(key);
                    continue;
                }
                this.myMappings.put(key, MappingValue.known(newValue));
            }
            this.cleanup();
        }
        Project project = this.getProject();
        this.handleMappingChange(mappings.keySet(), oldFiles, project != null && !project.isDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMapping(@Nullable VirtualFile file, @Nullable T value) {
        Map<VirtualFile, MappingValue<T>> map2 = this.myMappings;
        synchronized (map2) {
            this.ensureStateLoaded();
            if (value == null) {
                this.myMappings.remove(file);
            } else {
                this.myMappings.put(file, MappingValue.known(value));
            }
        }
        List<VirtualFile> files = ContainerUtil.createMaybeSingletonList(file);
        this.handleMappingChange(files, files, false);
    }

    private void handleMappingChange(Collection<? extends VirtualFile> files, Collection<? extends VirtualFile> oldFiles, boolean includeOpenFiles) {
        Project project = this.getProject();
        FilePropertyPusher<T> pusher = this.getFilePropertyPusher();
        if (project != null && pusher != null) {
            for (VirtualFile virtualFile : oldFiles) {
                if (virtualFile == null) continue;
                pusher.getFilePropertyKey().setPersistentValue(virtualFile, null);
            }
            if (!project.isDefault()) {
                PushedFilePropertiesUpdater.getInstance(project).pushAll(pusher);
            }
        }
        if (this.shouldReparseFiles()) {
            Project[] projects;
            Project[] projectArray;
            if (project == null) {
                projectArray = ProjectManager.getInstance().getOpenProjects();
            } else {
                Project[] projectArray2 = new Project[1];
                projectArray = projectArray2;
                projectArray2[0] = project;
            }
            for (Project p : projects = projectArray) {
                PsiDocumentManager.getInstance(p).reparseFiles(files, includeOpenFiles);
            }
        }
    }

    public abstract @Unmodifiable @NotNull List<T> getAvailableValues();

    @Nullable
    protected abstract String serialize(@NotNull T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getState() {
        Map<VirtualFile, MappingValue<T>> map2 = this.myMappings;
        synchronized (map2) {
            if (this.myDeferredMappings != null) {
                return PerFileMappingState.write(this.myDeferredMappings, this.getValueAttribute());
            }
            this.cleanup();
            Element element = new Element("x");
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myMappings.keySet());
            files.sort((o1, o2) -> {
                if (o1 == null || o2 == null) {
                    return o1 == null ? (o2 == null ? 0 : 1) : -1;
                }
                return o1.getPath().compareTo(o2.getPath());
            });
            for (VirtualFile file : files) {
                String valueStr;
                T value;
                MappingValue<T> mappingValue = this.myMappings.get(file);
                T t = value = mappingValue != null ? (T)mappingValue.value() : null;
                String string = mappingValue != null && mappingValue.unknownValue() != null ? mappingValue.unknownValue() : (valueStr = value == null ? null : this.serialize(value));
                if (valueStr == null) continue;
                Element child = new Element("file");
                element.addContent(child);
                child.setAttribute("url", file == null ? "PROJECT" : file.getUrl());
                child.setAttribute(this.getValueAttribute(), valueStr);
            }
            return element;
        }
    }

    @Nullable
    protected T handleUnknownMapping(@Nullable VirtualFile file, String value) {
        return null;
    }

    @Deprecated
    @NotNull
    protected String getValueAttribute() {
        return "value";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadState(@NotNull Element element) {
        if (element == null) {
            PerFileMappingsBase.$$$reportNull$$$0(6);
        }
        List<PerFileMappingState> list = PerFileMappingState.read(element, this.getValueAttribute());
        Map<VirtualFile, MappingValue<T>> map2 = this.myMappings;
        synchronized (map2) {
            if (list.isEmpty()) {
                this.myMappings.clear();
                this.myDeferredMappings = null;
            } else {
                this.myDeferredMappings = list;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureStateLoaded() {
        Map<VirtualFile, MappingValue<T>> map2 = this.myMappings;
        synchronized (map2) {
            List<PerFileMappingState> state2 = this.myDeferredMappings;
            if (state2 == null) {
                return;
            }
            this.myDeferredMappings = null;
            HashMap<String, T> valuesMap = new HashMap<String, T>();
            for (T value : this.getAvailableValues()) {
                String key = value == null ? null : this.serialize(value);
                if (key == null) continue;
                valuesMap.put(key, value);
            }
            this.myMappings.clear();
            for (PerFileMappingState entry : state2) {
                VirtualFile file;
                String url = entry.getUrl();
                String valueStr = entry.getValue();
                if (valueStr == null) continue;
                if ("PROJECT".equals(url)) {
                    file = null;
                } else {
                    file = VirtualFileManager.getInstance().findFileByUrl(url);
                    if (file == null) continue;
                }
                Object value = valuesMap.get(valueStr);
                if (value != null) {
                    if (file != null && this.isDefaultMapping(file, value)) continue;
                    this.myMappings.put(file, MappingValue.known(value));
                    continue;
                }
                value = this.handleUnknownMapping(file, valueStr);
                if (value == null) continue;
                this.myMappings.put(file, MappingValue.unknown(value, valueStr));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void cleanupForNextTest() {
        Map<VirtualFile, MappingValue<T>> map2 = this.myMappings;
        synchronized (map2) {
            this.myDeferredMappings = null;
            this.myMappings.clear();
        }
    }

    protected boolean shouldReparseFiles() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMappings() {
        Map<VirtualFile, MappingValue<T>> map2 = this.myMappings;
        synchronized (map2) {
            this.ensureStateLoaded();
            return !this.myMappings.isEmpty();
        }
    }

    private void installDeleteUndo() {
        Application app = ApplicationManager.getApplication();
        if (app == null) {
            return;
        }
        app.getMessageBus().connect(this).subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){
            WeakReference<MyUndoableAction> lastAction;

            @Override
            public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
                    return;
                }
                Project project = CommandProcessor.getInstance().getCurrentCommandProject();
                if (project == null || !project.isOpen()) {
                    return;
                }
                MyUndoableAction action2 = this.createUndoableAction(events);
                if (action2 == null) {
                    return;
                }
                action2.doRemove(action2.removed);
                this.lastAction = new WeakReference<MyUndoableAction>(action2);
                UndoManager.getInstance(project).undoableActionPerformed(action2);
            }

            @Override
            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(1);
                }
                MyUndoableAction action2 = SoftReference.dereference(this.lastAction);
                this.lastAction = null;
                if (action2 != null) {
                    ApplicationManager.getApplication().invokeLater(() -> action2.doAdd(action2.added));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            MyUndoableAction createUndoableAction(@NotNull List<? extends VFileEvent> events) {
                List<VFileDeleteEvent> eventsFiltered;
                if (events == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((eventsFiltered = JBIterable.from(events).filter(VFileDeleteEvent.class).toList()).isEmpty()) {
                    return null;
                }
                HashMap removed = new HashMap();
                TreeSet<VirtualFile> navSet = null;
                Map map2 = PerFileMappingsBase.this.myMappings;
                synchronized (map2) {
                    PerFileMappingsBase.this.ensureStateLoaded();
                    for (VFileEvent vFileEvent : eventsFiltered) {
                        VirtualFile child;
                        VirtualFile file = vFileEvent.getFile();
                        if (file == null) continue;
                        String fileUrl = file.getUrl();
                        if (!file.isDirectory()) {
                            Object m = PerFileMappingsBase.this.doGetImmediateMapping(file);
                            if (m == null) continue;
                            removed.put(fileUrl, m);
                            continue;
                        }
                        if (navSet == null) {
                            navSet = new TreeSet<VirtualFile>((f1, f2) -> Comparing.compare(f1 == null ? null : f1.getUrl(), f2 == null ? null : f2.getUrl()));
                            navSet.addAll(PerFileMappingsBase.this.myMappings.keySet());
                        }
                        Iterator iterator2 = navSet.tailSet(file).iterator();
                        while (iterator2.hasNext() && VfsUtilCore.isAncestor(file, child = (VirtualFile)iterator2.next(), false)) {
                            String childUrl = child.getUrl();
                            Object m = PerFileMappingsBase.this.doGetImmediateMapping(child);
                            removed.put(childUrl, m);
                        }
                    }
                }
                return removed.isEmpty() ? null : new MyUndoableAction(new HashMap(), removed);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "events";
                objectArray2[1] = "com/intellij/lang/PerFileMappingsBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "before";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createUndoableAction";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/PerFileMappingsBase";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetMappings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/PerFileMappingsBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNotInHierarchy";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultMapping";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setMappings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    private record MappingValue<T>(@NotNull T value, @Nullable String unknownValue) {
        @NotNull
        private final T value;

        private MappingValue(@NotNull T value, @Nullable String unknownValue) {
            if (value == null) {
                MappingValue.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        static <T> MappingValue<T> known(@NotNull T t) {
            if (t == null) {
                MappingValue.$$$reportNull$$$0(1);
            }
            return new MappingValue<T>(t, null);
        }

        @NotNull
        static <T> MappingValue<T> unknown(@NotNull T defaultValue, @NotNull String unknownValue) {
            if (defaultValue == null) {
                MappingValue.$$$reportNull$$$0(2);
            }
            if (unknownValue == null) {
                MappingValue.$$$reportNull$$$0(3);
            }
            return new MappingValue<T>(defaultValue, unknownValue);
        }

        @NotNull
        public T value() {
            T t = this.value;
            if (t == null) {
                MappingValue.$$$reportNull$$$0(4);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "t";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unknownValue";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/PerFileMappingsBase$MappingValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/PerFileMappingsBase$MappingValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "known";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "unknown";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private class MyUndoableAction
    extends BasicUndoableAction {
        final Map<String, T> added;
        final Map<String, T> removed;

        MyUndoableAction(Map<String, T> added, Map<String, T> removed) {
            this.added = added;
            this.removed = removed;
        }

        @Override
        public void undo() {
            this.doRemove(this.added);
            this.doAdd(this.removed);
        }

        @Override
        public void redo() {
            this.doRemove(this.removed);
            this.doAdd(this.added);
        }

        void doAdd(Map<String, T> toAdd) {
            if (toAdd == null) {
                return;
            }
            for (String url : toAdd.keySet()) {
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file == null) continue;
                PerFileMappingsBase.this.setMapping(file, toAdd.get(url));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doRemove(Map<String, T> toRemove) {
            if (toRemove != null) {
                Map map2 = PerFileMappingsBase.this.myMappings;
                synchronized (map2) {
                    for (String url : toRemove.keySet()) {
                        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                        if (file == null) continue;
                        PerFileMappingsBase.this.myMappings.remove(file);
                    }
                }
            }
        }
    }
}

