/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.ChangeDiffIterableBase;
import com.intellij.diff.util.Range;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000fB=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/diff/comparison/iterables/SubiterableDiffIterable;", "Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase;", "myChanged", "", "Lcom/intellij/diff/util/Range;", "myStart1", "", "myEnd1", "myStart2", "myEnd2", "myFirstIndex", "<init>", "(Ljava/util/List;IIIII)V", "createChangeIterable", "Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase$ChangeIterable;", "SubiterableChangeIterable", "intellij.platform.util.diff"})
@ApiStatus.Internal
public final class SubiterableDiffIterable
extends ChangeDiffIterableBase {
    @NotNull
    private final List<Range> myChanged;
    private final int myStart1;
    private final int myEnd1;
    private final int myStart2;
    private final int myEnd2;
    private final int myFirstIndex;

    public SubiterableDiffIterable(@NotNull List<Range> myChanged, int myStart1, int myEnd1, int myStart2, int myEnd2, int myFirstIndex) {
        Intrinsics.checkNotNullParameter(myChanged, (String)"myChanged");
        super(myEnd1 - myStart1, myEnd2 - myStart2);
        this.myChanged = myChanged;
        this.myStart1 = myStart1;
        this.myEnd1 = myEnd1;
        this.myStart2 = myStart2;
        this.myEnd2 = myEnd2;
        this.myFirstIndex = myFirstIndex;
    }

    @Override
    @NotNull
    protected ChangeDiffIterableBase.ChangeIterable createChangeIterable() {
        return new SubiterableChangeIterable(this.myChanged, this.myStart1, this.myEnd1, this.myStart2, this.myEnd2, this.myFirstIndex);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0014\u0010\u0019\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/intellij/diff/comparison/iterables/SubiterableDiffIterable$SubiterableChangeIterable;", "Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase$ChangeIterable;", "myChanged", "", "Lcom/intellij/diff/util/Range;", "myStart1", "", "myEnd1", "myStart2", "myEnd2", "myIndex", "<init>", "(Ljava/util/List;IIIII)V", "myLast", "valid", "", "next", "", "start1", "getStart1", "()I", "start2", "getStart2", "end1", "getEnd1", "end2", "getEnd2", "intellij.platform.util.diff"})
    private static final class SubiterableChangeIterable
    implements ChangeDiffIterableBase.ChangeIterable {
        @NotNull
        private final List<Range> myChanged;
        private final int myStart1;
        private final int myEnd1;
        private final int myStart2;
        private final int myEnd2;
        private int myIndex;
        @Nullable
        private Range myLast;

        public SubiterableChangeIterable(@NotNull List<Range> myChanged, int myStart1, int myEnd1, int myStart2, int myEnd2, int myIndex) {
            Intrinsics.checkNotNullParameter(myChanged, (String)"myChanged");
            this.myChanged = myChanged;
            this.myStart1 = myStart1;
            this.myEnd1 = myEnd1;
            this.myStart2 = myStart2;
            this.myEnd2 = myEnd2;
            this.myIndex = myIndex;
            this.next();
        }

        @Override
        public boolean valid() {
            return this.myLast != null;
        }

        @Override
        public void next() {
            this.myLast = null;
            while (this.myIndex < this.myChanged.size()) {
                Range range = this.myChanged.get(this.myIndex);
                int n = this.myIndex;
                this.myIndex = n + 1;
                if (range.end1 < this.myStart1 || range.end2 < this.myStart2) continue;
                if (range.start1 > this.myEnd1 || range.start2 > this.myEnd2) break;
                Range newRange = new Range(Math.max(this.myStart1, range.start1) - this.myStart1, Math.min(this.myEnd1, range.end1) - this.myStart1, Math.max(this.myStart2, range.start2) - this.myStart2, Math.min(this.myEnd2, range.end2) - this.myStart2);
                if (newRange.isEmpty()) continue;
                this.myLast = newRange;
                break;
            }
        }

        @Override
        public int getStart1() {
            Range range = this.myLast;
            Intrinsics.checkNotNull((Object)range);
            return range.start1;
        }

        @Override
        public int getStart2() {
            Range range = this.myLast;
            Intrinsics.checkNotNull((Object)range);
            return range.start2;
        }

        @Override
        public int getEnd1() {
            Range range = this.myLast;
            Intrinsics.checkNotNull((Object)range);
            return range.end1;
        }

        @Override
        public int getEnd2() {
            Range range = this.myLast;
            Intrinsics.checkNotNull((Object)range);
            return range.end2;
        }
    }
}

