/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdater;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdaterImpl;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.InvalidPsi;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class ManagedHighlighterRecycler {
    private final Long2ObjectMap<List<InvalidPsi>> incinerator;
    @NotNull
    final HighlightingSession myHighlightingSession;
    @NotNull
    private final HighlightInfoUpdaterImpl myHighlightInfoUpdater;

    private ManagedHighlighterRecycler(@NotNull HighlightingSession session) {
        if (session == null) {
            ManagedHighlighterRecycler.$$$reportNull$$$0(0);
        }
        this.incinerator = new Long2ObjectOpenHashMap<List<InvalidPsi>>();
        this.myHighlightingSession = session;
        this.myHighlightInfoUpdater = (HighlightInfoUpdaterImpl)HighlightInfoUpdater.getInstance(session.getProject());
    }

    synchronized void recycleHighlighter(@NotNull PsiElement psiElement, @NotNull HighlightInfo info) {
        if (psiElement == null) {
            ManagedHighlighterRecycler.$$$reportNull$$$0(1);
        }
        if (info == null) {
            ManagedHighlighterRecycler.$$$reportNull$$$0(2);
        }
        assert (info.isFromHighlightVisitor() || info.isFromAnnotator() || info.isFromInspection() || info.isInjectionRelated()) : info;
        assert (info.getHighlighter() != null);
        assert (info.getGroup() == -6) : info;
        RangeHighlighterEx highlighter = info.getHighlighter();
        if (UpdateHighlightersUtil.LOG.isDebugEnabled()) {
            UpdateHighlightersUtil.LOG.debug("recycleHighlighter " + String.valueOf(highlighter) + HighlightInfoUpdaterImpl.currentProgressInfo());
        }
        long range = ((RangeMarkerImpl)highlighter).getScalarRange();
        this.incinerator.computeIfAbsent(range, __ -> new ArrayList()).add(new InvalidPsi(psiElement, info));
    }

    @Nullable
    synchronized InvalidPsi pickupHighlighterFromGarbageBin(int startOffset, int endOffset, int layer) {
        long range = TextRangeScalarUtil.toScalarRange(startOffset, endOffset);
        List list = (List)this.incinerator.get(range);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                InvalidPsi psi = (InvalidPsi)list.get(i);
                RangeHighlighterEx highlighter = psi.info().getHighlighter();
                if (!highlighter.isValid() || highlighter.getLayer() != layer) continue;
                list.remove(i);
                if (list.isEmpty()) {
                    this.incinerator.remove(range);
                }
                if (UpdateHighlightersUtil.LOG.isDebugEnabled()) {
                    UpdateHighlightersUtil.LOG.debug("pickupHighlighterFromGarbageBin pickedup:" + String.valueOf(highlighter) + HighlightInfoUpdaterImpl.currentProgressInfo());
                }
                return psi;
            }
        }
        return null;
    }

    @NotNull
    synchronized @Unmodifiable Collection<InvalidPsi> forAllInGarbageBin() {
        List<InvalidPsi> list = ContainerUtil.flatten(this.incinerator.values());
        if (list == null) {
            ManagedHighlighterRecycler.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static void runWithRecycler(@NotNull HighlightingSession session, @NotNull Consumer<? super ManagedHighlighterRecycler> consumer) {
        if (session == null) {
            ManagedHighlighterRecycler.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            ManagedHighlighterRecycler.$$$reportNull$$$0(5);
        }
        ManagedHighlighterRecycler recycler = new ManagedHighlighterRecycler(session);
        consumer.accept(recycler);
        recycler.myHighlightInfoUpdater.incinerateAndRemoveFromDataAtomically(recycler);
    }

    public synchronized String toString() {
        return "ManagedHighlighterRecycler: " + this.incinerator.size() + " recycled RHs";
    }

    synchronized void incinerateAndClear() {
        for (InvalidPsi psi : this.forAllInGarbageBin()) {
            UpdateHighlightersUtil.disposeWithFileLevelIgnoreErrors(psi.info(), this.myHighlightingSession);
        }
        this.incinerator.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ManagedHighlighterRecycler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ManagedHighlighterRecycler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "forAllInGarbageBin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recycleHighlighter";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runWithRecycler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

