/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoB;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdaterImpl;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.actions.DisableHighlightingIntentionAction;
import com.intellij.codeInsight.daemon.impl.actions.IntentionActionWithFixAllOption;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.ExternalSourceProblemGroup;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ReportingClassSubstitutor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public class HighlightInfo
implements Segment {
    private static final Logger LOG = Logger.getInstance(HighlightInfo.class);
    @ApiStatus.Internal
    static final String ANNOTATOR_INSPECTION_SHORT_NAME = "Annotator";
    private static final String DESCRIPTION_PLACEHOLDER = "\u0000";
    private static final byte HAS_HINT_MASK = 1;
    private static final byte FROM_INJECTION_MASK = 2;
    private static final byte AFTER_END_OF_LINE_MASK = 4;
    private static final byte FILE_LEVEL_ANNOTATION_MASK = 8;
    private static final byte NEEDS_UPDATE_ON_TYPING_MASK = 16;
    public final TextAttributes forcedTextAttributes;
    public final TextAttributesKey forcedTextAttributesKey;
    @NotNull
    public final HighlightInfoType type;
    public final int startOffset;
    public final int endOffset;
    @Deprecated
    public @Unmodifiable List<Pair<IntentionActionDescriptor, TextRange>> quickFixActionRanges;
    @Deprecated
    public @Unmodifiable List<Pair<IntentionActionDescriptor, RangeMarker>> quickFixActionMarkers;
    private @Unmodifiable @NotNull List<IntentionActionDescriptor> myIntentionActionDescriptors;
    @NotNull
    private @Unmodifiable List<LazyFixDescription> myLazyQuickFixes;
    private final @NlsContexts.DetailedDescription String description;
    private final @NlsContexts.Tooltip String toolTip;
    @NotNull
    private final HighlightSeverity severity;
    private final GutterMark gutterIconRenderer;
    private final ProblemGroup myProblemGroup;
    volatile Object toolId;
    private int group;
    private final long fixRange;
    private static final RangeMarker FIX_MARKER_SAME_AS_HIGHLIGHTER = FileStatusMap.WHOLE_FILE_DIRTY_MARKER;
    @Nullable(value="null means it's the same as highlighter")
    private @Nullable(value="null means it's the same as highlighter") RangeMarker fixMarker;
    private volatile byte myFlags;
    @ApiStatus.Internal
    public final int navigationShift;
    @Nullable
    private Object fileLevelComponentsStorage;
    private volatile RangeHighlighterEx highlighter;

    @NotNull
    private synchronized @Unmodifiable List<IntentionActionDescriptor> getIntentionActionDescriptors() {
        List<IntentionActionDescriptor> list = ContainerUtil.concat(this.myIntentionActionDescriptors, ContainerUtil.flatMap(this.myLazyQuickFixes, desc -> {
            if (desc.future() != null && desc.future().isDone()) {
                try {
                    return List.copyOf((Collection)desc.future().get());
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn(e);
                    return List.of();
                }
            }
            return List.of();
        }));
        if (list == null) {
            HighlightInfo.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Deprecated
    @ApiStatus.Internal
    protected HighlightInfo(@Nullable TextAttributes forcedTextAttributes, @Nullable TextAttributesKey forcedTextAttributesKey, @NotNull HighlightInfoType type, int startOffset, int endOffset, @NlsContexts.DetailedDescription @Nullable String escapedDescription, @NlsContexts.Tooltip @Nullable String escapedToolTip, @NotNull HighlightSeverity severity, boolean afterEndOfLine, @Nullable Boolean needsUpdateOnTyping, boolean isFileLevelAnnotation, int navigationShift, @Nullable ProblemGroup problemGroup, @Nullable Object toolId, @Nullable GutterMark gutterIconRenderer, int group, boolean hasHint, @NotNull @NotNull @Unmodifiable List<? extends @NotNull Consumer<? super QuickFixActionRegistrar>> lazyFixes) {
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(1);
        }
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(2);
        }
        if (lazyFixes == null) {
            HighlightInfo.$$$reportNull$$$0(3);
        }
        this.myIntentionActionDescriptors = List.of();
        this.fixMarker = FIX_MARKER_SAME_AS_HIGHLIGHTER;
        if (startOffset < 0 || startOffset > endOffset) {
            throw new IllegalArgumentException("Incorrect highlightInfo bounds: startOffset=" + startOffset + "; endOffset=" + endOffset + ";type=" + String.valueOf(type) + "; description=" + escapedDescription + ". Maybe you forgot to call .range()?");
        }
        this.forcedTextAttributes = forcedTextAttributes;
        this.forcedTextAttributesKey = forcedTextAttributesKey;
        this.type = type;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.fixRange = TextRangeScalarUtil.toScalarRange(startOffset, endOffset);
        this.description = escapedDescription;
        this.toolTip = HighlightInfo.encodeTooltip(escapedToolTip, escapedDescription);
        this.severity = severity;
        this.myFlags = (byte)((afterEndOfLine ? 4 : 0) | (HighlightInfo.calcNeedUpdateOnTyping(needsUpdateOnTyping, type) ? 16 : 0) | (isFileLevelAnnotation ? 8 : 0) | (hasHint ? 1 : 0));
        this.navigationShift = navigationShift;
        this.myProblemGroup = problemGroup;
        this.gutterIconRenderer = gutterIconRenderer;
        this.toolId = toolId;
        this.group = group;
        this.myLazyQuickFixes = ContainerUtil.map(lazyFixes, c -> new LazyFixDescription((Consumer<? super QuickFixActionRegistrar>)c, 0L, null));
    }

    @ApiStatus.Internal
    public void setToolId(Object toolId) {
        this.toolId = toolId;
    }

    @ApiStatus.Internal
    public Object getToolId() {
        return this.toolId;
    }

    public <T> T findRegisteredQuickFix(@NotNull @NotNull BiFunction<? super @NotNull IntentionActionDescriptor, ? super @NotNull TextRange, ? extends @Nullable T> predicate) {
        if (predicate == null) {
            HighlightInfo.$$$reportNull$$$0(4);
        }
        List<IntentionActionDescriptor> descriptors = this.getIntentionActionDescriptors();
        HashSet<IntentionActionDescriptor> processed2 = new HashSet<IntentionActionDescriptor>();
        for (IntentionActionDescriptor descriptor : descriptors) {
            T result;
            if (!processed2.add(descriptor)) continue;
            TextRange fixRange = descriptor.getFixRange();
            if (fixRange == null) {
                fixRange = TextRange.create(this.getFixTextRange());
            }
            if ((result = predicate.apply(descriptor, fixRange)) == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static HighlightInfo fromRangeHighlighter(@NotNull RangeHighlighter highlighter) {
        HighlightInfo info;
        Object errorStripeTooltip;
        if (highlighter == null) {
            HighlightInfo.$$$reportNull$$$0(5);
        }
        return (errorStripeTooltip = highlighter.getErrorStripeTooltip()) instanceof HighlightInfo ? (info = (HighlightInfo)errorStripeTooltip) : null;
    }

    @NotNull
    @ApiStatus.Internal
    private synchronized Segment getFixTextRange() {
        RangeMarker myFixMarker = this.fixMarker;
        if (myFixMarker != null) {
            if (myFixMarker == FIX_MARKER_SAME_AS_HIGHLIGHTER) {
                RangeHighlighterEx myHighlighter = this.highlighter;
                if (myHighlighter != null && myHighlighter.isValid()) {
                    RangeHighlighterEx rangeHighlighterEx = myHighlighter;
                    if (rangeHighlighterEx == null) {
                        HighlightInfo.$$$reportNull$$$0(6);
                    }
                    return rangeHighlighterEx;
                }
            } else if (myFixMarker.isValid()) {
                RangeMarker rangeMarker = myFixMarker;
                if (rangeMarker == null) {
                    HighlightInfo.$$$reportNull$$$0(7);
                }
                return rangeMarker;
            }
        }
        TextRange textRange = TextRangeScalarUtil.create(this.fixRange);
        if (textRange == null) {
            HighlightInfo.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    @ApiStatus.Internal
    public void markFromInjection() {
        this.setFlag((byte)2, true);
    }

    @ApiStatus.Internal
    public void addFileLevelComponent(@NotNull FileEditor fileEditor, @NotNull JComponent component) {
        if (fileEditor == null) {
            HighlightInfo.$$$reportNull$$$0(9);
        }
        if (component == null) {
            HighlightInfo.$$$reportNull$$$0(10);
        }
        if (this.fileLevelComponentsStorage == null) {
            this.fileLevelComponentsStorage = new Pair<FileEditor, JComponent>(fileEditor, component);
        } else {
            Object object = this.fileLevelComponentsStorage;
            if (object instanceof Pair) {
                Pair p;
                Pair pair = p = (Pair)object;
                HashMap<FileEditor, JComponent> map2 = new HashMap<FileEditor, JComponent>();
                map2.put((FileEditor)pair.first, (JComponent)pair.second);
                map2.put(fileEditor, component);
                this.fileLevelComponentsStorage = map2;
            } else {
                object = this.fileLevelComponentsStorage;
                if (object instanceof Map) {
                    Map map3 = (Map)object;
                    map3.put(fileEditor, component);
                } else {
                    LOG.error(new IllegalStateException("fileLevelComponents=" + String.valueOf(this.fileLevelComponentsStorage)));
                }
            }
        }
    }

    @ApiStatus.Internal
    public void removeFileLeverComponent(@NotNull FileEditor fileEditor) {
        Object object;
        if (fileEditor == null) {
            HighlightInfo.$$$reportNull$$$0(11);
        }
        if ((object = this.fileLevelComponentsStorage) instanceof Pair) {
            Pair p;
            Pair pair = p = (Pair)object;
            if (pair.first == fileEditor) {
                this.fileLevelComponentsStorage = null;
            }
        } else {
            object = this.fileLevelComponentsStorage;
            if (object instanceof Map) {
                Map map2 = (Map)object;
                map2.remove(fileEditor);
            }
        }
    }

    @ApiStatus.Internal
    @Nullable
    public JComponent getFileLevelComponent(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            HighlightInfo.$$$reportNull$$$0(12);
        }
        if (this.fileLevelComponentsStorage == null) {
            return null;
        }
        Object object = this.fileLevelComponentsStorage;
        if (object instanceof Pair) {
            Pair p;
            Pair pair = p = (Pair)object;
            return pair.first == fileEditor ? (JComponent)pair.second : null;
        }
        object = this.fileLevelComponentsStorage;
        if (object instanceof Map) {
            Map map2 = (Map)object;
            return (JComponent)map2.get(fileEditor);
        }
        LOG.error(new IllegalStateException("fileLevelComponents=" + String.valueOf(this.fileLevelComponentsStorage)));
        return null;
    }

    @NlsContexts.Tooltip
    @Nullable
    public String getToolTip() {
        String toolTip = this.toolTip;
        String description = this.description;
        if (toolTip == null) {
            return null;
        }
        String wrapped = XmlStringUtil.wrapInHtml(toolTip);
        if (description == null || !wrapped.contains(DESCRIPTION_PLACEHOLDER)) {
            return wrapped;
        }
        return StringUtil.replace(wrapped, DESCRIPTION_PLACEHOLDER, XmlStringUtil.escapeString(description));
    }

    @NlsContexts.Tooltip
    @Nullable
    private static String encodeTooltip(@NlsContexts.Tooltip @Nullable String tooltip, @NlsContexts.DetailedDescription @Nullable String description) {
        if (tooltip == null) {
            return null;
        }
        String stripped = XmlStringUtil.stripHtml(tooltip);
        if (description == null || description.isEmpty()) {
            return stripped;
        }
        String encoded = StringUtil.replace(stripped, XmlStringUtil.escapeString(description), DESCRIPTION_PLACEHOLDER);
        if (Strings.areSameInstance(encoded, stripped)) {
            return stripped;
        }
        if (encoded.equals(DESCRIPTION_PLACEHOLDER)) {
            encoded = DESCRIPTION_PLACEHOLDER;
        }
        return encoded;
    }

    @NlsContexts.DetailedDescription
    public String getDescription() {
        return this.description;
    }

    @Nullable
    @NonNls
    public String getInspectionToolId() {
        String inspectionToolShortName;
        Object object = this.toolId;
        return object instanceof String ? (inspectionToolShortName = (String)object) : null;
    }

    @ApiStatus.Internal
    @Nullable
    @NonNls
    public String getExternalSourceId() {
        String string;
        ProblemGroup problemGroup = this.myProblemGroup;
        if (problemGroup instanceof ExternalSourceProblemGroup) {
            ExternalSourceProblemGroup externalSourceId = (ExternalSourceProblemGroup)problemGroup;
            string = externalSourceId.getExternalCheckName();
        } else {
            string = null;
        }
        return string;
    }

    private boolean isFlagSet(@FlagConstant byte mask) {
        return BitUtil.isSet(this.myFlags, mask);
    }

    private void setFlag(@FlagConstant byte mask, boolean value) {
        this.myFlags = BitUtil.set(this.myFlags, mask, value);
    }

    @ApiStatus.Internal
    public boolean isFileLevelAnnotation() {
        return this.isFlagSet((byte)8);
    }

    @Deprecated
    void setVisitingTextRange(@NotNull PsiFile psiFile, @NotNull Document document, long range) {
        if (psiFile == null) {
            HighlightInfo.$$$reportNull$$$0(13);
        }
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(14);
        }
    }

    @Deprecated
    @NotNull
    Segment getVisitingTextRange() {
        TextRange textRange = TextRange.EMPTY_RANGE;
        if (textRange == null) {
            HighlightInfo.$$$reportNull$$$0(15);
        }
        return textRange;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.severity;
        if (highlightSeverity == null) {
            HighlightInfo.$$$reportNull$$$0(16);
        }
        return highlightSeverity;
    }

    public RangeHighlighterEx getHighlighter() {
        return this.highlighter;
    }

    public synchronized void setHighlighter(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            HighlightInfo.$$$reportNull$$$0(17);
        }
        if (this.highlighter != null) {
            throw new IllegalStateException("Cannot set highlighter to " + String.valueOf(highlighter) + " because it already set: " + String.valueOf(this.highlighter) + ". Maybe this HighlightInfo was (incorrectly) stored and reused?");
        }
        this.highlighter = highlighter;
        this.updateFields(this.getIntentionActionDescriptors(), highlighter.getDocument());
        HighlightInfo.assertIntentionActionDescriptorsAreRangeMarkerBased(this.getIntentionActionDescriptors());
    }

    public boolean isAfterEndOfLine() {
        return this.isFlagSet((byte)4);
    }

    @Nullable
    public TextAttributes getTextAttributes(@Nullable PsiElement element, @Nullable EditorColorsScheme editorColorsScheme) {
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes;
        }
        EditorColorsScheme colorsScheme = HighlightInfo.getColorsScheme(editorColorsScheme);
        if (this.forcedTextAttributesKey != null) {
            return colorsScheme.getAttributes(this.forcedTextAttributesKey);
        }
        return HighlightInfo.getAttributesByType(element, this.type, (TextAttributesScheme)colorsScheme);
    }

    public static TextAttributes getAttributesByType(@Nullable PsiElement element, @NotNull HighlightInfoType type, @NotNull TextAttributesScheme colorsScheme) {
        SeverityRegistrar severityRegistrar;
        TextAttributes textAttributes;
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(18);
        }
        if (colorsScheme == null) {
            HighlightInfo.$$$reportNull$$$0(19);
        }
        if ((textAttributes = (severityRegistrar = SeverityRegistrar.getSeverityRegistrar(element != null ? element.getProject() : null)).getTextAttributesBySeverity(type.getSeverity(element))) != null) {
            return textAttributes;
        }
        TextAttributesKey key = type.getAttributesKey();
        return colorsScheme.getAttributes(key);
    }

    @Nullable
    Color getErrorStripeMarkColor(@NotNull PsiElement element, @Nullable(value="when null, the global scheme will be used") @Nullable(value="when null, the global scheme will be used") EditorColorsScheme colorsScheme) {
        Color errorStripeColor;
        TextAttributes forcedTextAttributes;
        if (element == null) {
            HighlightInfo.$$$reportNull$$$0(20);
        }
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes.getErrorStripeColor();
        }
        EditorColorsScheme scheme = HighlightInfo.getColorsScheme(colorsScheme);
        if (this.forcedTextAttributesKey != null && (forcedTextAttributes = scheme.getAttributes(this.forcedTextAttributesKey)) != null && (errorStripeColor = forcedTextAttributes.getErrorStripeColor()) != null) {
            return errorStripeColor;
        }
        if (this.getSeverity() == HighlightSeverity.ERROR) {
            return scheme.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WARNING) {
            return scheme.getAttributes(CodeInsightColors.WARNINGS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.INFO) {
            return scheme.getAttributes(CodeInsightColors.INFO_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WEAK_WARNING) {
            return scheme.getAttributes(CodeInsightColors.WEAK_WARNING_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) {
            return scheme.getAttributes(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING).getErrorStripeColor();
        }
        TextAttributes attributes = HighlightInfo.getAttributesByType(element, this.type, (TextAttributesScheme)scheme);
        return attributes == null ? null : attributes.getErrorStripeColor();
    }

    @NotNull
    private static EditorColorsScheme getColorsScheme(@Nullable EditorColorsScheme customScheme) {
        EditorColorsScheme editorColorsScheme = customScheme != null ? customScheme : EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            HighlightInfo.$$$reportNull$$$0(21);
        }
        return editorColorsScheme;
    }

    public boolean needUpdateOnTyping() {
        return this.isFlagSet((byte)16);
    }

    private static boolean calcNeedUpdateOnTyping(@Nullable Boolean needsUpdateOnTyping, @NotNull HighlightInfoType type) {
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(22);
        }
        if (needsUpdateOnTyping != null) {
            return needsUpdateOnTyping;
        }
        if (type instanceof HighlightInfoType.UpdateOnTypingSuppressible) {
            HighlightInfoType.UpdateOnTypingSuppressible suppressible = (HighlightInfoType.UpdateOnTypingSuppressible)((Object)type);
            return suppressible.needsUpdateOnTyping();
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HighlightInfo)) {
            return false;
        }
        HighlightInfo info = (HighlightInfo)obj;
        return this.equalsByActualOffset(info);
    }

    @ApiStatus.Internal
    public boolean equalsByActualOffset(@NotNull HighlightInfo info) {
        if (info == null) {
            HighlightInfo.$$$reportNull$$$0(23);
        }
        if (info == this) {
            return true;
        }
        return info.getActualStartOffset() == this.getActualStartOffset() && info.getActualEndOffset() == this.getActualEndOffset() && this.attributesEqual(info);
    }

    @ApiStatus.Internal
    public boolean attributesEqual(@NotNull HighlightInfo info) {
        if (info == null) {
            HighlightInfo.$$$reportNull$$$0(24);
        }
        return info.getSeverity() == this.getSeverity() && Comparing.equal(info.type, this.type) && Comparing.equal(info.gutterIconRenderer, this.gutterIconRenderer) && Comparing.equal(info.forcedTextAttributes, this.forcedTextAttributes) && Comparing.equal(info.forcedTextAttributesKey, this.forcedTextAttributesKey) && Comparing.strEqual(info.getDescription(), this.getDescription());
    }

    public int hashCode() {
        return this.startOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NonNls
    public String toStringCompact(boolean showFullQualifiedClassNames) {
        String s = "HighlightInfo(" + this.getStartOffset() + "," + this.getEndOffset() + ")";
        if (this.isFileLevelAnnotation()) {
            s = s + " (file level)";
        }
        if (this.getStartOffset() != this.startOffset || this.getEndOffset() != this.endOffset) {
            s = s + "; created as: (" + this.startOffset + "," + this.endOffset + ")";
        }
        if (this.highlighter != null) {
            s = s + "; text='" + StringUtil.first(this.getText(), 40, true) + "'";
            if (!this.highlighter.isValid()) {
                s = s + "; highlighter: (" + this.highlighter.getStartOffset() + ", " + this.highlighter.getEndOffset() + ") is invalid";
            }
        }
        if (this.getDescription() != null) {
            s = s + ", description='" + this.getDescription() + "'";
        }
        s = s + "; severity=" + String.valueOf(this.getSeverity());
        HighlightInfo highlightInfo = this;
        synchronized (highlightInfo) {
            if (!this.getIntentionActionDescriptors().isEmpty()) {
                s = s + "; quickFixes: " + StringUtil.join(this.getIntentionActionDescriptors(), ", ");
            }
        }
        if (this.gutterIconRenderer != null) {
            s = s + "; gutter: " + String.valueOf(this.gutterIconRenderer);
        }
        if (this.toolId != null) {
            String string;
            if (showFullQualifiedClassNames) {
                string = "; toolId: " + String.valueOf(this.toolId) + " (" + String.valueOf(this.toolId.getClass()) + ")";
            } else {
                String string2;
                Object object = this.toolId;
                if (object instanceof Class) {
                    Class c = (Class)object;
                    string2 = c.getSimpleName();
                } else {
                    string2 = "not specified";
                }
                string = "; toolId: " + string2;
            }
            s = s + string;
        }
        if (this.group != -6) {
            s = s + "; group: " + this.group;
        }
        if (this.forcedTextAttributesKey != null) {
            s = s + "; forcedTextAttributesKey: " + String.valueOf(this.forcedTextAttributesKey);
        }
        if (this.forcedTextAttributes != null) {
            s = s + "; forcedTextAttributes: " + String.valueOf(this.forcedTextAttributes);
        }
        return s;
    }

    @NonNls
    public String toString() {
        return this.toStringCompact(true);
    }

    @NotNull
    public static Builder newHighlightInfo(@NotNull HighlightInfoType type) {
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(25);
        }
        return new HighlightInfoB(type, false);
    }

    @ApiStatus.Internal
    public void setGroup(int group) {
        this.group = group;
    }

    public GutterMark getGutterIconRenderer() {
        return this.gutterIconRenderer;
    }

    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @NotNull
    public static HighlightInfo fromAnnotation(@NotNull Annotation annotation, @NotNull Document document) {
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(26);
        }
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(27);
        }
        return HighlightInfo.fromAnnotation(ExternalAnnotator.class, annotation, false, document);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @NotNull
    public static HighlightInfo fromAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(28);
        }
        return HighlightInfo.fromAnnotation(ExternalAnnotator.class, annotation, false, new DocumentImpl(""));
    }

    @ApiStatus.Internal
    @NotNull
    public static HighlightInfo fromAnnotation(@NotNull ExternalAnnotator<?, ?> externalAnnotator, @NotNull Annotation annotation, @NotNull Document document) {
        if (externalAnnotator == null) {
            HighlightInfo.$$$reportNull$$$0(29);
        }
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(30);
        }
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(31);
        }
        return HighlightInfo.fromAnnotation(externalAnnotator.getClass(), annotation, false, document);
    }

    @NotNull
    static HighlightInfo fromAnnotation(@NotNull Class<?> annotatorClass, @NotNull Annotation annotation, boolean batchMode, @NotNull Document document) {
        List<Annotation.QuickFixInfo> fixes;
        if (annotatorClass == null) {
            HighlightInfo.$$$reportNull$$$0(32);
        }
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(33);
        }
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(34);
        }
        TextAttributes forcedAttributes = annotation.getEnforcedTextAttributes();
        TextAttributesKey key = annotation.getTextAttributes();
        TextAttributesKey forcedAttributesKey = forcedAttributes == null && key != HighlighterColors.NO_HIGHLIGHTING ? key : null;
        HighlightInfo info = new HighlightInfo(forcedAttributes, forcedAttributesKey, HighlightInfo.convertType(annotation), annotation.getStartOffset(), annotation.getEndOffset(), annotation.getMessage(), annotation.getTooltip(), annotation.getSeverity(), annotation.isAfterEndOfLine(), annotation.needsUpdateOnTyping(), annotation.isFileLevelAnnotation(), 0, annotation.getProblemGroup(), annotatorClass, (GutterMark)annotation.getGutterIconRenderer(), -6, false, annotation.getLazyQuickFixes());
        List<Annotation.QuickFixInfo> list = fixes = batchMode ? annotation.getBatchFixes() : annotation.getQuickFixes();
        if (fixes != null) {
            List<IntentionActionDescriptor> descriptors = ContainerUtil.map(fixes, af -> {
                TextRange range = af.textRange;
                HighlightDisplayKey k = af.key != null ? af.key : HighlightDisplayKey.find(ANNOTATOR_INSPECTION_SHORT_NAME);
                return new IntentionActionDescriptor(af.quickFix, null, HighlightDisplayKey.getDisplayNameByKey(k), null, k, annotation.getProblemGroup(), info.getSeverity(), range);
            });
            info.registerFixes(descriptors, document);
        }
        HighlightInfo highlightInfo = info;
        if (highlightInfo == null) {
            HighlightInfo.$$$reportNull$$$0(35);
        }
        return highlightInfo;
    }

    @NotNull
    private static HighlightInfoType convertType(@NotNull Annotation annotation) {
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(36);
        }
        ProblemHighlightType type = annotation.getHighlightType();
        HighlightSeverity severity = annotation.getSeverity();
        return HighlightInfo.toHighlightInfoType(type, severity);
    }

    @NotNull
    private static HighlightInfoType toHighlightInfoType(ProblemHighlightType problemHighlightType, @NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(37);
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.UNUSED_SYMBOL;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(38);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.WRONG_REF;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(39);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_DEPRECATED) {
            HighlightInfoType highlightInfoType = HighlightInfoType.DEPRECATED;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(40);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.MARKED_FOR_REMOVAL;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(41);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.POSSIBLE_PROBLEM) {
            HighlightInfoType highlightInfoType = HighlightInfoType.POSSIBLE_PROBLEM;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(42);
            }
            return highlightInfoType;
        }
        return HighlightInfo.convertSeverity(severity);
    }

    @NotNull
    public static HighlightInfoType convertSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(43);
        }
        HighlightInfoType highlightInfoType = severity == HighlightSeverity.ERROR ? HighlightInfoType.ERROR : (severity == HighlightSeverity.WARNING ? HighlightInfoType.WARNING : (severity == HighlightSeverity.INFO ? HighlightInfoType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? HighlightInfoType.WEAK_WARNING : (severity == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING ? HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER : HighlightInfoType.INFORMATION))));
        if (highlightInfoType == null) {
            HighlightInfo.$$$reportNull$$$0(44);
        }
        return highlightInfoType;
    }

    @NotNull
    public static ProblemHighlightType convertType(@NotNull HighlightInfoType infoType) {
        if (infoType == null) {
            HighlightInfo.$$$reportNull$$$0(45);
        }
        if (infoType == HighlightInfoType.ERROR || infoType == HighlightInfoType.WRONG_REF) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.ERROR;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(46);
            }
            return problemHighlightType;
        }
        if (infoType == HighlightInfoType.WARNING) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.WARNING;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(47);
            }
            return problemHighlightType;
        }
        if (infoType == HighlightInfoType.INFORMATION) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.INFORMATION;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(48);
            }
            return problemHighlightType;
        }
        ProblemHighlightType problemHighlightType = ProblemHighlightType.WEAK_WARNING;
        if (problemHighlightType == null) {
            HighlightInfo.$$$reportNull$$$0(49);
        }
        return problemHighlightType;
    }

    @NotNull
    public static ProblemHighlightType convertSeverityToProblemHighlight(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(50);
        }
        ProblemHighlightType problemHighlightType = severity == HighlightSeverity.ERROR ? ProblemHighlightType.ERROR : (severity == HighlightSeverity.WARNING ? ProblemHighlightType.WARNING : (severity == HighlightSeverity.INFO ? ProblemHighlightType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION)));
        if (problemHighlightType == null) {
            HighlightInfo.$$$reportNull$$$0(51);
        }
        return problemHighlightType;
    }

    public boolean hasHint() {
        return this.isFlagSet((byte)1);
    }

    private void setHint(boolean hasHint) {
        this.setFlag((byte)1, hasHint);
    }

    public int getActualStartOffset() {
        RangeHighlighterEx h = this.highlighter;
        return h == null || !h.isValid() || this.isFileLevelAnnotation() ? this.startOffset : h.getStartOffset();
    }

    public int getActualEndOffset() {
        RangeHighlighterEx h = this.highlighter;
        return h == null || !h.isValid() || this.isFileLevelAnnotation() ? this.endOffset : h.getEndOffset();
    }

    @Override
    public int getStartOffset() {
        return this.getActualStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.getActualEndOffset();
    }

    @ApiStatus.Internal
    public int getGroup() {
        return this.group;
    }

    @ApiStatus.Internal
    public boolean isFromInjection() {
        return this.isFlagSet((byte)2);
    }

    @NotNull
    public String getText() {
        if (this.isFileLevelAnnotation()) {
            return "";
        }
        RangeHighlighterEx highlighter = this.highlighter;
        if (highlighter == null) {
            throw new RuntimeException("info not applied yet");
        }
        TextRange range = highlighter.getTextRange();
        if (!highlighter.isValid()) {
            return "";
        }
        String text = highlighter.getDocument().getText();
        String string = text.substring(Math.min(range.getStartOffset(), text.length()), Math.min(range.getEndOffset(), text.length()));
        if (string == null) {
            HighlightInfo.$$$reportNull$$$0(52);
        }
        return string;
    }

    @Deprecated
    public void registerFix(@NotNull IntentionAction action2, @Nullable List<? extends IntentionAction> options, @Nullable @Nls String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
        if (action2 == null) {
            HighlightInfo.$$$reportNull$$$0(53);
        }
        this.registerFixes(List.of(new IntentionActionDescriptor(action2, options, displayName, null, key, this.myProblemGroup, this.getSeverity(), fixRange)), null);
    }

    @ApiStatus.Internal
    synchronized void registerFixes(@NotNull @NotNull List<? extends @NotNull IntentionActionDescriptor> fixes, @Nullable Document document) {
        if (fixes == null) {
            HighlightInfo.$$$reportNull$$$0(54);
        }
        if (fixes.isEmpty()) {
            return;
        }
        List<IntentionActionDescriptor> descriptors = this.myIntentionActionDescriptors;
        ArrayList<? extends IntentionActionDescriptor> result = new ArrayList<IntentionActionDescriptor>(descriptors.size() + fixes.size());
        result.addAll(descriptors);
        result.addAll(fixes);
        this.myIntentionActionDescriptors = List.copyOf(result);
        this.updateFields(this.getIntentionActionDescriptors(), document);
    }

    @ApiStatus.Internal
    public synchronized void updateLazyFixesPsiTimeStamp(long psiTimeStamp) {
        List<LazyFixDescription> newFixes = ContainerUtil.map(this.myLazyQuickFixes, d -> d.psiModificationStamp() == 0L ? new LazyFixDescription(d.fixesComputer(), psiTimeStamp, d.future()) : d);
        if (!newFixes.equals(this.myLazyQuickFixes)) {
            this.myLazyQuickFixes = newFixes;
        }
    }

    private void updateFields(@NotNull @Unmodifiable List<? extends IntentionActionDescriptor> descriptors, @Nullable Document document) {
        if (descriptors == null) {
            HighlightInfo.$$$reportNull$$$0(55);
        }
        long newFixRange = TextRangeScalarUtil.toScalarRange(this.getFixTextRange());
        for (IntentionActionDescriptor intentionActionDescriptor : descriptors) {
            Segment segment;
            TextRange fixRange = intentionActionDescriptor.getFixRange();
            if (intentionActionDescriptor.myAction instanceof HintAction) {
                this.setHint(true);
            }
            if (document == null && (segment = intentionActionDescriptor.myFixRange) instanceof RangeMarker) {
                RangeMarker marker = (RangeMarker)segment;
                document = marker.getDocument();
            }
            if (fixRange == null) continue;
            newFixRange = TextRangeScalarUtil.union(newFixRange, TextRangeScalarUtil.toScalarRange(fixRange));
        }
        RangeHighlighterEx highlighter = this.highlighter;
        if (document == null) {
            RangeMarker rangeMarker = this.fixMarker;
            Document document2 = rangeMarker != null && rangeMarker != FIX_MARKER_SAME_AS_HIGHLIGHTER ? rangeMarker.getDocument() : (document = highlighter != null ? highlighter.getDocument() : null);
        }
        if (document != null) {
            newFixRange = TextRangeScalarUtil.coerceRange(newFixRange, 0, document.getTextLength());
            Long2ObjectMap<RangeMarker> long2ObjectMap = this.getRangeMarkerCache();
            HighlightInfo.updateDescriptorFixRanges(descriptors, document, long2ObjectMap, newFixRange);
            if (highlighter != null && highlighter.isValid()) {
                long highlighterRange = TextRangeScalarUtil.toScalarRange((Segment)highlighter);
                this.updateFixMarker(document, long2ObjectMap, newFixRange, highlighterRange);
            }
        }
    }

    @NotNull
    private Long2ObjectMap<RangeMarker> getRangeMarkerCache() {
        RangeHighlighterEx highlighter;
        Long2ObjectOpenHashMap<RangeMarker> cache2 = new Long2ObjectOpenHashMap<RangeMarker>();
        for (IntentionActionDescriptor pair : this.getIntentionActionDescriptors()) {
            RangeMarker marker;
            Segment fixRange = pair.myFixRange;
            if (!(fixRange instanceof RangeMarker) || !(marker = (RangeMarker)fixRange).isValid()) continue;
            cache2.put(TextRangeScalarUtil.toScalarRange(marker), marker);
            break;
        }
        if ((highlighter = this.highlighter) != null && highlighter.isValid()) {
            cache2.putIfAbsent(TextRangeScalarUtil.toScalarRange((Segment)highlighter), (RangeMarker)highlighter);
        }
        Long2ObjectOpenHashMap<RangeMarker> long2ObjectOpenHashMap = cache2;
        if (long2ObjectOpenHashMap == null) {
            HighlightInfo.$$$reportNull$$$0(56);
        }
        return long2ObjectOpenHashMap;
    }

    public synchronized void unregisterQuickFix(@NotNull Condition<? super IntentionAction> condition) {
        if (condition == null) {
            HighlightInfo.$$$reportNull$$$0(57);
        }
        this.myIntentionActionDescriptors = List.copyOf(ContainerUtil.filter(this.myIntentionActionDescriptors, descriptor -> !condition.value(descriptor.getAction())));
    }

    public synchronized IntentionAction getSameFamilyFix(@NotNull IntentionActionWithFixAllOption action2) {
        if (action2 == null) {
            HighlightInfo.$$$reportNull$$$0(58);
        }
        for (IntentionActionDescriptor descriptor : this.getIntentionActionDescriptors()) {
            IntentionActionWithFixAllOption option;
            IntentionAction other = IntentionActionDelegate.unwrap(descriptor.getAction());
            if (!(other instanceof IntentionActionWithFixAllOption) || !action2.belongsToMyFamily(option = (IntentionActionWithFixAllOption)other)) continue;
            return other;
        }
        return null;
    }

    @ApiStatus.Internal
    public boolean containsOffset(int offset, boolean includeFixRange) {
        RangeHighlighterEx highlighter = this.getHighlighter();
        if (highlighter == null || !highlighter.isValid()) {
            return false;
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        if (startOffset <= offset && offset <= endOffset) {
            return true;
        }
        if (!includeFixRange) {
            return false;
        }
        Segment fixRange = this.getFixTextRange();
        startOffset = fixRange.getStartOffset();
        endOffset = fixRange.getEndOffset();
        return startOffset <= offset && offset <= endOffset;
    }

    @NotNull
    private static RangeMarker getOrCreate(@NotNull Document document, @NotNull Long2ObjectMap<RangeMarker> range2markerCache, long textRange) {
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(59);
        }
        if (range2markerCache == null) {
            HighlightInfo.$$$reportNull$$$0(60);
        }
        RangeMarker rangeMarker = range2markerCache.computeIfAbsent(textRange, __ -> document.createRangeMarker(TextRangeScalarUtil.startOffset(textRange), TextRangeScalarUtil.endOffset(textRange)));
        if (rangeMarker == null) {
            HighlightInfo.$$$reportNull$$$0(61);
        }
        return rangeMarker;
    }

    synchronized void updateQuickFixFields(@NotNull Document document, @NotNull Long2ObjectMap<RangeMarker> range2markerCache, long finalHighlighterRange) {
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(62);
        }
        if (range2markerCache == null) {
            HighlightInfo.$$$reportNull$$$0(63);
        }
        long fixTextRange = TextRangeScalarUtil.coerceRange(TextRangeScalarUtil.toScalarRange(this.getFixTextRange()), 0, document.getTextLength());
        this.updateFixMarker(document, range2markerCache, fixTextRange, finalHighlighterRange);
        HighlightInfo.updateDescriptorFixRanges(this.getIntentionActionDescriptors(), document, range2markerCache, fixTextRange);
    }

    private static void updateDescriptorFixRanges(@NotNull List<? extends IntentionActionDescriptor> descriptors, @NotNull Document document, @NotNull Long2ObjectMap<RangeMarker> range2markerCache, long fixTextRange) {
        if (descriptors == null) {
            HighlightInfo.$$$reportNull$$$0(64);
        }
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(65);
        }
        if (range2markerCache == null) {
            HighlightInfo.$$$reportNull$$$0(66);
        }
        for (IntentionActionDescriptor intentionActionDescriptor : descriptors) {
            Segment descriptorFixRange = intentionActionDescriptor.myFixRange;
            if (descriptorFixRange instanceof TextRange) {
                TextRange tr = (TextRange)descriptorFixRange;
                intentionActionDescriptor.myFixRange = HighlightInfo.getOrCreate(document, range2markerCache, TextRangeScalarUtil.toScalarRange(tr));
                continue;
            }
            if (descriptorFixRange != null) continue;
            intentionActionDescriptor.myFixRange = HighlightInfo.getOrCreate(document, range2markerCache, fixTextRange);
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void updateFixMarker(@NotNull Document document, @NotNull Long2ObjectMap<RangeMarker> range2markerCache, long newFixRange, long l) {
        void finalHighlighterRange;
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(67);
        }
        if (range2markerCache == null) {
            HighlightInfo.$$$reportNull$$$0(68);
        }
        this.fixMarker = newFixRange == finalHighlighterRange ? FIX_MARKER_SAME_AS_HIGHLIGHTER : HighlightInfo.getOrCreate(document, range2markerCache, newFixRange);
    }

    @ApiStatus.Internal
    public synchronized boolean hasLazyQuickFixes() {
        return !this.myLazyQuickFixes.isEmpty();
    }

    @ApiStatus.Internal
    public boolean isFromAnnotator() {
        return HighlightInfoUpdaterImpl.isAnnotatorToolId(this.toolId);
    }

    @ApiStatus.Internal
    public boolean isFromInspection() {
        return HighlightInfoUpdaterImpl.isInspectionToolId(this.toolId);
    }

    @ApiStatus.Internal
    public boolean isFromHighlightVisitor() {
        return HighlightInfoUpdaterImpl.isHighlightVisitorToolId(this.toolId);
    }

    @ApiStatus.Internal
    boolean isInjectionRelated() {
        return HighlightInfoUpdaterImpl.isInjectionRelated(this.toolId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static HighlightInfo createComposite(@NotNull List<? extends HighlightInfo> infos) {
        HighlightInfo info2;
        HighlightInfo anchorInfo;
        if (infos == null) {
            HighlightInfo.$$$reportNull$$$0(69);
        }
        if ((anchorInfo = (HighlightInfo)((Object)ContainerUtil.find(infos, info -> info.getToolTip() != null))) == null) {
            anchorInfo = infos.get(0);
        }
        Builder builder = anchorInfo.copy(false);
        String compositeDescription = HighlightInfo.createCompositeDescription(infos);
        String compositeTooltip = HighlightInfo.createCompositeTooltip(infos);
        if (compositeDescription != null) {
            builder.description(compositeDescription);
        }
        if (compositeTooltip != null) {
            builder.escapedToolTip(compositeTooltip);
        }
        HighlightInfo highlightInfo = info2 = builder.createUnconditionally();
        synchronized (highlightInfo) {
            info2.highlighter = anchorInfo.getHighlighter();
            info2.myIntentionActionDescriptors = ContainerUtil.concat(ContainerUtil.map(infos, i -> i.myIntentionActionDescriptors));
        }
        HighlightInfo highlightInfo2 = info2;
        if (highlightInfo2 == null) {
            HighlightInfo.$$$reportNull$$$0(70);
        }
        return highlightInfo2;
    }

    @Nullable
    @NlsSafe
    private static String createCompositeDescription(@NotNull List<? extends HighlightInfo> infos) {
        if (infos == null) {
            HighlightInfo.$$$reportNull$$$0(71);
        }
        StringBuilder description = new StringBuilder();
        boolean isNull = true;
        for (HighlightInfo highlightInfo : infos) {
            String itemDescription = highlightInfo.getDescription();
            if (itemDescription == null) continue;
            itemDescription = itemDescription.trim();
            description.append(itemDescription);
            if (!itemDescription.endsWith(".")) {
                description.append('.');
            }
            description.append(' ');
            isNull = false;
        }
        return isNull ? null : description.toString();
    }

    @Nullable
    @NlsSafe
    private static String createCompositeTooltip(@NotNull List<? extends HighlightInfo> infos) {
        if (infos == null) {
            HighlightInfo.$$$reportNull$$$0(72);
        }
        StringBuilder result = new StringBuilder();
        for (HighlightInfo highlightInfo : infos) {
            String toolTip = highlightInfo.getToolTip();
            if (toolTip == null) continue;
            if (!result.isEmpty()) {
                result.append("<hr size=1 noshade>");
            }
            toolTip = XmlStringUtil.stripHtml(toolTip);
            result.append(toolTip);
        }
        if (result.isEmpty()) {
            return null;
        }
        return XmlStringUtil.wrapInHtml(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeQuickFixesSynchronously(@NotNull PsiFile psiFile, @NotNull Document document) throws ExecutionException, InterruptedException {
        ArrayList<LazyFixDescription> pairs;
        if (psiFile == null) {
            HighlightInfo.$$$reportNull$$$0(73);
        }
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(74);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HighlightInfo highlightInfo = this;
        synchronized (highlightInfo) {
            pairs = new ArrayList<LazyFixDescription>(this.myLazyQuickFixes);
        }
        List<LazyFixDescription> newPairs = ContainerUtil.map(pairs, desc -> {
            Future<? extends List<IntentionActionDescriptor>> future = desc.future();
            if (future == null || !future.isDone()) {
                Consumer<? super QuickFixActionRegistrar> computer = desc.fixesComputer();
                future = CompletableFuture.completedFuture(this.doComputeLazyQuickFixes(document, psiFile.getProject(), desc.psiModificationStamp(), computer));
                return new LazyFixDescription(computer, desc.psiModificationStamp(), future);
            }
            return desc;
        });
        for (LazyFixDescription newPair : newPairs) {
            newPair.future().get();
        }
        HighlightInfo highlightInfo2 = this;
        synchronized (highlightInfo2) {
            if (!newPairs.equals(pairs)) {
                this.myLazyQuickFixes = newPairs;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private List<IntentionActionDescriptor> doComputeLazyQuickFixes(final @NotNull Document document, @NotNull Project project, long oldPsiModificationStamp, @NotNull Consumer<? super QuickFixActionRegistrar> consumer) {
        void computation;
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(75);
        }
        if (project == null) {
            HighlightInfo.$$$reportNull$$$0(76);
        }
        if (consumer == null) {
            HighlightInfo.$$$reportNull$$$0(77);
        }
        if (project.isDisposed() || PsiDocumentManager.getInstance(project).isUncommited(document) || PsiManager.getInstance(project).getModificationTracker().getModificationCount() != oldPsiModificationStamp) {
            List<IntentionActionDescriptor> list = List.of();
            if (list == null) {
                HighlightInfo.$$$reportNull$$$0(78);
            }
            return list;
        }
        HighlightInfo.assertIntentionActionDescriptorsAreRangeMarkerBased(this.getIntentionActionDescriptors());
        final List<IntentionActionDescriptor> newDescriptors = Collections.synchronizedList(new ArrayList());
        QuickFixActionRegistrar registrarDelegate = new QuickFixActionRegistrar(){

            @Override
            public void register(@NotNull IntentionAction action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.doRegister(HighlightInfo.this.getFixTextRange(), action2, null);
            }

            @Override
            public void register(@NotNull TextRange fixRange, @NotNull IntentionAction action2, @Nullable HighlightDisplayKey key) {
                if (fixRange == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (action2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.doRegister(fixRange, action2, key);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doRegister(@NotNull Segment fixRange, @NotNull IntentionAction action2, @Nullable HighlightDisplayKey key) {
                if (fixRange == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (action2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                IntentionActionDescriptor descriptor = new IntentionActionDescriptor(action2, null, null, null, key, HighlightInfo.this.myProblemGroup, HighlightInfo.this.severity, fixRange);
                newDescriptors.add(descriptor);
                HighlightInfo highlightInfo = HighlightInfo.this;
                synchronized (highlightInfo) {
                    HighlightInfo.this.updateFields(List.of(descriptor), document);
                    HighlightInfo.assertIntentionActionDescriptorsAreRangeMarkerBased(List.of(descriptor));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fixRange";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "register";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doRegister";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        computation.accept(registrarDelegate);
        HighlightInfo.assertIntentionActionDescriptorsAreRangeMarkerBased(newDescriptors);
        List<IntentionActionDescriptor> list = newDescriptors;
        if (list == null) {
            HighlightInfo.$$$reportNull$$$0(79);
        }
        return list;
    }

    private static void assertIntentionActionDescriptorsAreRangeMarkerBased(@NotNull List<? extends IntentionActionDescriptor> descriptors) {
        if (descriptors == null) {
            HighlightInfo.$$$reportNull$$$0(80);
        }
        for (IntentionActionDescriptor intentionActionDescriptor : descriptors) {
            assert (intentionActionDescriptor.myFixRange == null || intentionActionDescriptor.myFixRange instanceof RangeMarker) : String.valueOf(intentionActionDescriptor) + "; descriptors:" + String.valueOf(descriptors);
        }
    }

    synchronized void startComputeQuickFixes(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(81);
        }
        if (project == null) {
            HighlightInfo.$$$reportNull$$$0(82);
        }
        HighlightInfo.assertIntentionActionDescriptorsAreRangeMarkerBased(this.getIntentionActionDescriptors());
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        List<LazyFixDescription> newPairs = ContainerUtil.map(this.myLazyQuickFixes, description -> {
            Future<? extends List<IntentionActionDescriptor>> future = description.future();
            if (future == null) {
                Consumer<? super QuickFixActionRegistrar> computer = description.fixesComputer();
                future = ReadAction.nonBlocking(() -> {
                    AtomicReference result = new AtomicReference(List.of());
                    ((ApplicationEx)ApplicationManager.getApplication()).executeByImpatientReader(() -> result.set(this.doComputeLazyQuickFixes(document, project, description.psiModificationStamp, computer)));
                    return result.get();
                }).submit(ForkJoinPool.commonPool());
                return new LazyFixDescription(computer, PsiManager.getInstance(project).getModificationTracker().getModificationCount(), future);
            }
            return description;
        });
        if (!newPairs.equals(this.myLazyQuickFixes)) {
            this.myLazyQuickFixes = newPairs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyComputedLazyFixesTo(@NotNull HighlightInfo newInfo, @NotNull Document document) {
        ArrayList<LazyFixDescription> list;
        if (newInfo == null) {
            HighlightInfo.$$$reportNull$$$0(83);
        }
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(84);
        }
        HighlightInfo highlightInfo = this;
        synchronized (highlightInfo) {
            list = new ArrayList<LazyFixDescription>(this.myLazyQuickFixes);
        }
        highlightInfo = newInfo;
        synchronized (highlightInfo) {
            if (newInfo.myLazyQuickFixes.size() == list.size() && HighlightInfo.psiModificationStampIsTheSame(newInfo.myLazyQuickFixes, list)) {
                newInfo.myLazyQuickFixes = list;
                newInfo.updateFields(newInfo.getIntentionActionDescriptors(), document);
            }
        }
    }

    private static boolean psiModificationStampIsTheSame(@NotNull @Unmodifiable List<LazyFixDescription> list1, @NotNull @Unmodifiable List<LazyFixDescription> list2) {
        if (list1 == null) {
            HighlightInfo.$$$reportNull$$$0(85);
        }
        if (list2 == null) {
            HighlightInfo.$$$reportNull$$$0(86);
        }
        for (int i = 0; i < list1.size(); ++i) {
            LazyFixDescription fix1 = list1.get(i);
            LazyFixDescription fix2 = list2.get(i);
            if (fix1.psiModificationStamp() == fix2.psiModificationStamp()) continue;
            return false;
        }
        return true;
    }

    @ApiStatus.Internal
    @NotNull
    public synchronized Builder copy(final boolean copyFlagsAndFixes) {
        GutterMark gutterMark;
        HighlightInfoB builder = new HighlightInfoB(this.type, true){

            @Override
            @NotNull
            public HighlightInfo createUnconditionally() {
                HighlightInfo newInfo = super.createUnconditionally();
                if (copyFlagsAndFixes) {
                    newInfo.myIntentionActionDescriptors = HighlightInfo.this.myIntentionActionDescriptors;
                    newInfo.fixMarker = HighlightInfo.this.fixMarker;
                    newInfo.myFlags = HighlightInfo.this.myFlags;
                }
                newInfo.myLazyQuickFixes = HighlightInfo.this.myLazyQuickFixes;
                newInfo.toolId = HighlightInfo.this.toolId;
                HighlightInfo highlightInfo = newInfo;
                if (highlightInfo == null) {
                    2.$$$reportNull$$$0(0);
                }
                return highlightInfo;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$2", "createUnconditionally"));
            }
        };
        builder.range(this.startOffset, this.endOffset);
        if (this.forcedTextAttributes != null) {
            builder.textAttributes(this.forcedTextAttributes);
        }
        if (this.forcedTextAttributesKey != null) {
            builder.textAttributes(this.forcedTextAttributesKey);
        }
        if (this.description != null) {
            builder.description(this.description);
        }
        if (this.toolTip != null) {
            builder.escapedToolTip(this.toolTip);
        }
        builder.needsUpdateOnTyping(this.needUpdateOnTyping());
        if (this.isFileLevelAnnotation()) {
            builder.fileLevelAnnotation();
        }
        if (copyFlagsAndFixes && this.isAfterEndOfLine()) {
            builder.endOfLine();
        }
        builder.severity(this.severity);
        if (this.navigationShift != 0) {
            builder.navigationShift(this.navigationShift);
        }
        if (this.getProblemGroup() != null) {
            builder.problemGroup(this.getProblemGroup());
        }
        if ((gutterMark = this.gutterIconRenderer) instanceof GutterIconRenderer) {
            GutterIconRenderer g = (GutterIconRenderer)gutterMark;
            builder.gutterIconRenderer(g);
        }
        if (this.group != 0) {
            builder.group(this.group);
        }
        HighlightInfoB highlightInfoB = builder;
        if (highlightInfoB == null) {
            HighlightInfo.$$$reportNull$$$0(87);
        }
        return highlightInfoB;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 14, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36, 37, 43, 45, 50, 53, 54, 55, 57, 58, 59, 60, 62, 63, 64, 65, 66, 67, 68, 69, 71, 72, 73, 74, 75, 76, 77, 80, 81, 82, 83, 84, 85, 86 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo";
                break;
            }
            case 1: 
            case 18: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 37: 
            case 43: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyFixes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 13: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 14: 
            case 27: 
            case 31: 
            case 34: 
            case 59: 
            case 62: 
            case 65: 
            case 67: 
            case 74: 
            case 75: 
            case 81: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalAnnotator";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotatorClass";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoType";
                break;
            }
            case 53: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 55: 
            case 64: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 60: 
            case 63: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range2markerCache";
                break;
            }
            case 69: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 76: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionActionDescriptors";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 43: 
            case 45: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixTextRange";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisitingTextRange";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAnnotation";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "toHighlightInfoType";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSeverity";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "convertType";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSeverityToProblemHighlight";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeMarkerCache";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "createComposite";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeLazyQuickFixes";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredQuickFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromRangeHighlighter";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFileLevelComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeFileLeverComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileLevelComponent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setVisitingTextRange";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setHighlighter";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesByType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getErrorStripeMarkColor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "calcNeedUpdateOnTyping";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "equalsByActualOffset";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "attributesEqual";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "newHighlightInfo";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "fromAnnotation";
                break;
            }
            case 36: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "convertType";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "toHighlightInfoType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "convertSeverity";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "convertSeverityToProblemHighlight";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "registerFix";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "updateFields";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "unregisterQuickFix";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getSameFamilyFix";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "updateQuickFixFields";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "updateDescriptorFixRanges";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "updateFixMarker";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createComposite";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeDescription";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeTooltip";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "computeQuickFixesSynchronously";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "doComputeLazyQuickFixes";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "assertIntentionActionDescriptorsAreRangeMarkerBased";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "startComputeQuickFixes";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "copyComputedLazyFixesTo";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "psiModificationStampIsTheSame";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 14, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36, 37, 43, 45, 50, 53, 54, 55, 57, 58, 59, 60, 62, 63, 64, 65, 66, 67, 68, 69, 71, 72, 73, 74, 75, 76, 77, 80, 81, 82, 83, 84, 85, 86 -> new IllegalArgumentException(string);
        };
    }

    public static final class IntentionActionDescriptor {
        private final IntentionAction myAction;
        private volatile @Unmodifiable List<? extends IntentionAction> myOptions;
        @Nullable
        private final HighlightDisplayKey myKey;
        private final ProblemGroup myProblemGroup;
        private final HighlightSeverity mySeverity;
        @Nls
        private final String myDisplayName;
        private final Icon myIcon;
        private Boolean myCanCleanup;
        private Segment myFixRange;

        @Deprecated
        public IntentionActionDescriptor(@NotNull IntentionAction action2, @Nullable @Unmodifiable List<? extends IntentionAction> options, @Nullable @Nls String displayName, @Nullable Icon icon, @Nullable HighlightDisplayKey key, @Nullable ProblemGroup problemGroup, @Nullable HighlightSeverity severity) {
            if (action2 == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(0);
            }
            this(action2, options, displayName, icon, key, problemGroup, severity, null);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action2, @Nullable @Unmodifiable List<? extends IntentionAction> options, @Nullable @Nls String displayName, @Nullable Icon icon, @Nullable HighlightDisplayKey key, @Nullable ProblemGroup problemGroup, @Nullable HighlightSeverity severity, @Nullable Segment fixRange) {
            if (action2 == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(1);
            }
            this.myAction = action2;
            this.myOptions = options;
            this.myDisplayName = displayName;
            this.myIcon = icon;
            this.myKey = key;
            this.myProblemGroup = problemGroup;
            this.mySeverity = severity;
            this.myFixRange = fixRange;
        }

        @Nullable
        @ApiStatus.Internal
        public IntentionActionDescriptor withEmptyAction() {
            if (this.myKey == null || this.myKey.getID().equals(HighlightInfo.ANNOTATOR_INSPECTION_SHORT_NAME)) {
                return null;
            }
            String displayName = HighlightDisplayKey.getDisplayNameByKey(this.myKey);
            if (displayName == null) {
                return null;
            }
            return new IntentionActionDescriptor(new EmptyIntentionAction(displayName), this.myOptions, this.myDisplayName, this.myIcon, this.myKey, this.myProblemGroup, this.mySeverity, this.myFixRange);
        }

        @NotNull
        IntentionActionDescriptor withProblemGroupAndSeverity(@Nullable ProblemGroup problemGroup, @Nullable HighlightSeverity severity) {
            return new IntentionActionDescriptor(this.myAction, this.myOptions, this.myDisplayName, this.myIcon, this.myKey, problemGroup, severity, this.myFixRange);
        }

        @NotNull
        @ApiStatus.Internal
        IntentionActionDescriptor withFixRange(@NotNull Segment fixRange) {
            if (fixRange == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(2);
            }
            return new IntentionActionDescriptor(this.myAction, this.myOptions, this.myDisplayName, this.myIcon, this.myKey, this.myProblemGroup, this.mySeverity, fixRange);
        }

        @NotNull
        public IntentionAction getAction() {
            IntentionAction intentionAction = this.myAction;
            if (intentionAction == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(3);
            }
            return intentionAction;
        }

        @ApiStatus.Internal
        public boolean isError() {
            return this.mySeverity == null || this.mySeverity.compareTo(HighlightSeverity.ERROR) >= 0;
        }

        @ApiStatus.Internal
        public boolean isInformation() {
            return HighlightSeverity.INFORMATION.equals(this.mySeverity);
        }

        @ApiStatus.Internal
        public boolean canCleanup(@NotNull PsiElement element) {
            if (element == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(4);
            }
            if (this.myCanCleanup == null) {
                InspectionToolWrapper<?, ?> toolWrapper;
                InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(element.getProject()).getCurrentProfile();
                this.myCanCleanup = this.myKey == null ? Boolean.valueOf(false) : Boolean.valueOf((toolWrapper = profile.getInspectionTool(this.myKey.getShortName(), element)) != null && toolWrapper.isCleanupTool());
            }
            return this.myCanCleanup;
        }

        @NotNull
        public Iterable<? extends IntentionAction> getOptions(@NotNull PsiElement element, @Nullable Editor editor) {
            ProblemGroup wrappedTool;
            IntentionAction action2;
            if (element == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(5);
            }
            if (editor != null && Boolean.FALSE.equals(editor.getUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY))) {
                List list = Collections.emptyList();
                if (list == null) {
                    IntentionActionDescriptor.$$$reportNull$$$0(6);
                }
                return list;
            }
            List<? extends IntentionAction> options = this.myOptions;
            if (options != null) {
                List<? extends IntentionAction> list = options;
                if (list == null) {
                    IntentionActionDescriptor.$$$reportNull$$$0(7);
                }
                return list;
            }
            HighlightDisplayKey key = this.myKey;
            if (this.myProblemGroup != null) {
                HighlightDisplayKey problemGroupKey;
                String problemName = this.myProblemGroup.getProblemName();
                HighlightDisplayKey highlightDisplayKey = problemGroupKey = problemName != null ? HighlightDisplayKey.findById(problemName) : null;
                if (problemGroupKey != null) {
                    key = problemGroupKey;
                }
            }
            if ((action2 = IntentionActionDelegate.unwrap(this.myAction)) instanceof IntentionActionWithOptions) {
                IntentionActionWithOptions wo = (IntentionActionWithOptions)action2;
                if (!(key != null && wo.getCombiningPolicy() != IntentionActionWithOptions.CombiningPolicy.IntentionOptionsOnly || (options = wo.getOptions()).isEmpty())) {
                    return this.updateOptions(options);
                }
            }
            if (key == null) {
                List list = Collections.emptyList();
                if (list == null) {
                    IntentionActionDescriptor.$$$reportNull$$$0(8);
                }
                return list;
            }
            IntentionManager intentionManager = IntentionManager.getInstance();
            ArrayList<IntentionAction> newOptions = new ArrayList<IntentionAction>(intentionManager.getStandardIntentionOptions(key, element));
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(element.getProject()).getCurrentProfile();
            InspectionToolWrapper<?, ?> toolWrapper = profile.getInspectionTool(key.getShortName(), element);
            if (toolWrapper != null) {
                this.myCanCleanup = toolWrapper.isCleanupTool();
                IntentionAction fixAllIntention = intentionManager.createFixAllIntention(toolWrapper, this.myAction);
                if (toolWrapper instanceof LocalInspectionToolWrapper) {
                    LocalInspectionToolWrapper local = (LocalInspectionToolWrapper)toolWrapper;
                    v4 = local.getTool();
                } else {
                    v4 = wrappedTool = ((GlobalInspectionToolWrapper)toolWrapper).getTool();
                }
                if (HighlightInfo.ANNOTATOR_INSPECTION_SHORT_NAME.equals(((InspectionProfileEntry)((Object)wrappedTool)).getShortName())) {
                    List<Object> actions = Collections.emptyList();
                    ProblemGroup problemGroup = this.myProblemGroup;
                    if (problemGroup instanceof SuppressableProblemGroup) {
                        SuppressableProblemGroup suppressible = (SuppressableProblemGroup)problemGroup;
                        actions = Arrays.asList(suppressible.getSuppressActions(element));
                    }
                    if (fixAllIntention != null) {
                        if (actions.isEmpty()) {
                            List<IntentionAction> list = Collections.singletonList(fixAllIntention);
                            if (list == null) {
                                IntentionActionDescriptor.$$$reportNull$$$0(9);
                            }
                            return list;
                        }
                        actions = new ArrayList(actions);
                        actions.add(fixAllIntention);
                    }
                    List list = actions;
                    if (list == null) {
                        IntentionActionDescriptor.$$$reportNull$$$0(10);
                    }
                    return list;
                }
                if (!(action2 instanceof EmptyIntentionAction)) {
                    newOptions.add(new DisableHighlightingIntentionAction(toolWrapper.getShortName()));
                }
                ContainerUtil.addIfNotNull(newOptions, fixAllIntention);
                if (wrappedTool instanceof CustomSuppressableInspectionTool) {
                    CustomSuppressableInspectionTool custom = (CustomSuppressableInspectionTool)((Object)wrappedTool);
                    SuppressIntentionAction[] suppressActions = custom.getSuppressActions(element);
                    if (suppressActions != null) {
                        ContainerUtil.addAll(newOptions, suppressActions);
                    }
                } else {
                    SuppressQuickFix[] suppressFixes = ((InspectionProfileEntry)((Object)wrappedTool)).getBatchSuppressActions(element);
                    if (suppressFixes.length > 0) {
                        newOptions.addAll(ContainerUtil.map(suppressFixes, SuppressIntentionActionFromFix::convertBatchToSuppressIntentionAction));
                    }
                }
            }
            if ((wrappedTool = this.myProblemGroup) instanceof SuppressableProblemGroup) {
                SuppressableProblemGroup suppressible = (SuppressableProblemGroup)wrappedTool;
                SuppressIntentionAction[] suppressActions = suppressible.getSuppressActions(element);
                ContainerUtil.addAll(newOptions, suppressActions);
            }
            return this.updateOptions(newOptions);
        }

        @NotNull
        private synchronized List<? extends IntentionAction> updateOptions(@NotNull List<? extends IntentionAction> newOptions) {
            List<? extends IntentionAction> options;
            if (newOptions == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(11);
            }
            if ((options = this.myOptions) == null) {
                this.myOptions = options = newOptions;
            }
            List<? extends IntentionAction> list = options;
            if (list == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(12);
            }
            return list;
        }

        @Nullable
        @Nls
        public String getDisplayName() {
            return this.myDisplayName;
        }

        public String toString() {
            String name = this.getAction().getFamilyName();
            return "IntentionActionDescriptor: '" + name + "' (" + String.valueOf(ReportingClassSubstitutor.getClassToReport(this.getAction())) + ")" + (String)(this.myFixRange == null || this.myFixRange.getStartOffset() == this.myFixRange.getEndOffset() ? "" : "; fixRange: " + String.valueOf(TextRange.create(this.myFixRange)) + "(" + String.valueOf(this.myFixRange.getClass()) + ")");
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof IntentionActionDescriptor)) return false;
            IntentionActionDescriptor descriptor = (IntentionActionDescriptor)obj;
            if (!this.myAction.equals(descriptor.myAction)) return false;
            return true;
        }

        @Nullable
        public String getToolId() {
            return this.myKey != null ? this.myKey.getID() : null;
        }

        @ApiStatus.Internal
        public TextRange getFixRange() {
            TextRange textRange;
            Segment range = this.myFixRange;
            if (range instanceof TextRange) {
                TextRange tr;
                textRange = tr = (TextRange)range;
            } else if (range instanceof RangeMarker) {
                RangeMarker marker = (RangeMarker)range;
                textRange = marker.getTextRange();
            } else {
                textRange = null;
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 6, 7, 8, 9, 10, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixRange";
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptions";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "withFixRange";
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canCleanup";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getOptions";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "updateOptions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 6, 7, 8, 9, 10, 12 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.NonExtendable
    public static interface Builder {
        @NotNull
        public Builder range(@NotNull TextRange var1);

        @NotNull
        public Builder range(@NotNull ASTNode var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1, @NotNull TextRange var2);

        @NotNull
        public Builder range(@NotNull PsiElement var1, int var2, int var3);

        @NotNull
        public Builder range(int var1, int var2);

        @NotNull
        public Builder gutterIconRenderer(@NotNull GutterIconRenderer var1);

        @NotNull
        public Builder problemGroup(@NotNull ProblemGroup var1);

        @Deprecated
        @NotNull
        public Builder inspectionToolId(@NotNull String var1);

        @NotNull
        public Builder description(@NlsContexts.DetailedDescription @NotNull String var1);

        @NotNull
        public Builder descriptionAndTooltip(@NlsContexts.DetailedDescription @NotNull String var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributes var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributesKey var1);

        @NotNull
        public Builder unescapedToolTip(@NlsContexts.Tooltip @NotNull String var1);

        @NotNull
        public Builder escapedToolTip(@NlsContexts.Tooltip @NotNull String var1);

        @NotNull
        public Builder endOfLine();

        @NotNull
        public Builder needsUpdateOnTyping(boolean var1);

        @NotNull
        public Builder severity(@NotNull HighlightSeverity var1);

        @NotNull
        public Builder fileLevelAnnotation();

        @NotNull
        public Builder navigationShift(int var1);

        @NotNull
        public Builder group(int var1);

        @NotNull
        public Builder registerFix(@NotNull IntentionAction var1, @Nullable List<? extends IntentionAction> var2, @Nullable @Nls String var3, @Nullable TextRange var4, @Nullable HighlightDisplayKey var5);

        @NotNull
        @ApiStatus.Experimental
        public Builder registerLazyFixes(@NotNull Consumer<? super QuickFixActionRegistrar> var1);

        @ApiStatus.Experimental
        @NotNull
        default public Builder registerFix(@NotNull ModCommandAction action2, @Nullable List<? extends IntentionAction> options, @Nullable @Nls String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
            if (action2 == null) {
                Builder.$$$reportNull$$$0(0);
            }
            Builder builder = this.registerFix(action2.asIntention(), options, displayName, fixRange, key);
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @Nullable(value="null means filtered out")
        public @Nullable(value="null means filtered out") HighlightInfo create();

        @NotNull
        public HighlightInfo createUnconditionally();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "registerFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "registerFix";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private record LazyFixDescription(@NotNull Consumer<? super QuickFixActionRegistrar> fixesComputer, long psiModificationStamp, @Nullable Future<? extends @NotNull List<IntentionActionDescriptor>> future) {
        @NotNull
        private final Consumer<? super QuickFixActionRegistrar> fixesComputer;

        /*
         * WARNING - void declaration
         */
        private LazyFixDescription(@NotNull Consumer<? super QuickFixActionRegistrar> fixesComputer, long psiModificationStamp, @Nullable Future<? extends @NotNull List<IntentionActionDescriptor>> future) {
            void future2;
            if (fixesComputer == null) {
                LazyFixDescription.$$$reportNull$$$0(0);
            }
            this.fixesComputer = fixesComputer;
            this.psiModificationStamp = psiModificationStamp;
            this.future = future2;
        }

        @NotNull
        public Consumer<? super QuickFixActionRegistrar> fixesComputer() {
            Consumer<? super QuickFixActionRegistrar> consumer = this.fixesComputer;
            if (consumer == null) {
                LazyFixDescription.$$$reportNull$$$0(1);
            }
            return consumer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixesComputer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$LazyFixDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$LazyFixDescription";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fixesComputer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static @interface FlagConstant {
    }
}

