/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class DefaultHighlightVisitor
implements HighlightVisitor,
DumbAware {
    private final Project myProject;
    private final boolean myHighlightErrorElements;
    private HighlightInfoHolder myHolder;
    private final boolean myBatchMode;

    DefaultHighlightVisitor(@NotNull Project project) {
        if (project == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(0);
        }
        this(project, true, false);
    }

    DefaultHighlightVisitor(@NotNull Project project, boolean highlightErrorElements, boolean batchMode) {
        if (project == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myHighlightErrorElements = highlightErrorElements;
        this.myBatchMode = batchMode;
    }

    @Override
    public boolean suitableForFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(2);
        }
        return this.myHighlightErrorElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(@NotNull PsiFile psiFile, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action2) {
        if (psiFile == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(4);
        }
        if (action2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(5);
        }
        this.myHolder = holder;
        try {
            action2.run();
        }
        finally {
            this.myHolder = null;
        }
        return true;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        PsiErrorElement e;
        if (element == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(6);
        }
        if (element instanceof PsiErrorElement && HighlightErrorFilter.EP_NAME.findFirstSafe(this.myProject, arg_0 -> DefaultHighlightVisitor.lambda$visit$0(e = (PsiErrorElement)element, arg_0)) == null) {
            this.myHolder.add(DefaultHighlightVisitor.createErrorElementInfo(e));
        }
    }

    @Override
    @NotNull
    public HighlightVisitor clone() {
        return new DefaultHighlightVisitor(this.myProject, this.myHighlightErrorElements, this.myBatchMode);
    }

    private static HighlightInfo createErrorElementInfo(@NotNull PsiErrorElement element) {
        if (element == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(7);
        }
        HighlightInfo.Builder builder = DefaultHighlightVisitor.createErrorElementInfoWithoutFixes(element);
        List<ErrorQuickFixProvider> providers = DumbService.getInstance(element.getProject()).filterByDumbAwareness(ErrorQuickFixProvider.EP_NAME.getExtensionList());
        for (ErrorQuickFixProvider provider : providers) {
            provider.registerErrorQuickFix(element, builder);
        }
        return builder.create();
    }

    @NotNull
    private static HighlightInfo.Builder createErrorElementInfoWithoutFixes(@NotNull PsiErrorElement element) {
        String text;
        if (element == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(8);
        }
        TextRange range = element.getTextRange();
        String errorDescription = element.getErrorDescription();
        if (!range.isEmpty()) {
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(errorDescription);
            if (builder == null) {
                DefaultHighlightVisitor.$$$reportNull$$$0(9);
            }
            return builder;
        }
        int offset = range.getStartOffset();
        PsiFile containingFile = element.getContainingFile();
        int fileLength = containingFile.getTextLength();
        FileViewProvider viewProvider = containingFile.getViewProvider();
        PsiElement elementAtOffset = viewProvider.findElementAt(offset, LanguageUtil.getRootLanguage(element));
        String string = text = elementAtOffset == null ? null : elementAtOffset.getText();
        if (offset < fileLength && text != null && !StringUtil.startsWithChar(text, '\n') && !StringUtil.startsWithChar(text, '\r')) {
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(offset, offset + 1).descriptionAndTooltip(errorDescription);
            if (builder == null) {
                DefaultHighlightVisitor.$$$reportNull$$$0(10);
            }
            return builder;
        }
        int start = offset;
        int end = offset == 0 ? Math.min(offset + 1, fileLength) : offset;
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element, start, end).descriptionAndTooltip(errorDescription).endOfLine();
        if (builder == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(11);
        }
        return builder;
    }

    private static /* synthetic */ boolean lambda$visit$0(PsiErrorElement e, HighlightErrorFilter filter2) {
        return !filter2.shouldHighlightErrorElement(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorElementInfoWithoutFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suitableForFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createErrorElementInfo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createErrorElementInfoWithoutFixes";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

