/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.AnnotatorStatisticsCollector;
import com.intellij.codeInsight.daemon.impl.AnnotationSessionImpl;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoB;
import com.intellij.codeInsight.daemon.impl.ResultSink;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.PluginException;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class AnnotatorRunner {
    private static final Logger LOG = Logger.getInstance(AnnotatorRunner.class);
    private final Project myProject;
    private final PsiFile myPsiFile;
    private final AnnotationSession myAnnotationSession;
    private final DumbService myDumbService;
    private final boolean myBatchMode;
    private final AnnotatorStatisticsCollector myAnnotatorStatisticsCollector;
    private final List<HighlightInfo> results;

    AnnotatorRunner(@NotNull AnnotationSession annotationSession, boolean batchMode) {
        if (annotationSession == null) {
            AnnotatorRunner.$$$reportNull$$$0(0);
        }
        this.myAnnotatorStatisticsCollector = new AnnotatorStatisticsCollector();
        this.results = Collections.synchronizedList(new ArrayList());
        this.myProject = annotationSession.getFile().getProject();
        this.myPsiFile = annotationSession.getFile();
        this.myAnnotationSession = annotationSession;
        this.myDumbService = DumbService.getInstance(this.myProject);
        this.myBatchMode = batchMode;
    }

    @ApiStatus.Internal
    boolean runAnnotatorsAsync(@NotNull List<? extends PsiElement> inside, @NotNull List<? extends PsiElement> outside, @NotNull Runnable runnable, @NotNull ResultSink resultSink) {
        if (inside == null) {
            AnnotatorRunner.$$$reportNull$$$0(1);
        }
        if (outside == null) {
            AnnotatorRunner.$$$reportNull$$$0(2);
        }
        if (runnable == null) {
            AnnotatorRunner.$$$reportNull$$$0(3);
        }
        if (resultSink == null) {
            AnnotatorRunner.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        DaemonProgressIndicator indicator = GlobalInspectionContextBase.assertUnderDaemonProgress();
        List<? extends PsiElement> insideThenOutside = ContainerUtil.concat(inside, outside);
        Map<Annotator, Set<Language>> supportedLanguages = AnnotatorRunner.calcSupportedLanguages(insideThenOutside);
        Processor<Annotator> processor = annotator -> ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> this.runAnnotator((Annotator)annotator, insideThenOutside, supportedLanguages, resultSink));
        boolean result = JobLauncher.getInstance().processConcurrentlyAsync(indicator, new ArrayList<Annotator>(supportedLanguages.keySet()), processor, runnable);
        this.myAnnotatorStatisticsCollector.reportAnalysisFinished(this.myProject, this.myAnnotationSession, this.myPsiFile);
        return result;
    }

    @NotNull
    private static Map<Annotator, Set<Language>> calcSupportedLanguages(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            AnnotatorRunner.$$$reportNull$$$0(5);
        }
        Map<Annotator, Set<Language>> map2 = CollectionFactory.createCustomHashingStrategyMap(new HashingStrategy<Annotator>(){

            @Override
            public int hashCode(Annotator object) {
                return object.getClass().hashCode();
            }

            @Override
            public boolean equals(Annotator o1, Annotator o2) {
                return o1 == null || o2 == null ? o1 == o2 : o1.getClass().equals(o2.getClass());
            }
        });
        HashSet languages = new HashSet();
        for (PsiElement psiElement : elements) {
            Language language = psiElement.getLanguage();
            AnnotatorRunner.addDialects(language, languages);
        }
        for (Language language : languages) {
            List templates = LanguageAnnotators.INSTANCE.allForLanguageOrAny(language);
            for (Annotator template : templates) {
                Set<Language> supportedLanguages = map2.get(template);
                if (supportedLanguages == null) {
                    supportedLanguages = new HashSet<Language>();
                    map2.put(AnnotatorRunner.cloneTemplate(template), supportedLanguages);
                }
                supportedLanguages.add(language);
            }
        }
        Map<Annotator, Set<Language>> map3 = map2;
        if (map3 == null) {
            AnnotatorRunner.$$$reportNull$$$0(6);
        }
        return map3;
    }

    private static void addDialects(@NotNull Language language, @NotNull Set<? super Language> outProcessedLanguages) {
        if (language == null) {
            AnnotatorRunner.$$$reportNull$$$0(7);
        }
        if (outProcessedLanguages == null) {
            AnnotatorRunner.$$$reportNull$$$0(8);
        }
        if (outProcessedLanguages.add(language)) {
            Collection<Language> dialects = language.getTransitiveDialects();
            outProcessedLanguages.addAll(dialects);
        }
    }

    private void runAnnotator(@NotNull Annotator annotator, @NotNull List<? extends PsiElement> insideThenOutside, @NotNull Map<Annotator, Set<Language>> supportedLanguages, @NotNull ResultSink result) {
        Set<Language> supported;
        if (annotator == null) {
            AnnotatorRunner.$$$reportNull$$$0(9);
        }
        if (insideThenOutside == null) {
            AnnotatorRunner.$$$reportNull$$$0(10);
        }
        if (supportedLanguages == null) {
            AnnotatorRunner.$$$reportNull$$$0(11);
        }
        if (result == null) {
            AnnotatorRunner.$$$reportNull$$$0(12);
        }
        if ((supported = supportedLanguages.get(annotator)).isEmpty()) {
            return;
        }
        AnnotationSessionImpl.computeWithSession(this.myBatchMode, annotator, this.myAnnotationSession, annotationHolder -> {
            for (PsiElement psiElement : insideThenOutside) {
                List newInfos;
                if (!supported.contains(psiElement.getLanguage()) || !this.myDumbService.isUsableInCurrentContext(annotator)) continue;
                ProgressManager.checkCanceled();
                int sizeBefore = annotationHolder.size();
                annotationHolder.runAnnotatorWithContext(psiElement);
                int sizeAfter = annotationHolder.size();
                if (sizeBefore == sizeAfter) {
                    newInfos = List.of();
                } else {
                    newInfos = new ArrayList(sizeAfter - sizeBefore);
                    Document document = this.myPsiFile.getViewProvider().getDocument();
                    boolean isFromInjection = this.myPsiFile.getViewProvider() instanceof InjectedFileViewProvider;
                    for (int i = sizeBefore; i < sizeAfter; ++i) {
                        Annotation annotation = (Annotation)annotationHolder.get(i);
                        HighlightInfo info = HighlightInfo.fromAnnotation(annotator.getClass(), annotation, this.myBatchMode, document);
                        if (isFromInjection) {
                            info.markFromInjection();
                        }
                        int sizeNewBefore = newInfos.size();
                        this.addConvertedToHostInfo(info, newInfos);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("runAnnotator " + String.valueOf(annotator) + "; annotation=" + String.valueOf(annotation) + " -> " + String.valueOf(newInfos.subList(sizeNewBefore, newInfos.size())));
                        }
                        this.myAnnotatorStatisticsCollector.reportAnnotationProduced(annotator, annotation);
                    }
                    this.results.addAll(newInfos);
                }
                result.accept(annotator.getClass(), psiElement, newInfos);
            }
            return null;
        });
    }

    private static void addPatchedInfos(@NotNull HighlightInfo injectedInfo, @NotNull PsiFile injectedPsi, @NotNull DocumentWindow documentWindow, @NotNull Collection<? super HighlightInfo> outHostInfos) {
        if (injectedInfo == null) {
            AnnotatorRunner.$$$reportNull$$$0(13);
        }
        if (injectedPsi == null) {
            AnnotatorRunner.$$$reportNull$$$0(14);
        }
        if (documentWindow == null) {
            AnnotatorRunner.$$$reportNull$$$0(15);
        }
        if (outHostInfos == null) {
            AnnotatorRunner.$$$reportNull$$$0(16);
        }
        TextRange infoRange = TextRange.create(injectedInfo);
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(injectedPsi.getProject());
        List<TextRange> editables = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, infoRange);
        for (TextRange editable : editables) {
            int lineNumber;
            int hostLineEndOffset;
            int hostEndOffset;
            TextRange hostRange = documentWindow.injectedToHost(editable);
            boolean isAfterEndOfLine = injectedInfo.isAfterEndOfLine();
            Document hostDocument = documentWindow.getDelegate();
            if (isAfterEndOfLine && (hostEndOffset = hostRange.getEndOffset()) < (hostLineEndOffset = hostDocument.getLineEndOffset(lineNumber = hostDocument.getLineNumber(hostEndOffset)))) {
                isAfterEndOfLine = false;
                hostRange = new ProperTextRange(hostRange.getStartOffset(), hostEndOffset + 1);
            }
            HighlightInfo.Builder builder = injectedInfo.copy(false).range(hostRange);
            if (isAfterEndOfLine) {
                builder.endOfLine();
            }
            HighlightInfo patched = builder.createUnconditionally();
            ArrayList quickFixes = new ArrayList();
            injectedInfo.findRegisteredQuickFix((descriptor, quickfixTextRange) -> {
                List<TextRange> editableQF = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, (TextRange)quickfixTextRange);
                for (TextRange editableRange : editableQF) {
                    TextRange hostEditableRange = documentWindow.injectedToHost(editableRange);
                    quickFixes.add(descriptor.withFixRange(hostEditableRange));
                }
                return null;
            });
            patched.registerFixes(quickFixes, hostDocument);
            patched.markFromInjection();
            outHostInfos.add(patched);
        }
    }

    private void addConvertedToHostInfo(@NotNull HighlightInfo info, @NotNull List<? super HighlightInfo> newInfos) {
        if (info == null) {
            AnnotatorRunner.$$$reportNull$$$0(17);
        }
        if (newInfos == null) {
            AnnotatorRunner.$$$reportNull$$$0(18);
        }
        if (HighlightInfoB.isAcceptedByFilters(info, this.myPsiFile)) {
            Document document;
            if (info.isFromInjection() && (document = this.myPsiFile.getFileDocument()) instanceof DocumentWindow) {
                DocumentWindow window = (DocumentWindow)document;
                AnnotatorRunner.addPatchedInfos(info, this.myPsiFile, window, newInfos);
            } else {
                newInfos.add(info);
            }
        }
    }

    private static Annotator cloneTemplate(@NotNull Annotator template) {
        Annotator annotator;
        if (template == null) {
            AnnotatorRunner.$$$reportNull$$$0(19);
        }
        try {
            annotator = (Annotator)ReflectionUtil.newInstance(template.getClass());
        }
        catch (Exception e) {
            LOG.error(PluginException.createByClass(e, template.getClass()));
            return null;
        }
        return annotator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationSession";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSink";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/AnnotatorRunner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outProcessedLanguages";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insideThenOutside";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedLanguages";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedInfo";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsi";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outHostInfos";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfos";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/AnnotatorRunner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcSupportedLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runAnnotatorsAsync";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcSupportedLanguages";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDialects";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runAnnotator";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addPatchedInfos";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addConvertedToHostInfo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "cloneTemplate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

