/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public final class TailTypes {
    private static final TailType UNKNOWN = new TailType(){

        @Override
        public int processTail(Editor editor, int tailOffset) {
            return tailOffset;
        }

        public String toString() {
            return "UNKNOWN";
        }
    };
    private static final TailType NONE = new TailType(){

        @Override
        public int processTail(Editor editor, int tailOffset) {
            return tailOffset;
        }

        public String toString() {
            return "NONE";
        }
    };
    private static final TailType SEMICOLON = new CharTailType(';');
    private static final TailType SPACE = new CharTailType(' ');
    private static final TailType INSERT_SPACE = new CharTailType(' ', false);
    private static final TailType HUMBLE_SPACE_BEFORE_WORD = new CharTailType(' ', false){

        @Override
        public boolean isApplicable(@NotNull InsertionContext context) {
            char ch;
            if (context == null) {
                3.$$$reportNull$$$0(0);
            }
            CharSequence text = context.getDocument().getCharsSequence();
            int tail = context.getTailOffset();
            if (text.length() > tail + 1 && text.charAt(tail) == ' ' && ((ch = text.charAt(tail + 1)) == '@' || Character.isLetter(ch))) {
                return false;
            }
            return super.isApplicable(context);
        }

        @Override
        public String toString() {
            return "HUMBLE_SPACE_BEFORE_WORD";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/TailTypes$3", "isApplicable"));
        }
    };
    private static final TailType DOT = new CharTailType('.');
    private static final TailType CASE_COLON = new CharTailType(':');
    private static final TailType EQUALS = new CharTailType('=');
    private static final TailType COND_EXPR_COLON = new TailType(){

        @Override
        public int processTail(Editor editor, int tailOffset) {
            Document document = editor.getDocument();
            int textLength = document.getTextLength();
            CharSequence chars = document.getCharsSequence();
            int afterWhitespace = CharArrayUtil.shiftForward(chars, tailOffset, " \n\t");
            if (afterWhitespace < textLength && chars.charAt(afterWhitespace) == ':') {
                return 4.moveCaret(editor, tailOffset, afterWhitespace - tailOffset + 1);
            }
            document.insertString(tailOffset, " : ");
            return 4.moveCaret(editor, tailOffset, 3);
        }

        public String toString() {
            return "COND_EXPR_COLON";
        }
    };

    private TailTypes() {
    }

    public static TailType unknownType() {
        return UNKNOWN;
    }

    public static TailType noneType() {
        return NONE;
    }

    public static TailType semicolonType() {
        return SEMICOLON;
    }

    public static TailType spaceType() {
        return SPACE;
    }

    public static TailType insertSpaceType() {
        return INSERT_SPACE;
    }

    public static TailType humbleSpaceBeforeWordType() {
        return HUMBLE_SPACE_BEFORE_WORD;
    }

    public static TailType dotType() {
        return DOT;
    }

    public static TailType caseColonType() {
        return CASE_COLON;
    }

    public static TailType equalsType() {
        return EQUALS;
    }

    public static TailType conditionalExpressionColonType() {
        return COND_EXPR_COLON;
    }

    public static TailType charType(char aChar) {
        return new CharTailType(aChar);
    }

    public static TailType charType(char aChar, boolean overwrite) {
        return new CharTailType(aChar, overwrite);
    }
}

