/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlNode;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AttributeModel {
    private static final Pattern PACKAGE_NAME_PATTERN = Pattern.compile("([A-Za-z][A-Za-z\\d_]*\\.)*[A-Za-z][A-Za-z\\d_]*");
    @NotNull
    private final XmlNode.NodeName mXmlNodeName;
    private final boolean mIsPackageDependent;
    @Nullable
    private final String mDefaultValue;
    @Nullable
    private final Validator mOnReadValidator;
    @Nullable
    private final Validator mOnWriteValidator;
    @NotNull
    private final MergingPolicy mMergingPolicy;
    @NotNull
    static final MergingPolicy STRICT_MERGING_POLICY = new MergingPolicy(){

        @Override
        public boolean shouldMergeDefaultValues() {
            return false;
        }

        @Override
        @Nullable
        public String merge(@NotNull String higherPriority, @NotNull String lowerPriority) {
            return higherPriority.equals(lowerPriority) ? higherPriority : null;
        }
    };
    @NotNull
    static final MergingPolicy STRICT_MAIN_OR_OVERLAY_MERGING_POLICY = new MergingPolicy(){

        @Override
        public boolean shouldMergeDefaultValues() {
            return false;
        }

        @Override
        public boolean canMergeWithLowerPriority(@NotNull XmlDocument document) {
            return EnumSet.of(XmlDocument.Type.MAIN, XmlDocument.Type.OVERLAY).contains((Object)document.getFileType());
        }

        @Override
        @Nullable
        public String merge(@NotNull String higherPriority, @NotNull String lowerPriority) {
            return STRICT_MERGING_POLICY.merge(higherPriority, lowerPriority);
        }
    };
    static final MergingPolicy OR_MERGING_POLICY = new MergingPolicy(){

        @Override
        public boolean shouldMergeDefaultValues() {
            return true;
        }

        @Override
        @Nullable
        public String merge(@NotNull String higherPriority, @NotNull String lowerPriority) {
            return Boolean.toString(BooleanValidator.isTrue(higherPriority) || BooleanValidator.isTrue(lowerPriority));
        }
    };
    static final MergingPolicy NO_MERGING_POLICY = new MergingPolicy(){

        @Override
        public boolean shouldMergeDefaultValues() {
            return true;
        }

        @Override
        @Nullable
        public String merge(@NotNull String higherPriority, @NotNull String lowerPriority) {
            return higherPriority;
        }
    };
    static final MergingPolicy AND_MERGING_POLICY = new MergingPolicy(){

        @Override
        public boolean shouldMergeDefaultValues() {
            return true;
        }

        @Override
        @Nullable
        public String merge(@NotNull String higherPriority, @NotNull String lowerPriority) {
            return Boolean.toString(BooleanValidator.isTrue(higherPriority) && BooleanValidator.isTrue(lowerPriority));
        }
    };
    static final MergingPolicy STRING_VALUE_MERGING_POLICY = new MergingPolicy(){

        @Override
        public boolean shouldMergeDefaultValues() {
            return true;
        }

        @Override
        @Nullable
        public String merge(@NotNull String higherPriority, @NotNull String lowerPriority) {
            return String.format("%s|%s", higherPriority, lowerPriority);
        }
    };
    static final MergingPolicy PURPOSE_MIN_SDK_VERSION_MERGING_POLICY = new MergingPolicy(){

        @Override
        public boolean shouldMergeDefaultValues() {
            return true;
        }

        @Override
        public boolean removeIfNotPresentOnBothManifests() {
            return true;
        }

        @Override
        @Nullable
        public String merge(@NotNull String higherPriority, @NotNull String lowerPriority) {
            if (Integer.parseInt(higherPriority) > Integer.parseInt(lowerPriority)) {
                return lowerPriority;
            }
            return higherPriority;
        }
    };
    static final MergingPolicy PURPOSE_MAX_SDK_VERSION_MERGING_POLICY = new MergingPolicy(){

        @Override
        public boolean shouldMergeDefaultValues() {
            return true;
        }

        @Override
        public boolean removeIfNotPresentOnBothManifests() {
            return true;
        }

        @Override
        @Nullable
        public String merge(@NotNull String higherPriority, @NotNull String lowerPriority) {
            if (Integer.parseInt(higherPriority) > Integer.parseInt(lowerPriority)) {
                return higherPriority;
            }
            return lowerPriority;
        }
    };

    private AttributeModel(@NotNull XmlNode.NodeName xmlNodeName, boolean isPackageDependent, @Nullable String defaultValue, @Nullable Validator onReadValidator, @Nullable Validator onWriteValidator, @NotNull MergingPolicy mergingPolicy) {
        this.mXmlNodeName = xmlNodeName;
        this.mIsPackageDependent = isPackageDependent;
        this.mDefaultValue = defaultValue;
        this.mOnReadValidator = onReadValidator;
        this.mOnWriteValidator = onWriteValidator;
        this.mMergingPolicy = mergingPolicy;
    }

    @NotNull
    XmlNode.NodeName getName() {
        return this.mXmlNodeName;
    }

    boolean isPackageDependent() {
        return this.mIsPackageDependent;
    }

    @Nullable
    String getDefaultValue() {
        return this.mDefaultValue;
    }

    @Nullable
    public Validator getOnReadValidator() {
        return this.mOnReadValidator;
    }

    @Nullable
    public Validator getOnWriteValidator() {
        return this.mOnWriteValidator;
    }

    @NotNull
    public MergingPolicy getMergingPolicy() {
        return this.mMergingPolicy;
    }

    @NotNull
    static Builder newModel(String attributeName) {
        return new Builder(XmlNode.fromNSName("http://schemas.android.com/apk/res/android", "android", attributeName));
    }

    private static int decodeDecOrHexString(@NotNull String s) {
        long decodedValue;
        long l = decodedValue = s.startsWith("0x") || s.startsWith("0X") ? Long.decode(s) : Long.parseLong(s);
        if (decodedValue < 0xFFFFFFFFL) {
            return (int)decodedValue;
        }
        throw new IllegalArgumentException("Value " + s + " too big for 32 bits.");
    }

    static interface Validator {
        public boolean validates(@NotNull MergingReport.Builder var1, @NotNull XmlAttribute var2, @NotNull String var3);
    }

    static interface MergingPolicy {
        public boolean shouldMergeDefaultValues();

        default public boolean canMergeWithLowerPriority(@NotNull XmlDocument document) {
            return true;
        }

        default public boolean removeIfNotPresentOnBothManifests() {
            return false;
        }

        @Nullable
        public String merge(@NotNull String var1, @NotNull String var2);
    }

    static class Builder {
        private final XmlNode.NodeName mXmlNodeName;
        private boolean mIsPackageDependent = false;
        private String mDefaultValue;
        private Validator mOnReadValidator;
        private Validator mOnWriteValidator;
        @NotNull
        private MergingPolicy mMergingPolicy = STRICT_MERGING_POLICY;

        Builder(XmlNode.NodeName xmlNodeName) {
            this.mXmlNodeName = xmlNodeName;
        }

        @NotNull
        Builder setIsPackageDependent() {
            this.mIsPackageDependent = true;
            return this;
        }

        @NotNull
        Builder setDefaultValue(String value) {
            this.mDefaultValue = value;
            return this;
        }

        @NotNull
        Builder setOnReadValidator(Validator validator) {
            this.mOnReadValidator = validator;
            return this;
        }

        @NotNull
        Builder setOnWriteValidator(Validator validator) {
            this.mOnWriteValidator = validator;
            return this;
        }

        @NotNull
        Builder setMergingPolicy(@NotNull MergingPolicy mergingPolicy) {
            this.mMergingPolicy = mergingPolicy;
            return this;
        }

        @NotNull
        AttributeModel build() {
            return new AttributeModel(this.mXmlNodeName, this.mIsPackageDependent, this.mDefaultValue, this.mOnReadValidator, this.mOnWriteValidator, this.mMergingPolicy);
        }
    }

    static class Hexadecimal32BitsWithMinimumValue
    extends Hexadecimal32Bits {
        private final int mMinimumValue;

        Hexadecimal32BitsWithMinimumValue(int minimumValue) {
            this.mMinimumValue = minimumValue;
        }

        @Override
        public boolean validates(@NotNull MergingReport.Builder mergingReport, @NotNull XmlAttribute attribute, @NotNull String value) {
            boolean valid = super.validates(mergingReport, attribute, value);
            if (valid) {
                try {
                    Long decodedValue = Long.decode(value);
                    valid = decodedValue >= (long)this.mMinimumValue && decodedValue < 0xFFFFFFFFL;
                }
                catch (NumberFormatException e) {
                    valid = false;
                }
                if (!valid) {
                    mergingReport.addMessage(attribute, MergingReport.Record.Severity.ERROR, String.format("Attribute %1$s at %2$s is not a valid hexadecimal value, minimum is 0x%3$08X, maximum is 0x%4$08X, found %5$s", attribute.getId(), attribute.printPosition(), this.mMinimumValue, Integer.MAX_VALUE, value));
                }
                return valid;
            }
            return false;
        }
    }

    static class Hexadecimal32Bits
    implements Validator {
        protected static final Pattern PATTERN = Pattern.compile("0[xX]([0-9a-fA-F]+)");

        Hexadecimal32Bits() {
        }

        @Override
        public boolean validates(@NotNull MergingReport.Builder mergingReport, @NotNull XmlAttribute attribute, @NotNull String value) {
            boolean valid;
            Matcher matcher = PATTERN.matcher(value);
            boolean bl = valid = matcher.matches() && matcher.group(1).length() <= 8;
            if (!valid) {
                mergingReport.addMessage(attribute, MergingReport.Record.Severity.ERROR, String.format("Attribute %1$s at %2$s is not a valid hexadecimal 32 bit value, found %3$s", attribute.getId(), attribute.printPosition(), value));
            }
            return valid;
        }
    }

    static class IntegerValueValidator
    implements Validator {
        private static final Pattern INTEGER_RESOURCE_REF_PATTERN = Pattern.compile("[@?](" + String.valueOf(PACKAGE_NAME_PATTERN) + ":)?integer/\\w+");

        IntegerValueValidator() {
        }

        @Override
        public boolean validates(@NotNull MergingReport.Builder mergingReport, @NotNull XmlAttribute attribute, @NotNull String value) {
            try {
                return Integer.parseInt(value) > 0;
            }
            catch (NumberFormatException e) {
                if (INTEGER_RESOURCE_REF_PATTERN.matcher(value).matches()) {
                    return true;
                }
                mergingReport.addMessage(attribute, MergingReport.Record.Severity.ERROR, String.format("Attribute %1$s at %2$s must be an integer, found %3$s", attribute.getId(), attribute.printPosition(), value));
                return false;
            }
        }
    }

    static class SeparatedValuesValidator
    implements Validator {
        @NotNull
        private final ImmutableList<String> multiValuesList;
        @NotNull
        private final String delimiter;

        SeparatedValuesValidator(@NotNull String delimiter, String ... multiValues) {
            this.multiValuesList = ImmutableList.copyOf((Object[])multiValues);
            this.delimiter = delimiter;
        }

        @Override
        public boolean validates(@NotNull MergingReport.Builder mergingReport, @NotNull XmlAttribute attribute, @NotNull String value) {
            boolean result = true;
            List<String> delimitedValues = Arrays.asList(value.split(Pattern.quote(this.delimiter)));
            if (delimitedValues.isEmpty()) {
                result = false;
            }
            for (String delimitedValue : delimitedValues) {
                if (this.multiValuesList.contains((Object)delimitedValue)) continue;
                result = false;
                break;
            }
            if (!result) {
                mergingReport.addMessage(attribute, MergingReport.Record.Severity.ERROR, String.format("Invalid value for attribute %1$s at %2$s, value=(%3$s), acceptable delimiter-separated values are (%4$s)", attribute.getId(), attribute.printPosition(), value, Joiner.on((String)this.delimiter).join(this.multiValuesList)));
            }
            return result;
        }
    }

    static class BooleanValidator
    implements Validator {
        private static final Pattern BOOL_RESOURCE_REF_PATTERN = Pattern.compile("[@?](" + String.valueOf(PACKAGE_NAME_PATTERN) + ":)?bool/\\w+");
        private static final Pattern TRUE_PATTERN = Pattern.compile("true|True|TRUE|" + String.valueOf(BOOL_RESOURCE_REF_PATTERN));
        private static final Pattern FALSE_PATTERN = Pattern.compile("false|False|FALSE|" + String.valueOf(BOOL_RESOURCE_REF_PATTERN));

        BooleanValidator() {
        }

        private static boolean isTrue(@NotNull String value) {
            return TRUE_PATTERN.matcher(value).matches();
        }

        @Override
        public boolean validates(@NotNull MergingReport.Builder mergingReport, @NotNull XmlAttribute attribute, @NotNull String value) {
            boolean matches;
            boolean bl = matches = TRUE_PATTERN.matcher(value).matches() || FALSE_PATTERN.matcher(value).matches();
            if (!matches) {
                mergingReport.addMessage(attribute, MergingReport.Record.Severity.ERROR, String.format("Attribute %1$s at %2$s has an illegal value=(%3$s), expected 'true' or 'false'", attribute.getId(), attribute.printPosition(), value));
            }
            return matches;
        }
    }
}

