/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.PathCollection;
import com.android.tools.lint.VirtualFileWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtBinaryModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtSourceModuleBuilder;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a \u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0000\u001a6\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0014\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\b0\f2\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00010\u000fH\u0000\u001a4\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0014\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\b0\fH\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u0011*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u0011*\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0004H\u0000\"\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"asFile", "Ljava/io/File;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSourceFilePaths", "Lcom/android/tools/lint/PathCollection;", "javaSourceRoots", "", "includeDirectoryRoot", "", "getFilePaths", "roots", "isExtensionWanted", "Lkotlin/Function1;", "", "toPathCollection", "", "collectFilePaths", "", "root", "Ljava/nio/file/Path;", "result", "", "addSourcePaths", "Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtSourceModuleBuilder;", "paths", "addBinaryPaths", "Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtBinaryModuleBuilder;", "sourceFileExtensions", "", "[Ljava/lang/String;", "lint-cli"})
@SourceDebugExtension(value={"SMAP\nUastEnvironmentVirtualFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UastEnvironmentVirtualFileUtils.kt\ncom/android/tools/lint/UastEnvironmentVirtualFileUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,257:1\n13472#2,2:258\n*S KotlinDebug\n*F\n+ 1 UastEnvironmentVirtualFileUtils.kt\ncom/android/tools/lint/UastEnvironmentVirtualFileUtilsKt\n*L\n80#1:258,2\n*E\n"})
public final class UastEnvironmentVirtualFileUtilsKt {
    @NotNull
    private static final String[] sourceFileExtensions;

    @NotNull
    public static final File asFile(@NotNull VirtualFile $this$asFile) {
        Intrinsics.checkNotNullParameter((Object)$this$asFile, (String)"<this>");
        return new VirtualFileWrapper($this$asFile);
    }

    @NotNull
    public static final PathCollection getSourceFilePaths(@NotNull Collection<? extends File> javaSourceRoots, boolean includeDirectoryRoot) {
        Intrinsics.checkNotNullParameter(javaSourceRoots, (String)"javaSourceRoots");
        return UastEnvironmentVirtualFileUtilsKt.getFilePaths(javaSourceRoots, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>((Object)sourceFileExtensions){

            public final Boolean invoke(String p0) {
                return ArraysKt.contains((Object[])((Object[])this.receiver), (Object)p0);
            }
        }), includeDirectoryRoot);
    }

    public static /* synthetic */ PathCollection getSourceFilePaths$default(Collection collection, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UastEnvironmentVirtualFileUtilsKt.getSourceFilePaths(collection, bl);
    }

    private static final PathCollection getFilePaths(Collection<? extends File> roots, Function1<? super String, Boolean> isExtensionWanted, boolean includeDirectoryRoot) {
        HashSet<Path> physicalPaths = new HashSet<Path>();
        HashSet<Path> physicalDirectoryPaths = new HashSet<Path>();
        HashSet<VirtualFile> virtualFiles = new HashSet<VirtualFile>();
        HashSet<VirtualFile> virtualDirectories = new HashSet<VirtualFile>();
        for (File file : roots) {
            if (file instanceof VirtualFileWrapper) {
                UastEnvironmentVirtualFileUtilsKt.getFilePaths$fromVirtualFile(includeDirectoryRoot, virtualDirectories, isExtensionWanted, virtualFiles, ((VirtualFileWrapper)file).getFile());
                continue;
            }
            UastEnvironmentVirtualFileUtilsKt.getFilePaths$fromFile(physicalPaths, isExtensionWanted, includeDirectoryRoot, physicalDirectoryPaths, file);
        }
        return new PathCollection((Collection<? extends Path>)physicalPaths, (Collection<? extends Path>)physicalDirectoryPaths, (Collection<? extends VirtualFile>)virtualFiles, (Collection<? extends VirtualFile>)virtualDirectories);
    }

    static /* synthetic */ PathCollection getFilePaths$default(Collection collection, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return UastEnvironmentVirtualFileUtilsKt.getFilePaths(collection, (Function1<? super String, Boolean>)function1, bl);
    }

    @NotNull
    public static final PathCollection toPathCollection(@NotNull Iterable<? extends File> $this$toPathCollection) {
        Intrinsics.checkNotNullParameter($this$toPathCollection, (String)"<this>");
        HashSet<Path> physicalFilePaths = new HashSet<Path>();
        HashSet<Path> physicalDirectoryPaths = new HashSet<Path>();
        HashSet<VirtualFile> virtualFiles = new HashSet<VirtualFile>();
        HashSet<VirtualFile> virtualDirectories = new HashSet<VirtualFile>();
        for (File file : $this$toPathCollection) {
            boolean bl;
            if (file instanceof VirtualFileWrapper) {
                if (((VirtualFileWrapper)file).getFile().isDirectory()) {
                    bl = virtualDirectories.add(((VirtualFileWrapper)file).getFile());
                    continue;
                }
                bl = virtualFiles.add(((VirtualFileWrapper)file).getFile());
                continue;
            }
            bl = file.isDirectory() ? physicalDirectoryPaths.add(Paths.get(file.getPath(), new String[0])) : physicalFilePaths.add(Paths.get(file.getPath(), new String[0]));
        }
        return new PathCollection((Collection<? extends Path>)physicalFilePaths, (Collection<? extends Path>)physicalDirectoryPaths, (Collection<? extends VirtualFile>)virtualFiles, (Collection<? extends VirtualFile>)virtualDirectories);
    }

    private static final void collectFilePaths(Path root, Set<Path> result, Function1<? super String, Boolean> isExtensionWanted) {
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(isExtensionWanted, result){
            final /* synthetic */ Function1<String, Boolean> $isExtensionWanted;
            final /* synthetic */ Set<Path> $result;
            {
                this.$isExtensionWanted = $isExtensionWanted;
                this.$result = $result;
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                return Files.isReadable(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!Files.isRegularFile(file, new LinkOption[0]) || !Files.isReadable(file)) {
                    return FileVisitResult.CONTINUE;
                }
                if (((Boolean)this.$isExtensionWanted.invoke((Object)com.google.common.io.Files.getFileExtension((String)((Object)file.getFileName()).toString()))).booleanValue()) {
                    this.$result.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static final void addSourcePaths(@NotNull KtSourceModuleBuilder $this$addSourcePaths, @NotNull PathCollection paths) {
        Intrinsics.checkNotNullParameter((Object)$this$addSourcePaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        $this$addSourcePaths.addSourceRoots(paths.getPhysicalDirectories());
        $this$addSourcePaths.addSourceRoots(paths.getPhysicalFiles());
        $this$addSourcePaths.addSourceVirtualFiles(paths.getVirtualDirectories());
        $this$addSourcePaths.addSourceVirtualFiles(paths.getVirtualFiles());
    }

    public static final void addBinaryPaths(@NotNull KtBinaryModuleBuilder $this$addBinaryPaths, @NotNull PathCollection paths) {
        Intrinsics.checkNotNullParameter((Object)$this$addBinaryPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        $this$addBinaryPaths.addBinaryRoots(paths.getPhysicalDirectories());
        $this$addBinaryPaths.addBinaryRoots(paths.getPhysicalFiles());
        $this$addBinaryPaths.addBinaryVirtualFiles(paths.getVirtualDirectories());
        $this$addBinaryPaths.addBinaryVirtualFiles(paths.getVirtualFiles());
    }

    private static final void getFilePaths$fromFile(HashSet<Path> physicalPaths, Function1<? super String, Boolean> $isExtensionWanted, boolean $includeDirectoryRoot, HashSet<Path> physicalDirectoryPaths, File root) {
        Path path = Paths.get(root.getPath(), new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            Intrinsics.checkNotNull((Object)path);
            UastEnvironmentVirtualFileUtilsKt.collectFilePaths(path, (Set<Path>)physicalPaths, $isExtensionWanted);
            if ($includeDirectoryRoot) {
                physicalDirectoryPaths.add(path);
            }
        } else {
            physicalPaths.add(path);
        }
    }

    private static final void getFilePaths$fromVirtualFile(boolean $includeDirectoryRoot, HashSet<VirtualFile> virtualDirectories, Function1<? super String, Boolean> $isExtensionWanted, HashSet<VirtualFile> virtualFiles, VirtualFile root) {
        UastEnvironmentVirtualFileUtilsKt.getFilePaths$fromVirtualFile$visit($isExtensionWanted, virtualFiles, root);
        if (root.isDirectory() && $includeDirectoryRoot) {
            virtualDirectories.add(root);
        }
    }

    private static final void getFilePaths$fromVirtualFile$visit(Function1<? super String, Boolean> $isExtensionWanted, HashSet<VirtualFile> virtualFiles, VirtualFile file) {
        if (file.isDirectory()) {
            VirtualFile[] virtualFileArray = file.getChildren();
            if (virtualFileArray != null) {
                VirtualFile[] $this$forEach$iv = virtualFileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile element$iv;
                    VirtualFile p0 = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    UastEnvironmentVirtualFileUtilsKt.getFilePaths$fromVirtualFile$visit($isExtensionWanted, virtualFiles, p0);
                }
            }
        } else if (((Boolean)$isExtensionWanted.invoke((Object)file.getExtension())).booleanValue()) {
            virtualFiles.add(file);
        }
    }

    static {
        String[] stringArray = new String[]{"kt", KotlinParserDefinition.STD_SCRIPT_SUFFIX, "java"};
        sourceFileExtensions = stringArray;
    }
}

