/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.WearDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/WearPasswordInputDetector;", "Lcom/android/tools/lint/checks/WearDetector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableAttributes", "", "", "getApplicableReferenceNames", "visitReference", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "Issues", "lint-checks"})
public final class WearPasswordInputDetector
extends WearDetector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String MESSAGE = "Don't ask Wear OS users for a password";
    @NotNull
    private static final Set<String> VALUE_PASSWORD_INPUT_TYPES;
    @NotNull
    private static final List<String> TYPE_PASSWORD_INPUT_TYPES;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return ResourceFolderType.LAYOUT == folderType;
    }

    @NotNull
    public List<String> getApplicableAttributes() {
        return CollectionsKt.listOf((Object)"inputType");
    }

    @NotNull
    public List<String> getApplicableReferenceNames() {
        return TYPE_PASSWORD_INPUT_TYPES;
    }

    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
        if (this.isWearProject() && context.getEvaluator().isMemberInClass((PsiMember)(referenced instanceof PsiField ? (PsiField)referenced : null), "android.text.InputType")) {
            context.report(new Incident(ISSUE, context.getLocation((UElement)reference), MESSAGE));
        }
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (this.isWearProject() && Intrinsics.areEqual((Object)attribute.getOwnerElement().getTagName(), (Object)"EditText")) {
            String string2 = attribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            if (StringsKt.findAnyOf$default((CharSequence)string2, (Collection)VALUE_PASSWORD_INPUT_TYPES, (int)0, (boolean)false, (int)6, null) != null) {
                context.report(new Incident(ISSUE, context.getLocation((Node)attribute), MESSAGE));
            }
        }
    }

    static {
        Object[] objectArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(WearPasswordInputDetector.class, Scope.JAVA_AND_RESOURCE_FILES, (EnumSet[])objectArray);
        objectArray = Issue.Companion;
        Category category = Category.USABILITY;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"WearPasswordInput", (String)"Wear: Using password input", (String)"\n          Your app must not ask the user to input password directly on the Wear device.\n        ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)true, null, null, null, (int)3664, null).addMoreInfo("https://developer.android.com/training/wearables/apps/auth-wear#auth-methods");
        objectArray = new String[]{"numberPassword", "textPassword", "textVisiblePassword", "textWebPassword"};
        VALUE_PASSWORD_INPUT_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"TYPE_TEXT_VARIATION_PASSWORD", "TYPE_NUMBER_VARIATION_PASSWORD", "TYPE_TEXT_VARIATION_VISIBLE_PASSWORD", "TYPE_TEXT_VARIATION_WEB_PASSWORD"};
        TYPE_PASSWORD_INPUT_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/WearPasswordInputDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "MESSAGE", "", "VALUE_PASSWORD_INPUT_TYPES", "", "TYPE_PASSWORD_INPUT_TYPES", "", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

