/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ShortcutUsageDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/ShortcutUsageDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "numSetOrAddDynamicShortcutsCalls", "", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "checkPartialResults", "Lcom/android/tools/lint/detector/api/Context;", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "afterCheckRootProject", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nShortcutUsageDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShortcutUsageDetector.kt\ncom/android/tools/lint/checks/ShortcutUsageDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1761#2,3:155\n*S KotlinDebug\n*F\n+ 1 ShortcutUsageDetector.kt\ncom/android/tools/lint/checks/ShortcutUsageDetector\n*L\n89#1:155,3\n*E\n"})
public final class ShortcutUsageDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int numSetOrAddDynamicShortcutsCalls;
    @NotNull
    public static final String SHORTCUT_MANAGER_CLASS = "android.content.pm.ShortcutManager";
    @NotNull
    public static final String SHORTCUT_MANAGER_COMPAT_CLASS = "androidx.core.content.pm.ShortcutManagerCompat";
    @NotNull
    public static final String SET_DYNAMIC_SHORTCUTS = "setDynamicShortcuts";
    @NotNull
    public static final String ADD_DYNAMIC_SHORTCUTS = "addDynamicShortcuts";
    @NotNull
    public static final String PUSH_DYNAMIC_SHORTCUT = "pushDynamicShortcut";
    @NotNull
    public static final String REPORT_SHORTCUT_USED = "reportShortcutUsed";
    @NotNull
    public static final String HAS_PUSH_DYNAMIC_SHORTCUT = "hasPushDynamicShortcut";
    @NotNull
    public static final String HAS_REPORT_SHORTCUT_USED = "hasReportShortcutUsed";
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Nullable
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{ADD_DYNAMIC_SHORTCUTS, SET_DYNAMIC_SHORTCUTS, PUSH_DYNAMIC_SHORTCUT, REPORT_SHORTCUT_USED};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        block15: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            JavaEvaluator evaluator = context.getEvaluator();
            if (!evaluator.isMemberInClass((PsiMember)method, SHORTCUT_MANAGER_CLASS) && !evaluator.isMemberInClass((PsiMember)method, SHORTCUT_MANAGER_COMPAT_CLASS)) break block15;
            LintMap map2 = context.getPartialResults(ISSUE).map();
            switch (method.getName()) {
                case "addDynamicShortcuts": 
                case "setDynamicShortcuts": {
                    if (context.getDriver().isSuppressed(context, ISSUE, (UElement)node)) break;
                    int n = this.numSetOrAddDynamicShortcutsCalls;
                    this.numSetOrAddDynamicShortcutsCalls = n + 1;
                    map2.put(String.valueOf(n), context.getLocation((UElement)node));
                    break;
                }
                case "pushDynamicShortcut": {
                    map2.put(HAS_PUSH_DYNAMIC_SHORTCUT, true);
                    break;
                }
                case "reportShortcutUsed": {
                    map2.put(HAS_REPORT_SHORTCUT_USED, true);
                }
            }
        }
    }

    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
            if (context.getMainProject().isLibrary()) {
                return;
            }
            Function1 hasReportShortcutUsage2 = checkPartialResults.hasReportShortcutUsage.1.INSTANCE;
            Iterable $this$any$iv = partialResults.maps();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    if (!((Boolean)hasReportShortcutUsage2.invoke(element$iv)).booleanValue()) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        for (LintMap perModuleLintMap : partialResults.maps()) {
            for (String key : perModuleLintMap) {
                String url = "https://developer.android.com/develop/ui/views/launch/shortcuts/managing-shortcuts#track-usage";
                Incident incident = IncidentKt.Incident((Context)context).issue(ISSUE);
                Location location = perModuleLintMap.getLocation(key);
                Intrinsics.checkNotNull((Object)location);
                context.report(incident.location(location).message("Calling this method indicates use of dynamic shortcuts, but there are no calls to methods that track shortcut usage, such as `pushDynamicShortcut` or `reportShortcutUsed`. Calling these methods is recommended, as they track shortcut usage and allow launchers to adjust which shortcuts appear based on activation history. Please see " + url).fix(this.fix().url(url).build()));
            }
        }
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isGlobalAnalysis()) {
            this.checkPartialResults(context, context.getPartialResults(ISSUE));
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.USABILITY;
        Severity severity = Severity.INFORMATIONAL;
        Implementation implementation = new Implementation(ShortcutUsageDetector.class, EnumSet.of((Enum)Scope.ALL_JAVA_FILES));
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"ReportShortcutUsage", (String)"Report shortcut usage", (String)"\n                Reporting shortcut usage is important to improving the ranking of shortcuts\n                ", (Implementation)implementation, (String)"https://developer.android.com/develop/ui/views/launch/shortcuts/managing-shortcuts", (Category)category, (int)2, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/ShortcutUsageDetector$Companion;", "", "<init>", "()V", "SHORTCUT_MANAGER_CLASS", "", "SHORTCUT_MANAGER_COMPAT_CLASS", "SET_DYNAMIC_SHORTCUTS", "ADD_DYNAMIC_SHORTCUTS", "PUSH_DYNAMIC_SHORTCUT", "REPORT_SHORTCUT_USED", "HAS_PUSH_DYNAMIC_SHORTCUT", "HAS_REPORT_SHORTCUT_USED", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

