/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.r8.ConsumerRuleGlobalGuardian;
import com.android.tools.lint.checks.DependencyDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.model.LintModelAndroidLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R<\u0010\u000b\u001a*\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fj\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e`\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/ProguardConsumerRulesDetector;", "Lcom/android/tools/lint/checks/DependencyDetector;", "Lcom/android/tools/lint/checks/ProguardConsumerRulesDetector$GlobalOptionIssue;", "<init>", "()V", "isDependencyKnownSafe", "", "group", "", "artifact", "version", "dependencyIssueCache", "Ljava/util/HashMap;", "Lcom/android/tools/lint/model/LintModelMavenName;", "", "Lcom/android/tools/lint/checks/DependencyDetector$DependencyIssue;", "Lkotlin/collections/HashMap;", "getDependencyIssueCache", "()Ljava/util/HashMap;", "getIncidentsFromAndroidLibrary", "library", "Lcom/android/tools/lint/model/LintModelAndroidLibrary;", "GlobalOptionIssue", "Companion", "lint-checks"})
public final class ProguardConsumerRulesDetector
extends DependencyDetector<GlobalOptionIssue> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final HashMap<LintModelMavenName, List<DependencyDetector.DependencyIssue>> _dependencyIssueCache = new HashMap();
    @JvmField
    @NotNull
    public static final Issue GLOBAL_OPTION_ISSUE;

    @Override
    public boolean isDependencyKnownSafe(@NotNull String group, @NotNull String artifact, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (Intrinsics.areEqual((Object)group, (Object)"com.google.android.fhir") && (Intrinsics.areEqual((Object)artifact, (Object)"engine") || Intrinsics.areEqual((Object)artifact, (Object)"data-capture"))) {
            return false;
        }
        return StringsKt.startsWith$default((String)group, (String)"androidx.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)group, (String)"com.google.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)group, (String)"com.android.", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)group, (Object)"org.chromium.net") || StringsKt.startsWith$default((String)group, (String)"com.crashlytics.", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public HashMap<LintModelMavenName, List<DependencyDetector.DependencyIssue>> getDependencyIssueCache() {
        return _dependencyIssueCache;
    }

    @Override
    @NotNull
    public List<DependencyDetector.DependencyIssue> getIncidentsFromAndroidLibrary(@NotNull LintModelAndroidLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (!library.getProguardRules().exists()) {
            return CollectionsKt.emptyList();
        }
        List errors = new ArrayList();
        ConsumerRuleGlobalGuardian.INSTANCE.validateConsumerRulesHasNoBannedGlobals(library.getProguardRules(), false, new Consumer(errors, library){
            final /* synthetic */ List<DependencyDetector.DependencyIssue> $errors;
            final /* synthetic */ LintModelAndroidLibrary $library;
            {
                this.$errors = $errors;
                this.$library = $library;
            }

            public final void accept(ConsumerRuleGlobalGuardian.DiscoveredIssue issue) {
                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
                this.$errors.add(new GlobalOptionIssue(this.$library.getResolvedCoordinates(), this.$library.getProguardRules(), issue.getRequiresArgumentInConsumerRules(), issue.getGlobalOption()));
            }
        });
        return errors;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.GRADLE_SCOPE, Scope.TOML_SCOPE};
        Implementation implementation = new Implementation(ProguardConsumerRulesDetector.class, Scope.GRADLE_AND_TOML_SCOPE, enumSetArray);
        GLOBAL_OPTION_ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"GlobalOptionInConsumerRules", (String)"Library has global options in consumer rules", (String)"\n          Libraries often include consumer keep rules to instruct R8 how to \\\n          optimize the library, especially if the library uses reflection. \\\n          These keep rules typically indicate to R8 of which classes, methods \\\n          and fields shouldn't be fully optimized so e.g. reflection continues \\\n          to work.\n\n          Global keep rules can be used by an application to disable significant \\\n          optimization features, debug R8 behavior, suppress warnings, etc. \\\n          However, these global options should not be included in library consumer \\\n          rules -- those distributed with a library.\n\n          Starting in Android Gradle Plugin version 9.0, all such rules are not \\\n          supported in library builds, and ignored by application builds if \\\n          included in a library. Libraries should not rely on these global \\\n          options in consumer rules to function, and should remove them.\n\n          If you see a flagged library, first try to update to a newer version \\\n          that doesn't have the embedded global rule. If an updated version without \\\n          these global options is not available, contact the library vendor to ask \\\n          about their plans to remove global options, and thus support better R8 \\\n          configuration.\n\n          As an application developer using Android Gradle Plugin 9.0, verify that \\\n          Android Gradle Plugin removing these global options isn't causing issues \\\n          in your application. If they are, you can add them temporarily to a local \\\n          keep rule file.\n          ", (Implementation)implementation, (String)"https://developer.android.com/topic/performance/app-optimization/choose-libraries-wisely", (Category)category, (int)2, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R6\u0010\u0004\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/ProguardConsumerRulesDetector$Companion;", "", "<init>", "()V", "_dependencyIssueCache", "Ljava/util/HashMap;", "Lcom/android/tools/lint/model/LintModelMavenName;", "", "Lcom/android/tools/lint/checks/DependencyDetector$DependencyIssue;", "Lkotlin/collections/HashMap;", "GLOBAL_OPTION_ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/ProguardConsumerRulesDetector$GlobalOptionIssue;", "Lcom/android/tools/lint/checks/DependencyDetector$DependencyIssue;", "coordinates", "Lcom/android/tools/lint/model/LintModelMavenName;", "keepRules", "Ljava/io/File;", "requiresArgumentInConsumerRules", "", "globalOption", "", "<init>", "(Lcom/android/tools/lint/model/LintModelMavenName;Ljava/io/File;ZLjava/lang/String;)V", "getCoordinates", "()Lcom/android/tools/lint/model/LintModelMavenName;", "getKeepRules", "()Ljava/io/File;", "getRequiresArgumentInConsumerRules", "()Z", "getGlobalOption", "()Ljava/lang/String;", "toLintIncident", "Lcom/android/tools/lint/detector/api/Incident;", "lint-checks"})
    public static final class GlobalOptionIssue
    extends DependencyDetector.DependencyIssue {
        @NotNull
        private final LintModelMavenName coordinates;
        @NotNull
        private final File keepRules;
        private final boolean requiresArgumentInConsumerRules;
        @NotNull
        private final String globalOption;

        public GlobalOptionIssue(@NotNull LintModelMavenName coordinates, @NotNull File keepRules, boolean requiresArgumentInConsumerRules, @NotNull String globalOption) {
            Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
            Intrinsics.checkNotNullParameter((Object)keepRules, (String)"keepRules");
            Intrinsics.checkNotNullParameter((Object)globalOption, (String)"globalOption");
            this.coordinates = coordinates;
            this.keepRules = keepRules;
            this.requiresArgumentInConsumerRules = requiresArgumentInConsumerRules;
            this.globalOption = globalOption;
        }

        @NotNull
        public final LintModelMavenName getCoordinates() {
            return this.coordinates;
        }

        @NotNull
        public final File getKeepRules() {
            return this.keepRules;
        }

        public final boolean getRequiresArgumentInConsumerRules() {
            return this.requiresArgumentInConsumerRules;
        }

        @NotNull
        public final String getGlobalOption() {
            return this.globalOption;
        }

        @Override
        @NotNull
        public Incident toLintIncident() {
            Location location = Location.Companion.create(this.keepRules);
            File file = this.keepRules.getParentFile();
            String libraryName = (file != null ? file.getName() : null) + "/" + this.keepRules.getName();
            String errorSuffix = this.requiresArgumentInConsumerRules ? " without an argument" : "";
            String message2 = "The consumer keep rules at `" + libraryName + "` (from `" + this.coordinates + "`) contains a global option which should not be specified in library consumer rules" + errorSuffix + ": -" + this.globalOption;
            Incident incident = new Incident(GLOBAL_OPTION_ISSUE, location, message2);
            return incident;
        }
    }
}

