/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.support.AndroidxName;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.client.api.AndroidPlatformAnnotations;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiVariable;
import java.util.List;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

public class PermissionFinder {
    private final JavaContext mContext;
    private final Operation mOperation;

    public static Result findRequiredPermissions(JavaContext context, Operation operation, UElement parameter) {
        return new PermissionFinder(context, operation).search(parameter);
    }

    private PermissionFinder(JavaContext context, Operation operation) {
        this.mContext = context;
        this.mOperation = operation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result search(UElement node) {
        PsiVariable variable;
        UExpression lastAssignment;
        if (UastLiteralUtils.isNullLiteral((UElement)node)) {
            return null;
        }
        if (node instanceof UIfExpression) {
            Result result;
            UIfExpression expression = (UIfExpression)node;
            if (expression.getThenExpression() != null && (result = this.search((UElement)expression.getThenExpression())) != null) {
                return result;
            }
            if (expression.getElseExpression() == null) return null;
            return this.search((UElement)expression.getElseExpression());
        }
        if (UastExpressionUtils.isTypeCast((UElement)node)) {
            UBinaryExpressionWithType cast = (UBinaryExpressionWithType)node;
            UExpression operand = cast.getOperand();
            return this.search((UElement)operand);
        }
        if (node instanceof UParenthesizedExpression) {
            UParenthesizedExpression parens = (UParenthesizedExpression)node;
            UExpression expression = parens.getExpression();
            return this.search((UElement)expression);
        }
        if (UastExpressionUtils.isConstructorCall((UElement)node) && this.mOperation == Operation.ACTION) {
            UExpression action;
            List expressions;
            String type;
            UCallExpression call2 = (UCallExpression)node;
            UReferenceExpression classReference = call2.getClassReference();
            String string2 = type = classReference != null ? UastUtils.getQualifiedName((UReferenceExpression)classReference) : null;
            if (!"android.content.Intent".equals(type) || (expressions = call2.getValueArguments()).isEmpty() || (action = (UExpression)expressions.get(0)) == null) return null;
            return this.search((UElement)action);
        }
        if (!(node instanceof UReferenceExpression)) return null;
        PsiElement resolved = ((UReferenceExpression)node).resolve();
        if (resolved instanceof PsiField) {
            PsiField field = (PsiField)resolved;
            if (this.mOperation == Operation.ACTION) {
                JavaEvaluator evaluator = this.mContext.getEvaluator();
                UAnnotation annotation = evaluator.getAnnotation((PsiModifierListOwner)field, new String[]{AnnotationDetectorKt.PERMISSION_ANNOTATION.oldName(), AnnotationDetectorKt.PERMISSION_ANNOTATION.newName(), "android.annotation.RequiresPermission"});
                if (annotation != null) {
                    return this.getPermissionRequirement(field, annotation);
                }
            } else if (this.mOperation == Operation.READ || this.mOperation == Operation.WRITE) {
                AndroidxName fqn = this.mOperation == Operation.READ ? AnnotationDetectorKt.PERMISSION_ANNOTATION_READ : AnnotationDetectorKt.PERMISSION_ANNOTATION_WRITE;
                JavaEvaluator evaluator = this.mContext.getEvaluator();
                UAnnotation annotation = evaluator.getAnnotation((PsiModifierListOwner)field, new String[]{fqn.oldName(), fqn.newName()});
                if (annotation == null) {
                    String s = AndroidPlatformAnnotations.toPlatformAnnotation((String)fqn.newName());
                    annotation = evaluator.getAnnotation((PsiModifierListOwner)field, new String[]{s});
                }
                if (annotation != null) {
                    String qualifiedName;
                    UExpression o;
                    List values = annotation.getAttributeValues();
                    UExpression uExpression = o = values.size() == 1 ? ((UNamedExpression)values.get(0)).getExpression() : null;
                    if (!(o instanceof UCallExpression) || !(o.getSourcePsi() instanceof PsiAnnotation)) return this.getPermissionRequirement(field, annotation);
                    PsiAnnotation nestedPsi = (PsiAnnotation)o.getSourcePsi();
                    UAnnotation nested = (UAnnotation)UastFacade.INSTANCE.convertElement((PsiElement)nestedPsi, null, UAnnotation.class);
                    if (nested != null && (AnnotationDetectorKt.PERMISSION_ANNOTATION.isEquals(qualifiedName = nested.getQualifiedName()) || "android.annotation.RequiresPermission".equals(qualifiedName))) {
                        return this.getPermissionRequirement(field, nested);
                    }
                }
            } else assert (false) : this.mOperation;
        }
        if (!(resolved instanceof PsiVariable) || (lastAssignment = UastLintUtils.findLastAssignment((PsiVariable)(variable = (PsiVariable)resolved), (UElement)node)) == null) return null;
        return this.search((UElement)lastAssignment);
    }

    private Result getPermissionRequirement(PsiField field, UAnnotation annotation) {
        PermissionRequirement requirement = PermissionRequirement.create(annotation);
        PsiClass containingClass = field.getContainingClass();
        String name = containingClass != null ? containingClass.getName() + "." + field.getName() : field.getName();
        return new Result(this.mOperation, requirement, name);
    }

    public static enum Operation {
        CALL,
        ACTION,
        READ,
        WRITE;


        public String prefix() {
            switch (this.ordinal()) {
                case 1: {
                    return "by intent";
                }
                case 2: {
                    return "to read";
                }
                case 3: {
                    return "to write";
                }
            }
            return "by";
        }
    }

    public static class Result {
        public final PermissionRequirement requirement;
        public final String name;
        public final Operation operation;

        public Result(Operation operation, PermissionRequirement requirement, String name) {
            this.operation = operation;
            this.requirement = requirement;
            this.name = name;
        }
    }
}

