/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.sdklib.internal.avd.ConfigEnum;

public enum GpuMode implements ConfigEnum
{
    AUTO("auto"),
    HOST("host"),
    SOFTWARE("software");

    private final String mySetting;

    private GpuMode(String setting) {
        this.mySetting = setting;
    }

    public String toString() {
        switch (this.ordinal()) {
            case 1: {
                return "Hardware";
            }
            case 2: {
                return "Software";
            }
        }
        return "Automatic";
    }

    public static GpuMode fromGpuSetting(String setting) {
        for (GpuMode mode : GpuMode.values()) {
            if (!mode.mySetting.equals(setting)) continue;
            return mode;
        }
        return AUTO;
    }

    public String getGpuSetting() {
        return this.mySetting;
    }

    @Override
    public String getAsParameter() {
        return this.getGpuSetting();
    }
}

