/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.ProjectInitializer;
import com.android.tools.lint.ProjectInitializerKt;
import com.android.tools.lint.ProjectMetadata;
import com.android.tools.lint.client.api.LintClient;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b)\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/\u001a\u001a\u00100\u001a\u0004\u0018\u00010\u00012\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020/H\u0007\u001a*\u00103\u001a\u0002042\u0006\u00102\u001a\u00020/2\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020406H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010#\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010$\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010%\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010&\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010'\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010(\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010)\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"TAG_PROJECT", "", "TAG_MODULE", "TAG_CLASSES", "TAG_CLASSPATH", "TAG_KLIB", "TAG_SRC", "TAG_DEP", "TAG_ROOT", "TAG_MANIFEST", "TAG_RESOURCE", "TAG_AAR", "TAG_JAR", "TAG_SDK", "TAG_JDK", "TAG_JDK_BOOT_CLASS_PATH", "TAG_LINT_CHECKS", "TAG_BASELINE", "TAG_MERGED_MANIFEST", "TAG_CACHE", "TAG_AIDL", "TAG_PROGUARD", "TAG_ANNOTATIONS", "ATTR_COMPILE_SDK_VERSION", "ATTR_TEST", "ATTR_GENERATED", "ATTR_NAME", "ATTR_FILE", "ATTR_EXTRACTED", "ATTR_DIR", "ATTR_JAR", "ATTR_MODULE", "ATTR_INCOMPLETE", "ATTR_JAVA8_LIBS", "ATTR_DESUGAR", "ATTR_JAVA_LEVEL", "ATTR_KOTLIN_LEVEL", "ATTR_MODEL", "ATTR_PARTIAL_RESULTS_DIR", "ATTR_KIND", "ATTR_COMPUTE_SOURCE_ROOTS", "ATTR_KOTLIN_PLATFORMS", "computeMetadata", "Lcom/android/tools/lint/ProjectMetadata;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "descriptor", "Ljava/io/File;", "findPackage", "source", "file", "forEachZippedFile", "", "step", "Lkotlin/Function2;", "Ljava/util/zip/ZipFile;", "Ljava/util/zip/ZipEntry;", "lint-cli"})
@SourceDebugExtension(value={"SMAP\nProjectInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectInitializer.kt\ncom/android/tools/lint/ProjectInitializerKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1392:1\n1321#2,2:1393\n*S KotlinDebug\n*F\n+ 1 ProjectInitializer.kt\ncom/android/tools/lint/ProjectInitializerKt\n*L\n1390#1:1393,2\n*E\n"})
public final class ProjectInitializerKt {
    @NotNull
    private static final String TAG_PROJECT = "project";
    @NotNull
    private static final String TAG_MODULE = "module";
    @NotNull
    private static final String TAG_CLASSES = "classes";
    @NotNull
    private static final String TAG_CLASSPATH = "classpath";
    @NotNull
    private static final String TAG_KLIB = "klib";
    @NotNull
    private static final String TAG_SRC = "src";
    @NotNull
    private static final String TAG_DEP = "dep";
    @NotNull
    private static final String TAG_ROOT = "root";
    @NotNull
    private static final String TAG_MANIFEST = "manifest";
    @NotNull
    private static final String TAG_RESOURCE = "resource";
    @NotNull
    private static final String TAG_AAR = "aar";
    @NotNull
    private static final String TAG_JAR = "jar";
    @NotNull
    private static final String TAG_SDK = "sdk";
    @NotNull
    private static final String TAG_JDK = "jdk";
    @NotNull
    private static final String TAG_JDK_BOOT_CLASS_PATH = "jdk-boot-classpath";
    @NotNull
    private static final String TAG_LINT_CHECKS = "lint-checks";
    @NotNull
    private static final String TAG_BASELINE = "baseline";
    @NotNull
    private static final String TAG_MERGED_MANIFEST = "merged-manifest";
    @NotNull
    private static final String TAG_CACHE = "cache";
    @NotNull
    private static final String TAG_AIDL = "aidl";
    @NotNull
    private static final String TAG_PROGUARD = "proguard";
    @NotNull
    private static final String TAG_ANNOTATIONS = "annotations";
    @NotNull
    private static final String ATTR_COMPILE_SDK_VERSION = "compile-sdk-version";
    @NotNull
    private static final String ATTR_TEST = "test";
    @NotNull
    private static final String ATTR_GENERATED = "generated";
    @NotNull
    private static final String ATTR_NAME = "name";
    @NotNull
    private static final String ATTR_FILE = "file";
    @NotNull
    private static final String ATTR_EXTRACTED = "extracted";
    @NotNull
    private static final String ATTR_DIR = "dir";
    @NotNull
    private static final String ATTR_JAR = "jar";
    @NotNull
    private static final String ATTR_MODULE = "module";
    @NotNull
    private static final String ATTR_INCOMPLETE = "incomplete";
    @NotNull
    private static final String ATTR_JAVA8_LIBS = "android_java8_libs";
    @NotNull
    private static final String ATTR_DESUGAR = "desugar";
    @NotNull
    private static final String ATTR_JAVA_LEVEL = "javaLanguage";
    @NotNull
    private static final String ATTR_KOTLIN_LEVEL = "kotlinLanguage";
    @NotNull
    private static final String ATTR_MODEL = "model";
    @NotNull
    private static final String ATTR_PARTIAL_RESULTS_DIR = "partial-results-dir";
    @NotNull
    private static final String ATTR_KIND = "kind";
    @NotNull
    private static final String ATTR_COMPUTE_SOURCE_ROOTS = "compute_source_roots";
    @NotNull
    private static final String ATTR_KOTLIN_PLATFORMS = "kotlinPlatforms";

    @NotNull
    public static final ProjectMetadata computeMetadata(@NotNull LintClient client, @NotNull File descriptor) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        File file = descriptor.getParentFile();
        if (file == null) {
            file = descriptor;
        }
        ProjectInitializer initializer = new ProjectInitializer(client, descriptor, file);
        return initializer.computeMetadata();
    }

    @VisibleForTesting
    @Nullable
    public static final String findPackage(@NotNull String source, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)ATTR_FILE);
        int STATE_INIT = 0;
        int STATE_SLASH = 1;
        int STATE_LINE_COMMENT = 2;
        int STATE_BLOCK_COMMENT = 3;
        int STATE_BLOCK_COMMENT_STAR = 4;
        int STATE_BLOCK_COMMENT_SLASH = 5;
        int blockCommentDepth = 0;
        int state = STATE_INIT;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        boolean isKotlin = StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null);
        for (int offset = 0; offset < source.length(); ++offset) {
            char c = source.charAt(offset);
            int n = state;
            if (n == 0) {
                if (c == '/') {
                    state = STATE_SLASH;
                    continue;
                }
                if (c != 'p' || !StringsKt.startsWith$default((String)source, (String)"package", (int)offset, (boolean)false, (int)4, null)) continue;
                StringBuilder pkg = new StringBuilder();
                offset += 7;
                while (offset < source.length()) {
                    char p;
                    if (Character.isJavaIdentifierPart(p = source.charAt(offset++)) || p == '.') {
                        pkg.append(p);
                        continue;
                    }
                    if (p != ';' && (p != '\n' || !isKotlin)) continue;
                }
                return pkg.toString();
            }
            if (n == STATE_SLASH) {
                switch (c) {
                    case '/': {
                        state = STATE_LINE_COMMENT;
                        break;
                    }
                    case '*': {
                        state = STATE_BLOCK_COMMENT;
                        ++blockCommentDepth;
                        break;
                    }
                    default: {
                        state = STATE_INIT;
                        break;
                    }
                }
                continue;
            }
            if (n == STATE_LINE_COMMENT) {
                if (c != '\n') continue;
                state = STATE_INIT;
                continue;
            }
            if (n == STATE_BLOCK_COMMENT) {
                if (c == '*') {
                    state = STATE_BLOCK_COMMENT_STAR;
                    continue;
                }
                if (c != '/' || !isKotlin) continue;
                state = STATE_BLOCK_COMMENT_SLASH;
                continue;
            }
            if (n == STATE_BLOCK_COMMENT_STAR) {
                if (c == '/') {
                    state = --blockCommentDepth == 0 ? STATE_INIT : STATE_BLOCK_COMMENT;
                    continue;
                }
                if (c == '*') continue;
                state = STATE_BLOCK_COMMENT;
                continue;
            }
            if (n != STATE_BLOCK_COMMENT_SLASH) continue;
            if (c == '*') {
                ++blockCommentDepth;
            }
            if (c == '/') continue;
            state = STATE_BLOCK_COMMENT;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void forEachZippedFile(File file, Function2<? super ZipFile, ? super ZipEntry, Unit> step) {
        Closeable closeable = new ZipFile(file);
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
            Sequence $this$forEach$iv = SequencesKt.filterNot((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)forEachZippedFile.1.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ZipEntry it = (ZipEntry)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                step.invoke((Object)zipFile, (Object)it);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ void access$forEachZippedFile(File file, Function2 step) {
        ProjectInitializerKt.forEachZippedFile(file, (Function2<? super ZipFile, ? super ZipEntry, Unit>)step);
    }
}

