/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.ClassNameKt;
import com.android.tools.lint.client.api.LintFixPerformer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0006\u0010\u0012\u001a\u00020\u0003J\u0010\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/ClassName;", "", "source", "", "extension", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getSource", "()Ljava/lang/String;", "getExtension", "packageName", "getPackageName", "className", "getClassName", "jvmName", "getJvmName", "cleanup", "contents", "packageNameWithDefault", "relativePath", "lint-cli"})
public class ClassName {
    @NotNull
    private final String source;
    @NotNull
    private final String extension;
    @Nullable
    private final String packageName;
    @Nullable
    private final String className;
    @Nullable
    private final String jvmName;

    public ClassName(@NotNull String source, @NotNull String extension) {
        String string;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.source = source;
        this.extension = extension;
        String cleaned = this.cleanup(this.source, this.extension);
        this.packageName = ClassNameKt.access$getPackage(cleaned);
        this.className = ClassNameKt.access$getClassName(cleaned);
        if (Intrinsics.areEqual((Object)this.extension, (Object)".java")) {
            string = this.className;
        } else {
            string = ClassNameKt.access$getJvmName(cleaned);
            if (string == null) {
                string = this.className;
            }
        }
        this.jvmName = string;
    }

    public /* synthetic */ ClassName(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = ".java";
        }
        this(string, string2);
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final String getExtension() {
        return this.extension;
    }

    @Nullable
    public final String getPackageName() {
        return this.packageName;
    }

    @Nullable
    public final String getClassName() {
        return this.className;
    }

    @Nullable
    public final String getJvmName() {
        return this.jvmName;
    }

    private final String cleanup(String contents2, String extension) {
        boolean allowCommentNesting;
        int length = contents2.length();
        StringBuilder sb = new StringBuilder(length);
        int current = 0;
        boolean bl = allowCommentNesting = Intrinsics.areEqual((Object)extension, (Object)".kt") || Intrinsics.areEqual((Object)extension, (Object)".kts");
        while (current < length) {
            StringBuilder stringBuilder;
            char c;
            int skipped = LintFixPerformer.Companion.skipCommentsAndWhitespace$default((LintFixPerformer.Companion)LintFixPerformer.Companion, (CharSequence)contents2, (int)current, (boolean)allowCommentNesting, (boolean)false, (int)8, null);
            if (skipped > current) {
                sb.append(' ');
                current = skipped;
                if (current == length) break;
            }
            if (CharsKt.isWhitespace((char)(c = contents2.charAt(current)))) {
                stringBuilder = sb.append(c);
            } else {
                if (!(c != '@' || StringsKt.startsWith$default((String)contents2, (String)"@interface", (int)current, (boolean)false, (int)4, null) || StringsKt.startsWith$default((String)contents2, (String)"@file:JvmName", (int)current, (boolean)false, (int)4, null) || StringsKt.startsWith$default((String)contents2, (String)"@file:kotlin.jvm.JvmName", (int)current, (boolean)false, (int)4, null))) {
                    int afterAnnotation = LintFixPerformer.Companion.skipAnnotation((CharSequence)contents2, current);
                    sb.append(' ');
                    current = afterAnnotation;
                    continue;
                }
                stringBuilder = sb.append(c);
            }
            ++current;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String packageNameWithDefault() {
        String string = this.packageName;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String relativePath(@NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String string = this.className;
        if (string == null && (string = this.jvmName) == null) {
            string = "test";
        }
        String name = string + extension;
        return this.packageName != null ? StringsKt.replace$default((String)this.packageName, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + name : name;
    }

    public static /* synthetic */ String relativePath$default(ClassName className, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: relativePath");
        }
        if ((n & 1) != 0) {
            string = className.extension;
        }
        return className.relativePath(string);
    }
}

