/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.inline;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.CommonIrAttributesKt;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.inline.CallInlinerStrategy;
import org.jetbrains.kotlin.ir.inline.CallInlining;
import org.jetbrains.kotlin.ir.inline.InlineFunctionResolver;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.JvmIrInlineExperimental;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@PhaseDescription(name="FunctionInlining")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B1\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u000eJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\f\u0010\u001f\u001a\u00020 *\u00020 H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/ir/inline/FunctionInlining;", "Lorg/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "inlineFunctionResolver", "Lorg/jetbrains/kotlin/ir/inline/InlineFunctionResolver;", "insertAdditionalImplicitCasts", "", "regenerateInlinedAnonymousObjects", "produceOuterThisFields", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;Lorg/jetbrains/kotlin/ir/inline/InlineFunctionResolver;ZZZ)V", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;Lorg/jetbrains/kotlin/ir/inline/InlineFunctionResolver;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "data", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "markAsRegenerated", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "ir.inline"})
@SourceDebugExtension(value={"SMAP\nFunctionInlining.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionInlining.kt\norg/jetbrains/kotlin/ir/inline/FunctionInlining\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,731:1\n1878#2,3:732\n*S KotlinDebug\n*F\n+ 1 FunctionInlining.kt\norg/jetbrains/kotlin/ir/inline/FunctionInlining\n*L\n89#1:732,3\n*E\n"})
public final class FunctionInlining
extends IrTransformer<IrDeclaration>
implements BodyLoweringPass {
    @NotNull
    private final LoweringContext context;
    @NotNull
    private final InlineFunctionResolver inlineFunctionResolver;
    private final boolean insertAdditionalImplicitCasts;
    private final boolean regenerateInlinedAnonymousObjects;
    private final boolean produceOuterThisFields;

    @JvmIrInlineExperimental
    public FunctionInlining(@NotNull LoweringContext context2, @NotNull InlineFunctionResolver inlineFunctionResolver, boolean insertAdditionalImplicitCasts, boolean regenerateInlinedAnonymousObjects, boolean produceOuterThisFields) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)inlineFunctionResolver, (String)"inlineFunctionResolver");
        this.context = context2;
        this.inlineFunctionResolver = inlineFunctionResolver;
        this.insertAdditionalImplicitCasts = insertAdditionalImplicitCasts;
        this.regenerateInlinedAnonymousObjects = regenerateInlinedAnonymousObjects;
        this.produceOuterThisFields = produceOuterThisFields;
        if (!(!this.produceOuterThisFields || this.context instanceof CommonBackendContext)) {
            boolean bl = false;
            String string = "The inliner can generate outer fields only with param `context` of type `CommonBackendContext`";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final LoweringContext getContext() {
        return this.context;
    }

    public FunctionInlining(@NotNull LoweringContext context2, @NotNull InlineFunctionResolver inlineFunctionResolver) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)inlineFunctionResolver, (String)"inlineFunctionResolver");
        this(context2, inlineFunctionResolver, true, false, false);
    }

    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        irBody.accept(this, container);
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull IrDeclaration data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IrDeclarationBase irDeclarationBase = declaration;
        return irDeclarationBase instanceof IrFunction || irDeclarationBase instanceof IrClass || irDeclarationBase instanceof IrProperty ? (IrStatement)this.context.getIrFactory().getStageController().restrictTo(declaration, () -> FunctionInlining.visitDeclaration$lambda$1(this, declaration)) : super.visitDeclaration(declaration, declaration);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull IrDeclaration data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        expression2.transformChildren(this, data);
        IrFunction irFunction = this.inlineFunctionResolver.getFunctionDeclarationToInline(expression2);
        if (irFunction == null) {
            return expression2;
        }
        IrFunction actualCallee = irFunction;
        if (expression2 instanceof IrCall && Symbols.Companion.isTypeOfIntrinsic(actualCallee.getSymbol())) {
            this.inlineFunctionResolver.getCallInlinerStrategy().at(data, expression2);
            CallInlinerStrategy callInlinerStrategy = this.inlineFunctionResolver.getCallInlinerStrategy();
            IrCall irCall = (IrCall)expression2;
            IrType irType = expression2.getTypeArguments().get(0);
            Intrinsics.checkNotNull((Object)irType);
            return callInlinerStrategy.postProcessTypeOf(irCall, irType);
        }
        if (actualCallee.getBody() == null) {
            return expression2;
        }
        IrBody irBody = actualCallee.getBody();
        if (irBody != null) {
            irBody.transformChildren(this, actualCallee);
        }
        Iterable $this$forEachIndexed$iv = actualCallee.getParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int index2 = n;
            boolean bl = false;
            if (expression2.getArguments().get(index2) != null) continue;
            IrExpressionBody irExpressionBody = param.getDefaultValue();
            param.setDefaultValue((IrExpressionBody)(irExpressionBody != null ? irExpressionBody.transform((IrTransformer)this, actualCallee) : null));
        }
        this.inlineFunctionResolver.getCallInlinerStrategy().at(data, expression2);
        IrFile irFile = IrUtilsKt.getFile(data);
        IrDeclarationParent irDeclarationParent = data instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)data) : null;
        if (irDeclarationParent == null) {
            irDeclarationParent = data.getParent();
        }
        return this.markAsRegenerated(new CallInlining(this.context, actualCallee, irFile, irDeclarationParent, this.inlineFunctionResolver, this.insertAdditionalImplicitCasts, this.produceOuterThisFields).inline(expression2));
    }

    private final IrBlock markAsRegenerated(IrBlock $this$markAsRegenerated) {
        if (!this.regenerateInlinedAnonymousObjects) {
            return $this$markAsRegenerated;
        }
        IrVisitorsKt.acceptVoid((IrElement)$this$markAsRegenerated, new IrVisitorVoid(){

            private final void setUpCorrectAttributeOwner(IrElement $this$setUpCorrectAttributeOwner) {
                if (Intrinsics.areEqual((Object)$this$setUpCorrectAttributeOwner.getAttributeOwnerId(), (Object)$this$setUpCorrectAttributeOwner)) {
                    return;
                }
                CommonIrAttributesKt.setOriginalBeforeInline((IrElement)$this$setUpCorrectAttributeOwner, (IrElement)$this$setUpCorrectAttributeOwner.getAttributeOwnerId());
                $this$setUpCorrectAttributeOwner.setAttributeOwnerId($this$setUpCorrectAttributeOwner);
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!(element instanceof IrInlinedFunctionBlock)) {
                    this.setUpCorrectAttributeOwner(element);
                }
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }
        });
        return $this$markAsRegenerated;
    }

    private static final IrStatement visitDeclaration$lambda$1(FunctionInlining this$0, IrDeclarationBase $declaration) {
        return super.visitDeclaration($declaration, $declaration);
    }
}

