/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.lint.model.DefaultLintModelLintOptions;
import com.android.tools.lint.model.DefaultLintModelModule;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleLoader;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelReader;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelSeverity;
import com.android.tools.lint.model.LintModelVariant;
import com.android.tools.lint.model.LintModelVariantReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\rH\u0002J \u0010\u000f\u001a\u00020\u00102\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/model/LintModelModuleReader;", "Lcom/android/tools/lint/model/LintModelReader;", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "<init>", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;)V", "path", "", "getPath", "()Ljava/lang/String;", "readLintOptions", "Lcom/android/tools/lint/model/LintModelLintOptions;", "readSeverities", "", "Lcom/android/tools/lint/model/LintModelSeverity;", "readModule", "Lcom/android/tools/lint/model/LintModelModule;", "variantNames", "", "readDependencies", "", "readVariantReference", "Lcom/android/tools/lint/model/LintModelVariant;", "module", "lint-model"})
@SourceDebugExtension(value={"SMAP\nLintModelSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintModelSerialization.kt\ncom/android/tools/lint/model/LintModelModuleReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2012:1\n1#2:2013\n*E\n"})
final class LintModelModuleReader
extends LintModelReader {
    public LintModelModuleReader(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        super(adapter, adapter.getRoot(), LintModelSerialization.LintModelSerializationAdapter.getReader$default(adapter, LintModelSerialization.TargetFile.MODULE, null, null, 6, null));
    }

    @Override
    @NotNull
    protected String getPath() {
        Object object = LintModelSerialization.LintModelSerializationAdapter.file$default(this.getAdapter(), LintModelSerialization.TargetFile.MODULE, null, null, 6, null);
        if (object == null || (object = ((File)object).getPath()) == null) {
            object = "<unknown>";
        }
        return object;
    }

    private final LintModelLintOptions readLintOptions() {
        this.expectTag("lintOptions");
        boolean isCheckTestSources = this.getOptionalBoolean("checkTestSources", false);
        File lintConfig = LintModelReader.getOptionalFile$default(this, "lintConfig", null, 2, null);
        boolean isCheckDependencies = this.getOptionalBoolean("checkDependencies", false);
        File baselineFile = LintModelReader.getOptionalFile$default(this, "baselineFile", null, 2, null);
        Map<String, LintModelSeverity> severityOverrides = null;
        List it = LintModelReader.getStrings$default(this, "enable", null, 2, null);
        boolean bl = false;
        Set enable = !((Collection)it).isEmpty() ? CollectionsKt.toSet((Iterable)it) : SetsKt.emptySet();
        List it2 = LintModelReader.getStrings$default(this, "disable", null, 2, null);
        boolean bl2 = false;
        Set disable = !((Collection)it2).isEmpty() ? CollectionsKt.toSet((Iterable)it2) : SetsKt.emptySet();
        List it3 = LintModelReader.getStrings$default(this, "check", null, 2, null);
        boolean bl3 = false;
        Set check = !((Collection)it3).isEmpty() ? CollectionsKt.toSet((Iterable)it3) : null;
        boolean abortOnError = this.getOptionalBoolean("abortOnError", false);
        boolean absolutePaths = this.getOptionalBoolean("absolutePaths", false);
        boolean noLines = this.getOptionalBoolean("noLines", false);
        boolean quiet = this.getOptionalBoolean("quiet", false);
        boolean checkAllWarnings = this.getOptionalBoolean("checkAllWarnings", false);
        boolean ignoreWarnings = this.getOptionalBoolean("ignoreWarnings", false);
        boolean warningsAsErrors = this.getOptionalBoolean("warningsAsErrors", false);
        boolean ignoreTestSources = this.getOptionalBoolean("ignoreTestSources", false);
        boolean ignoreTestFixturesSources = this.getOptionalBoolean("ignoreTestFixturesSources", false);
        boolean checkGeneratedSources = this.getOptionalBoolean("checkGeneratedSources", false);
        boolean checkReleaseBuilds = this.getOptionalBoolean("checkReleaseBuilds", false);
        boolean explainIssues = this.getOptionalBoolean("explainIssues", false);
        boolean showAll = this.getOptionalBoolean("showAll", false);
        boolean textReport = this.getOptionalBoolean("textReport", false);
        File textOutput = this.getOptionalOutputFile("textOutput");
        boolean htmlReport = this.getOptionalBoolean("htmlReport", false);
        File htmlOutput = this.getOptionalOutputFile("htmlOutput");
        boolean xmlReport = this.getOptionalBoolean("xmlReport", false);
        File xmlOutput = this.getOptionalOutputFile("xmlOutput");
        boolean sarifReport = this.getOptionalBoolean("sarifReport", false);
        File sarifOutput = LintModelReader.getOptionalFile$default(this, "sarifOutput", null, 2, null);
        block4: while (this.getParser().next() != 1) {
            int eventType = this.getParser().getEventType();
            switch (eventType) {
                case 2: {
                    if (Intrinsics.areEqual((Object)this.getParser().getName(), (Object)"severities")) {
                        severityOverrides = this.readSeverities();
                        continue block4;
                    }
                    this.unexpectedTag();
                    continue block4;
                }
                case 3: {
                    this.expectTag("lintOptions");
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return new DefaultLintModelLintOptions(disable, enable, check, abortOnError, absolutePaths, noLines, quiet, checkAllWarnings, ignoreWarnings, warningsAsErrors, isCheckTestSources, ignoreTestSources, ignoreTestFixturesSources, checkGeneratedSources, explainIssues, showAll, lintConfig, textReport, textOutput, htmlReport, htmlOutput, xmlReport, xmlOutput, sarifReport, sarifOutput, checkReleaseBuilds, isCheckDependencies, baselineFile, severityOverrides);
    }

    private final Map<String, LintModelSeverity> readSeverities() {
        this.expectTag("severities");
        Map map = new LinkedHashMap();
        block4: while (this.getParser().next() != 1) {
            int eventType = this.getParser().getEventType();
            switch (eventType) {
                case 2: {
                    if (Intrinsics.areEqual((Object)this.getParser().getName(), (Object)"severity")) {
                        LintModelSeverity severity;
                        String id = this.getRequiredAttribute("id");
                        String severityString = this.getRequiredAttribute("severity");
                        if (LintModelSeverity.Companion.fromName(severityString) == null) {
                            throw new IllegalStateException(("Unexpected severity " + severityString + " for id " + id + " at " + this.getLocation()).toString());
                        }
                        map.put(id, severity);
                        this.finishTag("severity");
                        continue block4;
                    }
                    this.unexpectedTag();
                    continue block4;
                }
                case 3: {
                    this.expectTag("severities");
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return map;
    }

    @NotNull
    public final LintModelModule readModule(@Nullable List<String> variantNames, boolean readDependencies) {
        try {
            Object object;
            String string;
            LintModelMavenName mavenString;
            LintModelModuleType type;
            String name;
            File dir;
            block20: {
                block19: {
                    LintModelMavenName lintModelMavenName;
                    this.getParser().nextTag();
                    this.expectTag("lint-module");
                    dir = LintModelReader.getRequiredFile$default(this, "dir", null, 2, null);
                    this.setRoot(dir);
                    name = this.getName();
                    type = LintModelModuleType.valueOf(this.getRequiredAttribute("type"));
                    String string2 = this.getOptionalAttribute("maven");
                    if (string2 != null) {
                        String it = string2;
                        boolean bl = false;
                        lintModelMavenName = LintModelMavenName.Companion.parse(it);
                    } else {
                        lintModelMavenName = mavenString = null;
                    }
                    if ((string = this.getOptionalAttribute("agpVersion")) == null) break block19;
                    String it = string;
                    boolean bl = false;
                    AgpVersion agpVersion = AgpVersion.Companion.tryParse(it);
                    string = agpVersion;
                    if (agpVersion != null) break block20;
                }
                String string3 = this.getOptionalAttribute("gradle");
                if (string3 != null) {
                    String it = string3;
                    boolean bl = false;
                    string = AgpVersion.Companion.tryParse(it);
                } else {
                    string = null;
                }
            }
            String agpVersion = string;
            File buildFolder = LintModelReader.getRequiredFile$default(this, "buildFolder", null, 2, null);
            String resourcePrefix = this.getOptionalAttribute("resourcePrefix");
            List dynamicFeatures = LintModelReader.getStrings$default(this, "dynamicFeatures", null, 2, null);
            List<File> bootClassPath = this.getFiles("bootClassPath");
            String javaSourceLevel = this.getRequiredAttribute("javaSourceLevel");
            String compileTarget = this.getRequiredAttribute("compileTarget");
            boolean neverShrinking = this.getOptionalBoolean("neverShrinking", false);
            boolean highlightGradualR8Api = this.getOptionalBoolean("highlightGradualR8Api", false);
            List variants = new ArrayList();
            List<File> lintRuleJars = this.getFiles("lintRuleJars");
            LintModelLintOptions lintOptions = null;
            while (this.getParser().next() != 1) {
                int eventType = this.getParser().getEventType();
                if (eventType != 2) continue;
                object = this.getParser().getName();
                if (Intrinsics.areEqual((Object)object, (Object)"lintOptions")) {
                    lintOptions = this.readLintOptions();
                    continue;
                }
                if (Intrinsics.areEqual((Object)object, (Object)"variant")) break;
                this.unexpectedTag();
            }
            if (lintOptions == null) {
                this.missingData();
            }
            object = LintModelSerialization.INSTANCE;
            LintModelLintOptions lintModelLintOptions = lintOptions;
            Intrinsics.checkNotNull(lintModelLintOptions);
            LintModelLintOptions lintModelLintOptions2 = lintModelLintOptions;
            DefaultLintModelModule module = new DefaultLintModelModule((LintModelModuleLoader)object, dir, name, type, mavenString, (AgpVersion)agpVersion, buildFolder, lintModelLintOptions2, lintRuleJars, resourcePrefix, dynamicFeatures, bootClassPath, javaSourceLevel, compileTarget, variants, highlightGradualR8Api, neverShrinking);
            if (Intrinsics.areEqual((Object)this.getParser().getName(), (Object)"variant")) {
                LintModelVariant lintModelVariant = this.readVariantReference(module, variantNames, readDependencies);
                if (lintModelVariant != null) {
                    LintModelVariant it = lintModelVariant;
                    boolean bl = false;
                    variants.add(it);
                }
                while (this.getParser().next() != 1) {
                    int eventType = this.getParser().getEventType();
                    if (eventType != 2) continue;
                    String tag = this.getParser().getName();
                    if (Intrinsics.areEqual((Object)tag, (Object)"variant")) {
                        if (this.readVariantReference(module, variantNames, readDependencies) != null) {
                            LintModelVariant it;
                            boolean bl = false;
                            variants.add(it);
                        }
                        continue;
                    }
                    this.unexpectedTag();
                }
            }
            return module;
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
    }

    public static /* synthetic */ LintModelModule readModule$default(LintModelModuleReader lintModelModuleReader, List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return lintModelModuleReader.readModule(list, bl);
    }

    private final LintModelVariant readVariantReference(LintModelModule module, List<String> variantNames, boolean readDependencies) {
        LintModelVariant lintModelVariant;
        this.expectTag("variant");
        String variantName = this.getName();
        this.finishTag("variant");
        if (variantNames == null || variantNames.contains(variantName)) {
            LintModelVariantReader reader = new LintModelVariantReader(this.getAdapter(), this.getRoot(), variantName, null, 8, null);
            lintModelVariant = reader.readVariant(module, readDependencies);
        } else {
            lintModelVariant = null;
        }
        return lintModelVariant;
    }
}

