/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.internal.ApkEntry;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkDiffEntry
implements ApkEntry {
    @NotNull
    private final String name;
    @Nullable
    private final ArchiveNode oldFile;
    @Nullable
    private final ArchiveNode newFile;
    private final long oldSize;
    private final long newSize;

    ApkDiffEntry(@NotNull String name, @Nullable ArchiveNode oldFile, @Nullable ArchiveNode newFile, long oldSize, long newSize) {
        if (oldFile == null && newFile == null) {
            throw new IllegalArgumentException("Both files can't be null");
        }
        this.name = name;
        this.oldFile = oldFile;
        this.newFile = newFile;
        this.oldSize = oldSize;
        this.newSize = newSize;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Path getPath() {
        assert (this.oldFile != null || this.newFile != null);
        return this.oldFile != null ? this.oldFile.getData().getPath() : this.newFile.getData().getPath();
    }

    @Override
    public long getSize() {
        return this.newSize - this.oldSize;
    }

    public long getOldSize() {
        return this.oldSize;
    }

    public long getNewSize() {
        return this.newSize;
    }

    public static long getOldSize(@NotNull ApkEntry apkEntry) {
        if (apkEntry instanceof ApkDiffEntry) {
            return ((ApkDiffEntry)apkEntry).getOldSize();
        }
        return apkEntry.getSize();
    }

    public static long getNewSize(@NotNull ApkEntry apkEntry) {
        if (apkEntry instanceof ApkDiffEntry) {
            return ((ApkDiffEntry)apkEntry).getNewSize();
        }
        return apkEntry.getSize();
    }

    public String toString() {
        return this.getName();
    }
}

