/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.util;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JpsPathUtil {
    public static final String FILE_URL_PREFIX = "file://";
    public static final String JAR_URL_PREFIX = "jar://";
    public static final String JAR_SEPARATOR = "!/";
    private static final String UNNAMED_PROJECT = "<unnamed>";

    public static boolean isUnder(Set<File> ancestors, File file) {
        if (ancestors.isEmpty()) {
            return false;
        }
        File current = file;
        while (current != null) {
            if (ancestors.contains(current)) {
                return true;
            }
            current = FileUtilRt.getParentFile(current);
        }
        return false;
    }

    public static File urlToFile(String url) {
        return new File(JpsPathUtil.urlToOsPath(url));
    }

    @NotNull
    public static Path urlToNioPath(@NotNull String url) {
        if (url == null) {
            JpsPathUtil.$$$reportNull$$$0(0);
        }
        Path path = Path.of(JpsPathUtil.urlToOsPath(url), new String[0]);
        if (path == null) {
            JpsPathUtil.$$$reportNull$$$0(1);
        }
        return path;
    }

    @NotNull
    public static String urlToOsPath(@NotNull String url) {
        if (url == null) {
            JpsPathUtil.$$$reportNull$$$0(2);
        }
        String string = FileUtilRt.toSystemDependentName(JpsPathUtil.urlToPath(url));
        if (string == null) {
            JpsPathUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null")
    @NlsSafe
    public static String urlToPath(@Nullable String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith(FILE_URL_PREFIX)) {
            return url.substring(FILE_URL_PREFIX.length());
        }
        if (url.startsWith(JAR_URL_PREFIX)) {
            int p = url.lastIndexOf(JAR_SEPARATOR);
            url = p >= 0 ? url.substring(JAR_URL_PREFIX.length(), p) : url.substring(JAR_URL_PREFIX.length());
        }
        return url;
    }

    public static String pathToUrl(String path) {
        return FILE_URL_PREFIX + path;
    }

    @NotNull
    public static String getLibraryRootUrl(File file) {
        String path = FileUtilRt.toSystemIndependentName(file.getAbsolutePath());
        String string = file.isDirectory() ? FILE_URL_PREFIX + path : JAR_URL_PREFIX + path + JAR_SEPARATOR;
        if (string == null) {
            JpsPathUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean isJrtUrl(@NotNull String url) {
        if (url == null) {
            JpsPathUtil.$$$reportNull$$$0(5);
        }
        return url.startsWith("jrt://");
    }

    @ApiStatus.Internal
    @Nullable
    public static String readProjectName(@NotNull Path projectDir) {
        String s;
        if (projectDir == null) {
            JpsPathUtil.$$$reportNull$$$0(6);
        }
        try (Stream<String> stream = Files.lines(projectDir.resolve(".name"));){
            s = stream.findFirst().orElse("");
        }
        catch (IOException | UncheckedIOException e) {
            return null;
        }
        return JpsPathUtil.normalizeProjectName(s);
    }

    @ApiStatus.Internal
    @Nullable
    public static String normalizeProjectName(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return (s = StringUtil.removeHtmlTags(s, true)).isBlank() ? null : s.trim();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/util/JpsPathUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/util/JpsPathUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToNioPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToOsPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRootUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "urlToNioPath";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "urlToOsPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isJrtUrl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readProjectName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

