/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.IORandomAccessFile;
import org.apache.commons.io.build.AbstractOrigin;
import org.apache.commons.io.build.AbstractSupplier;

public abstract class AbstractOriginSupplier<T, B extends AbstractOriginSupplier<T, B>>
extends AbstractSupplier<T, B> {
    private AbstractOrigin<?, ?> origin;

    protected static AbstractOrigin.ByteArrayOrigin newByteArrayOrigin(byte[] origin2) {
        return new AbstractOrigin.ByteArrayOrigin(origin2);
    }

    protected static AbstractOrigin.CharSequenceOrigin newCharSequenceOrigin(CharSequence origin2) {
        return new AbstractOrigin.CharSequenceOrigin(origin2);
    }

    protected static AbstractOrigin.FileOrigin newFileOrigin(File origin2) {
        return new AbstractOrigin.FileOrigin(origin2);
    }

    protected static AbstractOrigin.FileOrigin newFileOrigin(String origin2) {
        return new AbstractOrigin.FileOrigin(new File(origin2));
    }

    protected static AbstractOrigin.InputStreamOrigin newInputStreamOrigin(InputStream origin2) {
        return new AbstractOrigin.InputStreamOrigin(origin2);
    }

    protected static AbstractOrigin.OutputStreamOrigin newOutputStreamOrigin(OutputStream origin2) {
        return new AbstractOrigin.OutputStreamOrigin(origin2);
    }

    protected static AbstractOrigin.PathOrigin newPathOrigin(Path origin2) {
        return new AbstractOrigin.PathOrigin(origin2);
    }

    protected static AbstractOrigin.PathOrigin newPathOrigin(String origin2) {
        return new AbstractOrigin.PathOrigin(Paths.get(origin2, new String[0]));
    }

    protected static AbstractOrigin.IORandomAccessFileOrigin newRandomAccessFileOrigin(IORandomAccessFile origin2) {
        return new AbstractOrigin.IORandomAccessFileOrigin(origin2);
    }

    protected static AbstractOrigin.RandomAccessFileOrigin newRandomAccessFileOrigin(RandomAccessFile origin2) {
        return new AbstractOrigin.RandomAccessFileOrigin(origin2);
    }

    protected static AbstractOrigin.ReaderOrigin newReaderOrigin(Reader origin2) {
        return new AbstractOrigin.ReaderOrigin(origin2);
    }

    protected static AbstractOrigin.URIOrigin newURIOrigin(URI origin2) {
        return new AbstractOrigin.URIOrigin(origin2);
    }

    protected static AbstractOrigin.WriterOrigin newWriterOrigin(Writer origin2) {
        return new AbstractOrigin.WriterOrigin(origin2);
    }

    protected AbstractOrigin<?, ?> checkOrigin() {
        if (this.origin == null) {
            throw new IllegalStateException("origin == null");
        }
        return this.origin;
    }

    protected AbstractOrigin<?, ?> getOrigin() {
        return this.origin;
    }

    protected boolean hasOrigin() {
        return this.origin != null;
    }

    public B setByteArray(byte[] origin2) {
        return this.setOrigin(AbstractOriginSupplier.newByteArrayOrigin(origin2));
    }

    public B setCharSequence(CharSequence origin2) {
        return this.setOrigin(AbstractOriginSupplier.newCharSequenceOrigin(origin2));
    }

    public B setFile(File origin2) {
        return this.setOrigin(AbstractOriginSupplier.newFileOrigin(origin2));
    }

    public B setFile(String origin2) {
        return this.setOrigin(AbstractOriginSupplier.newFileOrigin(origin2));
    }

    public B setInputStream(InputStream origin2) {
        return this.setOrigin(AbstractOriginSupplier.newInputStreamOrigin(origin2));
    }

    protected B setOrigin(AbstractOrigin<?, ?> origin2) {
        this.origin = origin2;
        return (B)((AbstractOriginSupplier)this.asThis());
    }

    public B setOutputStream(OutputStream origin2) {
        return this.setOrigin(AbstractOriginSupplier.newOutputStreamOrigin(origin2));
    }

    public B setPath(Path origin2) {
        return this.setOrigin(AbstractOriginSupplier.newPathOrigin(origin2));
    }

    public B setPath(String origin2) {
        return this.setOrigin(AbstractOriginSupplier.newPathOrigin(origin2));
    }

    public B setRandomAccessFile(IORandomAccessFile origin2) {
        return this.setOrigin(AbstractOriginSupplier.newRandomAccessFileOrigin(origin2));
    }

    public B setRandomAccessFile(RandomAccessFile origin2) {
        return this.setOrigin(AbstractOriginSupplier.newRandomAccessFileOrigin(origin2));
    }

    public B setReader(Reader origin2) {
        return this.setOrigin(AbstractOriginSupplier.newReaderOrigin(origin2));
    }

    public B setURI(URI origin2) {
        return this.setOrigin(AbstractOriginSupplier.newURIOrigin(origin2));
    }

    public B setWriter(Writer origin2) {
        return this.setOrigin(AbstractOriginSupplier.newWriterOrigin(origin2));
    }
}

