/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.dom;

import com.fasterxml.aalto.WFCException;
import com.fasterxml.aalto.impl.ErrorConsts;
import com.intellij.util.xml.dom.NoOpXmlInterner;
import com.intellij.util.xml.dom.StaxFactory;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xml.dom.XmlElementBuilder;
import com.intellij.util.xml.dom.XmlInterner;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u001a$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0015"}, d2={"readXmlAsModel", "Lcom/intellij/util/xml/dom/XmlElement;", "inputReader", "Ljava/io/Reader;", "inputStream", "Ljava/io/InputStream;", "file", "Ljava/nio/file/Path;", "inputData", "", "readAndClose", "reader", "Lorg/codehaus/stax2/XMLStreamReader2;", "rootName", "", "interner", "Lcom/intellij/util/xml/dom/XmlInterner;", "readAttributes", "", "nextTag", "", "intellij.platform.util.xmlDom"})
@JvmName(name="XmlDomReader")
@ApiStatus.Internal
public final class XmlDomReader {
    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull Reader inputReader) {
        Intrinsics.checkNotNullParameter((Object)inputReader, (String)"inputReader");
        return XmlDomReader.readAndClose(StaxFactory.createXmlStreamReader(inputReader));
    }

    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return XmlDomReader.readAndClose(StaxFactory.createXmlStreamReader$default(inputStream, null, 2, null));
    }

    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return XmlDomReader.readAndClose(StaxFactory.createXmlStreamReader$default(inputStream, null, 2, null));
    }

    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull byte[] inputData) {
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        return XmlDomReader.readAndClose(StaxFactory.createXmlStreamReader(inputData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final XmlElement readAndClose(XMLStreamReader2 reader) {
        try {
            String rootName = XmlDomReader.nextTag(reader) == 1 ? reader.getLocalName() : null;
            XmlElement xmlElement = XmlDomReader.readXmlAsModel(reader, rootName, NoOpXmlInterner.INSTANCE);
            return xmlElement;
        }
        finally {
            reader.closeCompletely();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull XMLStreamReader2 reader, @Nullable String rootName, @NotNull XmlInterner interner) {
        XmlElementBuilder fragment;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)interner, (String)"interner");
        String string = rootName;
        XmlElementBuilder current = fragment = new XmlElementBuilder(string == null ? "" : interner.name(string), XmlDomReader.readAttributes(reader, interner));
        ArrayDeque<XmlElementBuilder> stack = new ArrayDeque<XmlElementBuilder>();
        ArrayDeque<XmlElementBuilder> elementPool = new ArrayDeque<XmlElementBuilder>();
        int depth = 1;
        block7: while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    String string2 = reader.getLocalName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocalName(...)");
                    String name = interner.name(string2);
                    Map<String, String> attributes = XmlDomReader.readAttributes(reader, interner);
                    if (reader.isEmptyElement()) {
                        ArrayList<XmlElement> arrayList = current.children;
                        List<XmlElement> list = Collections.emptyList();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
                        arrayList.add(new XmlElement(name, attributes, list, null));
                        reader.skipElement();
                        continue block7;
                    }
                    XmlElementBuilder child = (XmlElementBuilder)elementPool.pollLast();
                    if (child == null) {
                        child = new XmlElementBuilder(name, attributes);
                    } else {
                        child.name = name;
                        child.attributes = attributes;
                    }
                    stack.addLast(current);
                    current = child;
                    ++depth;
                    continue block7;
                }
                case 2: {
                    List<XmlElement> children2 = null;
                    if (current.children.isEmpty()) {
                        List<XmlElement> list = Collections.emptyList();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
                        children2 = list;
                    } else {
                        XmlElement[] xmlElementArray = current.children.toArray(new XmlElement[current.children.size()]);
                        List<XmlElement> list = Arrays.asList(Arrays.copyOf(xmlElementArray, xmlElementArray.length));
                        Intrinsics.checkNotNullExpressionValue(list, (String)"asList(...)");
                        children2 = list;
                        current.children.clear();
                    }
                    XmlElement result = new XmlElement(current.name, current.attributes, children2, current.content);
                    current.content = null;
                    elementPool.addLast(current);
                    if (--depth == 0) {
                        return result;
                    }
                    Object e = stack.removeLast();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"removeLast(...)");
                    current = (XmlElementBuilder)e;
                    current.children.add(result);
                    continue block7;
                }
                case 12: {
                    if (current.content == null) {
                        String string3 = current.name;
                        String string4 = reader.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                        current.content = interner.value(string3, string4);
                        continue block7;
                    }
                    XmlElementBuilder xmlElementBuilder = current;
                    xmlElementBuilder.content = xmlElementBuilder.content + reader.getText();
                    continue block7;
                }
                case 4: {
                    if (reader.isWhiteSpace()) continue block7;
                    if (current.content == null) {
                        current.content = reader.getText();
                        continue block7;
                    }
                    XmlElementBuilder xmlElementBuilder = current;
                    xmlElementBuilder.content = xmlElementBuilder.content + reader.getText();
                    continue block7;
                }
                case 3: 
                case 5: 
                case 6: 
                case 9: {
                    continue block7;
                }
            }
            throw new XMLStreamException("Unexpected XMLStream event " + reader.getEventType(), reader.getLocation());
        }
        throw new XMLStreamException("Unexpected end of input: " + reader.getEventType(), reader.getLocation());
    }

    private static final Map<String, String> readAttributes(XMLStreamReader2 reader, XmlInterner interner) {
        int attributeCount = reader.getAttributeCount();
        switch (attributeCount) {
            case 0: {
                Map<String, String> map2 = Collections.emptyMap();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"emptyMap(...)");
                return map2;
            }
            case 1: {
                String string = reader.getAttributeLocalName(0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeLocalName(...)");
                String name = interner.name(string);
                String string2 = reader.getAttributeValue(0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeValue(...)");
                Map<String, String> map3 = Collections.singletonMap(name, interner.value(name, string2));
                Intrinsics.checkNotNullExpressionValue(map3, (String)"singletonMap(...)");
                return map3;
            }
        }
        HashMap<String, String> result = new HashMap<String, String>(attributeCount);
        for (int i = 0; i < attributeCount; ++i) {
            String string = reader.getAttributeLocalName(i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeLocalName(...)");
            String name = interner.name(string);
            String string3 = reader.getAttributeValue(i);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttributeValue(...)");
            result.put(name, interner.value(name, string3));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int nextTag(XMLStreamReader2 reader) {
        int next;
        block5: while (true) {
            next = reader.next();
            switch (next) {
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    continue block5;
                }
                case 4: 
                case 12: {
                    if (!reader.isWhiteSpace()) throw new WFCException("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().", reader.getLocation());
                    continue block5;
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
            break;
        }
        throw new WFCException("Received event " + ErrorConsts.tokenTypeDesc(next) + ", instead of START_ELEMENT or END_ELEMENT.", reader.getLocation());
    }
}

