/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringsKmp;
import com.intellij.util.text.CharArrayUtilKmp;
import com.intellij.util.text.CharSequenceBackedByArray;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB\u0015\b\u0016\u0012\n\u0010\n\u001a\u00020\u0004\"\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0011\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0006H\u0096\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J&\u0010\"\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006J\b\u0010&\u001a\u00020\u0006H\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\n\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lcom/intellij/util/text/CharArrayCharSequence;", "Lcom/intellij/util/text/CharSequenceBackedByArray;", "Lcom/intellij/openapi/util/text/CharSequenceWithStringHash;", "myChars", "", "myStart", "", "myEnd", "<init>", "([CII)V", "chars", "", "([C)V", "hash", "length", "getLength", "()I", "get", "index", "subSequence", "", "start", "end", "toString", "", "getChars", "()[C", "", "dst", "dstOffset", "equals", "", "anObject", "", "readCharsTo", "cbuf", "off", "len", "hashCode", "intellij.platform.util.base.multiplatform"})
public class CharArrayCharSequence
implements CharSequenceBackedByArray,
CharSequenceWithStringHash {
    @JvmField
    @NotNull
    protected final char[] myChars;
    @JvmField
    protected final int myStart;
    @JvmField
    protected final int myEnd;
    private transient int hash;

    public CharArrayCharSequence(@NotNull char[] myChars, int myStart, int myEnd) {
        Intrinsics.checkNotNullParameter((Object)myChars, (String)"myChars");
        this.myChars = myChars;
        this.myStart = myStart;
        this.myEnd = myEnd;
        if (this.myStart < 0 || this.myEnd > this.myChars.length || this.myStart > this.myEnd) {
            throw new IndexOutOfBoundsException("chars.length:" + this.myChars.length + ", start:" + this.myStart + ", end:" + this.myEnd);
        }
    }

    public CharArrayCharSequence(char ... chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        this(chars, 0, chars.length);
    }

    public int getLength() {
        return this.myEnd - this.myStart;
    }

    public char get(int index) {
        return this.myChars[index + this.myStart];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return start == 0 && end == this.length() ? (CharSequence)this : (CharSequence)new CharArrayCharSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        return StringsKt.concatToString((char[])this.myChars, (int)this.myStart, (int)this.myEnd);
    }

    @Override
    @NotNull
    public char[] getChars() {
        if (this.myStart == 0) {
            return this.myChars;
        }
        char[] chars = new char[this.length()];
        this.getChars(chars, 0);
        return chars;
    }

    @Override
    public void getChars(@NotNull char[] dst, int dstOffset) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        ArraysKt.copyInto((char[])this.myChars, (char[])dst, (int)dstOffset, (int)this.myStart, (int)this.myEnd);
    }

    public boolean equals(@Nullable Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null || this.getClass() != anObject.getClass() || this.length() != ((CharSequence)anObject).length()) {
            return false;
        }
        return CharArrayUtilKmp.regionMatches(this.myChars, this.myStart, this.myEnd, (CharSequence)anObject);
    }

    public final int readCharsTo(int start, @NotNull char[] cbuf, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        int readChars = Math.min(len, this.length() - start);
        if (readChars <= 0) {
            return -1;
        }
        ArraysKt.copyInto((char[])this.myChars, (char[])cbuf, (int)off, (int)(this.myStart + start), (int)(this.myStart + start + readChars));
        return readChars;
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringsKmp.stringHashCode(this.myChars, this.myStart, this.myEnd);
        }
        return h;
    }
}

