/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.serialization.SerializationContext;
import com.intellij.platform.workspace.jps.serialization.impl.ExternalModuleImlFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.ModuleListSerializerImpl;
import com.intellij.platform.workspace.jps.serialization.impl.ModulePath;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.PathUtilRt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J(\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\t0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/ExternalModuleListSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/ModuleListSerializerImpl;", "externalStorageRoot", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "context", "Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;", "<init>", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;)V", "isExternalStorage", "", "()Z", "componentName", "", "getComponentName", "()Ljava/lang/String;", "entitySourceFilter", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/EntitySource;", "getEntitySourceFilter", "()Lkotlin/jvm/functions/Function1;", "getSourceToSave", "Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource$FileInDirectory;", "module", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "getFileName", "entity", "createSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntitiesSerializer;", "internalSource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "fileUrl", "moduleGroup", "deleteObsoleteFile", "", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "toString", "intellij.platform.workspace.jps"})
public final class ExternalModuleListSerializer
extends ModuleListSerializerImpl {
    @NotNull
    private final VirtualFileUrl externalStorageRoot;

    public ExternalModuleListSerializer(@NotNull VirtualFileUrl externalStorageRoot, @NotNull SerializationContext context) {
        Intrinsics.checkNotNullParameter((Object)externalStorageRoot, (String)"externalStorageRoot");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = externalStorageRoot.append("project/modules.xml").getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        super(string, context, null, 4, null);
        this.externalStorageRoot = externalStorageRoot;
    }

    @Override
    public boolean isExternalStorage() {
        return true;
    }

    @Override
    @NotNull
    public String getComponentName() {
        return "ExternalProjectModuleManager";
    }

    @Override
    @NotNull
    public Function1<EntitySource, Boolean> getEntitySourceFilter() {
        return ExternalModuleListSerializer::_get_entitySourceFilter_$lambda$0;
    }

    @Override
    @Nullable
    protected JpsProjectFileEntitySource.FileInDirectory getSourceToSave(@NotNull ModuleEntity module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        EntitySource entitySource = module.getEntitySource();
        JpsImportedEntitySource jpsImportedEntitySource = entitySource instanceof JpsImportedEntitySource ? (JpsImportedEntitySource)entitySource : null;
        JpsFileEntitySource jpsFileEntitySource = jpsImportedEntitySource != null ? jpsImportedEntitySource.getInternalFile() : null;
        return jpsFileEntitySource instanceof JpsProjectFileEntitySource.FileInDirectory ? (JpsProjectFileEntitySource.FileInDirectory)jpsFileEntitySource : null;
    }

    @Override
    @NotNull
    public String getFileName(@NotNull ModuleEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity.getName() + ".xml";
    }

    @Override
    @NotNull
    public JpsFileEntitiesSerializer<ModuleEntity> createSerializer(@NotNull JpsFileEntitySource internalSource, @NotNull VirtualFileUrl fileUrl, @Nullable String moduleGroup) {
        Intrinsics.checkNotNullParameter((Object)internalSource, (String)"internalSource");
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        String string = PathUtilRt.getFileName(fileUrl.getUrl());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String fileName = string;
        VirtualFileUrl actualFileUrl = Intrinsics.areEqual((Object)PathUtilRt.getFileExtension(fileName), (Object)"iml") ? this.externalStorageRoot.append("modules/" + StringsKt.substringBeforeLast$default((String)fileName, (char)'.', null, (int)2, null) + ".xml") : fileUrl;
        String filePath = JpsPathUtil.urlToPath(fileUrl.getUrl());
        Intrinsics.checkNotNull((Object)filePath);
        ModulePath modulePath = new ModulePath(filePath, moduleGroup);
        Intrinsics.checkNotNull((Object)actualFileUrl);
        return new ExternalModuleImlFileEntitiesSerializer(modulePath, actualFileUrl, this.getContext(), internalSource, this);
    }

    @Override
    public void deleteObsoleteFile(@NotNull String fileUrl, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        super.deleteObsoleteFile(fileUrl, writer);
        if (FileUtil.extensionEquals(fileUrl, "xml")) {
            writer.saveComponent(fileUrl, "ExternalSystem", null);
            writer.saveComponent(fileUrl, "ExternalFacetManager", null);
            writer.saveComponent(fileUrl, "DeprecatedModuleOptionManager", null);
            writer.saveComponent(fileUrl, "TestModuleProperties", null);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "ExternalModuleListSerializer(" + this.getFileUrl() + ")";
    }

    private static final boolean _get_entitySourceFilter_$lambda$0(EntitySource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof JpsImportedEntitySource && ((JpsImportedEntitySource)it).getStoredExternally();
    }
}

