/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.bridge.impl.serialization;

import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JpsComponentLoader;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/workspace/jps/bridge/impl/serialization/GlobalDirectJpsFileContentReader;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "macroExpander", "Lorg/jetbrains/jps/model/serialization/JpsMacroExpander;", "<init>", "(Lorg/jetbrains/jps/model/serialization/JpsMacroExpander;)V", "componentLoader", "Lorg/jetbrains/jps/model/serialization/JpsComponentLoader;", "loadComponent", "Lorg/jdom/Element;", "fileUrl", "", "componentName", "customModuleFilePath", "getExpandMacroMap", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "intellij.platform.workspace.jps"})
public final class GlobalDirectJpsFileContentReader
implements JpsFileContentReader {
    @NotNull
    private final JpsMacroExpander macroExpander;
    @NotNull
    private final JpsComponentLoader componentLoader;

    public GlobalDirectJpsFileContentReader(@NotNull JpsMacroExpander macroExpander) {
        Intrinsics.checkNotNullParameter((Object)macroExpander, (String)"macroExpander");
        this.macroExpander = macroExpander;
        this.componentLoader = new JpsComponentLoader(this.macroExpander, null);
    }

    @Override
    @Nullable
    public Element loadComponent(@NotNull String fileUrl, @NotNull String componentName, @Nullable String customModuleFilePath) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        String string = JpsPathUtil.urlToPath(fileUrl);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlToPath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return this.componentLoader.loadComponent(path, componentName);
    }

    @Override
    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        ExpandMacroToPathMap expandMacroToPathMap = this.macroExpander.getExpandMacroMap();
        Intrinsics.checkNotNullExpressionValue((Object)expandMacroToPathMap, (String)"getExpandMacroMap(...)");
        return expandMacroToPathMap;
    }
}

