/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.bridge.impl.library;

import com.intellij.platform.workspace.jps.bridge.impl.module.JpsModuleReferenceBridge;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.impl.JpsGlobalElementReference;
import org.jetbrains.jps.model.impl.JpsProjectElementReference;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.module.JpsModule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/workspace/jps/bridge/impl/library/JpsLibraryReferenceBridge;", "Lorg/jetbrains/jps/model/ex/JpsElementBase;", "Lorg/jetbrains/jps/model/library/JpsLibraryReference;", "libraryId", "Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "<init>", "(Lcom/intellij/platform/workspace/jps/entities/LibraryId;)V", "parentReference", "Lorg/jetbrains/jps/model/JpsElementReference;", "Lorg/jetbrains/jps/model/JpsCompositeElement;", "resolved", "Lorg/jetbrains/jps/model/library/JpsLibrary;", "Lorg/jetbrains/annotations/Nullable;", "getResolved", "()Lorg/jetbrains/jps/model/library/JpsLibrary;", "resolved$delegate", "Lkotlin/Lazy;", "createParentReference", "tableId", "Lcom/intellij/platform/workspace/jps/entities/LibraryTableId;", "resolve", "getLibraryName", "", "getParentReference", "intellij.platform.workspace.jps"})
public final class JpsLibraryReferenceBridge
extends JpsElementBase<JpsLibraryReferenceBridge>
implements JpsLibraryReference {
    @NotNull
    private final LibraryId libraryId;
    @NotNull
    private final JpsElementReference<? extends JpsCompositeElement> parentReference;
    @NotNull
    private final Lazy resolved$delegate;

    public JpsLibraryReferenceBridge(@NotNull LibraryId libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        this.libraryId = libraryId;
        this.parentReference = this.createParentReference(this.libraryId.getTableId());
        this.resolved$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> JpsLibraryReferenceBridge.resolved_delegate$lambda$0(this));
    }

    private final JpsLibrary getResolved() {
        Lazy lazy = this.resolved$delegate;
        return (JpsLibrary)lazy.getValue();
    }

    private final JpsElementReference<? extends JpsCompositeElement> createParentReference(LibraryTableId tableId) {
        JpsElementReference jpsElementReference;
        LibraryTableId libraryTableId = tableId;
        if (libraryTableId instanceof LibraryTableId.GlobalLibraryTableId) {
            jpsElementReference = new JpsGlobalElementReference();
        } else if (Intrinsics.areEqual((Object)libraryTableId, (Object)LibraryTableId.ProjectLibraryTableId.INSTANCE)) {
            jpsElementReference = new JpsProjectElementReference();
        } else if (libraryTableId instanceof LibraryTableId.ModuleLibraryTableId) {
            jpsElementReference = new JpsModuleReferenceBridge(((LibraryTableId.ModuleLibraryTableId)tableId).getModuleId().getName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        JpsElementReference reference = jpsElementReference;
        ((JpsElementBase)((Object)reference)).setParent(this);
        return reference;
    }

    @Override
    @Nullable
    public JpsLibrary resolve() {
        return this.getResolved();
    }

    @Override
    @NotNull
    public String getLibraryName() {
        return this.libraryId.getName();
    }

    @Override
    @NotNull
    public JpsElementReference<? extends JpsCompositeElement> getParentReference() {
        return this.parentReference;
    }

    private static final JpsLibrary resolved_delegate$lambda$0(JpsLibraryReferenceBridge this$0) {
        JpsLibraryCollection jpsLibraryCollection;
        JpsCompositeElement jpsCompositeElement = this$0.parentReference.resolve();
        if (jpsCompositeElement == null) {
            return null;
        }
        JpsCompositeElement parentElement = jpsCompositeElement;
        JpsCompositeElement jpsCompositeElement2 = parentElement;
        if (jpsCompositeElement2 instanceof JpsGlobal) {
            jpsLibraryCollection = ((JpsGlobal)parentElement).getLibraryCollection();
        } else if (jpsCompositeElement2 instanceof JpsProject) {
            jpsLibraryCollection = ((JpsProject)parentElement).getLibraryCollection();
        } else if (jpsCompositeElement2 instanceof JpsModule) {
            jpsLibraryCollection = ((JpsModule)parentElement).getLibraryCollection();
        } else {
            throw new IllegalStateException(("Unexpected parent element: " + parentElement).toString());
        }
        JpsLibraryCollection jpsLibraryCollection2 = jpsLibraryCollection;
        Intrinsics.checkNotNull((Object)jpsLibraryCollection2);
        JpsLibraryCollection libraryCollection = jpsLibraryCollection2;
        return libraryCollection.findLibrary(this$0.libraryId.getName());
    }
}

