/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.bridge.impl.library;

import com.intellij.platform.workspace.jps.bridge.impl.AssertionsKt;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryRootProcessing;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\fH\u0016J*\u0010\u0016\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u0004\"\n\b\u0001\u0010\u0001*\u0004\u0018\u00010\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0018H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/workspace/jps/bridge/impl/library/JpsLibraryBridgeBase;", "P", "Lorg/jetbrains/jps/model/JpsElement;", "Lorg/jetbrains/jps/model/ex/JpsNamedCompositeElementBase;", "Lorg/jetbrains/jps/model/library/JpsTypedLibrary;", "name", "", "parentElement", "Lorg/jetbrains/jps/model/ex/JpsElementBase;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/jps/model/ex/JpsElementBase;)V", "addRoot", "", "url", "rootType", "Lorg/jetbrains/jps/model/library/JpsOrderRootType;", "file", "Ljava/io/File;", "options", "Lorg/jetbrains/jps/model/library/JpsLibraryRoot$InclusionOptions;", "removeUrl", "delete", "asTyped", "type", "Lorg/jetbrains/jps/model/library/JpsLibraryType;", "getFiles", "", "getPaths", "Ljava/nio/file/Path;", "getRootUrls", "intellij.platform.workspace.jps"})
public abstract class JpsLibraryBridgeBase<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsLibraryBridgeBase<P>>
implements JpsTypedLibrary<P> {
    public JpsLibraryBridgeBase(@NotNull String name, @NotNull JpsElementBase<?> parentElement) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(parentElement, (String)"parentElement");
        super(name);
        this.setParent(parentElement);
    }

    @Override
    public void addRoot(@NotNull String url, @NotNull JpsOrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        AssertionsKt.reportModificationAttempt();
        throw new KotlinNothingValueException();
    }

    @Override
    public void addRoot(@NotNull File file, @NotNull JpsOrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        AssertionsKt.reportModificationAttempt();
        throw new KotlinNothingValueException();
    }

    @Override
    public void addRoot(@NotNull String url, @NotNull JpsOrderRootType rootType, @NotNull JpsLibraryRoot.InclusionOptions options) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        AssertionsKt.reportModificationAttempt();
        throw new KotlinNothingValueException();
    }

    @Override
    public void removeUrl(@NotNull String url, @NotNull JpsOrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        AssertionsKt.reportModificationAttempt();
        throw new KotlinNothingValueException();
    }

    @Override
    public void delete() {
        AssertionsKt.reportModificationAttempt();
        throw new KotlinNothingValueException();
    }

    @Override
    @Nullable
    public <P extends JpsElement> JpsTypedLibrary<P> asTyped(@NotNull JpsLibraryType<P> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (Intrinsics.areEqual((Object)this.getType(), type)) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.jps.model.library.JpsTypedLibrary<P of com.intellij.platform.workspace.jps.bridge.impl.library.JpsLibraryBridgeBase.asTyped>");
            return this;
        }
        return null;
    }

    @Override
    @NotNull
    public List<File> getFiles(@NotNull JpsOrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        List<File> list = JpsLibraryRootProcessing.convertToFiles(this.getRoots(rootType));
        Intrinsics.checkNotNullExpressionValue(list, (String)"convertToFiles(...)");
        return list;
    }

    @Override
    @NotNull
    public List<Path> getPaths(@NotNull JpsOrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        List<Path> list = JpsLibraryRootProcessing.convertToPaths(this.getRoots(rootType));
        Intrinsics.checkNotNullExpressionValue(list, (String)"convertToPaths(...)");
        return list;
    }

    @Override
    @NotNull
    public List<String> getRootUrls(@NotNull JpsOrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        List<String> list = JpsLibraryRootProcessing.convertToUrls(this.getRoots(rootType));
        Intrinsics.checkNotNullExpressionValue(list, (String)"convertToUrls(...)");
        return list;
    }
}

