/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileAttribute {
    private static final int UNDEFINED_VERSION = -1;
    private static final Set<String> registeredAttributeIds = ConcurrentHashMap.newKeySet();
    private final String id;
    private final int version;
    private final boolean fixedSize;

    public FileAttribute(@NonNls @NotNull String id) {
        if (id == null) {
            FileAttribute.$$$reportNull$$$0(0);
        }
        this(id, -1, false, false);
    }

    public FileAttribute(@NonNls @NotNull String id, int version, boolean fixedSize) {
        if (id == null) {
            FileAttribute.$$$reportNull$$$0(1);
        }
        this(id, version, fixedSize, false);
    }

    @Deprecated
    public FileAttribute(@NonNls @NotNull String id, int version, boolean fixedSize, boolean shouldEnumerate) {
        if (id == null) {
            FileAttribute.$$$reportNull$$$0(2);
        }
        this(version, fixedSize, id);
        boolean added = registeredAttributeIds.add(id);
        assert (added) : "Attribute id='" + id + "' is not unique";
    }

    private FileAttribute(int version, boolean fixedSize, @NotNull String id) {
        if (id == null) {
            FileAttribute.$$$reportNull$$$0(3);
        }
        this.id = id;
        this.version = version;
        this.fixedSize = fixedSize;
    }

    @Deprecated
    @Nullable
    public DataInputStream readAttribute(@NotNull VirtualFile file) {
        if (file == null) {
            FileAttribute.$$$reportNull$$$0(4);
        }
        return ManagingFS.getInstance().readAttribute(file, this);
    }

    @Deprecated
    @NotNull
    public DataOutputStream writeAttribute(@NotNull VirtualFile file) {
        if (file == null) {
            FileAttribute.$$$reportNull$$$0(5);
        }
        AttributeOutputStream attributeOutputStream = ManagingFS.getInstance().writeAttribute(file, this);
        if (attributeOutputStream == null) {
            FileAttribute.$$$reportNull$$$0(6);
        }
        return attributeOutputStream;
    }

    @Nullable
    public AttributeInputStream readFileAttribute(@NotNull VirtualFile file) {
        if (file == null) {
            FileAttribute.$$$reportNull$$$0(7);
        }
        return ManagingFS.getInstance().readAttribute(file, this);
    }

    @NotNull
    public AttributeOutputStream writeFileAttribute(@NotNull VirtualFile file) {
        if (file == null) {
            FileAttribute.$$$reportNull$$$0(8);
        }
        AttributeOutputStream attributeOutputStream = ManagingFS.getInstance().writeAttribute(file, this);
        if (attributeOutputStream == null) {
            FileAttribute.$$$reportNull$$$0(9);
        }
        return attributeOutputStream;
    }

    public byte @Nullable [] readAttributeBytes(VirtualFile file) throws IOException {
        try (DataInputStream stream = this.readAttribute(file);){
            if (stream == null) {
                byte[] byArray = null;
                return byArray;
            }
            int len = stream.readInt();
            byte[] byArray = FileUtil.loadBytes(stream, len);
            return byArray;
        }
    }

    public void writeAttributeBytes(VirtualFile file, byte @NotNull [] bytes) throws IOException {
        if (bytes == null) {
            FileAttribute.$$$reportNull$$$0(10);
        }
        this.writeAttributeBytes(file, bytes, 0, bytes.length);
    }

    public void writeAttributeBytes(VirtualFile file, byte[] bytes, int offset, int len) throws IOException {
        try (DataOutputStream stream = this.writeAttribute(file);){
            stream.writeInt(len);
            stream.write(bytes, offset, len);
        }
    }

    @NotNull
    public String getId() {
        String string = this.id;
        if (string == null) {
            FileAttribute.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean isFixedSize() {
        return this.fixedSize;
    }

    @NotNull
    public FileAttribute newVersion(int newVersion) {
        return new FileAttribute(newVersion, this.fixedSize, this.id);
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isVersioned() {
        return this.version != -1;
    }

    public static void resetRegisteredIds() {
        registeredAttributeIds.clear();
    }

    public String toString() {
        return "FileAttribute[" + this.id + "]{version: " + this.version + ", fixedSize: " + this.fixedSize + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/FileAttribute";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/FileAttribute";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "writeFileAttribute";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readFileAttribute";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeFileAttribute";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributeBytes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 11 -> new IllegalStateException(string);
        };
    }
}

