/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Query;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ProjectPackageIndexImpl
extends PackageIndex {
    private static final Logger LOG = Logger.getInstance(ProjectPackageIndexImpl.class);
    private final WorkspaceFileIndexEx myWorkspaceFileIndex;

    @ApiStatus.Internal
    public ProjectPackageIndexImpl(@NotNull Project project) {
        if (project == null) {
            ProjectPackageIndexImpl.$$$reportNull$$$0(0);
        }
        this.myWorkspaceFileIndex = WorkspaceFileIndexEx.getInstance((Project)project);
    }

    @Override
    public Query<VirtualFile> getDirsByPackageName(@NotNull @NlsSafe String packageName, @NotNull GlobalSearchScope scope) {
        if (packageName == null) {
            ProjectPackageIndexImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            ProjectPackageIndexImpl.$$$reportNull$$$0(2);
        }
        return this.myWorkspaceFileIndex.getDirectoriesByPackageName(packageName, scope);
    }

    @Override
    public Query<VirtualFile> getFilesByPackageName(@NotNull String packageName) {
        if (packageName == null) {
            ProjectPackageIndexImpl.$$$reportNull$$$0(3);
        }
        return this.myWorkspaceFileIndex.getFilesByPackageName(packageName);
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirsByPackageName(@NotNull @NlsSafe String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            ProjectPackageIndexImpl.$$$reportNull$$$0(4);
        }
        Query query = this.myWorkspaceFileIndex.getDirectoriesByPackageName(packageName, includeLibrarySources);
        if (query == null) {
            ProjectPackageIndexImpl.$$$reportNull$$$0(5);
        }
        return query;
    }

    @Override
    @Nullable
    public String getPackageName(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectPackageIndexImpl.$$$reportNull$$$0(6);
        }
        return this.myWorkspaceFileIndex.getPackageName(fileOrDir);
    }

    @Override
    @Nullable
    public String getPackageNameByDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            ProjectPackageIndexImpl.$$$reportNull$$$0(7);
        }
        if (!dir.isDirectory()) {
            LOG.error(dir.getPresentableUrl() + " is not a directory");
        }
        return this.myWorkspaceFileIndex.getPackageName(dir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectPackageIndexImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectPackageIndexImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirsByPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDirsByPackageName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByPackageName";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameByDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

