/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.codeInsight.multiverse.ModuleContext;
import com.intellij.codeInsight.multiverse.ProjectModelContextBridge;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.ActualCodeInsightContextInfo;
import com.intellij.psi.search.CodeInsightContextAwareSearchScope;
import com.intellij.psi.search.CodeInsightContextAwareSearchScopes;
import com.intellij.psi.search.CodeInsightContextFileInfo;
import com.intellij.psi.search.CodeInsightContextInfo;
import com.intellij.psi.search.DoesNotContainFileInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ModulesScope
extends GlobalSearchScope
implements CodeInsightContextAwareSearchScope,
ActualCodeInsightContextInfo {
    private final ProjectFileIndex myProjectFileIndex;
    private final Set<? extends Module> myModules;

    public ModulesScope(@NotNull Set<? extends Module> modules, @NotNull Project project) {
        if (modules == null) {
            ModulesScope.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ModulesScope.$$$reportNull$$$0(1);
        }
        super(project);
        this.myProjectFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        this.myModules = modules;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            ModulesScope.$$$reportNull$$$0(2);
        }
        if (CodeInsightContexts.isSharedSourceSupportEnabled(Objects.requireNonNull(this.getProject()))) {
            Set<Module> modulesOfFile = this.myProjectFileIndex.getModulesForFile(file, true);
            return ContainerUtil.intersects(this.myModules, modulesOfFile);
        }
        Module moduleOfFile = this.myProjectFileIndex.getModuleForFile(file);
        return this.myModules.contains(moduleOfFile);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public CodeInsightContextInfo getCodeInsightContextInfo() {
        ModulesScope modulesScope = this;
        if (modulesScope == null) {
            ModulesScope.$$$reportNull$$$0(3);
        }
        return modulesScope;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public CodeInsightContextFileInfo getFileInfo(@NotNull VirtualFile file) {
        Set<Module> modulesOfFile;
        Collection<Module> intersection;
        if (file == null) {
            ModulesScope.$$$reportNull$$$0(4);
        }
        if (!(intersection = ContainerUtil.intersection(this.myModules, modulesOfFile = this.myProjectFileIndex.getModulesForFile(file, true))).isEmpty()) {
            ProjectModelContextBridge bridge = ProjectModelContextBridge.getInstance(Objects.requireNonNull(this.getProject()));
            List<ModuleContext> contexts2 = ContainerUtil.mapNotNull(intersection, m -> bridge.getContext((Module)m));
            CodeInsightContextFileInfo codeInsightContextFileInfo = CodeInsightContextAwareSearchScopes.createContainingContextFileInfo(contexts2);
            if (codeInsightContextFileInfo == null) {
                ModulesScope.$$$reportNull$$$0(5);
            }
            return codeInsightContextFileInfo;
        }
        DoesNotContainFileInfo doesNotContainFileInfo = CodeInsightContextAwareSearchScopes.DoesNotContainFileInfo();
        if (doesNotContainFileInfo == null) {
            ModulesScope.$$$reportNull$$$0(6);
        }
        return doesNotContainFileInfo;
    }

    @Override
    @ApiStatus.Internal
    public boolean contains(@NotNull VirtualFile file, @NotNull CodeInsightContext context) {
        if (file == null) {
            ModulesScope.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ModulesScope.$$$reportNull$$$0(8);
        }
        if (!CodeInsightContexts.isSharedSourceSupportEnabled(Objects.requireNonNull(this.getProject()))) {
            return this.contains(file);
        }
        if (!(context instanceof ModuleContext)) {
            return false;
        }
        ModuleContext moduleContext = (ModuleContext)context;
        Module contextModule = moduleContext.getModule();
        Set<Module> modulesOfFile = this.myProjectFileIndex.getModulesForFile(file, true);
        return contextModule != null && this.myModules.contains(contextModule) && modulesOfFile.contains(contextModule);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            ModulesScope.$$$reportNull$$$0(9);
        }
        return this.myModules.contains(aModule);
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    public String toString() {
        return "Modules:" + Arrays.toString(this.myModules.toArray(Module.EMPTY_ARRAY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/scopes/ModulesScope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/scopes/ModulesScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeInsightContextInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

