/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class BulkArrayQueue<T> {
    private int tail;
    private int head;
    private Object[] myQueue = new Object[1024];

    public void enqueue(@NotNull T info) {
        int newTail;
        if (info == null) {
            BulkArrayQueue.$$$reportNull$$$0(0);
        }
        if ((newTail = (this.tail + 1) % this.myQueue.length) == this.head) {
            this.growAndUnwrap(0);
            newTail = this.tail + 1;
        }
        this.myQueue[this.tail] = info;
        this.tail = newTail;
    }

    private void growAndUnwrap(int reserveAtStart) {
        int firstChunkSize;
        if (reserveAtStart < 0) {
            throw new IllegalArgumentException("illegal argument: " + reserveAtStart);
        }
        int oldCapacity = this.myQueue.length;
        int newCapacity = reserveAtStart + (oldCapacity < 100000 ? oldCapacity * 2 : oldCapacity + (oldCapacity >> 1));
        if (newCapacity <= oldCapacity + reserveAtStart) {
            throw new OutOfMemoryError("reserveAtStart: " + reserveAtStart + "; oldCapacity: " + oldCapacity);
        }
        Object[] newQueue = new Object[newCapacity];
        if (this.head <= this.tail) {
            firstChunkSize = this.tail - this.head;
        } else {
            firstChunkSize = oldCapacity - this.head;
            System.arraycopy(this.myQueue, 0, newQueue, reserveAtStart + firstChunkSize, this.tail);
        }
        System.arraycopy(this.myQueue, this.head, newQueue, reserveAtStart, firstChunkSize);
        this.tail = this.size() + reserveAtStart;
        this.head = reserveAtStart;
        this.myQueue = newQueue;
    }

    public int size() {
        return this.head <= this.tail ? this.tail - this.head : this.tail + this.myQueue.length - this.head;
    }

    public int capacity() {
        return this.myQueue.length;
    }

    public T pollFirst() {
        if (this.isEmpty()) {
            return null;
        }
        int nextHead = (this.head + 1) % this.myQueue.length;
        T info = this.getAndNullize(this.head);
        this.head = nextHead;
        return info;
    }

    @NotNull
    private T getAndNullize(int head) {
        Object t = this.myQueue[head];
        this.myQueue[head] = null;
        Object object = t;
        if (object == null) {
            BulkArrayQueue.$$$reportNull$$$0(1);
        }
        return (T)object;
    }

    public void bulkEnqueueFirst(@NotNull @NotNull ObjectArrayList<? extends @NotNull T> elements) {
        int oldCapacity;
        int emptySpace;
        int insertSize;
        if (elements == null) {
            BulkArrayQueue.$$$reportNull$$$0(2);
        }
        if ((insertSize = elements.size()) > (emptySpace = (oldCapacity = this.myQueue.length) - this.size() - 1)) {
            this.growAndUnwrap(insertSize);
        }
        int secondChunkSize = this.head <= this.tail ? Math.min(insertSize, this.head) : Math.min(insertSize, this.head - this.tail - 1);
        int firstChunkSize = insertSize - secondChunkSize;
        this.head -= secondChunkSize;
        elements.getElements(firstChunkSize, this.myQueue, this.head, secondChunkSize);
        if (firstChunkSize != 0) {
            this.head = oldCapacity - firstChunkSize;
            elements.getElements(0, this.myQueue, this.head, firstChunkSize);
        }
    }

    void removeAll(@NotNull Predicate<? super T> shouldRemove) {
        int o;
        if (shouldRemove == null) {
            BulkArrayQueue.$$$reportNull$$$0(3);
        }
        if (this.head <= this.tail) {
            o = this.head;
            for (int i = this.head; i < this.tail; ++i) {
                T info = this.getAndNullize(i);
                if (shouldRemove.test(info)) continue;
                this.myQueue[o++] = info;
            }
        } else {
            T info;
            int i;
            o = this.myQueue.length;
            for (i = this.myQueue.length - 1; i >= this.head; --i) {
                info = this.getAndNullize(i);
                if (shouldRemove.test(info)) continue;
                this.myQueue[--o] = info;
            }
            this.head = o % this.myQueue.length;
            o = 0;
            for (i = 0; i < this.tail; ++i) {
                info = this.getAndNullize(i);
                if (shouldRemove.test(info)) continue;
                this.myQueue[o++] = info;
            }
        }
        this.tail = o;
    }

    boolean isEmpty() {
        return this.head == this.tail;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/BulkArrayQueue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/BulkArrayQueue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndNullize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enqueue";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bulkEnqueueFirst";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

